/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.x509;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class X509NameTokenizer {
    private String value;
    private int index;
    private char seperator;
    private StringBuilder buf = new StringBuilder();
    static final long serialVersionUID = 4207360631079763253L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public X509NameTokenizer(String oid) {
        this(oid, ',');
    }

    public X509NameTokenizer(String oid, char seperator) {
        this.value = oid;
        this.index = -1;
        this.seperator = seperator;
    }

    public boolean hasMoreTokens() {
        return this.index != this.value.length();
    }

    public String nextToken() {
        int end;
        if (this.index == this.value.length()) {
            return null;
        }
        boolean quoted = false;
        boolean escaped = false;
        this.buf.setLength(0);
        for (end = this.index + 1; end != this.value.length(); ++end) {
            char c = this.value.charAt(end);
            if (c == '\"') {
                if (!escaped) {
                    quoted = !quoted;
                } else {
                    this.buf.append(c);
                }
                escaped = false;
                continue;
            }
            if (escaped || quoted) {
                this.buf.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == this.seperator) break;
            this.buf.append(c);
        }
        this.index = end;
        return this.buf.toString().trim();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.asn1.x509.X509NameTokenizer", X509NameTokenizer.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.internal.resources.CSIv2CommonMessages");
    }
}

