/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest.utils;

import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSSearchObject {
    long startInstanceId = -1L;
    long endInstanceId = -1L;
    long lessThanInstanceId = -1L;
    long greaterThanInstanceId = -1L;
    List<Long> instanceIdList;
    List<InstanceState> instanceState;
    List<String> exitStatusList;
    Date startCreateTime = null;
    Date endCreateTime = null;
    String lessThanCreateTime = null;
    String greaterThanCreateTime = null;
    Date specificCreateTime = null;
    Date startLastUpdatedTime = null;
    Date endLastUpdatedTime = null;
    String lessThanLastUpdatedTime = null;
    String greaterThanLastUpdatedTime = null;
    Date specificLastUpdatedTime = null;
    boolean ignoreCase = false;
    Map<String, String> jobParams = null;
    List<String> submitterList = null;
    List<String> appNameList = null;
    List<String> jobNameList = null;
    Set<String> groupSecuritySubjectGroupsList = null;
    String queryIssuer = null;
    List<String> sortList;
    String sort = null;
    static final long serialVersionUID = 9017761001398776000L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WSSearchObject(String instanceIdParams, String createTimeParams, String instanceStateParams, String exitStatusParams) throws Exception {
        this(instanceIdParams, createTimeParams, instanceStateParams, new String[]{exitStatusParams}, null, null, null, null, null, null, null);
    }

    public WSSearchObject(String instanceIdParams, String createTimeParams, String instanceStateParams, String exitStatusParams, String lastUpdatedTimeParams, String sortParams, Map<String, String> jobParams) throws Exception {
        this(instanceIdParams, createTimeParams, instanceStateParams, new String[]{exitStatusParams}, lastUpdatedTimeParams, sortParams, jobParams, null, null, null, null);
    }

    public WSSearchObject(String instanceIdParams, String createTimeParams, String instanceStateParams, String[] exitStatusParams, String lastUpdatedTimeParams, String sortParams, Map<String, String> jobParams, String[] submitterParams, String[] appNameParams, String[] jobNameParams, String ignoreCaseParams) throws Exception {
        if (instanceIdParams != null) {
            this.processInstanceIdParams(instanceIdParams);
        }
        if (createTimeParams != null) {
            this.processCreateTimeParams(createTimeParams);
        }
        if (instanceStateParams != null) {
            this.processInstanceStateParams(instanceStateParams);
        }
        if (exitStatusParams != null) {
            this.processExitStatusParams(exitStatusParams);
        }
        if (lastUpdatedTimeParams != null) {
            this.processLastUpdatedTimeParams(lastUpdatedTimeParams);
        }
        if (jobParams != null) {
            this.processJobParameter(jobParams);
        }
        if (sortParams != null) {
            this.processSortParams(sortParams);
        }
        if (submitterParams != null) {
            this.processSubmitterParams(submitterParams);
        }
        if (appNameParams != null) {
            this.processAppNameParams(appNameParams);
        }
        if (jobNameParams != null) {
            this.processJobNameParams(jobNameParams);
        }
        if (ignoreCaseParams != null) {
            this.processIgnoreCaseParams(ignoreCaseParams);
        }
    }

    private void processSortParams(String params) throws Exception {
        if (params != null) {
            this.sortList = Arrays.asList(params.split(","));
        }
    }

    private void processLastUpdatedTimeParams(String params) throws Exception {
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (params.contains(":")) {
            String[] parts = params.split(":");
            this.startLastUpdatedTime = this.setDayStartForDate(dFormat.parse(parts[0]));
            this.endLastUpdatedTime = this.setDayEndForDate(dFormat.parse(parts[1]));
        } else if (params.contains("<")) {
            this.lessThanLastUpdatedTime = params.substring(1, params.indexOf("d"));
        } else if (params.contains(">")) {
            this.greaterThanLastUpdatedTime = params.substring(1, params.indexOf("d"));
        } else {
            dFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.specificLastUpdatedTime = dFormat.parse(params);
        }
    }

    private void processExitStatusParams(String[] params) throws Exception {
        if (params != null && params[0] != null) {
            this.exitStatusList = Arrays.asList(params);
        }
    }

    public void processJobParameter(Map<String, String> jobParams) {
        this.jobParams = jobParams;
    }

    private void processInstanceStateParams(String params) throws Exception {
        List<String> tempList = Arrays.asList(params.split(","));
        ArrayList<InstanceState> stateList = new ArrayList<InstanceState>(tempList.size());
        for (String value : tempList) {
            try {
                stateList.add(InstanceState.valueOf((String)value.trim().toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.jbatch.rest.utils.WSSearchObject", (String)"183", (Object)this, (Object[])new Object[]{params});
                throw new IllegalArgumentException("An invalid instanceState parameter was used: " + value + ". Valid instanceState parameters are: " + Arrays.toString(InstanceState.values()).replace("[", "").replace("]", ""));
            }
        }
        this.instanceState = stateList;
    }

    private void processInstanceIdParams(String params) throws Exception {
        block9: {
            block12: {
                block11: {
                    block10: {
                        block8: {
                            if (!params.contains(":")) break block8;
                            String[] parts = params.split(":");
                            this.startInstanceId = new Long(parts[0]);
                            this.endInstanceId = new Long(parts[1]);
                            if (this.isNegative(this.startInstanceId)) {
                                throw new IllegalArgumentException("A negative startInstanceId value was entered: " + this.startInstanceId);
                            }
                            if (this.isNegative(this.endInstanceId)) {
                                throw new IllegalArgumentException("A negative endInstanceId value was entered: " + this.endInstanceId);
                            }
                            break block9;
                        }
                        if (!params.contains("<")) break block10;
                        String part = params.substring(1, params.length());
                        this.lessThanInstanceId = new Long(part);
                        if (this.isNegative(this.lessThanInstanceId)) {
                            throw new IllegalArgumentException("A negative lessThanInstanceId value was entered: " + this.lessThanInstanceId);
                        }
                        break block9;
                    }
                    if (!params.contains(">")) break block11;
                    String part = params.substring(1, params.length());
                    this.greaterThanInstanceId = new Long(part);
                    if (this.isNegative(this.greaterThanInstanceId)) {
                        throw new IllegalArgumentException("A negative greaterThanInstanceId value was entered: " + this.greaterThanInstanceId);
                    }
                    break block9;
                }
                if (!params.contains(",")) break block12;
                List<String> tempList = Arrays.asList(params.split(","));
                this.instanceIdList = new ArrayList<Long>(tempList.size());
                for (String value : tempList) {
                    Long longValue = Long.parseLong(value);
                    if (this.isNegative(longValue)) {
                        throw new IllegalArgumentException("A negative jobInstanceId value was entered: " + longValue);
                    }
                    this.instanceIdList.add(longValue);
                }
                break block9;
            }
            if (params == null) break block9;
            List<String> tempList = Arrays.asList(params);
            this.instanceIdList = new ArrayList<Long>(tempList.size());
            for (String value : tempList) {
                Long longValue = Long.parseLong(value);
                if (this.isNegative(longValue)) {
                    throw new IllegalArgumentException("A negative jobInstanceId value was entered: " + longValue);
                }
                this.instanceIdList.add(Long.parseLong(value));
            }
        }
    }

    private void processCreateTimeParams(String params) throws Exception {
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (params.contains(":")) {
            String[] parts = params.split(":");
            this.startCreateTime = this.setDayStartForDate(dFormat.parse(parts[0]));
            this.endCreateTime = this.setDayEndForDate(dFormat.parse(parts[1]));
        } else if (params.contains("<")) {
            this.lessThanCreateTime = params.substring(1, params.indexOf("d"));
        } else if (params.contains(">")) {
            this.greaterThanCreateTime = params.substring(1, params.indexOf("d"));
        } else {
            dFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.specificCreateTime = dFormat.parse(params);
        }
    }

    private void processSubmitterParams(String[] params) {
        this.submitterList = Arrays.asList(params);
    }

    private void processAppNameParams(String[] params) {
        this.appNameList = Arrays.asList(params);
    }

    private void processJobNameParams(String[] params) {
        this.jobNameList = Arrays.asList(params);
    }

    private void processIgnoreCaseParams(String params) {
        if ("true".equalsIgnoreCase(params)) {
            this.ignoreCase = true;
        }
    }

    public long getStartInstanceId() {
        return this.startInstanceId;
    }

    public void setStartInstanceId(long startInstanceId) {
        this.startInstanceId = startInstanceId;
    }

    public long getEndInstanceId() {
        return this.endInstanceId;
    }

    public void setEndInstanceId(long endInstanceId) {
        this.endInstanceId = endInstanceId;
    }

    public long getLessThanInstanceId() {
        return this.lessThanInstanceId;
    }

    public void setLessThanInstanceId(long lessThanInstanceId) {
        this.lessThanInstanceId = lessThanInstanceId;
    }

    public long getGreaterThanInstanceId() {
        return this.greaterThanInstanceId;
    }

    public void setGreaterThanInstanceId(long greaterThanInstanceId) {
        this.greaterThanInstanceId = greaterThanInstanceId;
    }

    public List<InstanceState> getInstanceState() {
        return this.instanceState;
    }

    public void setInstanceState(List<InstanceState> instanceState) {
        this.instanceState = instanceState;
    }

    public List<String> getExitStatusList() {
        return this.exitStatusList;
    }

    public void setExitStatusList(List<String> exitStatus) {
        this.exitStatusList = exitStatus;
    }

    public Date getStartCreateTime() {
        return this.startCreateTime;
    }

    public void setStartCreateTime(Date startCreateTime) {
        this.startCreateTime = startCreateTime;
    }

    public Date getEndCreateTime() {
        return this.endCreateTime;
    }

    public void setEndCreateTime(Date endCreateTime) {
        this.endCreateTime = endCreateTime;
    }

    public String getLessThanCreateTime() {
        return this.lessThanCreateTime;
    }

    public void setLessThanCreateTime(String lessThanCreateTime) {
        this.lessThanCreateTime = lessThanCreateTime;
    }

    public String getGreaterThanCreateTime() {
        return this.greaterThanCreateTime;
    }

    public void setGreaterThanCreateTime(String greaterThanCreateTime) {
        this.greaterThanCreateTime = greaterThanCreateTime;
    }

    public List<Long> getInstanceIdList() {
        return this.instanceIdList;
    }

    public void setInstanceIdList(List<Long> instanceIdList) {
        this.instanceIdList = instanceIdList;
    }

    public Date getSpecificCreateTime() {
        return this.specificCreateTime;
    }

    public void setSpecificCreateTime(Date specificCreateTime) {
        this.specificCreateTime = specificCreateTime;
    }

    public Date getStartLastUpdatedTime() {
        return this.startLastUpdatedTime;
    }

    public void setStartLastUpdatedTime(Date startLastUpdatedTime) {
        this.startLastUpdatedTime = startLastUpdatedTime;
    }

    public Date getEndLastUpdatedTime() {
        return this.endLastUpdatedTime;
    }

    public void setEndLastUpdatedTime(Date endLastUpdatedTime) {
        this.endLastUpdatedTime = endLastUpdatedTime;
    }

    public String getLessThanLastUpdatedTime() {
        return this.lessThanLastUpdatedTime;
    }

    public void setLessThanLastUpdatedTime(String lessThanLastUpdatedTime) {
        this.lessThanLastUpdatedTime = lessThanLastUpdatedTime;
    }

    public String getGreaterThanLastUpdatedTime() {
        return this.greaterThanLastUpdatedTime;
    }

    public void setGreaterThanLastUpdatedTime(String greaterThanLastUpdatedTime) {
        this.greaterThanLastUpdatedTime = greaterThanLastUpdatedTime;
    }

    public Date getSpecificLastUpdatedTime() {
        return this.specificLastUpdatedTime;
    }

    public void setSpecificLastUpdatedTime(Date specificLastUpdatedTime) {
        this.specificLastUpdatedTime = specificLastUpdatedTime;
    }

    public List<String> getSubmitterList() {
        return this.submitterList;
    }

    public void setSubmitterList(List<String> submitter) {
        this.submitterList = submitter;
    }

    public String getQueryIssuer() {
        return this.queryIssuer;
    }

    public void setQueryIssuer(String issuer) {
        this.queryIssuer = issuer;
    }

    public List<String> getAppNameList() {
        return this.appNameList;
    }

    public void setAppNameList(List<String> appNames) {
        this.appNameList = appNames;
    }

    public List<String> getJobNameList() {
        return this.jobNameList;
    }

    public void setJobNameList(List<String> jobNames) {
        this.jobNameList = jobNames;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public Map<String, String> getJobParameters() {
        return this.jobParams;
    }

    public List<String> getSortList() {
        return this.sortList;
    }

    public void setSortList(List<String> sortList) {
        this.sortList = sortList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("WSSearchObject content :: \n");
        sb.append("startInstanceId = " + this.startInstanceId + "\n");
        sb.append("endInstanceId = " + this.endInstanceId + "\n");
        sb.append("lessThanInstanceId = " + this.lessThanInstanceId + "\n");
        sb.append("greaterThanInstanceId = " + this.greaterThanInstanceId + "\n");
        sb.append("instanceState = " + this.instanceState + "\n");
        sb.append("exitStatus = " + this.exitStatusList + "\n");
        sb.append("startCreateTime = " + this.startCreateTime + "\n");
        sb.append("endCreateTime = " + this.endCreateTime + "\n");
        sb.append("lessThanCreateTime = " + this.lessThanCreateTime + "\n");
        sb.append("greaterThanCreateTime = " + this.greaterThanCreateTime + "\n");
        sb.append("instanceIdList = " + this.instanceIdList + "\n");
        sb.append("specificCreateTime = " + this.specificCreateTime + "\n");
        sb.append("startLastUpdatedTime = " + this.startLastUpdatedTime + "\n");
        sb.append("endLastUpdatedTime = " + this.endLastUpdatedTime + "\n");
        sb.append("lessThanLastUpdatedTime = " + this.lessThanLastUpdatedTime + "\n");
        sb.append("greaterThanLastUpdatedTime = " + this.greaterThanLastUpdatedTime + "\n");
        sb.append("specificLastUpdatedTime = " + this.specificLastUpdatedTime + "\n");
        sb.append("sortList = " + this.sortList + "\n");
        sb.append("submitter = " + this.submitterList + "\n");
        sb.append("queryIssuer = " + this.queryIssuer + "\n");
        sb.append("appName = " + this.appNameList + "\n");
        sb.append("jobName = " + this.jobNameList + "\n");
        sb.append("ignoreCase = " + this.ignoreCase + "\n");
        if (this.jobParams != null) {
            for (Map.Entry<String, String> e : this.jobParams.entrySet()) {
                sb.append("jobParameter." + e.getKey() + "=" + e.getValue() + "\n");
            }
        }
        return sb.toString();
    }

    private Date setDayEndForDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        cal.set(11, 24);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Date(cal.getTimeInMillis() - 1L);
    }

    private Date setDayStartForDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Date(cal.getTimeInMillis());
    }

    private boolean isNegative(long value) {
        return value < 0L;
    }

    public void setGroupsForGroupSecurity(Set<String> groupsForSubject) {
        this.groupSecuritySubjectGroupsList = groupsForSubject;
    }

    public Set<String> getGroupsForGroupSecurity() {
        return this.groupSecuritySubjectGroupsList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.utils.WSSearchObject", WSSearchObject.class, (String)"wsbatch", null);
    }
}

