/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest.internal.resources;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jbatch.rest.internal.BatchRequestUtil;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class RequestHandler {
    private static final TraceComponent tc = Tr.register(RequestHandler.class, (String)"wsbatch", (String)"com.ibm.ws.jbatch.rest.resources.RESTMessages");
    private long lastOptionsMsg = 0L;
    private List<String> handlerPath;
    static final long serialVersionUID = -6106070987554463009L;

    protected RequestHandler() {
    }

    protected RequestHandler(String path) {
        this.setPath(path);
    }

    public RequestHandler setPath(String path) {
        this.handlerPath = BatchRequestUtil.splitPath(path);
        return this;
    }

    public boolean canHandle(RESTRequest request) {
        return this.canHandle(BatchRequestUtil.splitPath(request.getPath()));
    }

    public boolean canHandle(List<String> requestPath) {
        if (requestPath.size() != this.handlerPath.size()) {
            return false;
        }
        for (int i = 0; i < requestPath.size(); ++i) {
            if (requestPath.get(i).equals(this.handlerPath.get(i)) || this.handlerPath.get(i).equals("*")) continue;
            return false;
        }
        return true;
    }

    public void get(RESTRequest request, RESTResponse response) throws Exception {
        response.sendError(400, "GET request not supported");
    }

    public void put(RESTRequest request, RESTResponse response) throws Exception {
        response.sendError(400, "PUT request not supported");
    }

    public void post(RESTRequest request, RESTResponse response) throws Exception {
        response.sendError(400, "POST request not supported");
    }

    public void delete(RESTRequest request, RESTResponse response) throws Exception {
        response.sendError(400, "DELETE request not supported");
    }

    public void options(RESTRequest request, RESTResponse response) throws Exception {
        if (System.currentTimeMillis() - this.lastOptionsMsg > 60000L) {
            Tr.info((TraceComponent)tc, (String)"http.options.received", (Object[])new Object[]{request.getRemoteHost() + ":" + request.getRemotePort()});
            this.lastOptionsMsg = System.currentTimeMillis();
        }
        response.sendError(400, "OPTIONS request not supported");
    }

    public void trace(RESTRequest request, RESTResponse response) throws Exception {
        response.sendError(400, "TRACE request not supported");
    }

    public String toString() {
        return super.toString() + ":path=" + String.valueOf(this.handlerPath);
    }
}

