/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest.internal.resources;

import com.ibm.jbatch.container.exception.JobInstanceSearchNotSupportedException;
import com.ibm.jbatch.container.services.IJPAQueryHelper;
import com.ibm.jbatch.container.ws.BatchDispatcherException;
import com.ibm.jbatch.container.ws.BatchJobNotLocalException;
import com.ibm.jbatch.container.ws.BatchLocationService;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.WSJobOperator;
import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.jbatch.container.ws.WSRemotablePartitionExecution;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jbatch.joblog.JobExecutionLog;
import com.ibm.ws.jbatch.joblog.JobInstanceLog;
import com.ibm.ws.jbatch.joblog.services.IJobLogManagerService;
import com.ibm.ws.jbatch.rest.BatchManager;
import com.ibm.ws.jbatch.rest.JPAQueryHelperImpl;
import com.ibm.ws.jbatch.rest.internal.BatchJobExecutionAlreadyCompleteException;
import com.ibm.ws.jbatch.rest.internal.BatchJobExecutionNotRunningException;
import com.ibm.ws.jbatch.rest.internal.BatchJobRestartException;
import com.ibm.ws.jbatch.rest.internal.BatchNoSuchJobInstanceException;
import com.ibm.ws.jbatch.rest.internal.BatchRequestUtil;
import com.ibm.ws.jbatch.rest.internal.ZipHelper;
import com.ibm.ws.jbatch.rest.internal.resources.RequestException;
import com.ibm.ws.jbatch.rest.internal.resources.RequestHandler;
import com.ibm.ws.jbatch.rest.internal.resources.RequestRouter;
import com.ibm.ws.jbatch.rest.utils.BatchJSONHelper;
import com.ibm.ws.jbatch.rest.utils.JobRestartModel;
import com.ibm.ws.jbatch.rest.utils.JobSubmissionModel;
import com.ibm.ws.jbatch.rest.utils.PurgeStatus;
import com.ibm.ws.jbatch.rest.utils.ResourceBundleRest;
import com.ibm.ws.jbatch.rest.utils.StringUtils;
import com.ibm.ws.jbatch.rest.utils.WSPurgeResponse;
import com.ibm.ws.jbatch.rest.utils.WSSearchConstants;
import com.ibm.ws.jbatch.rest.utils.WSSearchObject;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.JobExecution;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.root=/batch/jobinstances", "com.ibm.wsspi.rest.handler.root=/batch/jobinstances/{jobinstanceid}", "com.ibm.wsspi.rest.handler.root=/batch/jobinstances/{jobinstanceid}/joblogs", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobinstances", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobinstances/{jobinstanceid}", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobinstances/{jobinstanceid}/joblogs", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobinstances", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobinstances/{jobinstanceid}", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobinstances/{jobinstanceid}/joblogs", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobinstances", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobinstances/{jobinstanceid}", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobinstances/{jobinstanceid}/joblogs", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobinstances", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobinstances/{jobinstanceid}", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobinstances/{jobinstanceid}/joblogs", "com.ibm.wsspi.rest.handler.custom.security=true"})
public class JobInstances
implements RESTHandler {
    private static final TraceComponent tc = Tr.register(JobInstances.class, (String)"wsbatch", (String)"com.ibm.ws.jbatch.rest.resources.RESTMessages");
    private WSJobRepository jobRepository;
    private WSJobOperator wsJobOperator;
    private BatchManager batchManager;
    private IJobLogManagerService jobLogManagerService;
    private BatchLocationService batchLocationService;
    private RequestRouter requestRouter = new RequestRouter().addHandler(new JobInstancesHandler().setPath("/batch/jobinstances")).addHandler(new JobInstanceHandler().setPath("/batch/jobinstances/*")).addHandler(new JobLogsHandler().setPath("/batch/jobinstances/*/joblogs")).addHandler(new JobInstancesHandler().setPath("/batch/v1/jobinstances")).addHandler(new JobInstanceHandler().setPath("/batch/v1/jobinstances/*")).addHandler(new JobLogsHandler().setPath("/batch/v1/jobinstances/*/joblogs")).addHandler(new JobInstancesHandler_v2().setPath("/batch/v2/jobinstances")).addHandler(new JobInstanceHandler().setPath("/batch/v2/jobinstances/*")).addHandler(new JobLogsHandler().setPath("/batch/v2/jobinstances/*/joblogs")).addHandler(new JobInstancesHandler_v3().setPath("/batch/v3/jobinstances")).addHandler(new JobInstanceHandler().setPath("/batch/v3/jobinstances/*")).addHandler(new JobLogsHandler().setPath("/batch/v3/jobinstances/*/joblogs")).addHandler(new JobInstancesHandler_v4().setPath("/batch/v4/jobinstances")).addHandler(new JobInstanceHandler().setPath("/batch/v4/jobinstances/*")).addHandler(new JobLogsHandler().setPath("/batch/v4/jobinstances/*/joblogs"));
    static final long serialVersionUID = 7182115371328979525L;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWSJobRepository(WSJobRepository ref) {
        this.jobRepository = ref;
    }

    protected void unsetWSJobRepository(WSJobRepository ref) {
        if (this.jobRepository == ref) {
            this.jobRepository = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWSJobOperator(WSJobOperator ref) {
        this.wsJobOperator = ref;
    }

    protected void unsetWSJobOperator(WSJobOperator ref) {
        if (this.wsJobOperator == ref) {
            this.wsJobOperator = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setBatchManager(BatchManager ref) {
        this.batchManager = ref;
    }

    protected void unsetBatchManager(BatchManager ref) {
        if (this.batchManager == ref) {
            this.batchManager = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setIJobLogManagerService(IJobLogManagerService jobLogManagerService) {
        this.jobLogManagerService = jobLogManagerService;
    }

    protected void unsetIJobLogManagerService(IJobLogManagerService jobLogManagerService) {
        if (this.jobLogManagerService == jobLogManagerService) {
            this.jobLogManagerService = null;
        }
    }

    @Reference
    protected void setBatchLocationService(BatchLocationService batchLocationService) {
        this.batchLocationService = batchLocationService;
    }

    /*
     * WARNING - void declaration
     */
    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        try {
            BatchRuntime.getJobOperator();
            this.requestRouter.routeRequest(request, response);
        }
        catch (JobSecurityException jobSecurityException) {
            void jse;
            FFDCFilter.processException((Throwable)jobSecurityException, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"263", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(401, jse.getMessage());
        }
        catch (BatchNoSuchJobInstanceException jse) {
            void bnsjie;
            FFDCFilter.processException((Throwable)((Object)jse), (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"265", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(400, bnsjie.getMessage());
        }
        catch (JobInstanceSearchNotSupportedException bnsjie) {
            FFDCFilter.processException((Throwable)bnsjie, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"267", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(500, ResourceBundleRest.getMessage("in.memory.search.not.supported", new Object[0]));
        }
        catch (UnsupportedOperationException jisnse) {
            void uoe;
            FFDCFilter.processException((Throwable)jisnse, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"270", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(500, uoe.getMessage());
        }
        catch (Exception uoe) {
            void e;
            FFDCFilter.processException((Throwable)uoe, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"272", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(500, e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected long getJobInstanceId(RESTRequest request) throws RequestException {
        String s = request.getPathVariable("jobinstanceid");
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            void nfe;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"564", (Object)this, (Object[])new Object[]{request});
            throw new RequestException(400, "The job instance id (" + s + ") must be a Long integer", (Exception)nfe);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void getJobInstanceData(RESTRequest request, RESTResponse response, long jobInstanceID) throws IOException, RequestException {
        WSJobInstance jobInstance = null;
        try {
            jobInstance = this.jobRepository.getJobInstance(jobInstanceID);
        }
        catch (NoSuchJobInstanceException noSuchJobInstanceException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchJobInstanceException, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"581", (Object)this, (Object[])new Object[]{request, response, jobInstanceID});
            throw new BatchNoSuchJobInstanceException((Throwable)e, jobInstanceID);
        }
        List jobExecs = this.jobRepository.getJobExecutionsFromInstance(jobInstanceID);
        response.setContentType("application/json; charset=UTF-8");
        BatchJSONHelper.writeJobInstance(jobInstance, jobExecs, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
    }

    /*
     * WARNING - void declaration
     */
    private void submitJob(RESTRequest request, RESTResponse response) throws IOException, RequestException {
        JobSubmissionModel jobSubmission;
        InputStream jsonInput = null;
        InputStream jslInput = null;
        if (request.isMultiPartRequest()) {
            jsonInput = request.getPart("jobdata");
            jslInput = request.getPart("jsl");
            if (jsonInput == null) {
                throw new RequestException(400, "A multipart form must be submitted with a part name of jobdata.");
            }
            if (jslInput == null) {
                throw new RequestException(400, "A multipart form must be submitted with a part name of jsl.");
            }
        } else {
            jsonInput = request.getInputStream();
        }
        if (StringUtils.isEmpty((jobSubmission = new JobSubmissionModel(BatchJSONHelper.readJsonObject(jsonInput))).getApplicationName()) && StringUtils.isEmpty(jobSubmission.getModuleName())) {
            throw new RequestException(400, "Either attribute [applicationName] or [moduleName] must be provided.");
        }
        if (StringUtils.isEmpty(jobSubmission.getJobXMLName()) && StringUtils.isEmpty(jobSubmission.getJobXML())) {
            throw new RequestException(400, "Either attribute [jobXMLName] or [jobXML] must be provided.");
        }
        try {
            WSJobInstance jobInstance;
            if (jslInput != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(jslInput, "UTF-8"));
                String jslBody = IOUtils.toString((Reader)br);
                jobInstance = this.batchManager.start(jobSubmission.getApplicationName(), jobSubmission.getModuleName(), jobSubmission.getComponentName(), jobSubmission.getJobXMLName(), jobSubmission.getJobParameters(), jslBody);
            } else {
                jobInstance = this.batchManager.start(jobSubmission.getApplicationName(), jobSubmission.getModuleName(), jobSubmission.getComponentName(), jobSubmission.getJobXMLName(), jobSubmission.getJobParameters(), jobSubmission.getJobXML());
            }
            response.setContentType("application/json; charset=UTF-8");
            response.setStatus(201);
            BatchJSONHelper.writeJobInstance(jobInstance, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
        }
        catch (BatchDispatcherException jobInstance) {
            void e;
            FFDCFilter.processException((Throwable)jobInstance, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"668", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(500, "The batch dispatcher encountered exception while dispatching the submit job request for job " + jobSubmission.getJobXMLName() + ", job instance " + e.getJobInstanceId() + ". The exception details is: " + e.getCause());
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={BatchJobNotLocalException.class})
    private void stopJobInstance(RESTRequest request, RESTResponse response, long jobInstanceID) throws IOException, RequestException {
        try {
            long jobExecutionId = this.batchManager.stopJobInstance(jobInstanceID);
            response.setContentType("application/json; charset=UTF-8");
            if (jobExecutionId >= 0L) {
                BatchJSONHelper.writeJobExecution(this.jobRepository.getJobExecution(jobExecutionId), Collections.EMPTY_LIST, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
            } else {
                BatchJSONHelper.writeJsonObject(BatchJSONHelper.createJsonObject(), response.getOutputStream());
            }
        }
        catch (BatchJobExecutionNotRunningException jobExecutionId) {
            void e;
            FFDCFilter.processException((Throwable)((Object)jobExecutionId), (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"703", (Object)this, (Object[])new Object[]{request, response, jobInstanceID});
            response.sendError(409, "The most recent job execution id " + e.getJobExecutionId() + " associated with job instance id " + e.getJobInstanceId() + " is not currently running.");
        }
        catch (BatchJobNotLocalException e) {
            String restUrl = e.getJobExecution().getRestUrl();
            BatchRequestUtil.handleNonLocalRequest(BatchRequestUtil.buildStopUrlForJobInstance(jobInstanceID, restUrl), "PUT", request, response);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void restartJobInstance(RESTRequest request, RESTResponse response, long jobInstanceID) throws IOException, RequestException {
        Properties jobParams = BatchRequestUtil.getContentLength(request) > 0 ? new JobRestartModel(BatchJSONHelper.readJsonObject(request.getInputStream())).getJobParameters() : null;
        boolean reuseParams = "true".equalsIgnoreCase(request.getParameter("reusePreviousParams"));
        jobParams = reuseParams ? BatchJSONHelper.mergeProperties(((WSJobExecution)this.jobRepository.getJobExecutionsFromInstance(jobInstanceID).get(0)).getJobParameters(), jobParams) : jobParams;
        try {
            WSJobInstance jobInstance = this.batchManager.restartJobInstance(jobInstanceID, jobParams);
            response.setContentType("application/json; charset=UTF-8");
            BatchJSONHelper.writeJobInstance(jobInstance, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
        }
        catch (BatchJobExecutionAlreadyCompleteException jobInstance) {
            void e;
            FFDCFilter.processException((Throwable)((Object)jobInstance), (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"748", (Object)this, (Object[])new Object[]{request, response, jobInstanceID});
            response.sendError(409, "The most recent job execution " + e.getJobExecutionId() + " for job instance " + e.getJobInstanceId() + " cannot be restarted because it is already complete.");
        }
        catch (BatchDispatcherException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"752", (Object)this, (Object[])new Object[]{request, response, jobInstanceID});
            response.sendError(500, "The batch dispatcher encountered exception while dispatching the restart request for job execution " + e.getJobExecutionId() + ".  The exception details is: " + e.toString());
        }
        catch (BatchJobRestartException e) {
            FFDCFilter.processException((Throwable)((Object)e), (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"756", (Object)this, (Object[])new Object[]{request, response, jobInstanceID});
            response.sendError(409, "The job " + jobInstanceID + " cannot be restarted.");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void purgeJobInstance(RESTRequest request, RESTResponse response) throws Exception {
        long jobInstanceId = this.getJobInstanceId(request);
        boolean purgeJobStoreOnly = "true".equalsIgnoreCase(request.getParameter("purgeJobStoreOnly"));
        try {
            if (!this.jobRepository.isJobInstancePurgeable(jobInstanceId)) {
                throw new RequestException(409, "The specified job instance, " + jobInstanceId + ", cannot be purged because it has active job executions.");
            }
        }
        catch (NoSuchJobInstanceException noSuchJobInstanceException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchJobInstanceException, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"775", (Object)this, (Object[])new Object[]{request, response});
            throw new BatchNoSuchJobInstanceException((Throwable)e, jobInstanceId);
        }
        if (!purgeJobStoreOnly) {
            boolean fileSuccess = false;
            JobInstanceLog instanceLog = null;
            try {
                instanceLog = this.jobLogManagerService.getJobInstanceLog(jobInstanceId);
            }
            catch (NoSuchJobInstanceException noSuchJobInstanceException) {
                void e;
                FFDCFilter.processException((Throwable)noSuchJobInstanceException, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"786", (Object)this, (Object[])new Object[]{request, response});
                throw new BatchNoSuchJobInstanceException((Throwable)e, jobInstanceId);
            }
            if ("true".equals(request.getParameter("localOnly")) || instanceLog.areExecutionsLocal()) {
                fileSuccess = instanceLog.purge();
            }
            if (!instanceLog.areExecutionsLocal() || instanceLog.hasRemotePartitionLogs()) {
                HashSet<String> restUrls = new HashSet<String>();
                restUrls.addAll(this.findJobExecutionEndpoints(jobInstanceId));
                restUrls.remove(this.batchLocationService.getBatchRestUrl());
                if (restUrls.size() == 1) {
                    BatchRequestUtil.handleNonLocalRequest(BatchRequestUtil.buildPurgeUrlForJobInstance(jobInstanceId, (String)restUrls.iterator().next()), "DELETE", request, response);
                    return;
                }
                String responses = "";
                for (String restUrl : restUrls) {
                    try {
                        HttpsURLConnection connection = BatchRequestUtil.sendRESTRequest(BatchRequestUtil.buildJoblogsUrlForJobInstance(jobInstanceId, restUrl, "localOnly=true"), "DELETE", request, null);
                        if (connection != null) {
                            responses = responses.concat("A request to " + connection.getURL().getPath() + " returned response code " + connection.getResponseCode() + ". ");
                            if (connection.getResponseCode() == 200) continue;
                            response.sendError(500, "An error occurred while purging the job instance (" + jobInstanceId + "). Not all job log files were deleted so no attempt was made to delete database entries. " + responses);
                            return;
                        }
                        responses = responses.concat("A request to " + BatchRequestUtil.buildJoblogsUrlForJobInstance(jobInstanceId, restUrl, "") + " failed. ");
                        response.sendError(500, "An error occurred while purging the job instance (" + jobInstanceId + "). Not all job log files were deleted so no attempt was made to delete database entries. " + responses);
                        return;
                    }
                    catch (Exception connection) {
                        void ex;
                        FFDCFilter.processException((Throwable)connection, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"840", (Object)this, (Object[])new Object[]{request, response});
                        responses = responses.concat("Exception occurred during a request to " + BatchRequestUtil.buildJoblogsUrlForJobInstance(jobInstanceId, restUrl, "") + ", exception details: " + ex.getClass().getName() + ": " + ex.getLocalizedMessage());
                        response.sendError(500, "An exception occurred while purging the job instance (" + jobInstanceId + "). Not all job log files were deleted so no attempt was made to delete database entries." + responses);
                        return;
                    }
                }
                fileSuccess = true;
            }
            if (fileSuccess) {
                boolean dbSuccess = this.wsJobOperator.purgeJobInstance(jobInstanceId);
                if (!dbSuccess) {
                    response.sendError(500, "An error occurred while purging the job instance (" + jobInstanceId + "). The job logs were sucessfully deleted but not all database entries were deleted.");
                }
            } else {
                response.sendError(500, "An error occurred while purging the job instance (" + jobInstanceId + "). Not all job log files were deleted so no attempt was made to delete database entries.");
            }
        } else {
            boolean dbSuccess = this.wsJobOperator.purgeJobInstance(jobInstanceId);
            if (!dbSuccess) {
                response.sendError(500, "An error occurred while purging the job instance (" + jobInstanceId + "). Not all database entries were deleted.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void listJobInstances(RESTRequest request, RESTResponse response) throws Exception {
        int page = Integer.parseInt(StringUtils.firstNonNull(request.getParameter("page"), "0"));
        int pageSize = Integer.parseInt(StringUtils.firstNonNull(request.getParameter("pageSize"), "50"));
        WSSearchObject wsso = null;
        try {
            wsso = new WSSearchObject(null, null, null, null, null, "-createTime", null);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"890", (Object)this, (Object[])new Object[]{request, response});
            throw new RequestException(400, "An error occurred while processing the specified parameters in " + request.getCompleteURL() + "; Original Exception Message: " + e.getMessage());
        }
        List jobInstances = this.jobRepository.getJobInstances((IJPAQueryHelper)new JPAQueryHelperImpl(wsso), page, pageSize);
        response.setContentType("application/json; charset=UTF-8");
        BatchJSONHelper.writeJobInstances(jobInstances, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
    }

    private String getUnrecognizedParameters(RESTRequest request, int version) throws Exception {
        String unrecognized = null;
        List<String> validParams = null;
        if (version == 3) {
            validParams = WSSearchConstants.VALID_SEARCH_PARAMS_V3;
        } else if (version == 4) {
            validParams = WSSearchConstants.VALID_SEARCH_PARAMS_V4;
        }
        Map params = request.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            if (!validParams.contains(entry.getKey())) {
                if (((String)entry.getKey()).startsWith("jobParameter") || ((String)entry.getKey()).contains(".") || ((String)entry.getKey()).startsWith("purgeJobStoreOnly")) continue;
                if (unrecognized != null) {
                    unrecognized = unrecognized.concat("," + (String)entry.getKey());
                    continue;
                }
                unrecognized = (String)entry.getKey();
                continue;
            }
            if (((String)entry.getKey()).equals("sort")) {
                String[] split = ((String[])entry.getValue())[0].split(",");
                for (int i = 0; i < split.length; ++i) {
                    String field = split[i];
                    if (field.startsWith("-")) {
                        field = field.substring(1);
                    }
                    if (!WSSearchConstants.VALID_SORT_FIELDS.contains(field)) {
                        if (unrecognized != null) {
                            unrecognized = unrecognized.concat(",sort=" + split[i]);
                            continue;
                        }
                        unrecognized = "sort=" + split[i];
                        continue;
                    }
                    if (!field.equals("lastUpdatedTime") || this.jobRepository.getJobInstanceEntityVersion() >= 2) continue;
                    throw new RequestException(501, "A search or sort by last update time was requested, but the job instance table does not contain the UPDATETIME column.");
                }
                continue;
            }
            if (!((String)entry.getKey()).equals("lastUpdatedTime") || this.jobRepository.getJobInstanceEntityVersion() >= 2) continue;
            throw new RequestException(501, "A search or sort by last update time was requested, but the job instance table does not contain the UPDATETIME column.");
        }
        return unrecognized;
    }

    private Map<String, String> getJobParameters(RESTRequest request) throws Exception {
        HashMap<String, String> jobParams = new HashMap<String, String>();
        Map params = request.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("jobParameter.")) continue;
            key = key.substring(key.indexOf(".") + 1);
            jobParams.put(key, ((String[])entry.getValue())[0]);
        }
        if (!jobParams.isEmpty() && this.jobRepository.getJobExecutionEntityVersion() < 2) {
            throw new RequestException(501, ResourceBundleRest.getMessage("db.tables.not.created.for.jobparm.search", new Object[0]));
        }
        return jobParams;
    }

    /*
     * WARNING - void declaration
     */
    private List<WSJobInstance> doJobInstanceSearch(RESTRequest request, int version) throws Exception {
        int page = Integer.parseInt(StringUtils.firstNonNull(request.getParameter("page"), "0"));
        int pageSize = Integer.parseInt(StringUtils.firstNonNull(request.getParameter("pageSize"), "50"));
        Map<String, String> jobParameters = this.getJobParameters(request);
        WSSearchObject wsso = null;
        try {
            if (version == 3) {
                wsso = new WSSearchObject(request.getParameter("jobInstanceId"), request.getParameter("createTime"), request.getParameter("instanceState"), request.getParameter("exitStatus"), request.getParameter("lastUpdatedTime"), request.getParameter("sort"), jobParameters);
            } else if (version == 4) {
                wsso = new WSSearchObject(request.getParameter("jobInstanceId"), request.getParameter("createTime"), request.getParameter("instanceState"), request.getParameterValues("exitStatus"), request.getParameter("lastUpdatedTime"), request.getParameter("sort"), jobParameters, request.getParameterValues("submitter"), request.getParameterValues("appName"), request.getParameterValues("jobName"), request.getParameter("ignoreCase"));
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"1022", (Object)this, (Object[])new Object[]{request, version});
            throw new RequestException(400, "An error occurred while processing the specified parameters in " + request.getCompleteURL() + "; Original Exception Message: " + e.getMessage());
        }
        List jobInstances = this.jobRepository.getJobInstances((IJPAQueryHelper)new JPAQueryHelperImpl(wsso), page, pageSize);
        return jobInstances;
    }

    protected void searchJobInstances(RESTRequest request, RESTResponse response, int version) throws Exception {
        String unrecognized = this.getUnrecognizedParameters(request, version);
        if (unrecognized != null) {
            response.addResponseHeader("X-IBM-Unrecognized-Fields", unrecognized);
        }
        List<WSJobInstance> jobInstances = this.doJobInstanceSearch(request, version);
        response.setContentType("application/json; charset=UTF-8");
        BatchJSONHelper.writeJobInstances(jobInstances, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
    }

    /*
     * WARNING - void declaration
     */
    protected void searchJobInstances(RESTRequest request, RESTResponse response) throws Exception {
        String instanceIdParams = request.getParameter("jobInstanceId");
        String startTimeParams = request.getParameter("createTime");
        String instanceStateParams = request.getParameter("instanceState");
        String exitStatusParams = request.getParameter("exitStatus");
        int page = Integer.parseInt(StringUtils.firstNonNull(request.getParameter("page"), "0"));
        int pageSize = Integer.parseInt(StringUtils.firstNonNull(request.getParameter("pageSize"), "50"));
        WSSearchObject wsso = null;
        try {
            wsso = new WSSearchObject(instanceIdParams, startTimeParams, instanceStateParams, exitStatusParams);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"1076", (Object)this, (Object[])new Object[]{request, response});
            throw new RequestException(400, "An error occurred while processing the specified parameters in " + request.getCompleteURL() + "; Original Exception Message: " + e.getMessage());
        }
        List jobInstances = this.jobRepository.getJobInstances((IJPAQueryHelper)new JPAQueryHelperImpl(wsso), page, pageSize);
        response.setContentType("application/json; charset=UTF-8");
        BatchJSONHelper.writeJobInstances(jobInstances, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
    }

    /*
     * WARNING - void declaration
     */
    protected void purgeJobInstances(RESTRequest request, RESTResponse response) throws Exception {
        int page = Integer.parseInt(StringUtils.firstNonNull(request.getParameter("page"), "0"));
        int pageSize = Integer.parseInt(StringUtils.firstNonNull(request.getParameter("pageSize"), "50"));
        WSSearchObject wsso = null;
        try {
            wsso = new WSSearchObject(request.getParameter("jobInstanceId"), request.getParameter("createTime"), request.getParameter("instanceState"), request.getParameter("exitStatus"));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"1110", (Object)this, (Object[])new Object[]{request, response});
            throw new RequestException(400, "An error occurred while processing the specified parameters in " + request.getCompleteURL());
        }
        List jobInstances = this.jobRepository.getJobInstances((IJPAQueryHelper)new JPAQueryHelperImpl(wsso), page, pageSize);
        ArrayList<Long> instanceList = new ArrayList<Long>(jobInstances.size());
        for (WSJobInstance job : jobInstances) {
            instanceList.add(job.getInstanceId());
        }
        ArrayList<WSPurgeResponse> purgeResponseList = new ArrayList<WSPurgeResponse>(instanceList.size());
        Iterator iterator = instanceList.iterator();
        while (iterator.hasNext()) {
            long instanceId = (Long)iterator.next();
            try {
                purgeResponseList.add(this.purgeJobInstance("true".equalsIgnoreCase(request.getParameter("purgeJobStoreOnly")), instanceId, request));
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"1128", (Object)this, (Object[])new Object[]{request, response});
                purgeResponseList.add(new WSPurgeResponse(instanceId, PurgeStatus.FAILED, "Exception ocurred during purge of job instance " + instanceId + " : " + e.getMessage(), null));
            }
        }
        response.setContentType("application/json; charset=UTF-8");
        BatchJSONHelper.buildAndWritePurgeJsonObject(purgeResponseList, response.getOutputStream());
    }

    /*
     * WARNING - void declaration
     */
    protected void purgeJobInstances(RESTRequest request, RESTResponse response, int version) throws Exception {
        String unrecognized = this.getUnrecognizedParameters(request, version);
        if (unrecognized != null) {
            response.addResponseHeader("X-IBM-Unrecognized-Fields", unrecognized);
        }
        List<WSJobInstance> jobInstances = this.doJobInstanceSearch(request, version);
        ArrayList<Long> instanceList = new ArrayList<Long>(jobInstances.size());
        for (WSJobInstance job : jobInstances) {
            instanceList.add(job.getInstanceId());
        }
        ArrayList<WSPurgeResponse> purgeResponseList = new ArrayList<WSPurgeResponse>(instanceList.size());
        Iterator iterator = instanceList.iterator();
        while (iterator.hasNext()) {
            long instanceId = (Long)iterator.next();
            try {
                purgeResponseList.add(this.purgeJobInstance("true".equalsIgnoreCase(request.getParameter("purgeJobStoreOnly")), instanceId, request));
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"1175", (Object)this, (Object[])new Object[]{request, response, version});
                purgeResponseList.add(new WSPurgeResponse(instanceId, PurgeStatus.FAILED, "Exception ocurred during purge of job instance " + instanceId + " : " + e.getMessage(), null));
            }
        }
        response.setContentType("application/json; charset=UTF-8");
        BatchJSONHelper.buildAndWritePurgeJsonObject(purgeResponseList, response.getOutputStream());
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={NoSuchJobInstanceException.class})
    protected WSPurgeResponse purgeJobInstance(boolean purgeJobStoreOnly, long jobInstanceId, RESTRequest request) throws Exception {
        WSPurgeResponse purgeResponse = new WSPurgeResponse(jobInstanceId, PurgeStatus.COMPLETED, "Successful purge.", null);
        try {
            if (!this.jobRepository.isJobInstancePurgeable(jobInstanceId)) {
                purgeResponse.setMessage("The specified job instance, " + jobInstanceId + ", cannot be purged because it has active job executions.");
                purgeResponse.setPurgeStatus(PurgeStatus.STILL_ACTIVE);
                return purgeResponse;
            }
        }
        catch (NoSuchJobInstanceException e) {
            purgeResponse.setMessage(ResourceBundleRest.getMessage("job.instance.not.found", jobInstanceId));
            purgeResponse.setPurgeStatus(PurgeStatus.FAILED);
            return purgeResponse;
        }
        if (!purgeJobStoreOnly) {
            boolean fileSuccess = false;
            JobInstanceLog instanceLog = null;
            try {
                instanceLog = this.jobLogManagerService.getJobInstanceLog(jobInstanceId);
            }
            catch (NoSuchJobInstanceException e) {
                throw new BatchNoSuchJobInstanceException(e, jobInstanceId);
            }
            if (instanceLog.areExecutionsLocal()) {
                fileSuccess = instanceLog.purge();
            } else {
                List<String> restUrls = this.findJobExecutionEndpoints(jobInstanceId);
                String responses = "";
                for (String restUrl : restUrls) {
                    try {
                        HttpsURLConnection connection = BatchRequestUtil.sendRESTRequest(BatchRequestUtil.buildJoblogsUrlForJobInstance(jobInstanceId, restUrl, ""), "DELETE", request, null);
                        if (connection != null) {
                            responses = responses.concat("A request to " + connection.getURL().getPath() + "/" + BatchRequestUtil.getUrlVersion(request.getURL()) + " returned response code " + connection.getResponseCode() + ". ");
                            if (connection.getResponseCode() == 200) continue;
                            purgeResponse.setMessage("An error occurred while purging the job instance (" + jobInstanceId + "). Not all job log files were deleted so no attempt was made to delete database entries. " + responses);
                            purgeResponse.setPurgeStatus(PurgeStatus.FAILED);
                            continue;
                        }
                        responses = responses.concat("A request to " + BatchRequestUtil.buildJoblogsUrlForJobInstance(jobInstanceId, restUrl, "") + " failed. ");
                        purgeResponse.setMessage("An error occurred while purging the job instance (" + jobInstanceId + "). Not all job log files were deleted so no attempt was made to delete database entries. " + responses);
                        purgeResponse.setPurgeStatus(PurgeStatus.FAILED);
                    }
                    catch (Exception connection) {
                        void ex;
                        FFDCFilter.processException((Throwable)connection, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"1259", (Object)this, (Object[])new Object[]{purgeJobStoreOnly, jobInstanceId, request});
                        responses = responses.concat("Exception occurred during a request to " + BatchRequestUtil.buildJoblogsUrlForJobInstance(jobInstanceId, restUrl, "") + ", exception details: " + ex.getClass().getName() + ": " + ex.getLocalizedMessage());
                        purgeResponse.setMessage("An exception occurred while purging the job instance (" + jobInstanceId + "). Not all job log files were deleted so no attempt was made to delete database entries." + responses);
                        purgeResponse.setPurgeStatus(PurgeStatus.FAILED);
                    }
                }
                if (purgeResponse.getPurgeStatus() == PurgeStatus.COMPLETED) {
                    fileSuccess = true;
                }
            }
            if (fileSuccess) {
                boolean dbSuccess = this.wsJobOperator.purgeJobInstance(jobInstanceId);
                if (!dbSuccess) {
                    purgeResponse.setMessage("An error occurred while purging the job instance (" + jobInstanceId + "). The job logs were sucessfully deleted but not all database entries were deleted.");
                    purgeResponse.setPurgeStatus(PurgeStatus.JOBLOGS_ONLY);
                }
            } else {
                purgeResponse.setMessage("An error occurred while purging the job instance (" + jobInstanceId + "). Not all job log files were deleted so no attempt was made to delete database entries.");
                purgeResponse.setPurgeStatus(PurgeStatus.FAILED);
            }
        } else {
            boolean dbSuccess = this.wsJobOperator.purgeJobInstance(jobInstanceId);
            if (!dbSuccess) {
                purgeResponse.setMessage("An error occurred while purging the job instance (" + jobInstanceId + "). Not all database entries were deleted.");
                purgeResponse.setPurgeStatus(PurgeStatus.FAILED);
            }
        }
        return purgeResponse;
    }

    private String findSingleJobExecutionEndpoint(long jobInstanceId) {
        List jobExecutions = this.jobRepository.getJobExecutionsFromInstance(jobInstanceId);
        ArrayList<String> restUrls = new ArrayList<String>();
        for (JobExecution jobExecution : jobExecutions) {
            restUrls.add(((WSJobExecution)jobExecution).getRestUrl());
        }
        if (StringUtils.areEqual(restUrls)) {
            String restUrl = ((WSJobExecution)jobExecutions.get(0)).getRestUrl();
            return restUrl;
        }
        throw new BatchRuntimeException("Cannot provide a single endpoint for job instance " + jobInstanceId + " because its job executions ran on different endpoints: " + restUrls);
    }

    private List<String> findJobExecutionEndpoints(long jobInstanceId) {
        List jobExecutions = this.jobRepository.getJobExecutionsFromInstance(jobInstanceId);
        ArrayList<String> restUrls = new ArrayList<String>();
        for (JobExecution jobExecution : jobExecutions) {
            restUrls.add(((WSJobExecution)jobExecution).getRestUrl());
            List remotePartitions = this.jobRepository.getRemotablePartitionsForJobExecution(jobExecution.getExecutionId());
            if (remotePartitions == null) continue;
            for (WSRemotablePartitionExecution partition : remotePartitions) {
                restUrls.add(partition.getRestUrl());
            }
        }
        return restUrls;
    }

    /*
     * WARNING - void declaration
     */
    protected void purgeLocalJobLogs(RESTRequest request, RESTResponse response, long jobInstanceId) {
        JobInstanceLog instanceLog = null;
        try {
            instanceLog = this.jobLogManagerService.getLocalJobInstanceLog(jobInstanceId);
            instanceLog.purge();
        }
        catch (NoSuchJobInstanceException noSuchJobInstanceException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchJobInstanceException, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances", (String)"1356", (Object)this, (Object[])new Object[]{request, response, jobInstanceId});
            throw new BatchNoSuchJobInstanceException((Throwable)e, jobInstanceId);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobLogsHandler
    extends RequestHandler {
        static final long serialVersionUID = 4019622600144967640L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobLogsHandler() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            long jobInstanceId = JobInstances.this.getJobInstanceId(request);
            try {
                JobInstanceLog jobInstanceLog = JobInstances.this.jobLogManagerService.getJobInstanceLog(jobInstanceId);
                if (jobInstanceLog.areExecutionsLocal() || "true".equals(request.getParameter("localOnly"))) {
                    this.sendJobInstanceLog(jobInstanceLog, request, response);
                } else {
                    this.handleJobLogsNotLocal(request, response, jobInstanceId);
                }
            }
            catch (NoSuchJobInstanceException jobInstanceLog) {
                void e;
                FFDCFilter.processException((Throwable)jobInstanceLog, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances$JobLogsHandler", (String)"379", (Object)this, (Object[])new Object[]{request, response});
                throw new BatchNoSuchJobInstanceException((Throwable)e, jobInstanceId);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void sendJobInstanceLog(JobInstanceLog jobInstanceLog, RESTRequest request, RESTResponse response) throws IOException {
            if ("zip".equals(request.getParameter("type"))) {
                ZipOutputStream zipOutput = new ZipOutputStream(response.getOutputStream());
                response.setContentType("application/zip");
                response.setResponseHeader("Content-Disposition", "attachment; filename=" + StringUtils.enquote(this.getZipFileName(jobInstanceLog)));
                HashSet partitionEndpointURLs = new HashSet();
                for (JobExecutionLog jobExecutionLog : jobInstanceLog.getJobExecutionLogs()) {
                    if (jobExecutionLog.getRemotePartitionLogs() == null || "true".equals(request.getParameter("localOnly"))) continue;
                    partitionEndpointURLs.addAll(jobExecutionLog.getRemotePartitionEndpointURLs());
                }
                partitionEndpointURLs.remove(BatchRequestUtil.getUrlRoot(request));
                System.out.println("CGCG endpoint URLs:");
                for (String url : partitionEndpointURLs) {
                    System.out.println("CGCG " + url);
                    String joblogUrl = BatchRequestUtil.buildJoblogsUrlForJobInstance(jobInstanceLog.getJobInstance().getInstanceId(), url, "type=zip&localOnly=true");
                    try {
                        HttpsURLConnection conn = BatchRequestUtil.sendRESTRequest(joblogUrl, "GET", request, null);
                        if (conn == null) continue;
                        ZipInputStream zipInput = new ZipInputStream(conn.getInputStream());
                        ZipHelper.copyZipEntries(zipInput, zipOutput);
                    }
                    catch (Exception conn) {
                        void ex;
                        FFDCFilter.processException((Throwable)conn, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances$JobLogsHandler", (String)"431", (Object)this, (Object[])new Object[]{jobInstanceLog, request, response});
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Exception occurred fetching remote partition logs from " + joblogUrl + ", exception details: " + ex.getClass().getName() + ": " + ex.getLocalizedMessage()), (Object[])new Object[0]);
                    }
                }
                ZipHelper.zipFilesToStream((List<File>)jobInstanceLog.getJobLogFiles(), jobInstanceLog.getInstanceLogRootDirs(), (OutputStream)zipOutput);
            } else if ("text".equals(request.getParameter("type"))) {
                response.setContentType("text/plain; charset=UTF-8");
                ZipHelper.aggregateFilesToStream((List<File>)jobInstanceLog.getJobLogFiles(), jobInstanceLog.getInstanceLogRootDirs(), response.getOutputStream());
                HashSet partitionEndpointURLs = new HashSet();
                for (JobExecutionLog jobExecutionLog : jobInstanceLog.getJobExecutionLogs()) {
                    if (jobExecutionLog.getRemotePartitionLogs() == null || "true".equals(request.getParameter("localOnly"))) continue;
                    partitionEndpointURLs.addAll(jobExecutionLog.getRemotePartitionEndpointURLs());
                }
                partitionEndpointURLs.remove(BatchRequestUtil.getUrlRoot(request));
                System.out.println("CGCG endpoint URLs:");
                for (String url : partitionEndpointURLs) {
                    System.out.println("CGCG " + url);
                    String joblogUrl = BatchRequestUtil.buildJoblogsUrlForJobInstance(jobInstanceLog.getJobInstance().getInstanceId(), url, "type=text&localOnly=true");
                    try {
                        int len;
                        HttpsURLConnection conn = BatchRequestUtil.sendRESTRequest(joblogUrl, "GET", request, null);
                        if (conn == null) continue;
                        byte[] buf = new byte[2048];
                        while ((len = conn.getInputStream().read(buf)) != -1) {
                            response.getOutputStream().write(buf, 0, len);
                        }
                    }
                    catch (Exception conn) {
                        void ex;
                        FFDCFilter.processException((Throwable)conn, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances$JobLogsHandler", (String)"488", (Object)this, (Object[])new Object[]{jobInstanceLog, request, response});
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Exception occurred fetching remote partition logs from " + joblogUrl + ", exception details: " + ex.getClass().getName() + ": " + ex.getLocalizedMessage()), (Object[])new Object[0]);
                    }
                }
            } else {
                response.setContentType("application/json; charset=UTF-8");
                BatchJSONHelper.writeJobInstanceLogLinks(jobInstanceLog, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
            }
        }

        protected void handleJobLogsNotLocal(RESTRequest request, RESTResponse response, long jobInstanceId) throws IOException {
            if ("zip".equals(request.getParameter("type")) || "text".equals(request.getParameter("type"))) {
                String restUrl = JobInstances.this.findSingleJobExecutionEndpoint(jobInstanceId);
                BatchRequestUtil.handleNonLocalRequest(BatchRequestUtil.buildJoblogsUrlForJobInstance(jobInstanceId, restUrl, request.getQueryString()), "GET", request, response);
            } else {
                JobInstanceLog jobInstanceLog = JobInstances.this.jobLogManagerService.getJobInstanceLogAllExecutions(jobInstanceId);
                response.setContentType("application/json; charset=UTF-8");
                BatchJSONHelper.writeJobInstanceLogLinks(jobInstanceLog, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
            }
        }

        protected String getZipFileName(JobInstanceLog jobInstanceLog) {
            return "joblogs." + jobInstanceLog.getJobInstance().getJobName() + ".instance." + jobInstanceLog.getJobInstance().getInstanceId() + ".zip";
        }

        @Override
        public void delete(RESTRequest request, RESTResponse response) throws Exception {
            JobInstances.this.purgeLocalJobLogs(request, response, JobInstances.this.getJobInstanceId(request));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances$JobLogsHandler", JobLogsHandler.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobInstanceHandler
    extends RequestHandler {
        static final long serialVersionUID = 7463780381537420939L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobInstanceHandler() {
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            JobInstances.this.getJobInstanceData(request, response, JobInstances.this.getJobInstanceId(request));
        }

        @Override
        public void put(RESTRequest request, RESTResponse response) throws Exception {
            String action = request.getParameter("action");
            if ("stop".equalsIgnoreCase(action)) {
                JobInstances.this.stopJobInstance(request, response, JobInstances.this.getJobInstanceId(request));
            } else if ("restart".equalsIgnoreCase(action)) {
                JobInstances.this.restartJobInstance(request, response, JobInstances.this.getJobInstanceId(request));
            } else {
                response.sendError(400, "Invalid HTTP query parameters: only action=stop and action=restart are supported.");
            }
        }

        @Override
        public void delete(RESTRequest request, RESTResponse response) throws Exception {
            JobInstances.this.purgeJobInstance(request, response);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances$JobInstanceHandler", JobInstanceHandler.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobInstancesHandler_v4
    extends JobInstancesHandler {
        static final long serialVersionUID = -7442095798064459700L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobInstancesHandler_v4() {
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            JobInstances.this.searchJobInstances(request, response, 4);
        }

        @Override
        public void delete(RESTRequest request, RESTResponse response) throws Exception {
            JobInstances.this.purgeJobInstances(request, response, 4);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances$JobInstancesHandler_v4", JobInstancesHandler_v4.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobInstancesHandler_v3
    extends JobInstancesHandler {
        static final long serialVersionUID = 8301012409616126484L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobInstancesHandler_v3() {
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            JobInstances.this.searchJobInstances(request, response, 3);
        }

        @Override
        public void delete(RESTRequest request, RESTResponse response) throws Exception {
            JobInstances.this.purgeJobInstances(request, response, 3);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances$JobInstancesHandler_v3", JobInstancesHandler_v3.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobInstancesHandler_v2
    extends JobInstancesHandler {
        static final long serialVersionUID = 3930509548619109934L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobInstancesHandler_v2() {
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            JobInstances.this.searchJobInstances(request, response);
        }

        @Override
        public void delete(RESTRequest request, RESTResponse response) throws Exception {
            JobInstances.this.purgeJobInstances(request, response);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances$JobInstancesHandler_v2", JobInstancesHandler_v2.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobInstancesHandler
    extends RequestHandler {
        static final long serialVersionUID = 487045429776557926L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobInstancesHandler() {
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            JobInstances.this.listJobInstances(request, response);
        }

        @Override
        public void post(RESTRequest request, RESTResponse response) throws Exception {
            JobInstances.this.submitJob(request, response);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.JobInstances$JobInstancesHandler", JobInstancesHandler.class, (String)"wsbatch", null);
        }
    }
}

