/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.rest;

import com.ibm.ws.jbatch.utility.rest.BatchDateFormat;
import com.ibm.ws.jbatch.utility.rest.JsonHelper;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.json.JsonObject;
import javax.json.JsonString;

public class JobExecutionModel
implements JobExecution {
    private JsonObject jsonObject;

    public JobExecutionModel(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public String getJobName() {
        return this.jsonObject.getString("jobName", "");
    }

    public long getExecutionId() {
        if (this.jsonObject.getJsonNumber("executionId") == null) {
            return -1L;
        }
        return this.jsonObject.getJsonNumber("executionId").longValue();
    }

    public BatchStatus getBatchStatus() {
        return BatchStatus.valueOf((String)this.jsonObject.getString("batchStatus"));
    }

    public Date getStartTime() {
        return BatchDateFormat.parseDate(this.jsonObject.getString("startTime", null));
    }

    public Date getEndTime() {
        return BatchDateFormat.parseDate(this.jsonObject.getString("endTime", null));
    }

    public String getExitStatus() {
        return this.jsonObject.getString("exitStatus", "");
    }

    public Date getCreateTime() {
        return BatchDateFormat.parseDate(this.jsonObject.getString("createTime", null));
    }

    public Date getLastUpdatedTime() {
        return BatchDateFormat.parseDate(this.jsonObject.getString("lastUpdatedTime", null));
    }

    public Properties getJobParameters() {
        return this.parseProperties(this.jsonObject.getJsonObject("jobParameters"));
    }

    protected Properties parseProperties(JsonObject props) {
        if (props == null) {
            return null;
        }
        Properties retMe = new Properties();
        for (Map.Entry entry : props.entrySet()) {
            retMe.setProperty((String)entry.getKey(), ((JsonString)entry.getValue()).getString());
        }
        return retMe;
    }

    public String toString() {
        return JsonHelper.removeFields(this.jsonObject, "_links").toString();
    }
}

