/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.tsx.db;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.tsx.db.ConnectionProperties;
import com.ibm.ws.jsp.tsx.db.QueryResults;
import com.ibm.ws.jsp.tsx.db.QueryRow;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class Query {
    private static final String icClass = "com.ibm.websphere.naming.WsnInitialContextFactory";
    private static final String icProvider = "iiop:///";
    private static Hashtable datasources;
    private static InitialContext ic;
    private String queryString = null;
    private QueryResults results = null;
    private ConnectionProperties connProperties = null;
    private int maxRows = -1;
    static final long serialVersionUID = -2112025061313216586L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected Query() {
    }

    public Query(ConnectionProperties cp, String queryString) throws JspCoreException {
        this.setConnProperties(cp);
        this.setQueryString(queryString);
    }

    public QueryResults execute() throws JspCoreException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        QueryResults qs = null;
        this.verify();
        try {
            conn = this.getJdbcConnection();
            stmt = conn.createStatement();
            int mrows = this.getMaxRows();
            if (mrows > 0) {
                stmt.setMaxRows(mrows);
            }
            rs = stmt.executeQuery(this.getQueryString());
            qs = new QueryResults();
            qs.compute(rs);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        this.setResults(qs);
        return qs;
    }

    public void executeUpdate() throws JspCoreException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        this.verify();
        try {
            conn = this.getJdbcConnection();
            stmt = conn.createStatement();
            stmt.executeUpdate(this.getQueryString());
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    protected ConnectionProperties getConnProperties() {
        return this.connProperties;
    }

    protected String getQueryString() {
        return this.queryString;
    }

    protected QueryResults getResults() {
        return this.results;
    }

    public void setMaxRows(int newValue) {
        if (newValue > 0) {
            this.maxRows = newValue;
        }
    }

    protected int getMaxRows() {
        return this.maxRows;
    }

    private Connection getJdbcConnection() throws JspCoreException, SQLException {
        DataSource ds;
        Connection conn = null;
        String url = this.getConnProperties().getUrl();
        String user = this.getConnProperties().getLoginUser();
        String passwd = this.getConnProperties().getLoginPasswd();
        String jndiName = this.getConnProperties().getJndiName();
        if (jndiName == null) {
            String dbDriver = this.getConnProperties().getDbDriver();
            try {
                Class.forName(dbDriver);
                conn = DriverManager.getConnection(url, user, passwd);
            }
            catch (ClassNotFoundException e) {
                throw new JspCoreException("InvalidDbDriver" + dbDriver);
            }
        }
        try {
            ds = Query.getSingleton(jndiName);
        }
        catch (Throwable th) {
            throw new JspCoreException("DatasourceException" + th.getMessage());
        }
        conn = ds.getConnection(user, passwd);
        return conn;
    }

    private static DataSource getSingleton(String datasourceName) throws JspCoreException {
        DataSource ds = (DataSource)datasources.get(datasourceName);
        if (ds != null) {
            return ds;
        }
        ds = Query.findDataSource(datasourceName);
        return ds;
    }

    private static synchronized DataSource findDataSource(String datasourceName) throws JspCoreException {
        DataSource ds = (DataSource)datasources.get(datasourceName);
        if (ds != null) {
            return ds;
        }
        InitialContext ic = Query.getSingletonContext();
        DataSource dataSource = null;
        try {
            dataSource = (DataSource)ic.lookup(datasourceName);
        }
        catch (Throwable th) {
            throw new JspCoreException("Error looking up DataSource " + dataSource + " " + th.getMessage());
        }
        datasources.put(datasourceName, dataSource);
        return dataSource;
    }

    private static InitialContext getSingletonContext() throws JspCoreException {
        if (ic == null) {
            Query.getInitialContext();
        }
        return ic;
    }

    private static synchronized InitialContext getInitialContext() throws JspCoreException {
        if (ic != null) {
            return ic;
        }
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (initialContext == null) {
            Properties p = new Properties();
            p.put("java.naming.factory.initial", icClass);
            p.put("java.naming.provider.url", icProvider);
            try {
                initialContext = new InitialContext(p);
                if (initialContext == null) {
                    throw new JspCoreException("null pointer returned for InitalContext");
                }
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.webcontainer.jsp.tsx.db.Query.getInitialContext", (String)"266");
                throw new JspCoreException("Error getting InitialContext, " + th.getMessage());
            }
        }
        ic = initialContext;
        return ic;
    }

    public static void main(String[] args) {
        String dbDriver = "COM.ibm.db2.jdbc.app.DB2Driver";
        String url = "jdbc:db2:sample";
        String user = "Murali";
        String pass = "ibm";
        String querystring = "Select * from Murali.department";
        try {
            ConnectionProperties cp = new ConnectionProperties(dbDriver, url, user, pass);
            Query query = new Query(cp, querystring);
            QueryResults qs = query.execute();
            System.out.println("Number of rows = " + qs.size());
            for (int i = 0; i < qs.size(); ++i) {
                String dept = qs.getValue("DEPTNAME", i);
                System.out.println("Department:" + dept);
            }
        }
        catch (Exception e) {
            System.out.println("Exception:: " + e.getMessage());
        }
    }

    public static void main2(String[] args) {
        String dbDriver = "COM.ibm.db2.jdbc.app.DB2Driver";
        String url = "jdbc:db2:sample";
        String user = "batra";
        String pass = "varunbatra";
        String querystring = "Select * from batra.employee";
        try {
            ConnectionProperties cp = new ConnectionProperties(dbDriver, url, user, pass);
            Query query = new Query(cp, querystring);
            QueryResults qs = query.execute();
            System.out.println("Number of rows = " + qs.size());
            while (qs.next()) {
                String fn = qs.getValue("FIRSTNME");
                String ln = qs.getValue("LASTNAME");
                String bd = qs.getValue("BIRTHDATE");
                String sal = qs.getValue("SALARY");
                System.out.println(fn + " " + ln + " birthdate " + bd + " salary " + sal);
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
        System.out.println("All is Fine!");
    }

    public static void main3(String[] args) {
        String dbDriver = "COM.ibm.db2.jdbc.app.DB2Driver";
        String url = "jdbc:db2:sample";
        String user = "batra";
        String pass = "varunbatra";
        String querystring = "Select * from batra.employee";
        try {
            ConnectionProperties cp = new ConnectionProperties(dbDriver, url, user, pass);
            Query query = new Query(cp, querystring);
            QueryResults qs = query.execute();
            System.out.println("Number of rows = " + qs.size());
            Enumeration e = qs.getRows();
            while (e.hasMoreElements()) {
                QueryRow qr = (QueryRow)e.nextElement();
                String fn = qr.getValue("FIRSTNME");
                String ln = qr.getValue("LASTNAME");
                String bd = qr.getValue("BIRTHDATE");
                String sal = qr.getValue("SALARY");
                System.out.println(fn + " " + ln + " birthdate " + bd + " salary " + sal);
            }
        }
        catch (Exception e) {
            System.out.println("Exception:: " + e.getMessage());
        }
        System.out.println("All is Fine!!!!!");
    }

    public static void mainold(String[] args) {
        String dbDriver = "COM.ibm.db2.jdbc.app.DB2Driver";
        String url = "jdbc:db2:sample";
        String user = "Murali";
        String pass = "ibm";
        String querystring = "Select FIRSTNME, LASTNAME, BIRTHDATE, SALARY from Murali.employee";
        try {
            ConnectionProperties cp = new ConnectionProperties(dbDriver, url, user, pass);
            Query query = new Query(cp, querystring);
            QueryResults qs = query.execute();
            System.out.println("Number of rows = " + qs.size());
            Enumeration e = qs.getRows();
            while (e.hasMoreElements()) {
                QueryRow qr = (QueryRow)e.nextElement();
                String fn = qr.getValue("FIRSTNME");
                String ln = qr.getValue("LASTNAME");
                String bd = qr.getValue("BIRTHDATE");
                String sal = qr.getValue("SALARY");
                System.out.println(fn + " " + ln + " birthdate " + bd + " salary " + sal);
            }
        }
        catch (Exception e) {
            System.out.println("Exception:: " + e.getMessage());
        }
    }

    public void setConnProperties(ConnectionProperties newValue) {
        this.connProperties = newValue;
    }

    protected void setQueryString(String newValue) throws JspCoreException {
        if (newValue == null) {
            throw new JspCoreException("NullQueryString");
        }
        int len = newValue.length();
        StringBuffer buff = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = newValue.charAt(i);
            if (Character.isWhitespace(c)) {
                buff.append(" ");
                continue;
            }
            buff.append(c);
        }
        this.queryString = buff.toString().trim();
    }

    protected void setResults(QueryResults newValue) {
        this.results = newValue;
    }

    protected void verify() throws JspCoreException {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.tsx.db.Query", Query.class, null, null);
        datasources = new Hashtable();
        ic = null;
    }
}

