/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.document;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.document.JspDocumentConverter;
import com.ibm.ws.jsp.translator.document.JspDocumentParser;
import com.ibm.ws.jsp.translator.document.JspEncodingScanner;
import com.ibm.ws.jsp.translator.document.JspPageParser;
import com.ibm.ws.jsp.translator.document.XMLEncodingDetector;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class Jsp2Dom {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.document.Jsp2Dom";
    static final String DEFAULT_ENCODING = "ISO-8859-1";
    static final String CONVERTED_DEFAULT_ENCODING = EncodingUtils.getJvmConverter((String)"ISO-8859-1");
    private Stack directoryStack;
    private Stack dependencyStack;
    private List dependencyList;
    private Map cdataJspIdMap;
    private Map implicitTagLibMap;
    private JspInputSource jspInputSource;
    private String resolvedRelativeURL;
    private JspCoreContext context;
    private JspConfiguration jspConfiguration;
    private JspOptions jspOptions;
    private Boolean parentIsXml;
    private boolean isXml;
    String sourceEnc;
    boolean isEncodingSpecifiedInProlog;
    boolean isBomPresent;
    private boolean isDefaultPageEncoding;
    private boolean isServlet25;
    static final long serialVersionUID = 1367834915942542419L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Jsp2Dom(JspInputSource jspInputSource, JspCoreContext context, JspConfiguration jspConfiguration, JspOptions jspOptions, Map implicitTagLibMap) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{jspInputSource, context, jspConfiguration, jspOptions, implicitTagLibMap});
        }
        this.directoryStack = null;
        this.dependencyStack = null;
        this.dependencyList = null;
        this.cdataJspIdMap = null;
        this.implicitTagLibMap = null;
        this.jspInputSource = null;
        this.resolvedRelativeURL = null;
        this.context = null;
        this.jspConfiguration = null;
        this.jspOptions = null;
        this.parentIsXml = null;
        this.isXml = false;
        this.sourceEnc = null;
        this.isEncodingSpecifiedInProlog = false;
        this.isBomPresent = false;
        this.isDefaultPageEncoding = false;
        this.isServlet25 = false;
        this.jspInputSource = jspInputSource;
        this.context = context;
        this.jspConfiguration = jspConfiguration;
        this.directoryStack = new Stack();
        this.directoryStack.push("/");
        this.dependencyStack = new Stack();
        this.dependencyList = new ArrayList();
        this.jspOptions = jspOptions;
        this.cdataJspIdMap = new HashMap();
        this.resolveBaseDir();
        this.implicitTagLibMap = implicitTagLibMap;
        this.isServlet25 = jspConfiguration.getServletVersion().equals("2.5");
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "Jsp2Dom 1 this.jspInputSource: [" + this.jspInputSource.getRelativeURL() + "]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Jsp2Dom(JspInputSource jspInputSource, JspCoreContext context, Stack directoryStack, JspConfiguration jspConfiguration, JspOptions jspOptions, Stack dependencyStack, List dependencyList, Map cdataJspIdMap, Map implicitTagLibMap, boolean parentIsXml) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{jspInputSource, context, directoryStack, jspConfiguration, jspOptions, dependencyStack, dependencyList, cdataJspIdMap, implicitTagLibMap, parentIsXml});
        }
        this.directoryStack = null;
        this.dependencyStack = null;
        this.dependencyList = null;
        this.cdataJspIdMap = null;
        this.implicitTagLibMap = null;
        this.jspInputSource = null;
        this.resolvedRelativeURL = null;
        this.context = null;
        this.jspConfiguration = null;
        this.jspOptions = null;
        this.parentIsXml = null;
        this.isXml = false;
        this.sourceEnc = null;
        this.isEncodingSpecifiedInProlog = false;
        this.isBomPresent = false;
        this.isDefaultPageEncoding = false;
        this.isServlet25 = false;
        this.jspInputSource = jspInputSource;
        this.context = context;
        this.jspConfiguration = jspConfiguration;
        this.jspOptions = jspOptions;
        this.directoryStack = directoryStack;
        this.dependencyStack = dependencyStack;
        this.dependencyList = dependencyList;
        this.cdataJspIdMap = cdataJspIdMap;
        this.implicitTagLibMap = implicitTagLibMap;
        this.parentIsXml = parentIsXml;
        this.resolveBaseDir();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "Jsp2Dom 2 this.jspInputSource: [" + this.jspInputSource.getRelativeURL() + "]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Document getJspDocument() throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspDocument", new Object[0]);
        }
        Document document = null;
        if (this.jspInputSource.isXmlDocument()) {
            document = new JspDocumentConverter(this.jspInputSource, this.resolvedRelativeURL, this.context, this.directoryStack, this.jspConfiguration, this.jspOptions, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, this.implicitTagLibMap).convert();
            this.jspConfiguration.setIsXml(true);
        } else {
            this.getSyntaxAndEncoding();
            if (!(!this.isXml || !this.isEncodingSpecifiedInProlog || this.jspConfiguration.getPageEncoding() == null || this.jspConfiguration.getPageEncoding().equalsIgnoreCase(this.sourceEnc) || this.jspConfiguration.getPageEncoding().toUpperCase().startsWith("UTF-16") && this.sourceEnc.toUpperCase().startsWith("UTF-16"))) {
                throw new JspCoreException("jsp.error.prolog_config_encoding_mismatch", new Object[]{this.sourceEnc, this.jspConfiguration.getPageEncoding()});
            }
            if (!this.isDefaultPageEncoding && !this.isXml) {
                this.jspConfiguration.setResponseEncoding(this.sourceEnc);
            }
            document = this.isXml ? this.parseToDom() : this.getJspDocumentAsJspPage();
        }
        this.directoryStack.pop();
        Document document2 = document;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            document2 = document2;
            logger.exiting(CLASS_NAME, "getJspDocument", document2);
        }
        return document2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void getSyntaxAndEncoding() throws JspCoreException {
        block74: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering(CLASS_NAME, "getSyntaxAndEncoding", new Object[0]);
            }
            InputStream is = null;
            BufferedReader br = null;
            try {
                JspConfiguration specificConfiguration;
                this.isXml = false;
                boolean isExternal = false;
                boolean revert = false;
                if (!this.jspOptions.isReusePropertyGroupConfigOnInclude()) {
                    specificConfiguration = this.jspConfiguration.getConfigManager().getConfigurationForUrl(this.resolvedRelativeURL);
                    this.jspConfiguration.setPageEncoding(specificConfiguration.getPageEncoding());
                } else {
                    specificConfiguration = this.jspConfiguration;
                }
                if (specificConfiguration.isXmlSpecified()) {
                    this.isXml = specificConfiguration.isXml();
                    this.jspConfiguration.setIsXml(this.isXml);
                    isExternal = true;
                } else if (this.jspInputSource.getRelativeURL().endsWith(".jspx") || this.jspInputSource.getRelativeURL().endsWith(".tagx")) {
                    this.isXml = true;
                    isExternal = true;
                    this.jspConfiguration.setIsXml(true);
                }
                if (isExternal && !this.isXml) {
                    this.sourceEnc = this.jspConfiguration.getPageEncoding();
                    if (this.sourceEnc != null) {
                        if (logger != null && logger.isLoggable(Level.FINER)) {
                            logger.exiting(CLASS_NAME, "getSyntaxAndEncoding");
                        }
                        return;
                    }
                    this.sourceEnc = DEFAULT_ENCODING;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "about to call detectXMLEncoding(), sourceEnc = {0}", new Object[]{this.sourceEnc});
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "about to call detectXMLEncoding(), isXml = {0}", new Object[]{this.isXml});
                    }
                    this.detectXMLEncoding();
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "back from detectXMLEncoding(), sourceEnc = {0}", new Object[]{this.sourceEnc});
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "back from detectXMLEncoding(), isXml = {0}", new Object[]{this.isXml});
                    }
                    if (!this.isXml && this.sourceEnc.equalsIgnoreCase("UTF-8")) {
                        this.sourceEnc = DEFAULT_ENCODING;
                        revert = true;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "Just reverted sourceEnc, sourceEnc = {0}", new Object[]{this.sourceEnc});
                        }
                    }
                }
                if (this.isXml) {
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        logger.exiting(CLASS_NAME, "getSyntaxAndEncoding");
                    }
                    return;
                }
                String savedEncoding = this.sourceEnc;
                is = this.getInputStream();
                try {
                    br = new BufferedReader(new InputStreamReader(is, this.sourceEnc), 8192);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "created BufferedReader with sourceEnc = {0}", new Object[]{this.sourceEnc});
                    }
                }
                catch (IOException e) {
                    throw new JspCoreException(e);
                }
                if (!isExternal) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "!isExternal about to call hasJspRoot()");
                    }
                    if (this.hasJspRoot(br)) {
                        if (revert) {
                            this.sourceEnc = "UTF-8";
                        }
                        this.isXml = true;
                        this.jspConfiguration.setIsXml(true);
                        if (logger != null && logger.isLoggable(Level.FINER)) {
                            logger.exiting(CLASS_NAME, "getSyntaxAndEncoding");
                        }
                        return;
                    }
                    if (revert && this.isBomPresent) {
                        this.sourceEnc = "UTF-8";
                    }
                    this.isXml = false;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "after hasJspRoot(), sourceEnc = {0}", new Object[]{this.sourceEnc});
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "after hasJspRoot(), isXml = {0}", new Object[]{this.isXml});
                    }
                }
                String sourceEncFromConfig = null;
                String sourceEncFromDir = null;
                sourceEncFromConfig = this.jspConfiguration.getPageEncoding();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "from jspConfiguration, sourceEnc = {0}", new Object[]{sourceEncFromConfig});
                }
                try {
                    br.reset();
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "called br.reset()");
                    }
                }
                catch (IOException e) {
                    try {
                        is.close();
                        br.close();
                        is = this.getInputStream();
                        br = new BufferedReader(new InputStreamReader(is, savedEncoding), 8192);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "created new BufferedReader with savedEncoding = {0}", new Object[]{savedEncoding});
                        }
                    }
                    catch (IOException ioe) {
                        throw new JspCoreException(ioe);
                    }
                }
                sourceEncFromDir = savedEncoding;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "calling getPageEncodingForJspSyntax(br) with sourceEnc = {0}", new Object[]{sourceEncFromDir});
                }
                sourceEncFromDir = this.getPageEncodingForJspSyntax(br);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "back from getPageEncodingForJspSyntax(br), sourceEnc = {0}", new Object[]{sourceEncFromDir});
                }
                if (this.isBomPresent) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "BOM is present, attempt to use page encoding from BOM, sourceEnc = {0}", new Object[]{this.sourceEnc});
                    }
                    if (!(sourceEncFromConfig == null || sourceEncFromConfig.equalsIgnoreCase(this.sourceEnc) || sourceEncFromConfig.toUpperCase().startsWith("UTF-16") && this.sourceEnc.toUpperCase().startsWith("UTF-16"))) {
                        throw new JspCoreException("jsp.error.prolog_config_encoding_mismatch", new Object[]{this.sourceEnc, sourceEncFromConfig});
                    }
                    if (!(sourceEncFromDir == null || sourceEncFromDir.equalsIgnoreCase(this.sourceEnc) || sourceEncFromDir.toUpperCase().startsWith("UTF-16") && this.sourceEnc.toUpperCase().startsWith("UTF-16"))) {
                        throw new JspCoreException("jsp.error.prolog_config_encoding_mismatch", new Object[]{this.sourceEnc, sourceEncFromDir});
                    }
                    break block74;
                }
                if (sourceEncFromConfig != null) {
                    this.sourceEnc = sourceEncFromConfig;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "Attempt to use page encoding from config, sourceEnc = {0}", new Object[]{this.sourceEnc});
                    }
                    if (sourceEncFromDir != null && !sourceEncFromConfig.equalsIgnoreCase(sourceEncFromDir) && this.isServlet25) {
                        throw new JspCoreException("jsp.error.encoding.mismatch.config.pageencoding", new Object[]{sourceEncFromConfig, sourceEncFromDir});
                    }
                    break block74;
                }
                if (sourceEncFromDir != null) {
                    this.sourceEnc = sourceEncFromDir;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "Attempt to use page encoding from page directives, sourceEnc = {0}", new Object[]{this.sourceEnc});
                    }
                    break block74;
                }
                this.sourceEnc = DEFAULT_ENCODING;
                this.isDefaultPageEncoding = true;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "sourceEnc was null, setting to default, sourceEnc = {0}", new Object[]{this.sourceEnc});
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "getSyntaxAndEncoding");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean hasJspRoot(BufferedReader br) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "hasJspRoot", new Object[]{br});
        }
        boolean hasRoot = false;
        JspEncodingScanner scanner = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "hasJspRoot", "Using Encoding = {0}", new Object[]{this.sourceEnc});
        }
        scanner = new JspEncodingScanner(br);
        scanner.scan();
        boolean bl = hasRoot = scanner.jspRootFound();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "hasJspRoot", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getPageEncodingForJspSyntax(BufferedReader br) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getPageEncodingForJspSyntax", new Object[]{br});
        }
        JspEncodingScanner scanner = null;
        String retEncoding = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "getPageEncodingForJspSyntax", " using Encoding = {0}", new Object[]{this.sourceEnc});
        }
        scanner = new JspEncodingScanner(br);
        scanner.scan();
        if (scanner.getEncoding() != null && !scanner.getEncoding().equals(DEFAULT_ENCODING)) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getPageEncodingForJspSyntax", "Scanned Encoding = {0}", new Object[]{scanner.getEncoding()});
            }
            retEncoding = EncodingUtils.getJvmConverter((String)scanner.getEncoding());
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getPageEncodingForJspSyntax", "Converted Scanned Encoding = {0}", new Object[]{retEncoding});
            }
        } else if (!CONVERTED_DEFAULT_ENCODING.equals(DEFAULT_ENCODING)) {
            retEncoding = CONVERTED_DEFAULT_ENCODING;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getPageEncodingForJspSyntax", "Converted Default Encoding = {0}", new Object[]{retEncoding});
            }
        }
        String string = retEncoding;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getPageEncodingForJspSyntax", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Document getJspDocumentAsJspPage() throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspDocumentAsJspPage", new Object[0]);
        }
        Document document = null;
        InputStream is = null;
        BufferedReader br = null;
        try {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getJspDocumentAsJspPage", " creating BufferedReader with encoding = {0}", new Object[]{this.sourceEnc});
            }
            is = this.getInputStream();
            String brEnc = !this.sourceEnc.toUpperCase().startsWith("UTF-16") ? this.sourceEnc : "UTF-16";
            br = new BufferedReader(new InputStreamReader(is, brEnc), 8192);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getJspDocumentAsJspPage", " CREATED BufferedReader with encoding = {0}", new Object[]{this.sourceEnc});
            }
            JspPageParser jspPageParser = new JspPageParser(br, this.jspInputSource, this.resolvedRelativeURL, this.context, this.directoryStack, this.jspConfiguration, this.jspOptions, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, this.implicitTagLibMap);
            try {
                document = jspPageParser.parse();
            }
            catch (JspCoreException jce) {
                throw new JspCoreException(jspPageParser.buildLineNumberMessage(jce.getLocalizedMessage()));
            }
        }
        catch (IOException e) {
            throw new JspCoreException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        Document document2 = document;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            document2 = document2;
            logger.exiting(CLASS_NAME, "getJspDocumentAsJspPage", document2);
        }
        return document2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Document parseToDom() throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "parseToDom", new Object[0]);
        }
        Document document = null;
        InputStream is = this.getInputStream();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "parseToDom 1 this.jspInputSource: [" + this.jspInputSource.getRelativeURL() + "]");
        }
        try {
            InputSource inputSource = new InputSource(is);
            JspDocumentParser jspDocumentParser = new JspDocumentParser(this.jspInputSource, this.resolvedRelativeURL, this.context, this.jspConfiguration, this.jspOptions, this.directoryStack, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, this.implicitTagLibMap, this.isBomPresent, this.isEncodingSpecifiedInProlog, this.sourceEnc);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "parseToDom 1 jspDocumentParser: [" + jspDocumentParser + "]");
            }
            try {
                document = jspDocumentParser.parse(inputSource);
            }
            catch (JspCoreException jce) {
                throw new JspCoreException(jspDocumentParser.buildLineNumberMessage(jce.getLocalizedMessage()));
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        Document document2 = document;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            document2 = document2;
            logger.exiting(CLASS_NAME, "parseToDom", document2);
        }
        return document2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void detectXMLEncoding() throws JspCoreException {
        Object[] ret;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "detectXMLEncoding", new Object[0]);
        }
        try {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "detectXMLEncoding about to call XMLEncodingDetector: [" + this.jspInputSource.getRelativeURL() + "]");
            }
            ret = XMLEncodingDetector.getEncoding(this.jspInputSource);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "detectXMLEncoding back from XMLEncodingDetector: [" + ret + "]");
            }
        }
        catch (IOException e1) {
            throw new JspCoreException(e1);
        }
        this.sourceEnc = (String)ret[0];
        if (((Boolean)ret[1]).booleanValue()) {
            this.isEncodingSpecifiedInProlog = true;
        }
        if (((Boolean)ret[2]).booleanValue()) {
            this.isBomPresent = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "detectXMLEncoding back from XMLEncodingDetector  sourceEnc: [" + this.sourceEnc + "]");
            logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "detectXMLEncoding back from XMLEncodingDetector  isEncodingSpecifiedInProlog: [" + this.isEncodingSpecifiedInProlog + "]");
            logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "detectXMLEncoding back from XMLEncodingDetector  isBomPresent: [" + this.isBomPresent + "]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "detectXMLEncoding");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected InputStream getInputStream() throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getInputStream", new Object[0]);
        }
        InputStream is = null;
        try {
            is = this.jspInputSource.getInputStream();
        }
        catch (IOException e) {
            String msg = JspCoreException.getMsg("jsp.error.failed.to.find.resource", new Object[]{this.jspInputSource.getRelativeURL()});
            throw new JspCoreException(msg, new FileNotFoundException(msg));
        }
        InputStream inputStream = is;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            inputStream = inputStream;
            logger.exiting(CLASS_NAME, "getInputStream", inputStream);
        }
        return inputStream;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void resolveBaseDir() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "resolveBaseDir", new Object[0]);
        }
        String relativeURL = this.jspInputSource.getRelativeURL();
        if (relativeURL.charAt(0) != '/') {
            this.resolvedRelativeURL = (String)this.directoryStack.peek() + relativeURL;
            this.jspInputSource = this.context.getJspInputSourceFactory().copyJspInputSource(this.jspInputSource, this.resolvedRelativeURL);
        } else {
            this.resolvedRelativeURL = relativeURL;
        }
        String baseDir = this.resolvedRelativeURL.substring(0, this.resolvedRelativeURL.lastIndexOf("/") + 1);
        this.directoryStack.push(baseDir);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "resolveBaseDir");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List getDependencyList() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getDependencyList", new Object[0]);
        }
        List list = this.dependencyList;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting(CLASS_NAME, "getDependencyList", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map getCdataJspIdMap() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getCdataJspIdMap", new Object[0]);
        }
        Map map = this.cdataJspIdMap;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            map = map;
            logger.exiting(CLASS_NAME, "getCdataJspIdMap", map);
        }
        return map;
    }
}

