/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.inputsource;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JspInputSourceImpl
implements JspInputSource {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.inputsource.JspInputSourceImpl";
    protected URL contextURL;
    protected URL absoluteURL;
    protected String relativeURL;
    protected URLStreamHandler urlStreamHandler;
    protected long lastModified;
    protected Document document;
    static final long serialVersionUID = 3658438364873870931L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspInputSourceImpl(URL contextURL, String relativeURL, URLStreamHandler urlStreamHandler) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{contextURL, relativeURL, urlStreamHandler});
        }
        this.contextURL = null;
        this.absoluteURL = null;
        this.relativeURL = null;
        this.urlStreamHandler = null;
        this.lastModified = 0L;
        this.document = null;
        this.contextURL = contextURL;
        this.relativeURL = relativeURL;
        this.urlStreamHandler = urlStreamHandler;
        String resolvedRelativeURL = relativeURL;
        if (resolvedRelativeURL.charAt(0) == '/') {
            resolvedRelativeURL = resolvedRelativeURL.substring(1);
        }
        try {
            this.absoluteURL = urlStreamHandler != null ? new URL(contextURL, resolvedRelativeURL, urlStreamHandler) : new URL(contextURL, resolvedRelativeURL);
        }
        catch (MalformedURLException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "JspInputSourceImpl", "Failed to create inputsource contextURL =[" + contextURL + " relativeURL =[" + relativeURL + "]", e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspInputSourceImpl(JspInputSourceImpl baseImpl, String relativeURL, URLStreamHandler urlStreamHandler) {
        this(baseImpl.contextURL, relativeURL, urlStreamHandler);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{baseImpl, relativeURL, urlStreamHandler});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public URL getAbsoluteURL() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getAbsoluteURL", new Object[0]);
        }
        URL uRL = this.absoluteURL;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            uRL = uRL;
            logger.exiting(CLASS_NAME, "getAbsoluteURL", uRL);
        }
        return uRL;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public URL getContextURL() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getContextURL", new Object[0]);
        }
        URL uRL = this.contextURL;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            uRL = uRL;
            logger.exiting(CLASS_NAME, "getContextURL", uRL);
        }
        return uRL;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Document getDocument() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getDocument", new Object[0]);
        }
        Document document = this.document;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            document = document;
            logger.exiting(CLASS_NAME, "getDocument", document);
        }
        return document;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public InputStream getInputStream() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getInputStream", new Object[0]);
        }
        InputStream is = null;
        URLConnection conn = this.absoluteURL.openConnection();
        conn.setUseCaches(false);
        is = conn.getInputStream();
        this.lastModified = conn.getLastModified();
        InputStream inputStream = is;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            inputStream = inputStream;
            logger.exiting(CLASS_NAME, "getInputStream", inputStream);
        }
        return inputStream;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getLastModified() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getLastModified", new Object[0]);
        }
        long l = this.lastModified;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting(CLASS_NAME, "getLastModified", l);
        }
        return l;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getRelativeURL() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getRelativeURL", new Object[0]);
        }
        String string = this.relativeURL;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getRelativeURL", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isXmlDocument() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isXmlDocument", new Object[0]);
        }
        boolean bl = this.document != null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isXmlDocument", bl);
        }
        return bl;
    }
}

