/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.yadis.YadisResolver;

public class RealmVerifier {
    private static Log _log = LogFactory.getLog(RealmVerifier.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    public static final int OK = 0;
    public static final int DENIED_REALM = 1;
    public static final int MALFORMED_REALM = 2;
    public static final int MALFORMED_RETURN_TO_URL = 3;
    public static final int FRAGMENT_NOT_ALLOWED = 4;
    public static final int PROTOCOL_MISMATCH = 5;
    public static final int PORT_MISMATCH = 6;
    public static final int PATH_MISMATCH = 7;
    public static final int DOMAIN_MISMATCH = 8;
    public static final int RP_DISCOVERY_FAILED = 9;
    public static final int RP_INVALID_ENDPOINT = 10;
    private List _deniedRealmDomains = new ArrayList();
    private List _deniedRealmRegExps;
    private YadisResolver _yadisResolver;
    private boolean _enforceRpId;
    private boolean _isOP;

    RealmVerifier(boolean isOP, YadisResolver yadisResolver) {
        this.addDeniedRealmDomain("\\*\\.[^\\.]+");
        this.addDeniedRealmDomain("\\*\\.[a-z]{2}\\.[a-z]{2}");
        this._yadisResolver = yadisResolver;
        this._enforceRpId = true;
        this._isOP = isOP;
    }

    public void addDeniedRealmDomain(String deniedRealmDomain) {
        this._deniedRealmDomains.add(deniedRealmDomain);
        this.compileDeniedRealms();
    }

    public List getDeniedRealmDomains() {
        return this._deniedRealmDomains;
    }

    public void setDeniedRealmDomains(List deniedRealmDomains) {
        this._deniedRealmDomains = deniedRealmDomains;
        this.compileDeniedRealms();
    }

    private void compileDeniedRealms() {
        this._deniedRealmRegExps = new ArrayList(this._deniedRealmDomains.size());
        for (int i = 0; i < this._deniedRealmDomains.size(); ++i) {
            String deniedRealm = (String)this._deniedRealmDomains.get(i);
            Pattern deniedRealmPattern = Pattern.compile(deniedRealm, 2);
            this._deniedRealmRegExps.add(deniedRealmPattern);
        }
    }

    public boolean getEnforceRpId() {
        return this._enforceRpId;
    }

    public void setEnforceRpId(boolean enforceRpId) {
        this._enforceRpId = enforceRpId;
        if (!enforceRpId) {
            _log.warn((Object)"RP discovery / realm validation disabled; ");
        }
    }

    public int validate(String realm, String returnTo) {
        return this.validate(realm, returnTo, false, this._enforceRpId);
    }

    public int validate(String realm, String returnTo, boolean compatibility) {
        return this.validate(realm, returnTo, compatibility, this._enforceRpId);
    }

    public int validate(String realm, String returnTo, boolean compatibility, boolean enforceRpId) {
        int result = this.match(realm, returnTo);
        if (0 != result) {
            _log.error((Object)("Return URL: " + returnTo + " does not match realm: " + realm));
            return result;
        }
        if (!compatibility && enforceRpId) {
            result = this.validateRpId(realm, returnTo);
            if (0 != result) {
                _log.error((Object)("Failed to validate return URL: " + returnTo + " against endpoints discovered from the RP's realm."));
            }
        } else if (!compatibility && !enforceRpId && this._isOP) {
            _log.warn((Object)"RP discovery / realm validation disabled; this option SHOULD be enabled for OPs");
        }
        return result;
    }

    private int validateRpId(String realm, String returnTo) {
        int result = 10;
        try {
            URL realmUrl = new URL(realm);
            if (realmUrl.getAuthority().startsWith("*.")) {
                realm = realm.replaceFirst("\\*\\.", "www.");
            }
            List endpoints = Discovery.rpDiscovery(realm, this._yadisResolver);
            for (DiscoveryInformation endpoint : endpoints) {
                String endpointUrl = endpoint.getOPEndpoint().toString();
                if (endpoint.getOPEndpoint().getAuthority().startsWith("*.")) {
                    _log.warn((Object)("Wildcard not allowed in discovered RP endpoints; found: " + endpointUrl));
                    continue;
                }
                if (0 != this.match(endpointUrl, returnTo)) continue;
                _log.info((Object)("Return URL: " + returnTo + " matched discovered RP endpoint: " + endpointUrl));
                result = 0;
                break;
            }
        }
        catch (DiscoveryException e) {
            if (this._enforceRpId) {
                _log.error((Object)("Discovery failed on realm: " + realm), (Throwable)e);
            } else {
                _log.warn((Object)("Discovery failed on realm: " + realm), (Throwable)e);
            }
            result = 9;
        }
        catch (MalformedURLException e) {
            _log.error((Object)("Invalid realm URL: " + realm), (Throwable)e);
            result = 2;
        }
        return result;
    }

    public int match(String realm, String returnTo) {
        URL returnToUrl;
        URL realmUrl;
        if (DEBUG) {
            _log.debug((Object)("Verifying realm: " + realm + " on return URL: " + returnTo));
        }
        try {
            realmUrl = new URL(realm);
        }
        catch (MalformedURLException e) {
            _log.error((Object)("Invalid realm URL: " + realm), (Throwable)e);
            return 2;
        }
        String realmDomain = realmUrl.getHost();
        if (this.isDeniedRealmDomain(realmDomain)) {
            _log.warn((Object)("Blacklisted realm domain: " + realmDomain));
            return 1;
        }
        try {
            returnToUrl = new URL(returnTo);
        }
        catch (MalformedURLException e) {
            _log.error((Object)("Invalid return URL: " + returnTo));
            return 3;
        }
        if (realmUrl.getRef() != null) {
            if (DEBUG) {
                _log.debug((Object)"Realm verification failed: URL fragments are not allowed.");
            }
            return 4;
        }
        if (!realmUrl.getProtocol().equalsIgnoreCase(returnToUrl.getProtocol())) {
            if (DEBUG) {
                _log.debug((Object)"Realm verification failed: protocol mismatch.");
            }
            return 5;
        }
        if (!this.domainMatch(realmDomain, returnToUrl.getHost())) {
            if (DEBUG) {
                _log.debug((Object)"Realm verification failed: domain mismatch.");
            }
            return 8;
        }
        if (!this.portMatch(realmUrl, returnToUrl)) {
            if (DEBUG) {
                _log.debug((Object)"Realm verification failed: port mismatch.");
            }
            return 6;
        }
        if (!this.pathMatch(realmUrl, returnToUrl)) {
            if (DEBUG) {
                _log.debug((Object)"Realm verification failed: path mismatch.");
            }
            return 7;
        }
        _log.info((Object)("Return URL: " + returnTo + " matches realm: " + realm));
        return 0;
    }

    private boolean isDeniedRealmDomain(String realmDomain) {
        for (int i = 0; i < this._deniedRealmRegExps.size(); ++i) {
            Pattern realmPattern = (Pattern)this._deniedRealmRegExps.get(i);
            if (!realmPattern.matcher(realmDomain).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean portMatch(URL realmUrl, URL returnToUrl) {
        int realmPort = realmUrl.getPort();
        int returnToPort = returnToUrl.getPort();
        if (realmPort == -1) {
            realmPort = realmUrl.getDefaultPort();
        }
        if (returnToPort == -1) {
            returnToPort = returnToUrl.getDefaultPort();
        }
        return realmPort == returnToPort;
    }

    private boolean pathMatch(URL realmUrl, URL returnToUrl) {
        String realmPath = realmUrl.getPath();
        String returnToPath = returnToUrl.getPath();
        if (!realmPath.endsWith("/")) {
            realmPath = realmPath + "/";
        }
        if (!returnToPath.endsWith("/")) {
            returnToPath = returnToPath + "/";
        }
        return returnToPath.startsWith(realmPath);
    }

    private boolean domainMatch(String realmDomain, String returnToDomain) {
        if (realmDomain.startsWith("*.")) {
            realmDomain = realmDomain.substring(1).toLowerCase();
            returnToDomain = "." + returnToDomain.toLowerCase();
            return returnToDomain.endsWith(realmDomain);
        }
        return realmDomain.equalsIgnoreCase(returnToDomain);
    }
}

