/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.diagnostics.AbstractIntrospection;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EclipselinkIntrospection
extends AbstractIntrospection {
    private static final String FFDCCN = EclipselinkIntrospection.class.getName();
    private final Set<Object> sessionSet = new HashSet<Object>();
    private final Map<Object, String> sessionDiagMap = new HashMap<Object, String>();
    private final Set<Object> projectSet = new HashSet<Object>();
    private final Map<Object, String> projectDiagMap = new HashMap<Object, String>();
    private final Set<Object> classDescriptorSet = new HashSet<Object>();
    private final Map<Object, String> classDescriptorDiagMap = new HashMap<Object, String>();
    private final Set<Object> databaseTableSet = new HashSet<Object>();
    private final Map<Object, String> databaseTableDiagMap = new HashMap<Object, String>();
    private final Set<Object> databaseFieldSet = new HashSet<Object>();
    private final Map<Object, String> databaseFieldDiagMap = new HashMap<Object, String>();
    private final Set<Object> databaseMappingSet = new HashSet<Object>();
    private final Map<Object, String> databaseMappingDiagMap = new HashMap<Object, String>();

    @Override
    public void dumpJPAEntityManagerFactoryState(Object emf, PrintWriter out) {
        this.dumpECLJPAEntityManagerFactoryState(emf, out);
        try {
            out.println();
            out.println("Session Objects (" + this.sessionDiagMap.size() + "):");
            for (Map.Entry<Object, String> entry : this.sessionDiagMap.entrySet()) {
                out.println(entry.getValue());
                out.println();
            }
            out.println("Project Objects (" + this.projectDiagMap.size() + "):");
            for (Map.Entry<Object, String> entry : this.projectDiagMap.entrySet()) {
                out.println(entry.getValue());
                out.println();
            }
            out.println("ClassDescriptor Objects (" + this.classDescriptorDiagMap.size() + "):");
            for (Map.Entry<Object, String> entry : this.classDescriptorDiagMap.entrySet()) {
                out.println(entry.getValue());
                out.println();
            }
            out.println("DatabaseTable Objects (" + this.databaseTableDiagMap.size() + "):");
            for (Map.Entry<Object, String> entry : this.databaseTableDiagMap.entrySet()) {
                out.println(entry.getValue());
                out.println();
            }
            out.println("DatabaseField Objects (" + this.databaseFieldDiagMap.size() + "):");
            for (Map.Entry<Object, String> entry : this.databaseFieldDiagMap.entrySet()) {
                out.println(entry.getValue());
                out.println();
            }
            out.println("DatabaseMapping Objects (" + this.databaseMappingDiagMap.size() + "):");
            for (Map.Entry<Object, String> entry : this.databaseMappingDiagMap.entrySet()) {
                out.println(entry.getValue());
                out.println();
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(FFDCCN + ".dumpJPAEntityManagerFactoryState"), (String)"39");
        }
    }

    private void dumpECLJPAEntityManagerFactoryState(Object emf, PrintWriter out) {
        String emfCN = emf.getClass().getName();
        if (!"org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl".equals(emfCN)) {
            out.println("Eclipselink EMF Class Type " + emfCN + " is not recognized.  Cannot introspect further.");
            return;
        }
        out.println("Eclipselink EntityManagerFactory: " + EclipselinkIntrospection.getInstanceClassAndAddress(emf));
        try {
            Object emfDelegate = EclipselinkIntrospection.reflectObjValue(emf, "delegate");
            out.println("   delegate = " + emfDelegate);
            if (emfDelegate == null) {
                return;
            }
            out.println("   .session = " + this.processSessionInfoObject(EclipselinkIntrospection.reflectObjValue(emfDelegate, "session")));
            out.println("   .myCache = " + EclipselinkIntrospection.reflectObjValue(emfDelegate, "myCache"));
            Object setupImpl = EclipselinkIntrospection.reflectObjValue(emfDelegate, "setupImpl");
            out.println("   .setupImpl = " + setupImpl);
            this.dumpEntityManagerSetupImpl(setupImpl, out, "       ");
            out.println("   .flushMode = " + EclipselinkIntrospection.reflectObjValue(emfDelegate, "flushMode"));
            out.println("   .referenceMode = " + EclipselinkIntrospection.reflectObjValue(emfDelegate, "referenceMode"));
            out.println("   .commitOrder = " + EclipselinkIntrospection.reflectObjValue(emfDelegate, "commitOrder"));
            out.println("   .owner = " + EclipselinkIntrospection.reflectObjValue(emfDelegate, "owner"));
            out.println("   .isOpen = " + EclipselinkIntrospection.reflectObjValue(emfDelegate, "isOpen"));
            out.println("   .closeOnCommit = " + EclipselinkIntrospection.reflectObjValue(emfDelegate, "closeOnCommit"));
            out.println("   .persistOnCommit = " + EclipselinkIntrospection.reflectObjValue(emfDelegate, "persistOnCommit"));
            out.println("   .shouldValidateExistence = " + EclipselinkIntrospection.reflectObjValue(emfDelegate, "shouldValidateExistence"));
            out.println("   .commitWithoutPersistRules = " + EclipselinkIntrospection.reflectObjValue(emfDelegate, "commitWithoutPersistRules"));
            out.println("   .flushClearCache = " + EclipselinkIntrospection.reflectObjValue(emfDelegate, "flushClearCache"));
            out.println("   .properties = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(emfDelegate, "properties"), "      ", true));
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(FFDCCN + ".dumpECLJPAEntityManagerFactoryState"), (String)"77");
        }
    }

    private void dumpEntityManagerSetupImpl(Object emfsi, PrintWriter out, String indent) {
        try {
            out.println(indent + " persistenceUnitUniqueName = " + EclipselinkIntrospection.reflectObjValue(emfsi, "persistenceUnitUniqueName"));
            out.println(indent + " sessionName = " + EclipselinkIntrospection.reflectObjValue(emfsi, "sessionName"));
            out.println(indent + " processor = " + EclipselinkIntrospection.reflectObjValue(emfsi, "processor"));
            out.println(indent + " weaver = " + EclipselinkIntrospection.reflectObjValue(emfsi, "weaver"));
            out.println(indent + " persistenceUnitInfo = " + EclipselinkIntrospection.getInstanceClassAndAddress(EclipselinkIntrospection.reflectObjValue(emfsi, "persistenceUnitInfo")));
            out.println(indent + " factoryCount = " + EclipselinkIntrospection.reflectObjValue(emfsi, "factoryCount"));
            out.println(indent + " session = " + this.processSessionInfoObject(EclipselinkIntrospection.reflectObjValue(emfsi, "session")));
            out.println(indent + " isInContainerMode = " + EclipselinkIntrospection.reflectObjValue(emfsi, "isInContainerMode"));
            out.println(indent + " isSessionLoadedFromSessionsXML = " + EclipselinkIntrospection.reflectObjValue(emfsi, "isSessionLoadedFromSessionsXML"));
            out.println(indent + " projectCacheAccessor = " + EclipselinkIntrospection.reflectObjValue(emfsi, "projectCacheAccessor"));
            out.println(indent + " shouldBuildProject = " + EclipselinkIntrospection.reflectObjValue(emfsi, "shouldBuildProject"));
            out.println(indent + " enableWeaving = " + EclipselinkIntrospection.reflectObjValue(emfsi, "enableWeaving"));
            out.println(indent + " isWeavingStatic = " + EclipselinkIntrospection.reflectObjValue(emfsi, "isWeavingStatic"));
            out.println(indent + " staticWeaveInfo = " + EclipselinkIntrospection.reflectObjValue(emfsi, "staticWeaveInfo"));
            out.println(indent + " securableObjectHolder = " + EclipselinkIntrospection.reflectObjValue(emfsi, "securableObjectHolder"));
            out.println(indent + " deployLock = " + EclipselinkIntrospection.reflectObjValue(emfsi, "deployLock"));
            out.println(indent + " requiresConnection = " + EclipselinkIntrospection.reflectObjValue(emfsi, "requiresConnection"));
            out.println(indent + " metaModel = " + EclipselinkIntrospection.reflectObjValue(emfsi, "metaModel"));
            out.println(indent + " structConverters = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(emfsi, "structConverters"), "         ", true));
            out.println(indent + " state = " + EclipselinkIntrospection.reflectObjValue(emfsi, "state"));
            out.println(indent + " compositeEmSetupImpl = " + EclipselinkIntrospection.reflectObjValue(emfsi, "compositeEmSetupImpl"));
            out.println(indent + " compositeMemberEmSetupImpls = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(emfsi, "compositeMemberEmSetupImpls"), "         ", true));
            out.println(indent + " mode = " + EclipselinkIntrospection.reflectObjValue(emfsi, "mode"));
            out.println(indent + " throwExceptionOnFail = " + EclipselinkIntrospection.reflectObjValue(emfsi, "throwExceptionOnFail"));
            out.println(indent + " weaveChangeTracking = " + EclipselinkIntrospection.reflectObjValue(emfsi, "weaveChangeTracking"));
            out.println(indent + " weaveLazy = " + EclipselinkIntrospection.reflectObjValue(emfsi, "weaveLazy"));
            out.println(indent + " weaveEager = " + EclipselinkIntrospection.reflectObjValue(emfsi, "weaveEager"));
            out.println(indent + " weaveFetchGroups = " + EclipselinkIntrospection.reflectObjValue(emfsi, "weaveFetchGroups"));
            out.println(indent + " weaveInternal = " + EclipselinkIntrospection.reflectObjValue(emfsi, "weaveInternal"));
            out.println(indent + " weaveRest = " + EclipselinkIntrospection.reflectObjValue(emfsi, "weaveRest"));
            out.println(indent + " isMetadataExpired = " + EclipselinkIntrospection.reflectObjValue(emfsi, "isMetadataExpired"));
            out.println(indent + " persistenceException = " + EclipselinkIntrospection.reflectObjValue(emfsi, "persistenceException"));
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(FFDCCN + ".dumpEntityManagerSetupImpl"), (String)"89");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processSessionInfoObject(Object session) {
        if (session == null || this.sessionSet.contains(session) || !EclipselinkIntrospection.isCastable("org.eclipse.persistence.internal.sessions.AbstractSession", session.getClass())) {
            return EclipselinkIntrospection.getInstanceClassAndAddress(session);
        }
        this.sessionSet.add(session);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos, true);
        try {
            out.println("   " + EclipselinkIntrospection.getInstanceClassAndAddress(session));
            out.println("      .toString = " + EclipselinkIntrospection.poa(session));
            Class<?> sessionObjC = session.getClass();
            String sessionObjCN = sessionObjC.getName();
            out.println("      .exceptionHandler = " + EclipselinkIntrospection.reflectObjValue(session, "exceptionHandler"));
            out.println("      .integrityChecker = " + EclipselinkIntrospection.reflectObjValue(session, "integrityChecker"));
            out.println("      .project = " + this.processProjectObject(EclipselinkIntrospection.reflectObjValue(session, "project")));
            out.println("      .transactionMutex = " + EclipselinkIntrospection.reflectObjValue(session, "transactionMutex"));
            out.println("      .commitManager = " + EclipselinkIntrospection.reflectObjValue(session, "commitManager"));
            out.println("      .broker = " + EclipselinkIntrospection.reflectObjValue(session, "broker"));
            out.println("      .platform = " + EclipselinkIntrospection.reflectObjValue(session, "platform"));
            out.println("      .externalTransactionController = " + EclipselinkIntrospection.reflectObjValue(session, "externalTransactionController"));
            out.println("      .commandManager = " + EclipselinkIntrospection.reflectObjValue(session, "commandManager"));
            out.println("      .queryBuilder = " + EclipselinkIntrospection.reflectObjValue(session, "queryBuilder"));
            out.println("      .serializer = " + EclipselinkIntrospection.reflectObjValue(session, "serializer"));
            out.println("      .entityListenerInjectionManager = " + EclipselinkIntrospection.reflectObjValue(session, "entityListenerInjectionManager"));
            out.println("      .queries = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(session, "queries"), "         ", true));
            Object descriptors = EclipselinkIntrospection.reflectObjValue(session, "descriptors");
            out.println("      .descriptors = " + EclipselinkIntrospection.poa(descriptors, "         ", true));
            try {
                if (descriptors != null && !((Map)descriptors).isEmpty()) {
                    this.processClassDescriptorCollection(((Map)descriptors).values());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            out.println("      .identityMapAccessor = " + EclipselinkIntrospection.reflectObjValue(session, "identityMapAccessor"));
            out.println("      .partitioningPolicy = " + EclipselinkIntrospection.reflectObjValue(session, "partitioningPolicy"));
            out.println("      .attributeGroups = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(session, "attributeGroups"), "         ", true));
            out.println("      .properties = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(session, "properties"), "         ", true));
            out.println("      .staticMetamodelClasses = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(session, "staticMetamodelClasses"), "         ", true));
            out.println("      .deferredEvents = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(session, "deferredEvents"), "         ", true));
            out.println("      .wasJTSTransactionInternallyStarted = " + EclipselinkIntrospection.reflectObjValue(session, "wasJTSTransactionInternallyStarted"));
            out.println("      .jpaQueriesProcessed = " + EclipselinkIntrospection.reflectObjValue(session, "jpaQueriesProcessed"));
            out.println("      .isInBroker = " + EclipselinkIntrospection.reflectObjValue(session, "isInBroker"));
            out.println("      .shouldCheckWriteLock = " + EclipselinkIntrospection.reflectObjValue(session, "shouldCheckWriteLock"));
            out.println("      .shouldPropagateChanges = " + EclipselinkIntrospection.reflectObjValue(session, "shouldPropagateChanges"));
            out.println("      .isInProfile = " + EclipselinkIntrospection.reflectObjValue(session, "isInProfile"));
            out.println("      .isLoggingOff = " + EclipselinkIntrospection.reflectObjValue(session, "isLoggingOff"));
            out.println("      .isFinalizersEnabled = " + EclipselinkIntrospection.reflectObjValue(session, "isFinalizersEnabled"));
            out.println("      .isSynchronized = " + EclipselinkIntrospection.reflectObjValue(session, "isSynchronized"));
            out.println("      .isConcurrent = " + EclipselinkIntrospection.reflectObjValue(session, "isConcurrent"));
            out.println("      .isExecutingEvents = " + EclipselinkIntrospection.reflectObjValue(session, "isExecutingEvents"));
            out.println("      .shouldOptimizeResultSetAccess = " + EclipselinkIntrospection.reflectObjValue(session, "shouldOptimizeResultSetAccess"));
            out.println("      .tolerateInvalidJPQL = " + EclipselinkIntrospection.reflectObjValue(session, "tolerateInvalidJPQL"));
            out.println("      .numberOfActiveUnitsOfWork = " + EclipselinkIntrospection.reflectObjValue(session, "numberOfActiveUnitsOfWork"));
            out.println("      .pessimisticLockTimeoutDefault = " + EclipselinkIntrospection.reflectObjValue(session, "pessimisticLockTimeoutDefault"));
            out.println("      .queryTimeoutDefault = " + EclipselinkIntrospection.reflectObjValue(session, "queryTimeoutDefault"));
            out.println("      .queryTimeoutUnitDefault = " + EclipselinkIntrospection.reflectObjValue(session, "queryTimeoutUnitDefault"));
            out.println("      .name = " + EclipselinkIntrospection.reflectObjValue(session, "name"));
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.sessions.server.ClientSession", sessionObjC)) {
                out.println("       ----- ClientSession fields");
                out.println("      .parent = " + this.processSessionInfoObject(EclipselinkIntrospection.reflectObjValue(session, "parent")));
                out.println("      .connectionPolicy = " + EclipselinkIntrospection.reflectObjValue(session, "connectionPolicy"));
                out.println("      .writeConnections = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(session, "writeConnections"), "         ", true));
                out.println("      .sequencing = " + EclipselinkIntrospection.reflectObjValue(session, "sequencing"));
                out.println("      .isActive = " + EclipselinkIntrospection.reflectObjValue(session, "isActive"));
            }
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.internal.sessions.DatabaseSessionImpl", sessionObjC)) {
                out.println("       ----- DatabaseSessionImpl fields");
                out.println("      .databaseEventListener = " + EclipselinkIntrospection.reflectObjValue(session, "databaseEventListener"));
                out.println("      .sequencingHome = " + EclipselinkIntrospection.reflectObjValue(session, "sequencingHome"));
                out.println("      .serverPlatform = " + EclipselinkIntrospection.reflectObjValue(session, "serverPlatform"));
                out.println("      .tuner = " + EclipselinkIntrospection.reflectObjValue(session, "tuner"));
                out.println("      .connectedTime = " + EclipselinkIntrospection.reflectObjValue(session, "connectedTime"));
                out.println("      .isLoggedIn = " + EclipselinkIntrospection.reflectObjValue(session, "isLoggedIn"));
            }
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.sessions.remote.DistributedSession", sessionObjC)) {
                out.println("       ----- DistributedSession fields");
                out.println("      .remoteConnection = " + EclipselinkIntrospection.reflectObjValue(session, "remoteConnection"));
                out.println("      .hasDefaultReadOnlyClasses = " + EclipselinkIntrospection.reflectObjValue(session, "hasDefaultReadOnlyClasses"));
                out.println("      .isMetadataRemote = " + EclipselinkIntrospection.reflectObjValue(session, "isMetadataRemote"));
            }
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.sessions.remote.RemoteSession", sessionObjC)) {
                out.println("       ----- RemoteSession fields");
                out.println("      .sequencing = " + EclipselinkIntrospection.reflectObjValue(session, "sequencing"));
                out.println("      .shouldEnableDistributedIndirectionGarbageCollection = " + EclipselinkIntrospection.reflectObjValue(session, "shouldEnableDistributedIndirectionGarbageCollection"));
            }
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.sessions.server.ServerSession", sessionObjC)) {
                out.println("       ----- ServerSession fields");
                out.println("      .readConnectionPool = " + EclipselinkIntrospection.reflectObjValue(session, "readConnectionPool"));
                out.println("      .connectionPools = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(session, "connectionPools"), "         ", true));
                out.println("      .defaultConnectionPolicy = " + EclipselinkIntrospection.reflectObjValue(session, "defaultConnectionPolicy"));
                out.println("      .numberOfNonPooledConnectionsUsed = " + EclipselinkIntrospection.reflectObjValue(session, "numberOfNonPooledConnectionsUsed"));
                out.println("      .maxNumberOfNonPooledConnections = " + EclipselinkIntrospection.reflectObjValue(session, "maxNumberOfNonPooledConnections"));
            }
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.sessions.broker.SessionBroker", sessionObjC)) {
                out.println("       ----- SessionBroker fields");
                out.println("      .parent = " + this.processSessionInfoObject(EclipselinkIntrospection.reflectObjValue(session, "parent")));
                out.println("      .sessionNamesByClass = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(session, "sessionNamesByClass"), "         ", true));
                out.println("      .sessionsByName = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(session, "sessionsByName"), "         ", true));
                out.println("      .sequencing = " + EclipselinkIntrospection.reflectObjValue(session, "sequencing"));
                out.println("      .shouldUseDescriptorAliases = " + EclipselinkIntrospection.reflectObjValue(session, "shouldUseDescriptorAliases"));
            }
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.internal.sessions.UnitOfWorkImpl", sessionObjC)) {
                out.println("       ----- UnitOfWorkImpl fields");
                out.println("      .unitOfWorkChangeSet = " + EclipselinkIntrospection.reflectObjValue(session, "unitOfWorkChangeSet"));
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(FFDCCN + ".processSessionInfoObject"), (String)"253");
        }
        finally {
            this.sessionDiagMap.put(session, baos.toString());
        }
        return EclipselinkIntrospection.getInstanceClassAndAddress(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processProjectObject(Object project) {
        if (project == null || this.projectSet.contains(project) || !EclipselinkIntrospection.isCastable("org.eclipse.persistence.sessions.Project", project.getClass())) {
            return EclipselinkIntrospection.getInstanceClassAndAddress(project);
        }
        this.projectSet.add(project);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos, true);
        try {
            out.println("   " + EclipselinkIntrospection.getInstanceClassAndAddress(project));
            out.println("      .toString = " + EclipselinkIntrospection.poa(project));
            out.println("      .name = " + EclipselinkIntrospection.reflectObjValue(project, "name"));
            out.println("      .datasourceLogin = " + EclipselinkIntrospection.reflectObjValue(project, "datasourceLogin"));
            Object descriptorsMap = EclipselinkIntrospection.reflectObjValue(project, "descriptors");
            out.println("      .descriptors = " + EclipselinkIntrospection.poa(descriptorsMap, "         ", true));
            try {
                if (descriptorsMap != null && !((Map)descriptorsMap).isEmpty()) {
                    this.processClassDescriptorCollection(((Map)descriptorsMap).values());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object orderedDescriptors = EclipselinkIntrospection.reflectObjValue(project, "orderedDescriptors");
            out.println("      .orderedDescriptors = " + EclipselinkIntrospection.poa(orderedDescriptors, "         ", true));
            try {
                if (orderedDescriptors != null && !((List)orderedDescriptors).isEmpty()) {
                    this.processClassDescriptorCollection(orderedDescriptors);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            out.println("      .multitenantPolicy = " + EclipselinkIntrospection.reflectObjValue(project, "multitenantPolicy"));
            out.println("      .defaultReadOnlyClasses = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(project, "defaultReadOnlyClasses"), "         ", true));
            out.println("      .aliasDescriptors = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(project, "aliasDescriptors"), "         ", true));
            out.println("      .hasIsolatedClasses = " + EclipselinkIntrospection.reflectObjValue(project, "hasIsolatedClasses"));
            out.println("      .hasNonIsolatedUOWClasses = " + EclipselinkIntrospection.reflectObjValue(project, "hasNonIsolatedUOWClasses"));
            out.println("      .hasGenericHistorySupport = " + EclipselinkIntrospection.reflectObjValue(project, "hasGenericHistorySupport"));
            out.println("      .hasProxyIndirection = " + EclipselinkIntrospection.reflectObjValue(project, "hasProxyIndirection"));
            out.println("      .sqlResultSetMappings = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(project, "sqlResultSetMappings"), "         ", true));
            out.println("      .jpqlParseCache = " + EclipselinkIntrospection.reflectObjValue(project, "jpqlParseCache"));
            out.println("      .defaultTemporalMutable = " + EclipselinkIntrospection.reflectObjValue(project, "defaultTemporalMutable"));
            out.println("      .hasMappingsPostCalculateChangesOnDeleted = " + EclipselinkIntrospection.reflectObjValue(project, "hasMappingsPostCalculateChangesOnDeleted"));
            out.println("      .defaultIdentityMapClass = " + EclipselinkIntrospection.reflectObjValue(project, "defaultIdentityMapClass"));
            out.println("      .defaultIdentityMapSize = " + EclipselinkIntrospection.reflectObjValue(project, "defaultIdentityMapSize"));
            out.println("      .defaultCacheIsolation = " + EclipselinkIntrospection.reflectObjValue(project, "defaultCacheIsolation"));
            out.println("      .defaultQueryResultsCachePolicy = " + EclipselinkIntrospection.reflectObjValue(project, "defaultQueryResultsCachePolicy"));
            out.println("      .defaultIdValidation = " + EclipselinkIntrospection.reflectObjValue(project, "defaultIdValidation"));
            out.println("      .queries = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(project, "queries"), "         ", true));
            out.println("      .attributeGroups = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(project, "attributeGroups"), "         ", true));
            out.println("      .jpaQueries = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(project, "jpaQueries"), "         ", true));
            out.println("      .jpaTablePerTenantQueries = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(project, "jpaTablePerTenantQueries"), "         ", true));
            out.println("      .allowNativeSQLQueries = " + EclipselinkIntrospection.reflectObjValue(project, "allowNativeSQLQueries"));
            out.println("      .allowTablePerMultitenantDDLGeneration = " + EclipselinkIntrospection.reflectObjValue(project, "allowTablePerMultitenantDDLGeneration"));
            out.println("      .allowSQLDeferral = " + EclipselinkIntrospection.reflectObjValue(project, "allowSQLDeferral"));
            Object mappedSuperclassDescriptors = EclipselinkIntrospection.reflectObjValue(project, "mappedSuperclassDescriptors");
            out.println("      .mappedSuperclassDescriptors = " + EclipselinkIntrospection.poa(mappedSuperclassDescriptors, "         ", true));
            try {
                if (mappedSuperclassDescriptors != null && !((Map)mappedSuperclassDescriptors).isEmpty()) {
                    this.processClassDescriptorCollection(((Map)mappedSuperclassDescriptors).values());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            out.println("      .metamodelIdClassMap = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(project, "metamodelIdClassMap"), "         ", true));
            out.println("      .partitioningPolicies = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(project, "partitioningPolicies"), "         ", true));
            out.println("      .descriptorsLock = " + EclipselinkIntrospection.reflectObjValue(project, "descriptorsLock"));
            out.println("      .vpdIdentifier = " + EclipselinkIntrospection.reflectObjValue(project, "vpdIdentifier"));
            out.println("      .vpdLastIdentifierClassName = " + EclipselinkIntrospection.reflectObjValue(project, "vpdLastIdentifierClassName"));
            out.println("      .classNamesForWeaving = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(project, "classNamesForWeaving"), "         ", true));
            out.println("      .structConverters = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(project, "structConverters"), "         ", true));
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(FFDCCN + ".processSessionInfoObject"), (String)"279");
        }
        finally {
            this.projectDiagMap.put(project, baos.toString());
        }
        return EclipselinkIntrospection.getInstanceClassAndAddress(project);
    }

    private void processClassDescriptorCollection(Object classDescriptorCollection) {
        if (classDescriptorCollection == null || !EclipselinkIntrospection.isCastable("java.util.Collection", classDescriptorCollection.getClass())) {
            return;
        }
        Collection c = (Collection)classDescriptorCollection;
        for (Object descriptor : c) {
            this.processClassDescriptorObject(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processClassDescriptorObject(Object classDescriptor) {
        if (classDescriptor == null || this.classDescriptorSet.contains(classDescriptor) || !EclipselinkIntrospection.isCastable("org.eclipse.persistence.descriptors.ClassDescriptor", classDescriptor.getClass())) {
            return EclipselinkIntrospection.getInstanceClassAndAddress(classDescriptor);
        }
        this.classDescriptorSet.add(classDescriptor);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos, true);
        try {
            out.println("   " + EclipselinkIntrospection.getInstanceClassAndAddress(classDescriptor));
            out.println("      .toString = " + EclipselinkIntrospection.poa(classDescriptor));
            out.println("      .javaClass = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "javaClass"));
            out.println("      .javaClassName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "javaClassName"));
            Object tables = EclipselinkIntrospection.reflectObjValue(classDescriptor, "tables");
            out.println("      .tables = " + EclipselinkIntrospection.poa(tables, "         ", true));
            try {
                if (tables != null && !((Collection)tables).isEmpty()) {
                    this.processDatabaseTableCollection(tables);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            out.println("      .defaultTable = " + this.processDatabaseTableObject(EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultTable")));
            Object primaryKeyFields = EclipselinkIntrospection.reflectObjValue(classDescriptor, "primaryKeyFields");
            out.println("      .primaryKeyFields = " + EclipselinkIntrospection.poa(primaryKeyFields, "         ", true));
            try {
                if (primaryKeyFields != null && !((Collection)primaryKeyFields).isEmpty()) {
                    this.processDatabaseFieldCollection(primaryKeyFields);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object additionalTablePrimaryKeyFields = EclipselinkIntrospection.reflectObjValue(classDescriptor, "additionalTablePrimaryKeyFields");
            out.println("      .additionalTablePrimaryKeyFields = " + EclipselinkIntrospection.poa(additionalTablePrimaryKeyFields, "         ", true));
            try {
                if (additionalTablePrimaryKeyFields != null && !((Map)additionalTablePrimaryKeyFields).isEmpty()) {
                    this.processDatabaseTableObject(((Map)additionalTablePrimaryKeyFields).keySet());
                    Collection values = ((Map)additionalTablePrimaryKeyFields).values();
                    for (Object val : values) {
                        this.processDatabaseFieldObject(((Map)val).keySet());
                        this.processDatabaseFieldObject(((Map)val).values());
                    }
                }
            }
            catch (Throwable values) {
                // empty catch block
            }
            Object multipleTableInsertOrder = EclipselinkIntrospection.reflectObjValue(classDescriptor, "multipleTableInsertOrder");
            out.println("      .multipleTableInsertOrder = " + EclipselinkIntrospection.poa(multipleTableInsertOrder, "         ", true));
            try {
                if (multipleTableInsertOrder != null && !((List)multipleTableInsertOrder).isEmpty()) {
                    this.processDatabaseTableObject(multipleTableInsertOrder);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object multipleTableForeignKeys = EclipselinkIntrospection.reflectObjValue(classDescriptor, "multipleTableForeignKeys");
            out.println("      .multipleTableForeignKeys = " + EclipselinkIntrospection.poa(multipleTableForeignKeys, "         ", true));
            try {
                if (multipleTableForeignKeys != null && !((Map)multipleTableForeignKeys).isEmpty()) {
                    this.processDatabaseTableObject(((Map)multipleTableForeignKeys).keySet());
                    this.processDatabaseTableCollection(((Map)multipleTableForeignKeys).values());
                }
            }
            catch (Throwable val) {
                // empty catch block
            }
            out.println("      .isCascadeOnDeleteSetOnDatabaseOnSecondaryTables = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "isCascadeOnDeleteSetOnDatabaseOnSecondaryTables"));
            Object fields = EclipselinkIntrospection.reflectObjValue(classDescriptor, "fields");
            out.println("      .fields = " + EclipselinkIntrospection.poa(fields, "         ", true));
            try {
                if (fields != null && !((Collection)fields).isEmpty()) {
                    this.processDatabaseFieldCollection(fields);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object allFields = EclipselinkIntrospection.reflectObjValue(classDescriptor, "allFields");
            out.println("      .allFields = " + EclipselinkIntrospection.poa(allFields, "         ", true));
            try {
                if (allFields != null && !((Collection)allFields).isEmpty()) {
                    this.processDatabaseFieldCollection(allFields);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object selectionFields = EclipselinkIntrospection.reflectObjValue(classDescriptor, "selectionFields");
            out.println("      .selectionFields = " + EclipselinkIntrospection.poa(selectionFields, "         ", true));
            try {
                if (selectionFields != null && !((Collection)selectionFields).isEmpty()) {
                    this.processDatabaseFieldCollection(selectionFields);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object allSelectionFields = EclipselinkIntrospection.reflectObjValue(classDescriptor, "allSelectionFields");
            out.println("      .allSelectionFields = " + EclipselinkIntrospection.poa(allSelectionFields, "         ", true));
            try {
                if (allSelectionFields != null && !((Collection)allSelectionFields).isEmpty()) {
                    this.processDatabaseFieldCollection(allSelectionFields);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object mappings = EclipselinkIntrospection.reflectObjValue(classDescriptor, "mappings");
            out.println("      .mappings = " + EclipselinkIntrospection.poa(mappings, "         ", true));
            try {
                if (mappings != null && !((Collection)mappings).isEmpty()) {
                    this.processDatabaseMappingCollection(mappings);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object referencingClasses = EclipselinkIntrospection.reflectObjValue(classDescriptor, "referencingClasses");
            out.println("      .referencingClasses = " + EclipselinkIntrospection.poa(referencingClasses, "         ", true));
            try {
                if (referencingClasses != null && !((Set)referencingClasses).isEmpty()) {
                    this.processClassDescriptorCollection(referencingClasses);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object lockableMappings = EclipselinkIntrospection.reflectObjValue(classDescriptor, "lockableMappings");
            out.println("      .lockableMappings = " + EclipselinkIntrospection.poa(lockableMappings, "         ", true));
            try {
                if (lockableMappings != null && !((Collection)lockableMappings).isEmpty()) {
                    this.processDatabaseMappingCollection(lockableMappings);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            out.println("      .queryKeys = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(classDescriptor, "queryKeys"), "         ", true));
            out.println("      .sequenceNumberName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "sequenceNumberName"));
            out.println("      .sequenceNumberField = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "sequenceNumberField"));
            out.println("      .sessionName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "sessionName"));
            out.println("      .constraintDependencies = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(classDescriptor, "constraintDependencies"), "         ", true));
            out.println("      .amendmentMethodName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "amendmentMethodName"));
            out.println("      .amendmentClass = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "amendmentClass"));
            out.println("      .amendmentClassName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "amendmentClassName"));
            out.println("      .alias = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "alias"));
            out.println("      .shouldBeReadOnly = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "shouldBeReadOnly"));
            out.println("      .shouldAlwaysConformResultsInUnitOfWork = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "shouldAlwaysConformResultsInUnitOfWork"));
            out.println("      .shouldRegisterResultsInUnitOfWork = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "shouldRegisterResultsInUnitOfWork"));
            out.println("      .queryManager = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "queryManager"));
            out.println("      .copyPolicy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "copyPolicy"));
            out.println("      .copyPolicyClassName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "copyPolicyClassName"));
            out.println("      .interfacePolicy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "interfacePolicy"));
            out.println("      .optimisticLockingPolicy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "optimisticLockingPolicy"));
            out.println("      .cascadeLockingPolicies = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(classDescriptor, "cascadeLockingPolicies"), "         ", true));
            out.println("      .wrapperPolicy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "wrapperPolicy"));
            out.println("      .changePolicy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "changePolicy"));
            out.println("      .returningPolicy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "returningPolicy"));
            out.println("      .historyPolicy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "historyPolicy"));
            out.println("      .partitioningPolicyName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "partitioningPolicyName"));
            out.println("      .partitioningPolicy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "partitioningPolicy"));
            out.println("      .cmpPolicy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "cmpPolicy"));
            out.println("      .cachePolicy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "cachePolicy"));
            out.println("      .multitenantPolicy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "multitenantPolicy"));
            out.println("      .serializedObjectPolicy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "serializedObjectPolicy"));
            out.println("      .fetchGroupManager = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "fetchGroupManager"));
            out.println("      .properties = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(classDescriptor, "properties"), "         ", true));
            out.println("      .unconvertedProperties = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(classDescriptor, "unconvertedProperties"), "         ", true));
            out.println("      .initializationStage = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "initializationStage"));
            out.println("      .interfaceInitializationStage = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "interfaceInitializationStage"));
            out.println("      .descriptorType = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "descriptorType"));
            out.println("      .shouldOrderMappings = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "shouldOrderMappings"));
            out.println("      .cacheInvalidationPolicy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "cacheInvalidationPolicy"));
            out.println("      .shouldAcquireCascadedLocks = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "shouldAcquireCascadedLocks"));
            out.println("      .cascadedLockingInitialized = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "cascadedLockingInitialized"));
            out.println("      .hasSimplePrimaryKey = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "hasSimplePrimaryKey"));
            out.println("      .hasMultipleTableConstraintDependecy = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "hasMultipleTableConstraintDependecy"));
            out.println("      .shouldUseFullChangeSetsForNewObjects = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "shouldUseFullChangeSetsForNewObjects"));
            out.println("      .isNativeConnectionRequired = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "isNativeConnectionRequired"));
            out.println("      .idValidation = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "idValidation"));
            out.println("      .primaryKeyIdValidations = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(classDescriptor, "primaryKeyIdValidations"), "         ", true));
            Object derivesIdMappings = EclipselinkIntrospection.reflectObjValue(classDescriptor, "derivesIdMappings");
            out.println("      .derivesIdMappings = " + EclipselinkIntrospection.poa(derivesIdMappings, "         ", true));
            try {
                if (derivesIdMappings != null && !((Map)derivesIdMappings).isEmpty()) {
                    this.processDatabaseMappingCollection(((Map)derivesIdMappings).values());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            out.println("      .defaultQueryRedirector = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultQueryRedirector"));
            out.println("      .defaultReadAllQueryRedirector = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultReadAllQueryRedirector"));
            out.println("      .defaultReadObjectQueryRedirector = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultReadObjectQueryRedirector"));
            out.println("      .defaultReportQueryRedirector = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultReportQueryRedirector"));
            out.println("      .defaultUpdateObjectQueryRedirector = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultUpdateObjectQueryRedirector"));
            out.println("      .defaultInsertObjectQueryRedirector = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultInsertObjectQueryRedirector"));
            out.println("      .defaultDeleteObjectQueryRedirector = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultDeleteObjectQueryRedirector"));
            out.println("      .defaultQueryRedirectorClassName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultQueryRedirectorClassName"));
            out.println("      .defaultReadAllQueryRedirectorClassName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultReadAllQueryRedirectorClassName"));
            out.println("      .defaultReadObjectQueryRedirectorClassName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultReadObjectQueryRedirectorClassName"));
            out.println("      .defaultReportQueryRedirectorClassName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultReportQueryRedirectorClassName"));
            out.println("      .defaultUpdateObjectQueryRedirectorClassName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultUpdateObjectQueryRedirectorClassName"));
            out.println("      .defaultInsertObjectQueryRedirectorClassName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultInsertObjectQueryRedirectorClassName"));
            out.println("      .defaultDeleteObjectQueryRedirectorClassName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "defaultDeleteObjectQueryRedirectorClassName"));
            out.println("      .sequence = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "sequence"));
            Object mappingsPostCalculateChanges = EclipselinkIntrospection.reflectObjValue(classDescriptor, "mappingsPostCalculateChanges");
            out.println("      .mappingsPostCalculateChanges = " + EclipselinkIntrospection.poa(mappingsPostCalculateChanges, "         ", true));
            try {
                if (mappingsPostCalculateChanges != null && !((Collection)mappingsPostCalculateChanges).isEmpty()) {
                    this.processDatabaseMappingCollection(mappingsPostCalculateChanges);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object mappingsPostCalculateChangesOnDeleted = EclipselinkIntrospection.reflectObjValue(classDescriptor, "mappingsPostCalculateChangesOnDeleted");
            out.println("      .mappingsPostCalculateChangesOnDeleted = " + EclipselinkIntrospection.poa(mappingsPostCalculateChangesOnDeleted, "         ", true));
            try {
                if (mappingsPostCalculateChangesOnDeleted != null && !((Collection)mappingsPostCalculateChangesOnDeleted).isEmpty()) {
                    this.processDatabaseMappingCollection(mappingsPostCalculateChangesOnDeleted);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object additionalAggregateCollectionKeyFields = EclipselinkIntrospection.reflectObjValue(classDescriptor, "additionalAggregateCollectionKeyFields");
            out.println("      .additionalAggregateCollectionKeyFields = " + EclipselinkIntrospection.poa(additionalAggregateCollectionKeyFields, "         ", true));
            try {
                if (additionalAggregateCollectionKeyFields != null && !((Collection)additionalAggregateCollectionKeyFields).isEmpty()) {
                    this.processDatabaseFieldCollection(additionalAggregateCollectionKeyFields);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object preDeleteMappings = EclipselinkIntrospection.reflectObjValue(classDescriptor, "preDeleteMappings");
            out.println("      .preDeleteMappings = " + EclipselinkIntrospection.poa(preDeleteMappings, "         ", true));
            try {
                if (preDeleteMappings != null && !((Collection)preDeleteMappings).isEmpty()) {
                    this.processDatabaseMappingCollection(preDeleteMappings);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object additionalWritableMapKeyFields = EclipselinkIntrospection.reflectObjValue(classDescriptor, "additionalWritableMapKeyFields");
            out.println("      .additionalWritableMapKeyFields = " + EclipselinkIntrospection.poa(additionalWritableMapKeyFields, "         ", true));
            try {
                if (additionalWritableMapKeyFields != null && !((Collection)additionalWritableMapKeyFields).isEmpty()) {
                    this.processDatabaseFieldCollection(additionalWritableMapKeyFields);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            out.println("      .hasRelationships = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "hasRelationships"));
            Object foreignKeyValuesForCaching = EclipselinkIntrospection.reflectObjValue(classDescriptor, "foreignKeyValuesForCaching");
            out.println("      .foreignKeyValuesForCaching = " + EclipselinkIntrospection.poa(foreignKeyValuesForCaching, "         ", true));
            try {
                if (foreignKeyValuesForCaching != null && !((Collection)foreignKeyValuesForCaching).isEmpty()) {
                    this.processDatabaseFieldCollection(foreignKeyValuesForCaching);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            out.println("      .hasNoncacheableMappings = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "hasNoncacheableMappings"));
            out.println("      .hasNoncacheableMappings = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "hasNoncacheableMappings"));
            out.println("      .virtualAttributeMethods = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(classDescriptor, "virtualAttributeMethods"), "         ", true));
            out.println("      .virtualAttributeMethods = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(classDescriptor, "virtualAttributeMethods"), "         ", true));
            out.println("      .accessorTree = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(classDescriptor, "accessorTree"), "         ", true));
            out.println("      .descriptorCustomizerClassName = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "descriptorCustomizerClassName"));
            out.println("      .shouldLockForClone = " + EclipselinkIntrospection.reflectObjValue(classDescriptor, "shouldLockForClone"));
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(FFDCCN + ".processClassDescriptorObject"), (String)"383");
        }
        finally {
            this.classDescriptorDiagMap.put(classDescriptor, baos.toString());
        }
        return EclipselinkIntrospection.getInstanceClassAndAddress(classDescriptor);
    }

    private void processDatabaseTableCollection(Object databaseTableCollection) {
        if (databaseTableCollection == null || !EclipselinkIntrospection.isCastable("java.util.Collection", databaseTableCollection.getClass())) {
            return;
        }
        Collection c = (Collection)databaseTableCollection;
        for (Object descriptor : c) {
            this.processDatabaseTableObject(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processDatabaseTableObject(Object databaseTable) {
        if (databaseTable == null || this.databaseTableSet.contains(databaseTable) || !EclipselinkIntrospection.isCastable("org.eclipse.persistence.internal.helper.DatabaseTable", databaseTable.getClass())) {
            return EclipselinkIntrospection.getInstanceClassAndAddress(databaseTable);
        }
        this.databaseTableSet.add(databaseTable);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos, true);
        try {
            out.println("   " + EclipselinkIntrospection.getInstanceClassAndAddress(databaseTable));
            out.println("      .toString = " + EclipselinkIntrospection.poa(databaseTable));
            out.println("      .name = " + EclipselinkIntrospection.reflectObjValue(databaseTable, "name"));
            out.println("      .tableQualifier = " + EclipselinkIntrospection.reflectObjValue(databaseTable, "tableQualifier"));
            out.println("      .qualifiedName = " + EclipselinkIntrospection.reflectObjValue(databaseTable, "qualifiedName"));
            out.println("      .foreignKeyConstraints = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(databaseTable, "foreignKeyConstraints"), "         ", true));
            out.println("      .uniqueConstraints = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(databaseTable, "uniqueConstraints"), "         ", true));
            out.println("      .indexes = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(databaseTable, "indexes"), "         ", true));
            out.println("      .useDelimiters = " + EclipselinkIntrospection.reflectObjValue(databaseTable, "useDelimiters"));
            out.println("      .creationSuffix = " + EclipselinkIntrospection.reflectObjValue(databaseTable, "creationSuffix"));
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(FFDCCN + ".processDatabaseTableObject"), (String)"383");
        }
        finally {
            this.databaseTableDiagMap.put(databaseTable, baos.toString());
        }
        return EclipselinkIntrospection.getInstanceClassAndAddress(databaseTable);
    }

    private void processDatabaseFieldCollection(Object databaseFieldCollection) {
        if (databaseFieldCollection == null || !EclipselinkIntrospection.isCastable("java.util.Collection", databaseFieldCollection.getClass())) {
            return;
        }
        Collection c = (Collection)databaseFieldCollection;
        for (Object descriptor : c) {
            this.processDatabaseFieldObject(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processDatabaseFieldObject(Object databaseField) {
        if (databaseField == null || this.databaseFieldSet.contains(databaseField) || !EclipselinkIntrospection.isCastable("org.eclipse.persistence.internal.helper.DatabaseField", databaseField.getClass())) {
            return EclipselinkIntrospection.getInstanceClassAndAddress(databaseField);
        }
        this.databaseFieldSet.add(databaseField);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos, true);
        try {
            out.println("   " + EclipselinkIntrospection.getInstanceClassAndAddress(databaseField));
            out.println("      .toString = " + EclipselinkIntrospection.poa(databaseField));
            out.println("      .scale = " + EclipselinkIntrospection.reflectObjValue(databaseField, "scale"));
            out.println("      .length = " + EclipselinkIntrospection.reflectObjValue(databaseField, "length"));
            out.println("      .precision = " + EclipselinkIntrospection.reflectObjValue(databaseField, "precision"));
            out.println("      .isUnique = " + EclipselinkIntrospection.reflectObjValue(databaseField, "isUnique"));
            out.println("      .isNullable = " + EclipselinkIntrospection.reflectObjValue(databaseField, "isNullable"));
            out.println("      .isUpdatable = " + EclipselinkIntrospection.reflectObjValue(databaseField, "isUpdatable"));
            out.println("      .isInsertable = " + EclipselinkIntrospection.reflectObjValue(databaseField, "isInsertable"));
            out.println("      .isCreatable = " + EclipselinkIntrospection.reflectObjValue(databaseField, "isCreatable"));
            out.println("      .isPrimaryKey = " + EclipselinkIntrospection.reflectObjValue(databaseField, "isPrimaryKey"));
            out.println("      .columnDefinition = " + EclipselinkIntrospection.reflectObjValue(databaseField, "columnDefinition"));
            out.println("      .name = " + EclipselinkIntrospection.reflectObjValue(databaseField, "name"));
            out.println("      .qualifiedName = " + EclipselinkIntrospection.reflectObjValue(databaseField, "qualifiedName"));
            out.println("      .table = " + this.processDatabaseTableObject(EclipselinkIntrospection.reflectObjValue(databaseField, "table")));
            out.println("      .type = " + EclipselinkIntrospection.reflectObjValue(databaseField, "type"));
            out.println("      .typeName = " + EclipselinkIntrospection.reflectObjValue(databaseField, "typeName"));
            out.println("      .sqlType = " + EclipselinkIntrospection.reflectObjValue(databaseField, "sqlType"));
            out.println("      .index = " + EclipselinkIntrospection.reflectObjValue(databaseField, "index"));
            out.println("      .useDelimiters = " + EclipselinkIntrospection.reflectObjValue(databaseField, "useDelimiters"));
            out.println("      .nameForComparisons = " + EclipselinkIntrospection.reflectObjValue(databaseField, "nameForComparisons"));
            out.println("      .useUpperCaseForComparisons = " + EclipselinkIntrospection.reflectObjValue(databaseField, "useUpperCaseForComparisons"));
            out.println("      .isTranslated = " + EclipselinkIntrospection.reflectObjValue(databaseField, "isTranslated"));
            out.println("      .keepInRow = " + EclipselinkIntrospection.reflectObjValue(databaseField, "keepInRow"));
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField", databaseField.getClass())) {
                out.println("       ----- ObjectRelationalDatabaseField fields");
                out.println("      .sqlTypeName = " + EclipselinkIntrospection.reflectObjValue(databaseField, "sqlTypeName"));
                out.println("      .nestedTypeField = " + this.processDatabaseFieldObject(EclipselinkIntrospection.reflectObjValue(databaseField, "nestedTypeField")));
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(FFDCCN + ".processDatabaseFieldObject"), (String)"383");
        }
        finally {
            this.databaseFieldDiagMap.put(databaseField, baos.toString());
        }
        return EclipselinkIntrospection.getInstanceClassAndAddress(databaseField);
    }

    private void processDatabaseMappingCollection(Object databaseMappingCollection) {
        if (databaseMappingCollection == null || !EclipselinkIntrospection.isCastable("java.util.Collection", databaseMappingCollection.getClass())) {
            return;
        }
        Collection c = (Collection)databaseMappingCollection;
        for (Object descriptor : c) {
            this.processDatabaseMappingObject(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processDatabaseMappingObject(Object databaseMapping) {
        if (databaseMapping == null || this.databaseMappingSet.contains(databaseMapping) || !EclipselinkIntrospection.isCastable("org.eclipse.persistence.mappings.DatabaseMapping", databaseMapping.getClass())) {
            return EclipselinkIntrospection.getInstanceClassAndAddress(databaseMapping);
        }
        this.databaseMappingSet.add(databaseMapping);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(baos, true);
        try {
            out.println("   " + EclipselinkIntrospection.getInstanceClassAndAddress(databaseMapping));
            out.println("      .toString = " + EclipselinkIntrospection.poa(databaseMapping));
            out.println("      .descriptor = " + this.processClassDescriptorObject(EclipselinkIntrospection.reflectObjValue(databaseMapping, "descriptor")));
            out.println("      .attributeAccessor = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "attributeAccessor"));
            out.println("      .isReadOnly = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isReadOnly"));
            out.println("      .isOptional = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isOptional"));
            out.println("      .isLazy = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isLazy"));
            Object fields = EclipselinkIntrospection.reflectObjValue(databaseMapping, "fields");
            out.println("      .fields = " + EclipselinkIntrospection.poa(fields, "         ", true));
            try {
                if (fields != null && !((Collection)fields).isEmpty()) {
                    this.processDatabaseFieldCollection(fields);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            out.println("      .isRemotelyInitialized = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isRemotelyInitialized"));
            out.println("      .weight = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "weight"));
            out.println("      .properties = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(databaseMapping, "properties"), "         ", true));
            out.println("      .unconvertedProperties = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(databaseMapping, "unconvertedProperties"), "         ", true));
            out.println("      .derivesId = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "derivesId"));
            out.println("      .isJPAId = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isJPAId"));
            out.println("      .mapsIdValue = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "mapsIdValue"));
            out.println("      .derivedIdMapping = " + this.processDatabaseMappingObject(EclipselinkIntrospection.reflectObjValue(databaseMapping, "derivedIdMapping")));
            out.println("      .isPrimaryKeyMapping = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isPrimaryKeyMapping"));
            out.println("      .attributeName = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "attributeName"));
            out.println("      .isMapKeyMapping = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isMapKeyMapping"));
            out.println("      .isCacheable = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isCacheable"));
            out.println("      .isInSopObject = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isInSopObject"));
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.mappings.foundation.AbstractColumnMapping", databaseMapping.getClass())) {
                out.println("       ----- AbstractColumnMapping fields");
                out.println("      .field = " + this.processDatabaseFieldObject(EclipselinkIntrospection.reflectObjValue(databaseMapping, "field")));
                out.println("      .converter = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "converter"));
                out.println("      .converterClassName = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "converterClassName"));
                out.println("      .isInsertable = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isInsertable"));
                out.println("      .isUpdatable = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isUpdatable"));
            }
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.mappings.foundation.AbstractDirectMapping", databaseMapping.getClass())) {
                out.println("       ----- AbstractDirectMapping fields");
                out.println("      .attributeClassification = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "attributeClassification"));
                out.println("      .attributeClassificationName = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "attributeClassificationName"));
                out.println("      .attributeObjectClassification = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "attributeObjectClassification"));
                out.println("      .nullValue = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(databaseMapping, "nullValue")));
                out.println("      .keyTableForMapKey = " + this.processDatabaseTableObject(EclipselinkIntrospection.reflectObjValue(databaseMapping, "keyTableForMapKey")));
                out.println("      .fieldClassificationClassName = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "fieldClassificationClassName"));
                out.println("      .bypassDefaultNullValueCheck = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "bypassDefaultNullValueCheck"));
                out.println("      .isMutable = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isMutable"));
            }
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping", databaseMapping.getClass())) {
                out.println("       ----- AbstractCompositeDirectCollectionMapping fields");
                out.println("      .field = " + this.processDatabaseFieldObject(EclipselinkIntrospection.reflectObjValue(databaseMapping, "field")));
                out.println("      .elementDataTypeName = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "elementDataTypeName"));
                out.println("      .valueConverter = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "valueConverter"));
                out.println("      .containerPolicy = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "containerPolicy"));
            }
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping", databaseMapping.getClass())) {
                out.println("       ----- AbstractTransformationMapping fields");
                out.println("      .attributeTransformerClassName = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "attributeTransformerClassName"));
                out.println("      .attributeTransformer = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "attributeTransformer"));
                out.println("      .fieldTransformations = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(databaseMapping, "fieldTransformations"), "         ", true));
                out.println("      .fieldToTransformers = " + EclipselinkIntrospection.poa(EclipselinkIntrospection.reflectObjValue(databaseMapping, "fieldToTransformers"), "         ", true));
                out.println("      .isMutable = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isMutable"));
                out.println("      .indirectionPolicy = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "indirectionPolicy"));
            }
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.mappings.AggregateMapping", databaseMapping.getClass())) {
                out.println("       ----- AggregateMapping fields");
                out.println("      .referenceClass = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "referenceClass"));
                out.println("      .referenceClassName = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "referenceClassName"));
                out.println("      .referenceDescriptor = " + this.processClassDescriptorObject(EclipselinkIntrospection.reflectObjValue(databaseMapping, "referenceDescriptor")));
                out.println("      .hasNestedIdentityReference = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "hasNestedIdentityReference"));
            }
            if (EclipselinkIntrospection.isCastable("org.eclipse.persistence.mappings.ForeignReferenceMapping", databaseMapping.getClass())) {
                out.println("       ----- ForeignReferenceMapping fields");
                out.println("      .referenceClass = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "referenceClass"));
                out.println("      .referenceClassName = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "referenceClassName"));
                out.println("      .tempInitSession = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "tempInitSession"));
                out.println("      .referenceDescriptor = " + this.processClassDescriptorObject(EclipselinkIntrospection.reflectObjValue(databaseMapping, "referenceDescriptor")));
                out.println("      .selectionQuery = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "selectionQuery"));
                out.println("      .isPrivateOwned = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isPrivateOwned"));
                out.println("      .batchFetchType = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "batchFetchType"));
                out.println("      .indirectionPolicy = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "indirectionPolicy"));
                out.println("      .hasCustomSelectionQuery = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "hasCustomSelectionQuery"));
                out.println("      .relationshipPartner = " + this.processDatabaseMappingObject(EclipselinkIntrospection.reflectObjValue(databaseMapping, "relationshipPartner")));
                out.println("      .relationshipPartnerAttributeName = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "relationshipPartnerAttributeName"));
                out.println("      .cascadePersist = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "cascadePersist"));
                out.println("      .cascadeMerge = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "cascadeMerge"));
                out.println("      .cascadeRefresh = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "cascadeRefresh"));
                out.println("      .cascadeRemove = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "cascadeRemove"));
                out.println("      .cascadeDetach = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "cascadeDetach"));
                out.println("      .requiresTransientWeavedFields = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "requiresTransientWeavedFields"));
                out.println("      .joinFetch = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "joinFetch"));
                out.println("      .forceInitializationOfSelectionCriteria = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "forceInitializationOfSelectionCriteria"));
                out.println("      .extendPessimisticLockScope = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "extendPessimisticLockScope"));
                out.println("      .isCascadeOnDeleteSetOnDatabase = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "isCascadeOnDeleteSetOnDatabase"));
                out.println("      .partitioningPolicy = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "partitioningPolicy"));
                out.println("      .partitioningPolicyName = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "partitioningPolicyName"));
                out.println("      .mappedBy = " + EclipselinkIntrospection.reflectObjValue(databaseMapping, "mappedBy"));
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)(FFDCCN + ".processDatabaseMappingObject"), (String)"792");
        }
        finally {
            this.databaseMappingDiagMap.put(databaseMapping, baos.toString());
        }
        return EclipselinkIntrospection.getInstanceClassAndAddress(databaseMapping);
    }
}

