/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.service.util.CpuInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.internal.QueueItem;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class BoundedBuffer<T>
implements BlockingQueue<T> {
    private static com.ibm.ejs.ras.TraceComponent tc = Tr.register(BoundedBuffer.class);
    private static final int SPINS_TAKE_ = Integer.getInteger("com.ibm.ws.util.BoundedBuffer.spins_take", CpuInfo.getAvailableProcessors() - 1);
    private static final int SPINS_PUT_ = Integer.getInteger("com.ibm.ws.util.BoundedBuffer.spins_put", SPINS_TAKE_ / 4);
    private static final boolean YIELD_TAKE_ = Boolean.getBoolean("com.ibm.ws.util.BoundedBuffer.yield_take");
    private static final boolean YIELD_PUT_ = Boolean.getBoolean("com.ibm.ws.util.BoundedBuffer.yield_put");
    private static final long WAIT_SHORT_SLICE_ = Long.getLong("com.ibm.ws.util.BoundedBuffer.wait", 1000L);
    private static ConcurrentLinkedQueue<GetQueueLock> waitingThreadLocks = new ConcurrentLinkedQueue();
    private static final ThreadLocal<GetQueueLock> threadLocalGetLock = new ThreadLocal<GetQueueLock>(){
        static final long serialVersionUID = 5004379665572331293L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        protected GetQueueLock initialValue() {
            return new GetQueueLock();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.threading.internal.BoundedBuffer$1", 1.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    };
    private final PutQueueLock putQueue_;
    private int putQueueLen_;
    private T[] buffer;
    private T[] expeditedBuffer;
    private int takeIndex;
    private int expeditedTakeIndex;
    private int putIndex;
    private int expeditedPutIndex;
    private final AtomicInteger numberOfUsedSlots;
    private final AtomicInteger numberOfUsedExpeditedSlots;
    private final BoundedBufferLock lock;
    static final long serialVersionUID = -4090265518883649563L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private void notifyGet_() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"notifyGet_", (Object)new Object[0]);
        }
        GetQueueLock lock = waitingThreadLocks.poll();
        if (lock != null) {
            GetQueueLock getQueueLock = lock;
            synchronized (getQueueLock) {
                lock.setNotified(true);
                lock.notify();
            }
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"notifyGet_");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private void waitGet_(long timeout) throws InterruptedException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"waitGet_", (Object)new Object[]{timeout});
        }
        GetQueueLock getQueueLock = threadLocalGetLock.get();
        try {
            GetQueueLock getQueueLock2 = getQueueLock;
            synchronized (getQueueLock2) {
                getQueueLock.setNotified(false);
                waitingThreadLocks.add(getQueueLock);
                getQueueLock.wait(timeout == -1L ? 0L : timeout);
            }
        }
        finally {
            if (!getQueueLock.isNotified()) {
                waitingThreadLocks.remove(getQueueLock);
            }
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"waitGet_");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private void notifyPut_() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"notifyPut_", (Object)new Object[0]);
        }
        if (this.putQueueLen_ > 0) {
            PutQueueLock putQueueLock = this.putQueue_;
            synchronized (putQueueLock) {
                this.putQueue_.notify();
            }
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"notifyPut_");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private void waitPut_(long timeout) throws InterruptedException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"waitPut_", (Object)new Object[]{timeout});
        }
        PutQueueLock putQueueLock = this.putQueue_;
        synchronized (putQueueLock) {
            try {
                ++this.putQueueLen_;
                if (this.numberOfUsedSlots.get() >= this.buffer.length) {
                    this.putQueue_.wait(timeout);
                }
            }
            finally {
                --this.putQueueLen_;
            }
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"waitPut_");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public BoundedBuffer(Class<T> c, int capacity, int expeditedCapacity) throws IllegalArgumentException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)new Object[]{c, capacity, expeditedCapacity});
        }
        this.putQueue_ = new PutQueueLock();
        this.putQueueLen_ = 0;
        this.takeIndex = 0;
        this.expeditedTakeIndex = 0;
        this.putIndex = 0;
        this.expeditedPutIndex = 0;
        this.numberOfUsedSlots = new AtomicInteger(0);
        this.numberOfUsedExpeditedSlots = new AtomicInteger(0);
        this.lock = new BoundedBufferLock();
        if (capacity <= 0 || expeditedCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        Object[] buffer = (Object[])Array.newInstance(c, capacity);
        this.buffer = buffer;
        Object[] expeditedBuffer = (Object[])Array.newInstance(c, expeditedCapacity);
        this.expeditedBuffer = expeditedBuffer;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((com.ibm.ejs.ras.TraceComponent)tc, (String)("Created bounded buffer: capacity=" + capacity + " expedited capacity=" + expeditedCapacity));
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public int size() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"size", (Object)new Object[0]);
        }
        int n = this.numberOfUsedSlots.get() + this.numberOfUsedExpeditedSlots.get();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            n = n;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"size", (Object)n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public int capacity() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"capacity", (Object)new Object[0]);
        }
        int n = this.buffer.length + this.expeditedBuffer.length;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            n = n;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"capacity", (Object)n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public int remainingCapacity() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"remainingCapacity", (Object)new Object[0]);
        }
        int n = this.capacity() - this.size();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            n = n;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"remainingCapacity", (Object)n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean isEmpty() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"isEmpty", (Object)new Object[0]);
        }
        if (this.size() == 0) {
            boolean bl = true;
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bl = bl;
                Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"isEmpty", (Object)bl);
            }
            return bl;
        }
        boolean bl = false;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"isEmpty", (Object)bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public T peek() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"peek", (Object)new Object[0]);
        }
        BoundedBuffer boundedBuffer = this;
        // MONITORENTER : boundedBuffer
        if (this.numberOfUsedExpeditedSlots.get() > 0) {
            T t = this.expeditedBuffer[this.expeditedTakeIndex];
            // MONITOREXIT : boundedBuffer
            if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled()) return t;
            if (tc == null) return t;
            if (!tc.isEntryEnabled()) return t;
            t = t;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"peek", t);
            return t;
        }
        if (this.numberOfUsedSlots.get() > 0) {
            T t = this.buffer[this.takeIndex];
            // MONITOREXIT : boundedBuffer
            if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled()) return t;
            if (tc == null) return t;
            if (!tc.isEntryEnabled()) return t;
            t = t;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"peek", t);
            return t;
        }
        T t = null;
        // MONITOREXIT : boundedBuffer
        if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled()) return t;
        if (tc == null) return t;
        if (!tc.isEntryEnabled()) return t;
        t = t;
        Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"peek", t);
        return t;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public T element() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"element", (Object)new Object[0]);
        }
        T retrievedElement = this.peek();
        if (retrievedElement == null) {
            throw new NoSuchElementException();
        }
        T t = retrievedElement;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            t = t;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"element", t);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void put(T t) throws InterruptedException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"put", (Object)new Object[]{t});
        }
        if (t == null) {
            throw new IllegalArgumentException();
        }
        boolean ret = false;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) {
                    this.insert(t);
                    this.numberOfUsedSlots.getAndIncrement();
                    ret = true;
                }
            }
            if (ret) {
                this.notifyGet_();
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                    Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"put");
                }
                return;
            }
            int spinctr = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (spinctr > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --spinctr;
                    continue;
                }
                this.waitPut_(WAIT_SHORT_SLICE_);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public T put(T t, long timeoutInMillis) throws InterruptedException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"put", (Object)new Object[]{t, timeoutInMillis});
        }
        if (t == null) {
            throw new IllegalArgumentException();
        }
        long start = timeoutInMillis <= 0L ? 0L : -1L;
        long waitTime = timeoutInMillis;
        T ret = null;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) {
                    this.insert(t);
                    this.numberOfUsedSlots.getAndIncrement();
                    ret = t;
                }
            }
            if (ret != null) {
                this.notifyGet_();
                T t2 = ret;
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                    t2 = t2;
                    Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"put", t2);
                }
                return t2;
            }
            if (start == -1L) {
                start = System.currentTimeMillis();
            }
            int spinctr = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (waitTime <= 0L) {
                    T t3 = null;
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                        t3 = t3;
                        Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"put", t3);
                    }
                    return t3;
                }
                if (spinctr > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --spinctr;
                } else {
                    this.waitPut_(timeoutInMillis);
                }
                waitTime = timeoutInMillis - (System.currentTimeMillis() - start);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public T put(T t, long timeoutInMillis, int maximumCapacity) throws InterruptedException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"put", (Object)new Object[]{t, timeoutInMillis, maximumCapacity});
        }
        if (t == null || maximumCapacity > this.buffer.length) {
            throw new IllegalArgumentException();
        }
        long start = timeoutInMillis <= 0L ? 0L : -1L;
        long waitTime = timeoutInMillis;
        T ret = null;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < maximumCapacity) {
                    this.insert(t);
                    this.numberOfUsedSlots.getAndIncrement();
                    ret = t;
                }
            }
            if (ret != null) {
                this.notifyGet_();
                T t2 = ret;
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                    t2 = t2;
                    Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"put", t2);
                }
                return t2;
            }
            if (start == -1L) {
                start = System.currentTimeMillis();
            }
            int spinctr = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (waitTime <= 0L) {
                    T t3 = null;
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                        t3 = t3;
                        Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"put", t3);
                    }
                    return t3;
                }
                if (spinctr > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --spinctr;
                } else {
                    this.waitPut_(timeoutInMillis);
                }
                waitTime = timeoutInMillis - (System.currentTimeMillis() - start);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean offer(T t, long timeout, TimeUnit unit) throws InterruptedException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"offer", (Object)new Object[]{t, timeout, unit});
        }
        if (t == null) {
            throw new IllegalArgumentException();
        }
        long timeoutMS = unit.toMillis(timeout);
        long start = timeoutMS <= 0L ? 0L : -1L;
        long waitTime = timeoutMS;
        boolean ret = false;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) {
                    this.insert(t);
                    this.numberOfUsedSlots.getAndIncrement();
                    ret = true;
                }
            }
            if (ret) {
                this.notifyGet_();
                boolean bl = true;
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                    bl = bl;
                    Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"offer", (Object)bl);
                }
                return bl;
            }
            if (start == -1L) {
                start = System.currentTimeMillis();
            }
            int spinctr = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (waitTime <= 0L) {
                    boolean bl = false;
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                        bl = bl;
                        Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"offer", (Object)bl);
                    }
                    return bl;
                }
                if (spinctr > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --spinctr;
                } else {
                    this.waitPut_(waitTime);
                }
                waitTime = timeoutMS - (System.currentTimeMillis() - start);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean offer(T t) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"offer", (Object)new Object[]{t});
        }
        if (t == null) {
            throw new IllegalArgumentException();
        }
        boolean ret = false;
        BoundedBufferLock boundedBufferLock = this.lock;
        synchronized (boundedBufferLock) {
            if (t instanceof QueueItem && ((QueueItem)t).isExpedited()) {
                if (this.numberOfUsedExpeditedSlots.get() < this.expeditedBuffer.length) {
                    this.expeditedInsert(t);
                    this.numberOfUsedExpeditedSlots.getAndIncrement();
                    ret = true;
                }
            } else if (this.numberOfUsedSlots.get() < this.buffer.length) {
                this.insert(t);
                this.numberOfUsedSlots.getAndIncrement();
                ret = true;
            }
        }
        if (ret) {
            this.notifyGet_();
            boolean bl = true;
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bl = bl;
                Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"offer", (Object)bl);
            }
            return bl;
        }
        boolean bl = false;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"offer", (Object)bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean add(T t) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"add", (Object)new Object[]{t});
        }
        if (this.offer(t)) {
            boolean bl = true;
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bl = bl;
                Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"add", (Object)bl);
            }
            return bl;
        }
        throw new IllegalStateException("Queue full");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public T take() throws InterruptedException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"take", (Object)new Object[0]);
        }
        T old = this.poll();
        while (old == null) {
            this.waitGet_(-1L);
            old = this.poll();
        }
        T t = old;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            t = t;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"take", t);
        }
        return t;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"poll", (Object)new Object[]{timeout, unit});
        }
        T old = this.poll();
        long endTimeMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        long timeLeftMillis = endTimeMillis - System.currentTimeMillis();
        int spinctr = SPINS_TAKE_;
        while (old == null && timeLeftMillis > 0L) {
            while (this.size() <= 0 && timeLeftMillis > 0L) {
                if (spinctr > 0) {
                    if (YIELD_TAKE_) {
                        Thread.yield();
                    }
                    --spinctr;
                } else {
                    this.waitGet_(timeLeftMillis);
                }
                timeLeftMillis = endTimeMillis - System.currentTimeMillis();
            }
            old = this.poll();
            timeLeftMillis = endTimeMillis - System.currentTimeMillis();
        }
        T t = old;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            t = t;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"poll", t);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public T poll() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"poll", (Object)new Object[0]);
        }
        T old = null;
        boolean expedited = false;
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            if (this.numberOfUsedExpeditedSlots.get() > 0) {
                old = this.expeditedExtract();
                this.numberOfUsedExpeditedSlots.getAndDecrement();
                expedited = true;
            } else if (this.numberOfUsedSlots.get() > 0) {
                old = this.extract();
                this.numberOfUsedSlots.getAndDecrement();
            }
        }
        if (old != null && !expedited) {
            this.notifyPut_();
        }
        T t = old;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            t = t;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"poll", t);
        }
        return t;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public T remove() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"remove", (Object)new Object[0]);
        }
        T retrievedElement = this.poll();
        if (retrievedElement == null) {
            throw new NoSuchElementException();
        }
        T t = retrievedElement;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            t = t;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"remove", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private final void insert(T t) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"insert", (Object)new Object[]{t});
        }
        this.buffer[this.putIndex] = t;
        if (++this.putIndex >= this.buffer.length) {
            this.putIndex = 0;
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"insert");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private final void expeditedInsert(T t) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"expeditedInsert", (Object)new Object[]{t});
        }
        this.expeditedBuffer[this.expeditedPutIndex] = t;
        if (++this.expeditedPutIndex >= this.expeditedBuffer.length) {
            this.expeditedPutIndex = 0;
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"expeditedInsert");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private final T extract() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"extract", (Object)new Object[0]);
        }
        T old = this.buffer[this.takeIndex];
        this.buffer[this.takeIndex] = null;
        if (++this.takeIndex >= this.buffer.length) {
            this.takeIndex = 0;
        }
        T t = old;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            t = t;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"extract", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private final T expeditedExtract() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"expeditedExtract", (Object)new Object[0]);
        }
        T old = this.expeditedBuffer[this.expeditedTakeIndex];
        this.expeditedBuffer[this.expeditedTakeIndex] = null;
        if (++this.expeditedTakeIndex >= this.expeditedBuffer.length) {
            this.expeditedTakeIndex = 0;
        }
        T t = old;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            t = t;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"expeditedExtract", t);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public synchronized void expand(int additionalCapacity) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"expand", (Object)new Object[]{additionalCapacity});
        }
        if (additionalCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        int capacityBefore = this.buffer.length;
        BoundedBufferLock boundedBufferLock = this.lock;
        synchronized (boundedBufferLock) {
            int capacityAfter = this.buffer.length;
            if (capacityAfter == capacityBefore) {
                Object[] newBuffer = new Object[this.buffer.length + additionalCapacity];
                if (this.putIndex > this.takeIndex) {
                    int used = this.putIndex - this.takeIndex;
                    System.arraycopy(this.buffer, this.takeIndex, newBuffer, 0, used);
                    this.putIndex = used;
                } else if (this.putIndex != this.takeIndex || this.buffer[this.takeIndex] != null) {
                    int used = this.buffer.length - this.takeIndex;
                    System.arraycopy(this.buffer, this.takeIndex, newBuffer, 0, used);
                    System.arraycopy(this.buffer, 0, newBuffer, used, this.putIndex);
                    this.putIndex += used;
                } else {
                    this.putIndex = 0;
                }
                this.takeIndex = 0;
                this.buffer = newBuffer;
            }
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"expand");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public synchronized void expandExpedited(int additionalCapacity) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"expandExpedited", (Object)new Object[]{additionalCapacity});
        }
        if (additionalCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        int capacityBefore = this.expeditedBuffer.length;
        BoundedBufferLock boundedBufferLock = this.lock;
        synchronized (boundedBufferLock) {
            int capacityAfter = this.expeditedBuffer.length;
            if (capacityAfter == capacityBefore) {
                Object[] newBuffer = new Object[this.expeditedBuffer.length + additionalCapacity];
                if (this.expeditedPutIndex > this.expeditedTakeIndex) {
                    int used = this.expeditedPutIndex - this.expeditedTakeIndex;
                    System.arraycopy(this.expeditedBuffer, this.expeditedTakeIndex, newBuffer, 0, used);
                    this.expeditedPutIndex = used;
                } else if (this.expeditedPutIndex != this.expeditedTakeIndex || this.expeditedBuffer[this.expeditedTakeIndex] != null) {
                    int used = this.expeditedBuffer.length - this.expeditedTakeIndex;
                    System.arraycopy(this.expeditedBuffer, this.expeditedTakeIndex, newBuffer, 0, used);
                    System.arraycopy(this.expeditedBuffer, 0, newBuffer, used, this.expeditedPutIndex);
                    this.expeditedPutIndex += used;
                } else {
                    this.expeditedPutIndex = 0;
                }
                this.expeditedTakeIndex = 0;
                this.expeditedBuffer = newBuffer;
            }
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"expandExpedited");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected synchronized boolean cancel(Object x) {
        block34: {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"cancel", (Object)new Object[]{x});
            }
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                int i;
                block35: {
                    block33: {
                        block32: {
                            block30: {
                                block31: {
                                    block29: {
                                        block28: {
                                            if (this.expeditedPutIndex <= this.expeditedTakeIndex) break block28;
                                            break block29;
                                        }
                                        if (this.expeditedPutIndex == this.expeditedTakeIndex && this.expeditedBuffer[this.expeditedTakeIndex] == null) break block30;
                                        break block31;
                                    }
                                    for (i = this.expeditedTakeIndex; i < this.expeditedPutIndex; ++i) {
                                        if (this.expeditedBuffer[i] != x) continue;
                                        System.arraycopy(this.expeditedBuffer, i + 1, this.expeditedBuffer, i, this.expeditedPutIndex - i - 1);
                                        --this.expeditedPutIndex;
                                        this.expeditedBuffer[this.expeditedPutIndex] = null;
                                        this.numberOfUsedExpeditedSlots.getAndDecrement();
                                        boolean bl = true;
                                        // MONITOREXIT @DISABLED, blocks:[7, 8] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                                            bl = bl;
                                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"cancel", (Object)bl);
                                        }
                                        return bl;
                                    }
                                    break block30;
                                }
                                for (i = this.expeditedTakeIndex; i < this.buffer.length; ++i) {
                                    if (this.expeditedBuffer[i] != x) continue;
                                    if (i != this.expeditedBuffer.length - 1) {
                                        System.arraycopy(this.expeditedBuffer, i + 1, this.expeditedBuffer, i, this.expeditedBuffer.length - i - 1);
                                    }
                                    if (this.expeditedPutIndex != 0) {
                                        this.expeditedBuffer[this.expeditedBuffer.length - 1] = this.expeditedBuffer[0];
                                        System.arraycopy(this.expeditedBuffer, 1, this.expeditedBuffer, 0, this.expeditedPutIndex - 1);
                                        --this.expeditedPutIndex;
                                    } else {
                                        this.expeditedPutIndex = this.expeditedBuffer.length - 1;
                                    }
                                    this.expeditedBuffer[this.expeditedPutIndex] = null;
                                    this.numberOfUsedExpeditedSlots.getAndDecrement();
                                    boolean bl = true;
                                    // MONITOREXIT @DISABLED, blocks:[7, 9] lbl38 : MonitorExitStatement: MONITOREXIT : var2_2
                                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                                        bl = bl;
                                        Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"cancel", (Object)bl);
                                    }
                                    return bl;
                                }
                                for (i = 0; i < this.expeditedPutIndex; ++i) {
                                    if (this.expeditedBuffer[i] != x) continue;
                                    System.arraycopy(this.expeditedBuffer, i + 1, this.expeditedBuffer, i, this.expeditedPutIndex - i - 1);
                                    --this.expeditedPutIndex;
                                    this.expeditedBuffer[this.expeditedPutIndex] = null;
                                    this.numberOfUsedExpeditedSlots.getAndDecrement();
                                    boolean bl = true;
                                    // MONITOREXIT @DISABLED, blocks:[7, 10] lbl51 : MonitorExitStatement: MONITOREXIT : var2_2
                                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                                        bl = bl;
                                        Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"cancel", (Object)bl);
                                    }
                                    return bl;
                                }
                            }
                            if (this.putIndex <= this.takeIndex) break block32;
                            break block33;
                        }
                        if (this.putIndex == this.takeIndex && this.buffer[this.takeIndex] == null) break block34;
                        break block35;
                    }
                    for (i = this.takeIndex; i < this.putIndex; ++i) {
                        if (this.buffer[i] != x) continue;
                        System.arraycopy(this.buffer, i + 1, this.buffer, i, this.putIndex - i - 1);
                        --this.putIndex;
                        this.buffer[this.putIndex] = null;
                        this.numberOfUsedSlots.getAndDecrement();
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[7, 11] lbl69 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                            bl = bl;
                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"cancel", (Object)bl);
                        }
                        return bl;
                    }
                    break block34;
                }
                for (i = this.takeIndex; i < this.buffer.length; ++i) {
                    if (this.buffer[i] != x) continue;
                    if (i != this.buffer.length - 1) {
                        System.arraycopy(this.buffer, i + 1, this.buffer, i, this.buffer.length - i - 1);
                    }
                    if (this.putIndex != 0) {
                        this.buffer[this.buffer.length - 1] = this.buffer[0];
                        System.arraycopy(this.buffer, 1, this.buffer, 0, this.putIndex - 1);
                        --this.putIndex;
                    } else {
                        this.putIndex = this.buffer.length - 1;
                    }
                    this.buffer[this.putIndex] = null;
                    this.numberOfUsedSlots.getAndDecrement();
                    boolean bl = true;
                    // MONITOREXIT @DISABLED, blocks:[7, 12] lbl89 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                        bl = bl;
                        Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"cancel", (Object)bl);
                    }
                    return bl;
                }
                for (i = 0; i < this.putIndex; ++i) {
                    if (this.buffer[i] != x) continue;
                    System.arraycopy(this.buffer, i + 1, this.buffer, i, this.putIndex - i - 1);
                    --this.putIndex;
                    this.buffer[this.putIndex] = null;
                    this.numberOfUsedSlots.getAndDecrement();
                    boolean bl = true;
                    // MONITOREXIT @DISABLED, blocks:[7, 13] lbl102 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                        bl = bl;
                        Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"cancel", (Object)bl);
                    }
                    return bl;
                }
            }
        }
        boolean bl = false;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"cancel", (Object)bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Iterator<T> iterator() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"iterator", (Object)new Object[0]);
        }
        ArrayList<T> bufferAsList = new ArrayList<T>();
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                int i;
                if (this.expeditedPutIndex > this.expeditedTakeIndex) {
                    for (i = this.expeditedTakeIndex; i <= this.expeditedPutIndex; ++i) {
                        bufferAsList.add(this.expeditedBuffer[i]);
                    }
                } else {
                    for (i = this.expeditedTakeIndex; i < this.expeditedBuffer.length; ++i) {
                        bufferAsList.add(this.expeditedBuffer[i]);
                    }
                    for (i = 0; i < this.expeditedPutIndex; ++i) {
                        bufferAsList.add(this.expeditedBuffer[i]);
                    }
                }
                if (this.putIndex > this.takeIndex) {
                    for (i = this.takeIndex; i <= this.putIndex; ++i) {
                        bufferAsList.add(this.buffer[i]);
                    }
                } else {
                    for (i = this.takeIndex; i < this.buffer.length; ++i) {
                        bufferAsList.add(this.buffer[i]);
                    }
                    for (i = 0; i < this.putIndex; ++i) {
                        bufferAsList.add(this.buffer[i]);
                    }
                }
            }
        }
        Iterator iterator = bufferAsList.iterator();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            iterator = iterator;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"iterator", iterator);
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Object[] toArray() {
        Object[] retArray;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"toArray", (Object)new Object[0]);
        }
        int size = this.size();
        if (size < 1) {
            retArray = new Object[]{};
        } else {
            retArray = new Object[size];
            int retArrayIndex = 0;
            BoundedBuffer boundedBuffer = this;
            synchronized (boundedBuffer) {
                BoundedBufferLock boundedBufferLock = this.lock;
                synchronized (boundedBufferLock) {
                    int i;
                    if (this.expeditedPutIndex > this.expeditedTakeIndex) {
                        for (i = this.expeditedTakeIndex; i <= this.expeditedPutIndex; ++i) {
                            retArray[retArrayIndex] = this.expeditedBuffer[i];
                            ++retArrayIndex;
                        }
                    } else {
                        for (i = this.expeditedTakeIndex; i < this.expeditedBuffer.length; ++i) {
                            retArray[retArrayIndex] = this.expeditedBuffer[i];
                            ++retArrayIndex;
                        }
                        for (i = 0; i < this.expeditedPutIndex; ++i) {
                            retArray[retArrayIndex] = this.expeditedBuffer[i];
                            ++retArrayIndex;
                        }
                    }
                    if (this.putIndex > this.takeIndex) {
                        for (i = this.takeIndex; i <= this.putIndex; ++i) {
                            retArray[retArrayIndex] = this.buffer[i];
                            ++retArrayIndex;
                        }
                    } else {
                        for (i = this.takeIndex; i < this.buffer.length; ++i) {
                            retArray[retArrayIndex] = this.buffer[i];
                            ++retArrayIndex;
                        }
                        for (i = 0; i < this.putIndex; ++i) {
                            retArray[retArrayIndex] = this.buffer[i];
                            ++retArrayIndex;
                        }
                    }
                }
            }
        }
        Object[] objectArray = retArray;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            objectArray = objectArray;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"toArray", (Object)objectArray);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public <E> E[] toArray(E[] a) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"toArray", (Object)new Object[]{a});
        }
        if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        int aIndex = 0;
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                int i;
                if (this.expeditedPutIndex > this.expeditedTakeIndex) {
                    for (i = this.expeditedTakeIndex; i <= this.expeditedPutIndex; ++i) {
                        a[aIndex] = this.expeditedBuffer[i];
                        ++aIndex;
                    }
                } else {
                    for (i = this.expeditedTakeIndex; i < this.expeditedBuffer.length; ++i) {
                        a[aIndex] = this.expeditedBuffer[i];
                        ++aIndex;
                    }
                    for (i = 0; i < this.expeditedPutIndex; ++i) {
                        a[aIndex] = this.expeditedBuffer[i];
                        ++aIndex;
                    }
                }
                if (this.putIndex > this.takeIndex) {
                    for (i = this.takeIndex; i <= this.putIndex; ++i) {
                        a[aIndex] = this.buffer[i];
                        ++aIndex;
                    }
                } else {
                    for (i = this.takeIndex; i < this.buffer.length; ++i) {
                        a[aIndex] = this.buffer[i];
                        ++aIndex;
                    }
                    for (i = 0; i < this.putIndex; ++i) {
                        a[aIndex] = this.buffer[i];
                        ++aIndex;
                    }
                }
            }
        }
        if (a.length > this.size()) {
            a[this.size()] = null;
        }
        Object[] objectArray = a;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            objectArray = objectArray;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"toArray", objectArray);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean contains(Object o) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"contains", (Object)new Object[]{o});
        }
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                int i;
                if (this.expeditedPutIndex > this.expeditedTakeIndex) {
                    for (i = this.expeditedTakeIndex; i <= this.expeditedPutIndex; ++i) {
                        if (!o.equals(this.expeditedBuffer[i])) continue;
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[9, 10, 11, 28] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                        // MONITOREXIT @DISABLED, blocks:[9, 11, 28] lbl14 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                            bl = bl;
                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"contains", (Object)bl);
                        }
                        return bl;
                    }
                } else {
                    for (i = this.expeditedTakeIndex; i < this.expeditedBuffer.length; ++i) {
                        if (!o.equals(this.expeditedBuffer[i])) continue;
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[9, 10, 27, 12] lbl23 : MonitorExitStatement: MONITOREXIT : var3_3
                        // MONITOREXIT @DISABLED, blocks:[9, 27, 12] lbl24 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                            bl = bl;
                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"contains", (Object)bl);
                        }
                        return bl;
                    }
                    for (i = 0; i < this.expeditedPutIndex; ++i) {
                        if (!o.equals(this.expeditedBuffer[i])) continue;
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[9, 10, 27, 13] lbl32 : MonitorExitStatement: MONITOREXIT : var3_3
                        // MONITOREXIT @DISABLED, blocks:[9, 27, 13] lbl33 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                            bl = bl;
                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"contains", (Object)bl);
                        }
                        return bl;
                    }
                }
                if (this.putIndex > this.takeIndex) {
                    for (i = this.takeIndex; i <= this.putIndex; ++i) {
                        if (!o.equals(this.buffer[i])) continue;
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[9, 26, 10, 14] lbl44 : MonitorExitStatement: MONITOREXIT : var3_3
                        // MONITOREXIT @DISABLED, blocks:[9, 26, 14] lbl45 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                            bl = bl;
                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"contains", (Object)bl);
                        }
                        return bl;
                    }
                } else {
                    for (i = this.takeIndex; i < this.buffer.length; ++i) {
                        if (!o.equals(this.buffer[i])) continue;
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[9, 25, 10, 15] lbl54 : MonitorExitStatement: MONITOREXIT : var3_3
                        // MONITOREXIT @DISABLED, blocks:[9, 25, 15] lbl55 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                            bl = bl;
                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"contains", (Object)bl);
                        }
                        return bl;
                    }
                    for (i = 0; i < this.putIndex; ++i) {
                        if (!o.equals(this.buffer[i])) continue;
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[16, 9, 25, 10] lbl63 : MonitorExitStatement: MONITOREXIT : var3_3
                        // MONITOREXIT @DISABLED, blocks:[16, 9, 25] lbl64 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                            bl = bl;
                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"contains", (Object)bl);
                        }
                        return bl;
                    }
                }
            }
        }
        boolean bl = false;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"contains", (Object)bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean containsAll(Collection<?> c) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"containsAll", (Object)new Object[]{c});
        }
        for (Object e : c) {
            if (this.contains(e)) continue;
            boolean bl = false;
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bl = bl;
                Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"containsAll", (Object)bl);
            }
            return bl;
        }
        boolean bl = true;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"containsAll", (Object)bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean remove(Object o) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"remove", (Object)new Object[]{o});
        }
        if (o == null) {
            boolean bl = false;
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bl = bl;
                Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"remove", (Object)bl);
            }
            return bl;
        }
        if (this.size() == 0) {
            boolean bl = false;
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                bl = bl;
                Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"remove", (Object)bl);
            }
            return bl;
        }
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                int i;
                if (this.expeditedPutIndex > this.expeditedTakeIndex) {
                    for (i = this.expeditedTakeIndex; i <= this.expeditedPutIndex; ++i) {
                        if (!o.equals(this.expeditedBuffer[i])) continue;
                        for (int j = i; j < this.expeditedPutIndex; ++j) {
                            this.expeditedBuffer[j] = this.expeditedBuffer[j + 1];
                        }
                        this.expeditedBuffer[this.expeditedPutIndex] = null;
                        --this.expeditedPutIndex;
                        this.numberOfUsedExpeditedSlots.getAndDecrement();
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[38, 9, 10, 11] lbl32 : MonitorExitStatement: MONITOREXIT : var3_3
                        // MONITOREXIT @DISABLED, blocks:[38, 9, 11] lbl33 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                            bl = bl;
                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"remove", (Object)bl);
                        }
                        return bl;
                    }
                } else {
                    for (i = this.expeditedTakeIndex; i < this.expeditedBuffer.length; ++i) {
                        if (!o.equals(this.expeditedBuffer[i])) continue;
                        for (int j = i; j > this.expeditedTakeIndex; --j) {
                            this.expeditedBuffer[j] = this.expeditedBuffer[j - 1];
                        }
                        this.expeditedBuffer[this.expeditedTakeIndex] = null;
                        this.expeditedTakeIndex = this.expeditedTakeIndex == this.expeditedBuffer.length - 1 ? 0 : ++this.expeditedTakeIndex;
                        this.numberOfUsedExpeditedSlots.getAndDecrement();
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[37, 9, 10, 13] lbl49 : MonitorExitStatement: MONITOREXIT : var3_3
                        // MONITOREXIT @DISABLED, blocks:[37, 9, 13] lbl50 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                            bl = bl;
                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"remove", (Object)bl);
                        }
                        return bl;
                    }
                    for (i = 0; i < this.expeditedPutIndex; ++i) {
                        if (!o.equals(this.expeditedBuffer[i])) continue;
                        for (int j = i; j < this.expeditedPutIndex; ++j) {
                            this.expeditedBuffer[j] = this.expeditedBuffer[j + 1];
                        }
                        this.expeditedBuffer[this.expeditedPutIndex] = null;
                        --this.expeditedPutIndex;
                        this.numberOfUsedExpeditedSlots.getAndDecrement();
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[37, 9, 10, 15] lbl65 : MonitorExitStatement: MONITOREXIT : var3_3
                        // MONITOREXIT @DISABLED, blocks:[37, 9, 15] lbl66 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                            bl = bl;
                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"remove", (Object)bl);
                        }
                        return bl;
                    }
                }
                if (this.putIndex > this.takeIndex) {
                    for (i = this.takeIndex; i <= this.putIndex; ++i) {
                        if (!o.equals(this.buffer[i])) continue;
                        for (int j = i; j < this.putIndex; ++j) {
                            this.buffer[j] = this.buffer[j + 1];
                        }
                        this.buffer[this.putIndex] = null;
                        --this.putIndex;
                        this.numberOfUsedSlots.getAndDecrement();
                        this.notifyPut_();
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[17, 36, 9, 10] lbl85 : MonitorExitStatement: MONITOREXIT : var3_3
                        // MONITOREXIT @DISABLED, blocks:[17, 36, 9] lbl86 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                            bl = bl;
                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"remove", (Object)bl);
                        }
                        return bl;
                    }
                } else {
                    for (i = this.takeIndex; i < this.buffer.length; ++i) {
                        if (!o.equals(this.buffer[i])) continue;
                        for (int j = i; j > this.takeIndex; --j) {
                            this.buffer[j] = this.buffer[j - 1];
                        }
                        this.buffer[this.takeIndex] = null;
                        this.takeIndex = this.takeIndex == this.buffer.length - 1 ? 0 : ++this.takeIndex;
                        this.numberOfUsedSlots.getAndDecrement();
                        this.notifyPut_();
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[35, 19, 9, 10] lbl103 : MonitorExitStatement: MONITOREXIT : var3_3
                        // MONITOREXIT @DISABLED, blocks:[35, 19, 9] lbl104 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                            bl = bl;
                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"remove", (Object)bl);
                        }
                        return bl;
                    }
                    for (i = 0; i < this.putIndex; ++i) {
                        if (!o.equals(this.buffer[i])) continue;
                        for (int j = i; j < this.putIndex; ++j) {
                            this.buffer[j] = this.buffer[j + 1];
                        }
                        this.buffer[this.putIndex] = null;
                        --this.putIndex;
                        this.numberOfUsedSlots.getAndDecrement();
                        this.notifyPut_();
                        boolean bl = true;
                        // MONITOREXIT @DISABLED, blocks:[35, 21, 9, 10] lbl120 : MonitorExitStatement: MONITOREXIT : var3_3
                        // MONITOREXIT @DISABLED, blocks:[35, 21, 9] lbl121 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                            bl = bl;
                            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"remove", (Object)bl);
                        }
                        return bl;
                    }
                }
            }
        }
        boolean bl = false;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"remove", (Object)bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public int drainTo(Collection<? super T> c) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"drainTo", (Object)new Object[]{c});
        }
        int n = this.drainTo(c, Integer.MAX_VALUE);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            n = n;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"drainTo", (Object)n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public int drainTo(Collection<? super T> c, int maxElements) {
        int n;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"drainTo", (Object)new Object[]{c, maxElements});
        }
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int numRemaining = n = Math.min(maxElements, this.size());
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                T retrieved;
                int i;
                for (i = 0; i < n; ++i) {
                    retrieved = this.expeditedExtract();
                    numRemaining = n - i;
                    if (retrieved == null) break;
                    this.numberOfUsedExpeditedSlots.getAndDecrement();
                }
                for (i = 0; i < numRemaining; ++i) {
                    retrieved = this.extract();
                    this.numberOfUsedSlots.getAndDecrement();
                    if (retrieved == null) continue;
                    this.notifyPut_();
                }
            }
        }
        int n2 = n;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            n2 = n2;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"drainTo", (Object)n2);
        }
        return n2;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean addAll(Collection<? extends T> c) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"addAll", (Object)new Object[]{c});
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean removeAll(Collection<?> c) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"removeAll", (Object)new Object[]{c});
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean retainAll(Collection<?> c) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"retainAll", (Object)new Object[]{c});
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void clear() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"clear", (Object)new Object[0]);
        }
        throw new UnsupportedOperationException();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class BoundedBufferLock {
        static final long serialVersionUID = -8194700352933284411L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private BoundedBufferLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.threading.internal.BoundedBuffer$BoundedBufferLock", BoundedBufferLock.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class GetQueueLock {
        private boolean notified;
        static final long serialVersionUID = -3722046241121369171L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GetQueueLock() {
        }

        public boolean isNotified() {
            return this.notified;
        }

        public void setNotified(boolean notified) {
            this.notified = notified;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.threading.internal.BoundedBuffer$GetQueueLock", GetQueueLock.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class PutQueueLock {
        static final long serialVersionUID = 2817268830729528386L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private PutQueueLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.threading.internal.BoundedBuffer$PutQueueLock", PutQueueLock.class, (String)"Threading", (String)"com.ibm.ws.threading.internal.resources.ThreadingMessages");
        }
    }
}

