/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javamail.management.j2ee;

import com.ibm.websphere.management.j2ee.J2EEManagementObjectNameFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.javamail.j2ee.MailSessionRegistrar;
import com.ibm.ws.javamail.management.j2ee.JavaMailResourceMBeanImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class MailSessionRegistrarImpl
implements MailSessionRegistrar {
    public static final String TRACE_GROUP_JAVAMAIL = "javamail.management.j2ee";
    public static final String TRACE_BUNDLE_JAVAMAIL = "com.ibm.ws.javamail.management.j2ee.internal.resources.JavaMailMessages";
    private static final TraceComponent tc = Tr.register(MailSessionRegistrarImpl.class, (String)"javamail.management.j2ee", (String)"com.ibm.ws.javamail.management.j2ee.internal.resources.JavaMailMessages");
    private static final String KEY_JMX_OBJECTNAME = "jmx.objectname";
    private static final String KEY_SERVICE_VENDOR = "service.vendor";
    private static int RESOURCE_COUNTER = 1;
    private static final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    private BundleContext bundle;
    static final long serialVersionUID = -1068962714592526829L;

    @Activate
    protected void activate(ComponentContext context) throws IOException {
        this.bundle = context.getBundleContext();
        this.locationAdminRef.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.locationAdminRef.deactivate(context);
    }

    @Reference(name="locationAdmin", service=WsLocationAdmin.class)
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    protected WsLocationAdmin getWsLocationAdmin() {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        if (locationAdmin == null) {
            MailSessionRegistrarImpl.throwMissingServiceError("WsLocationAdmin");
        }
        return locationAdmin;
    }

    private static void throwMissingServiceError(String service) {
        throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{service}));
    }

    public ServiceRegistration<?> registerJavaMailMBean(String mailSessionID) {
        ObjectName objectName = J2EEManagementObjectNameFactory.createJavaMailObjectName((String)this.getServerName(), (String)mailSessionID, (int)MailSessionRegistrarImpl.getResourceCounter());
        JavaMailResourceMBeanImpl javaMail = new JavaMailResourceMBeanImpl(objectName);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(KEY_SERVICE_VENDOR, "IBM");
        ((Dictionary)props).put(KEY_JMX_OBJECTNAME, javaMail.getobjectName());
        ServiceRegistration sr = this.bundle.registerService(JavaMailResourceMBeanImpl.class, (Object)javaMail, props);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("javaMail=" + javaMail.toString() + " props=" + props), (Object[])new Object[0]);
        }
        return sr;
    }

    private static synchronized int getResourceCounter() {
        return RESOURCE_COUNTER++;
    }

    private String getServerName() {
        return this.getWsLocationAdmin().getServerName();
    }
}

