/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.schemagen.internal;

import com.ibm.ws.config.schemagen.internal.DocumentationWriter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public enum Type {
    STRING(1, "xsd:string", "xsd:string", MinMaxWriter.STRING){

        @Override
        public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
        }
    }
    ,
    BOOLEAN(11, "booleanType", "xsd:boolean", null){

        @Override
        public void writeType(XMLStreamWriter writer, String min, String max, DocumentationWriter documentationWriter) throws XMLStreamException {
            this.writeType(writer, documentationWriter);
        }
    }
    ,
    BYTE(6, "byteType", "xsd:byte", MinMaxWriter.NUMBER),
    CHAR(5, "charType", "char", null){

        @Override
        public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "simpleType");
            writer.writeAttribute("name", "char");
            writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "restriction");
            writer.writeAttribute("base", "xsd:string");
            writer.writeEmptyElement("http://www.w3.org/2001/XMLSchema", "length");
            writer.writeAttribute("value", "1");
            writer.writeEndElement();
            writer.writeEndElement();
            super.writeGlobalType(writer);
        }
    }
    ,
    DOUBLE(7, "doubleType", "xsd:double", MinMaxWriter.NUMBER),
    FLOAT(8, "floatType", "xsd:float", MinMaxWriter.NUMBER),
    INTEGER(3, "intType", "xsd:int", MinMaxWriter.NUMBER),
    LONG(2, "longType", "xsd:long", MinMaxWriter.NUMBER),
    SHORT(4, "shortType", "xsd:short", MinMaxWriter.NUMBER),
    PASSWORD(12, "password", "xsd:string", MinMaxWriter.STRING){

        @Override
        public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
        }
    }
    ,
    PASSWORD_IBM(1003, "password", "xsd:string", MinMaxWriter.STRING),
    PASSWORD_HASH(1008, "passwordHash", "xsd:string", MinMaxWriter.STRING),
    DURATION(1000, "duration", "xsd:string", null),
    DURATION_HOUR(1006, "hourDuration", "xsd:string", null),
    DURATION_MINUTE(1005, "minuteDuration", "xsd:string", null),
    DURATION_SECOND(1004, "secondDuration", "xsd:string", null),
    ON_ERROR(1007, "xsd:string", "xsd:string", null){

        @Override
        public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
        }
    }
    ,
    LOCATION(1002, "location", "xsd:string", null),
    LOCATION_DIR(1010, "dirLocation", "xsd:string", null),
    LOCATION_FILE(1009, "fileLocation", "xsd:string", null),
    LOCATION_URL(1011, "urlLocation", "xsd:string", null),
    TOKEN(1012, "tokenType", "xsd:token", MinMaxWriter.STRING),
    PID(1001, "pidType", "singlePidType", null){

        @Override
        public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
            Type.writePatternType(writer, this.getSchemaBaseType(), "[^, ]+");
            super.writeGlobalType(writer);
        }
    }
    ,
    PID_LIST(-1, "pidListType", "multiplePidType", null){

        @Override
        public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
            Type.writePatternType(writer, this.getSchemaBaseType(), "[^, ]+(\\s*,\\s*[^, ]+)*");
            super.writeGlobalType(writer);
        }
    }
    ,
    VARIABLE(-2, "variableType", "xsd:string", null){

        @Override
        public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
            Type.writePatternType(writer, this.getGlobalSchemaType(), ".*$\\{[^\\s\\}]*\\}.*");
        }
    };

    private int typeId;
    private String globalSchemaType;
    private String schemaBaseType;
    private MinMaxWriter minMaxWriter;

    private Type(int id, String globalType, String schemaType, MinMaxWriter mmw) {
        this.typeId = id;
        this.globalSchemaType = globalType;
        this.schemaBaseType = schemaType;
        this.minMaxWriter = mmw;
    }

    public static Type fromId(int id) {
        Type[] types = Type.values();
        for (int i = 0; i < types.length; ++i) {
            if (types[i].getTypeId() != id) continue;
            return types[i];
        }
        return null;
    }

    public static Type fromId(String globalType) {
        Type[] types = Type.values();
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].getGlobalSchemaType().equals(globalType)) continue;
            return types[i];
        }
        return null;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getGlobalSchemaType() {
        return this.globalSchemaType;
    }

    public String getSchemaBaseType() {
        return this.schemaBaseType;
    }

    public void writeGlobalType(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "simpleType");
        writer.writeAttribute("name", this.getGlobalSchemaType());
        writer.writeEmptyElement("http://www.w3.org/2001/XMLSchema", "union");
        writer.writeAttribute("memberTypes", this.getSchemaBaseType() + " variableType");
        writer.writeEndElement();
    }

    public void writeType(XMLStreamWriter writer, DocumentationWriter documentationWriter) throws XMLStreamException {
        writer.writeAttribute("type", this.getGlobalSchemaType());
        documentationWriter.writeDoc();
    }

    @FFDCIgnore(value={NumberFormatException.class})
    public void writeType(XMLStreamWriter writer, String min, String max, DocumentationWriter documentationWriter) throws XMLStreamException {
        if (min != null) {
            try {
                Integer.parseInt(min);
            }
            catch (NumberFormatException e) {
                min = null;
            }
        }
        if (max != null) {
            try {
                Integer.parseInt(max);
            }
            catch (NumberFormatException e) {
                max = null;
            }
        }
        if (min == null && max == null || this.minMaxWriter == null) {
            this.writeType(writer, documentationWriter);
        } else {
            documentationWriter.writeDoc();
            this.minMaxWriter.writeType(writer, this.getSchemaBaseType(), min, max);
        }
    }

    private static void writePatternType(XMLStreamWriter writer, String name, String pattern) throws XMLStreamException {
        writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "simpleType");
        writer.writeAttribute("name", name);
        writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "restriction");
        writer.writeAttribute("base", "xsd:string");
        writer.writeEmptyElement("http://www.w3.org/2001/XMLSchema", "pattern");
        writer.writeAttribute("value", pattern);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private static enum MinMaxWriter {
        NUMBER{

            @Override
            public void writeLimits(XMLStreamWriter writer, String min, String max) throws XMLStreamException {
                if (min != null) {
                    writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "minInclusive");
                    writer.writeAttribute("value", min);
                    writer.writeEndElement();
                }
                if (max != null) {
                    writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "maxInclusive");
                    writer.writeAttribute("value", max);
                    writer.writeEndElement();
                }
            }
        }
        ,
        STRING{

            @Override
            public void writeLimits(XMLStreamWriter writer, String min, String max) throws XMLStreamException {
                if (min != null) {
                    writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "minLength");
                    writer.writeAttribute("value", min);
                    writer.writeEndElement();
                }
                if (max != null) {
                    writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "maxLength");
                    writer.writeAttribute("value", max);
                    writer.writeEndElement();
                }
            }
        };


        public void writeType(XMLStreamWriter writer, String baseType, String min, String max) throws XMLStreamException {
            writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "simpleType");
            writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "union");
            writer.writeAttribute("memberTypes", "variableType");
            writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "simpleType");
            writer.writeStartElement("http://www.w3.org/2001/XMLSchema", "restriction");
            writer.writeAttribute("base", baseType);
            this.writeLimits(writer, min, max);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }

        public abstract void writeLimits(XMLStreamWriter var1, String var2, String var3) throws XMLStreamException;
    }
}

