/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config14.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.config.impl.AbstractConfig;
import com.ibm.ws.microprofile.config.impl.ConversionManager;
import com.ibm.ws.microprofile.config.impl.SourcedValueImpl;
import com.ibm.ws.microprofile.config.interfaces.SortedSources;
import com.ibm.ws.microprofile.config.interfaces.SourcedValue;
import com.ibm.ws.microprofile.config.interfaces.WebSphereConfig;
import com.ibm.ws.microprofile.config14.impl.TimedCache;
import com.ibm.ws.microprofile.config14.impl.TypeCache;
import com.ibm.ws.microprofile.config14.sources.AppPropertyConfig14Source;
import com.ibm.ws.microprofile.config14.sources.ConfigString;
import com.ibm.ws.microprofile.config14.sources.ExtendedConfigSource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Config14Impl
extends AbstractConfig
implements WebSphereConfig {
    private final Map<String, TypeCache> convertedValueCache = new ConcurrentHashMap<String, TypeCache>();
    private final TimedCache<String, SourcedValue> rawValueCache;
    static final long serialVersionUID = -1412807091735648730L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Config14Impl(ConversionManager conversionManager, SortedSources sources, ScheduledExecutorService executor, long refreshInterval) {
        super(conversionManager, sources);
        this.rawValueCache = new TimedCache(executor, refreshInterval, TimeUnit.MILLISECONDS);
    }

    public SourcedValue getSourcedValue(String propertyName, Type propertyType) {
        SourcedValue sourcedValue = null;
        SourcedValue rawValue = this.getCachedRawValue(propertyName);
        if (rawValue != null) {
            sourcedValue = this.getCachedSourcedValue(rawValue, propertyType);
        }
        return sourcedValue;
    }

    private SourcedValue getCachedSourcedValue(SourcedValue rawValue, Type propertyType) {
        SourcedValue cachedValue;
        SourcedValue value = null;
        String key = rawValue.getKey();
        TypeCache typeCache = this.convertedValueCache.get(key);
        if (typeCache == null || !rawValue.equals(typeCache.getRawValue())) {
            typeCache = new TypeCache(rawValue);
            this.convertedValueCache.put(key, typeCache);
        }
        if ((cachedValue = typeCache.getConvertedValues().get(propertyType)) == null) {
            Object converted = this.getConversionManager().convert((String)rawValue.getValue(), propertyType);
            cachedValue = new SourcedValueImpl(key, converted, propertyType, rawValue.getSource());
            typeCache.getConvertedValues().put(propertyType, cachedValue);
        }
        value = cachedValue;
        return value;
    }

    @Trivial
    @FFDCIgnore(value={NullPointerException.class})
    private static Set<String> getPropertyNames(ConfigSource source) {
        Set<String> names = null;
        try {
            names = source.getPropertyNames();
        }
        catch (NullPointerException e) {
            names = Collections.emptySet();
        }
        return names;
    }

    public Set<String> getKeySet() {
        HashSet<String> result = new HashSet<String>();
        for (ConfigSource source : this.getConfigSources()) {
            Set<String> names = Config14Impl.getPropertyNames(source);
            result.addAll(names);
        }
        return result;
    }

    @Trivial
    private SourcedValue getCachedRawValue(String key) {
        return this.rawValueCache.get(key, this::getRawValue);
    }

    @Trivial
    private SourcedValue getRawValue(String key) {
        SourcedValueImpl raw = null;
        for (ConfigSource source : this.getConfigSources()) {
            if (source instanceof ExtendedConfigSource) {
                ConfigString configString = ((ExtendedConfigSource)source).getConfigString(key);
                if (!configString.isPresent()) continue;
                String sourceID = source.getName();
                raw = new SourcedValueImpl(key, (Object)configString.getValue(), String.class, sourceID);
                break;
            }
            String value = source.getValue(key);
            if (value == null && !source.getPropertyNames().contains(key)) continue;
            String sourceID = source.getName();
            raw = new SourcedValueImpl(key, (Object)value, String.class, sourceID);
            break;
        }
        return raw;
    }

    public void close() {
        this.rawValueCache.close();
        for (ConfigSource source : this.getConfigSources()) {
            if (!(source instanceof AppPropertyConfig14Source)) continue;
            ((AppPropertyConfig14Source)source).close();
        }
        super.close();
    }

    @Trivial
    public String dump() {
        StringBuilder sb = new StringBuilder();
        Set<String> keys = this.getKeySet();
        keys = new TreeSet<String>(keys);
        Iterator<String> keyItr = keys.iterator();
        while (keyItr.hasNext()) {
            String key = keyItr.next();
            SourcedValue rawCompositeValue = this.getCachedRawValue(key);
            if (rawCompositeValue == null) {
                sb.append("null");
            } else {
                sb.append(rawCompositeValue);
            }
            if (!keyItr.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.config14.impl.Config14Impl", Config14Impl.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config14.resources.Config14");
    }
}

