/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.NullConduitSelector;
import org.apache.cxf.endpoint.PreexistingConduitSelector;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.Extensible;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.OneShotAsyncExecutor;
import org.apache.cxf.workqueue.SynchronousExecutor;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.JAXWSAConstants;
import org.apache.cxf.ws.addressing.Names;
import org.apache.cxf.ws.addressing.impl.AddressingPropertiesImpl;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

final class InternalContextUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(InternalContextUtils.class);

    private InternalContextUtils() {
    }

    public static void rebaseResponse(EndpointReferenceType reference, AddressingProperties inMAPs, final Message inMessage) {
        String namespaceURI = inMAPs.getNamespaceURI();
        if (!ContextUtils.retrievePartialResponseSent((Message)inMessage)) {
            ContextUtils.storePartialResponseSent((Message)inMessage);
            Exchange exchange = inMessage.getExchange();
            Message fullResponse = exchange.getOutMessage();
            Message partialResponse = ContextUtils.createMessage((Exchange)exchange);
            InternalContextUtils.ensurePartialResponseMAPs(partialResponse, namespaceURI);
            ContextUtils.propogateReceivedMAPs((AddressingProperties)inMAPs, (Message)partialResponse);
            Destination target = inMessage.getDestination();
            if (target == null) {
                return;
            }
            try {
                if (reference == null) {
                    reference = ContextUtils.getNoneEndpointReference();
                }
                Conduit backChannel = target.getBackChannel(inMessage, partialResponse, reference);
                Exception exception = (Exception)inMessage.getContent(Exception.class);
                if (backChannel != null && !inMessage.getExchange().isOneWay() && ContextUtils.isFault((Message)inMessage)) {
                    exchange.setOutMessage(ContextUtils.createMessage((Exchange)exchange));
                    exchange.put(ConduitSelector.class, (Object)new NullConduitSelector());
                    exchange.put((Object)"org.apache.cxf.http.no_io_exceptions", (Object)true);
                    Destination destination = InternalContextUtils.createDecoupledDestination(exchange, reference);
                    exchange.setDestination(destination);
                    if (ContextUtils.retrieveAsyncPostResponseDispatch((Message)inMessage)) {
                        DelegatingInputStream in = (DelegatingInputStream)inMessage.getContent(DelegatingInputStream.class);
                        if (in != null) {
                            in.cacheInput();
                        }
                        inMessage.getInterceptorChain().reset();
                        if (inMessage.get((Object)Message.PATH_INFO) != null) {
                            inMessage.remove((Object)Message.PATH_INFO);
                        }
                        inMessage.getInterceptorChain().doIntercept(inMessage);
                    }
                    partialResponse.put((Object)"forced.faultstring", (Object)("The server sent HTTP status code :" + inMessage.getExchange().get((Object)Message.RESPONSE_CODE)));
                    partialResponse.setContent(Exception.class, (Object)exception);
                    partialResponse.put((Object)Message.PROTOCOL_HEADERS, inMessage.get((Object)Message.PROTOCOL_HEADERS));
                    partialResponse.put((Object)Message.ENCODING, inMessage.get((Object)Message.ENCODING));
                    partialResponse.put((Object)ContextUtils.ACTION, inMessage.get((Object)ContextUtils.ACTION));
                    partialResponse.put((Object)"javax.xml.ws.addressing.context.inbound", inMessage.get((Object)"javax.xml.ws.addressing.context.inbound"));
                    partialResponse.put((Object)"javax.xml.ws.addressing.context.outbound", inMessage.get((Object)"javax.xml.ws.addressing.context.outbound"));
                    exchange.setOutMessage(partialResponse);
                    PhaseInterceptorChain newChian = ((PhaseInterceptorChain)inMessage.getInterceptorChain()).cloneChain();
                    partialResponse.setInterceptorChain((InterceptorChain)newChian);
                    exchange.setDestination(target);
                    exchange.setOneWay(false);
                    exchange.put(ConduitSelector.class, (Object)new PreexistingConduitSelector(backChannel, (Endpoint)exchange.get(Endpoint.class)));
                    if (newChian != null && !newChian.doIntercept(partialResponse) && partialResponse.getContent(Exception.class) != null) {
                        if (partialResponse.getContent(Exception.class) instanceof Fault) {
                            throw (Fault)partialResponse.getContent(Exception.class);
                        }
                        throw new Fault((Throwable)partialResponse.getContent(Exception.class));
                    }
                    return;
                }
                if (backChannel != null) {
                    partialResponse.put((Object)"org.apache.cxf.partial.response", (Object)Boolean.TRUE);
                    partialResponse.put((Object)"org.apache.cxf.partial.response.empty", (Object)Boolean.TRUE);
                    boolean robust = MessageUtils.isTrue((Object)inMessage.getContextualProperty("org.apache.cxf.oneway.robust"));
                    if (robust) {
                        BindingOperationInfo boi = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
                        exchange.put(Executor.class, (Object)InternalContextUtils.getExecutor(inMessage));
                        inMessage.getInterceptorChain().pause();
                        inMessage.getInterceptorChain().resume();
                        MessageObserver faultObserver = inMessage.getInterceptorChain().getFaultObserver();
                        if (null != inMessage.getContent(Exception.class) && null != faultObserver) {
                            inMessage.getExchange().setOneWay(false);
                            faultObserver.onMessage(inMessage);
                            return;
                        }
                        exchange.put(BindingOperationInfo.class, (Object)boi);
                    }
                    InterceptorChain chain = fullResponse != null ? fullResponse.getInterceptorChain() : OutgoingChainInterceptor.getOutInterceptorChain((Exchange)exchange);
                    exchange.setOutMessage(partialResponse);
                    partialResponse.setInterceptorChain(chain);
                    exchange.put(ConduitSelector.class, (Object)new PreexistingConduitSelector(backChannel, (Endpoint)exchange.get(Endpoint.class)));
                    if (chain != null && !chain.doIntercept(partialResponse) && partialResponse.getContent(Exception.class) != null) {
                        if (partialResponse.getContent(Exception.class) instanceof Fault) {
                            throw (Fault)partialResponse.getContent(Exception.class);
                        }
                        throw new Fault((Throwable)partialResponse.getContent(Exception.class));
                    }
                    if (chain != null) {
                        chain.reset();
                    }
                    exchange.put(ConduitSelector.class, (Object)new NullConduitSelector());
                    if (fullResponse == null) {
                        fullResponse = ContextUtils.createMessage((Exchange)exchange);
                    }
                    exchange.setOutMessage(fullResponse);
                    Destination destination = InternalContextUtils.createDecoupledDestination(exchange, reference);
                    exchange.setDestination(destination);
                    if (ContextUtils.retrieveAsyncPostResponseDispatch((Message)inMessage) && !robust) {
                        DelegatingInputStream in = (DelegatingInputStream)inMessage.getContent(DelegatingInputStream.class);
                        if (in != null) {
                            in.cacheInput();
                        }
                        if (inMessage.get((Object)Message.PATH_INFO) != null) {
                            inMessage.remove((Object)Message.PATH_INFO);
                        }
                        inMessage.getInterceptorChain().pause();
                        try {
                            InternalContextUtils.getExecutor(inMessage).execute(new Runnable(){

                                public void run() {
                                    inMessage.getInterceptorChain().resume();
                                }
                            });
                        }
                        catch (RejectedExecutionException e) {
                            LOG.warning("Executor queue is full, use the caller thread.  Users can specify a larger executor queue to avoid this.");
                            if (!MessageUtils.isTrue((Object)inMessage.getContextualProperty("org.apache.cxf.oneway.rejected_execution_exception"))) {
                                inMessage.getInterceptorChain().resume();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "SERVER_TRANSPORT_REBASE_FAILURE_MSG", e);
            }
        }
    }

    public static Destination createDecoupledDestination(Exchange exchange, final EndpointReferenceType reference) {
        final EndpointInfo ei = ((Endpoint)exchange.get(Endpoint.class)).getEndpointInfo();
        return new Destination(){

            public EndpointReferenceType getAddress() {
                return reference;
            }

            public Conduit getBackChannel(Message inMessage, Message partialResponse, EndpointReferenceType address) throws IOException {
                Bus bus = (Bus)inMessage.getExchange().get(Bus.class);
                inMessage.getExchange().setOneWay(true);
                ConduitInitiator conduitInitiator = ((ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiatorForUri(reference.getAddress().getValue());
                if (conduitInitiator != null) {
                    Conduit c = conduitInitiator.getConduit(ei, reference);
                    c.setMessageObserver(new MessageObserver(){

                        public void onMessage(Message m) {
                            InputStream is = (InputStream)m.getContent(InputStream.class);
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    return c;
                }
                return null;
            }

            public MessageObserver getMessageObserver() {
                return null;
            }

            public void shutdown() {
            }

            public void setMessageObserver(MessageObserver observer) {
            }
        };
    }

    private static void ensurePartialResponseMAPs(Message partialResponse, String namespaceURI) {
        AddressingPropertiesImpl maps = new AddressingPropertiesImpl();
        maps.setTo(EndpointReferenceUtils.getAnonymousEndpointReference());
        maps.setReplyTo(ContextUtils.WSA_OBJECT_FACTORY.createEndpointReferenceType());
        maps.getReplyTo().setAddress(ContextUtils.getAttributedURI((String)"http://www.w3.org/2005/08/addressing/none"));
        maps.setAction(ContextUtils.getAttributedURI((String)""));
        maps.exposeAs(namespaceURI);
        ContextUtils.storeMAPs((AddressingProperties)maps, (Message)partialResponse, (boolean)true, (boolean)true, (boolean)false);
    }

    public static AttributedURIType getAction(Message message) {
        String action = null;
        LOG.fine("Determining action");
        Exception fault = (Exception)message.getContent(Exception.class);
        action = InternalContextUtils.getActionFromServiceModel(message, fault);
        LOG.fine("action: " + action);
        return action != null ? ContextUtils.getAttributedURI((String)action) : null;
    }

    private static String getActionFromServiceModel(Message message, Exception fault) {
        String action;
        block4: {
            BindingOperationInfo bindingOpInfo;
            block5: {
                MessageInfo msgInfo;
                String cachedAction;
                action = null;
                bindingOpInfo = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
                if (bindingOpInfo == null) break block4;
                if (bindingOpInfo.isUnwrappedCapable()) {
                    bindingOpInfo = bindingOpInfo.getUnwrappedOperation();
                }
                if (fault != null) break block5;
                action = (String)message.get((Object)ContextUtils.ACTION);
                if (StringUtils.isEmpty((String)action)) {
                    action = (String)message.get((Object)"SOAPAction");
                }
                if (action != null && !"".equals(action) || (action = (cachedAction = (String)(msgInfo = ContextUtils.isRequestor((Message)message) ? bindingOpInfo.getOperationInfo().getInput() : bindingOpInfo.getOperationInfo().getOutput()).getProperty(ContextUtils.ACTION)) == null ? InternalContextUtils.getActionFromMessageAttributes(msgInfo) : cachedAction) != null || !ContextUtils.isRequestor((Message)message)) break block4;
                SoapOperationInfo soi = InternalContextUtils.getSoapOperationInfo(bindingOpInfo);
                action = soi == null ? null : soi.getAction();
                action = StringUtils.isEmpty((String)action) ? null : action;
                break block4;
            }
            Throwable t = fault.getCause();
            for (BindingFaultInfo bfi : bindingOpInfo.getFaults()) {
                FaultInfo fi = bfi.getFaultInfo();
                Class fiTypeClass = fi.getMessagePart(0).getTypeClass();
                if (t == null || fiTypeClass == null || !t.getClass().isAssignableFrom(fiTypeClass) || fi.getExtensionAttributes() == null) continue;
                String attr = (String)fi.getExtensionAttributes().get(Names.WSAW_ACTION_QNAME);
                if (attr == null) {
                    attr = (String)fi.getExtensionAttributes().get(new QName("http://www.w3.org/2005/02/addressing/wsdl", "Action"));
                }
                if (attr == null) continue;
                action = attr;
                break;
            }
        }
        LOG.fine("action determined from service model: " + action);
        return action;
    }

    public static SoapOperationInfo getSoapOperationInfo(BindingOperationInfo bindingOpInfo) {
        SoapOperationInfo soi = (SoapOperationInfo)bindingOpInfo.getExtensor(SoapOperationInfo.class);
        if (soi == null && bindingOpInfo.isUnwrapped()) {
            soi = (SoapOperationInfo)bindingOpInfo.getWrappedOperation().getExtensor(SoapOperationInfo.class);
        }
        return soi;
    }

    private static String getActionFromMessageAttributes(MessageInfo msgInfo) {
        String attr;
        String action = null;
        if (msgInfo != null && msgInfo.getExtensionAttributes() != null && !StringUtils.isEmpty((String)(attr = InternalContextUtils.getAction((Extensible)msgInfo)))) {
            action = attr;
            msgInfo.setProperty(ContextUtils.ACTION, (Object)action);
        }
        return action;
    }

    public static String getAction(Extensible ext) {
        Object o = ext.getExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME);
        if (o == null) {
            o = ext.getExtensionAttributes().get(new QName("http://www.w3.org/2007/05/addressing/metadata", "Action"));
        }
        if (o == null) {
            o = ext.getExtensionAttributes().get(new QName("http://www.w3.org/2005/08/addressing", "Action"));
        }
        if (o == null) {
            o = ext.getExtensionAttributes().get(new QName("http://www.w3.org/2005/02/addressing/wsdl", "Action"));
        }
        if (o instanceof QName) {
            return ((QName)o).getLocalPart();
        }
        return o == null ? null : o.toString();
    }

    private static Executor getExecutor(Message message) {
        Endpoint endpoint = (Endpoint)message.getExchange().get(Endpoint.class);
        Executor executor = endpoint.getService().getExecutor();
        if (executor == null || SynchronousExecutor.isA((Executor)executor)) {
            WorkQueueManager workQueueManager;
            AutomaticWorkQueue autoWorkQueue;
            Bus bus = (Bus)message.getExchange().get(Bus.class);
            executor = bus != null ? ((autoWorkQueue = (workQueueManager = (WorkQueueManager)bus.getExtension(WorkQueueManager.class)).getNamedWorkQueue("ws-addressing")) != null ? autoWorkQueue : workQueueManager.getAutomaticWorkQueue()) : OneShotAsyncExecutor.getInstance();
        }
        message.getExchange().put(Executor.class, (Object)executor);
        return executor;
    }
}

