/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.model.media;

import com.ibm.ws.microprofile.openapi.model.utils.OpenAPIUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;

public class MediaTypeImpl
implements MediaType {
    private Schema schema = null;
    private Map<String, Example> examples = null;
    private Object example = null;
    private Map<String, Encoding> encoding = null;
    private Map<String, Object> extensions = null;

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public MediaType schema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public void setExamples(Map<String, Example> examples) {
        this.examples = examples;
    }

    public MediaType examples(Map<String, Example> examples) {
        this.examples = examples;
        return this;
    }

    public MediaType addExample(String key, Example example) {
        if (example == null) {
            return this;
        }
        if (this.examples == null) {
            this.examples = new HashMap<String, Example>();
        }
        this.examples.put(key, example);
        return this;
    }

    public Object getExample() {
        return this.example;
    }

    public void setExample(Object example) {
        this.example = example;
    }

    public MediaType example(Object example) {
        this.example = example;
        return this;
    }

    public Map<String, Encoding> getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Map<String, Encoding> encoding) {
        this.encoding = encoding;
    }

    public MediaType encoding(Map<String, Encoding> encoding) {
        this.encoding = encoding;
        return this;
    }

    public MediaType addEncoding(String key, Encoding encodingItem) {
        if (encodingItem == null) {
            return this;
        }
        if (this.encoding == null) {
            this.encoding = new HashMap<String, Encoding>();
        }
        this.encoding.put(key, encodingItem);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaTypeImpl mediaType = (MediaTypeImpl)o;
        return Objects.equals(this.schema, mediaType.schema) && Objects.equals(this.examples, mediaType.examples) && Objects.equals(this.example, mediaType.example) && Objects.equals(this.encoding, mediaType.encoding) && Objects.equals(this.extensions, mediaType.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.examples, this.example, this.encoding, this.extensions);
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public MediaType addExtension(String name, Object value) {
        if (value == null) {
            return this;
        }
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(name, value);
        return this;
    }

    public void removeExtension(String key) {
        if (this.extensions != null) {
            this.extensions.remove(key);
        }
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaType {\n");
        sb = this.schema != null ? sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n") : sb.append("");
        sb = this.examples != null ? sb.append("    examples: ").append(OpenAPIUtils.mapToString(this.examples)).append("\n") : sb.append("");
        sb = this.example != null ? sb.append("    example: ").append(this.toIndentedString(this.example)).append("\n") : sb.append("");
        sb = this.encoding != null ? sb.append("    encoding: ").append(OpenAPIUtils.mapToString(this.encoding)).append("\n") : sb.append("");
        sb = this.extensions != null ? sb.append("    extensions: ").append(OpenAPIUtils.mapToString(this.extensions)).append("\n") : sb.append("");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public void removeEncoding(String key) {
        if (this.encoding != null) {
            this.encoding.remove(key);
        }
    }

    public void removeExample(String key) {
        if (this.examples != null) {
            this.examples.remove(key);
        }
    }
}

