/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jndi.WSNameUtil;
import com.ibm.ws.jndi.internal.ContextNode;
import com.ibm.ws.jndi.internal.JNDIServiceBinderManager;
import com.ibm.ws.jndi.internal.WSContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={InitialContextFactory.class, ObjectFactory.class, WSContextFactory.class}, servicefactory=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class WSContextFactory
implements InitialContextFactory,
ObjectFactory,
AllServiceListener {
    private static final TraceComponent tc = Tr.register(WSContextFactory.class, (String)"Naming", (String)"com.ibm.ws.jndi.internal.resources.JNDIMessages");
    private BundleContext userContext;
    private final ConcurrentHashMap<ServiceReference<?>, Object> cache = new ConcurrentHashMap();
    static final long serialVersionUID = 6130441421822329217L;

    protected void activate(ComponentContext cc) {
        Bundle usingBundle = cc.getUsingBundle();
        this.userContext = usingBundle.getBundleContext();
        try {
            this.userContext.getBundle("System Bundle").getBundleContext().addServiceListener((ServiceListener)this, "(&(osgi.jndi.service.name=*)(!(osgi.jndi.service.origin=jndi)))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.jndi.internal.WSContextFactory", (String)"72", (Object)this, (Object[])new Object[]{cc});
        }
    }

    protected void deactivate(ComponentContext cc) {
        this.userContext.getBundle("System Bundle").getBundleContext().removeServiceListener((ServiceListener)this);
    }

    Object getService(ServiceReference<?> ref) {
        return this.cache.computeIfAbsent(ref, r -> AccessController.doPrivileged(() -> this.userContext.getService(r)));
    }

    public WSContext getInitialContext(Hashtable env) throws NamingException {
        return new WSContext(this.userContext, JNDIServiceBinderManager.JNDIServiceBinderHolder.HELPER.root, env, this);
    }

    @Override
    public Object getObjectInstance(Object o, Name n, Context c, Hashtable<?, ?> envmt) throws Exception {
        Hashtable<String, Object> env = envmt;
        return o instanceof Reference ? this.resolve((Reference)o, env) : null;
    }

    private WSContext resolve(Reference ref, Hashtable<String, Object> env) throws NamingException {
        RefAddr addr;
        Object content;
        if (ref.getClassName().equals(WSContext.class.getName()) && (content = (addr = ref.get("jndi")).getContent()) instanceof String) {
            String name = (String)content;
            Object o = JNDIServiceBinderManager.JNDIServiceBinderHolder.HELPER.root.lookup(WSNameUtil.normalize(name));
            try {
                ContextNode node = (ContextNode)o;
                return new WSContext(this.userContext, node, env, this);
            }
            catch (ClassCastException node) {
                FFDCFilter.processException((Throwable)node, (String)"com.ibm.ws.jndi.internal.WSContextFactory", (String)"117", (Object)this, (Object[])new Object[]{ref, env});
                throw new NotContextException(name);
            }
        }
        return null;
    }

    static Reference makeReference(WSContext ctx) throws NamingException {
        StringRefAddr addr = new StringRefAddr("jndi", "" + ctx.myNode.fullName);
        return new Reference(WSContext.class.getName(), addr, WSContextFactory.class.getName(), null);
    }

    /*
     * Unable to fully structure code
     */
    @FFDCIgnore(value={IllegalStateException.class})
    public void serviceChanged(ServiceEvent event) {
        ref = event.getServiceReference();
        switch (event.getType()) {
            case 2: 
            case 4: 
            case 8: {
                try {
                    this.userContext.ungetService(ref);
                }
                catch (IllegalStateException e) {
                    if (!WSContextFactory.tc.isDebugEnabled()) ** GOTO lbl11
                    Tr.debug((TraceComponent)WSContextFactory.tc, (String)("UngetService failed: " + e), (Object[])new Object[0]);
                }
lbl11:
                // 3 sources

                this.cache.remove(ref);
                break;
            }
        }
    }
}

