/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.channelfw.objectpool;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.wsspi.channelfw.objectpool.ObjectDestroyer;
import com.ibm.wsspi.channelfw.objectpool.ObjectFactory;
import com.ibm.wsspi.channelfw.objectpool.ObjectPool;

public class CircularObjectPool
implements ObjectPool {
    private Object[] free = null;
    private ObjectFactory factory = null;
    private ObjectDestroyer destroyer = null;
    private long[] timeFreed = null;
    private int firstEntry = -1;
    private int lastEntry = -1;
    private final int poolSize;
    private static int minPoolSize = 20;
    private static int batchSize = minPoolSize / 2;
    private boolean cleanUpOld = true;

    public CircularObjectPool(int size) {
        this(size, null, null);
    }

    public CircularObjectPool(int size, ObjectFactory fact) {
        this(size, fact, null);
    }

    public CircularObjectPool(int size, ObjectFactory fact, ObjectDestroyer dest) {
        this.factory = fact;
        this.destroyer = dest;
        this.poolSize = size;
        this.free = new Object[this.poolSize];
        this.timeFreed = new long[this.poolSize];
        for (int i = 0; i < this.poolSize; ++i) {
            this.free[i] = null;
            this.timeFreed[i] = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get() {
        Object oObject = null;
        CircularObjectPool circularObjectPool = this;
        synchronized (circularObjectPool) {
            if (this.lastEntry > -1) {
                oObject = this.free[this.lastEntry];
                this.free[this.lastEntry] = null;
                if (this.lastEntry == this.firstEntry) {
                    this.lastEntry = -1;
                    this.firstEntry = -1;
                } else {
                    this.lastEntry = this.lastEntry > 0 ? --this.lastEntry : this.poolSize - 1;
                }
            }
        }
        if (oObject == null && this.factory != null) {
            oObject = this.factory.create();
        }
        return oObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object object) {
        Object returnVal = null;
        long currentTime = CHFWBundle.getApproxTime();
        CircularObjectPool circularObjectPool = this;
        synchronized (circularObjectPool) {
            ++this.lastEntry;
            if (this.lastEntry == this.poolSize) {
                this.lastEntry = 0;
            }
            returnVal = this.free[this.lastEntry];
            this.free[this.lastEntry] = object;
            this.timeFreed[this.lastEntry] = currentTime;
            if (this.lastEntry == this.firstEntry) {
                ++this.firstEntry;
                if (this.firstEntry == this.poolSize) {
                    this.firstEntry = 0;
                }
            }
            if (this.firstEntry == -1) {
                this.firstEntry = this.lastEntry;
            }
            if (returnVal != null && this.destroyer != null) {
                this.destroyer.destroy(returnVal);
            }
            if (this.cleanUpOld) {
                while (this.firstEntry != this.lastEntry && currentTime > this.timeFreed[this.firstEntry] + 60000L) {
                    if (this.destroyer != null && this.free[this.firstEntry] != null) {
                        this.destroyer.destroy(this.free[this.firstEntry]);
                    }
                    this.free[this.firstEntry] = null;
                    ++this.firstEntry;
                    if (this.firstEntry != this.poolSize) continue;
                    this.firstEntry = 0;
                }
            }
        }
        return returnVal;
    }

    public void setCleanUpOld(boolean flag) {
        this.cleanUpOld = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] getBatch() {
        Object[] objectArray = new Object[batchSize];
        CircularObjectPool circularObjectPool = this;
        synchronized (circularObjectPool) {
            objectArray[0] = this.get();
            for (int index = 1; this.getCurrentNumElements() > minPoolSize / 2 && index < batchSize; ++index) {
                objectArray[index] = this.get();
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putBatch(Object[] objectArray) {
        CircularObjectPool circularObjectPool = this;
        synchronized (circularObjectPool) {
            for (int index = 0; index < objectArray.length && objectArray[index] != null; ++index) {
                this.put(objectArray[index]);
            }
        }
    }

    private int getCurrentNumElements() {
        if (this.lastEntry == -1) {
            return 0;
        }
        if (this.lastEntry >= this.firstEntry) {
            return this.lastEntry - this.firstEntry + 1;
        }
        return this.lastEntry + 1 + (this.poolSize - this.firstEntry);
    }
}

