/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udpchannel.internal;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.ChannelFactoryData;
import com.ibm.websphere.channelfw.OutboundChannelDefinition;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.udpchannel.internal.UDPChannel;
import com.ibm.ws.udpchannel.internal.UDPChannelConfiguration;
import com.ibm.ws.udpchannel.internal.UDPChannelFactoryConfiguration;
import com.ibm.ws.udpchannel.internal.WorkQueueManager;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ChannelFactory;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryException;
import com.ibm.wsspi.udpchannel.UDPContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UDPChannelFactory
implements ChannelFactory {
    private static final TraceComponent tc = Tr.register(UDPChannelFactory.class, (String)"UDPChannel", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");
    private static final Class<?> appSideClass = UDPContext.class;
    protected UDPChannelFactoryConfiguration factoryConfig = null;
    private WorkQueueManager workQueueManager = null;
    private VirtualConnectionFactory vcFactory = null;
    private Map<String, Channel> existingChannels = null;
    private Map<Object, Object> commonProperties = null;

    public UDPChannelFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Created " + this), (Object[])new Object[0]);
        }
        this.existingChannels = new HashMap<String, Channel>();
    }

    protected Channel createChannel(ChannelData data) throws ChannelException {
        UDPChannelConfiguration newCC = new UDPChannelConfiguration();
        newCC.setChannelData(data);
        try {
            return new UDPChannel(newCC, this.getWorkQueueManager());
        }
        catch (IOException ioe) {
            throw new ChannelException("Unable to create UDP channel", ioe);
        }
    }

    @Override
    public void init(ChannelFactoryData data) throws ChannelFactoryException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("init: " + this), (Object[])new Object[0]);
        }
        this.commonProperties = data.getProperties();
        this.factoryConfig = new UDPChannelFactoryConfiguration(data);
        this.vcFactory = ChannelFrameworkFactory.getChannelFramework().getInboundVCFactory();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"init");
        }
    }

    @Override
    public void destroy() {
        block2: {
            this.existingChannels.clear();
            this.existingChannels = null;
            try {
                this.vcFactory.destroy();
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block2;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Error disconnecting from vc factory; " + e), (Object[])new Object[0]);
            }
        }
        this.vcFactory = null;
    }

    @Override
    public Class<?> getApplicationInterface() {
        return appSideClass;
    }

    protected VirtualConnectionFactory getVCFactory() {
        return this.vcFactory;
    }

    private WorkQueueManager getWorkQueueManager() throws IOException {
        WorkQueueManager localWorkQueueManager = null;
        if (this.factoryConfig.isUniqueWorkerThreads()) {
            localWorkQueueManager = new WorkQueueManager(this);
        } else {
            if (this.workQueueManager == null) {
                this.workQueueManager = new WorkQueueManager(this);
            }
            localWorkQueueManager = this.workQueueManager;
        }
        return localWorkQueueManager;
    }

    @Override
    public synchronized Channel findOrCreateChannel(ChannelData channelData) throws ChannelException {
        String channelName;
        Channel ret;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("findOrCreateChannel: " + channelData.getName()), (Object[])new Object[0]);
        }
        if ((ret = this.existingChannels.get(channelName = channelData.getName())) == null) {
            ret = this.createChannel(channelData);
            this.existingChannels.put(channelName, ret);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"findOrCreateChannel");
        }
        return ret;
    }

    public synchronized void removeChannel(String channelName) {
        this.existingChannels.remove(channelName);
    }

    @Override
    public Map<Object, Object> getProperties() {
        return this.commonProperties;
    }

    @Override
    public final Class<?>[] getDeviceInterface() {
        throw new IllegalStateException("Not implemented and should not be used");
    }

    @Override
    public void updateProperties(Map<Object, Object> properties) {
        this.commonProperties = properties;
    }

    @Override
    public OutboundChannelDefinition getOutboundChannelDefinition(Map<Object, Object> props) {
        return new UDPOutboundDefinition(props);
    }

    private static class UDPOutboundDefinition
    implements OutboundChannelDefinition {
        private static final long serialVersionUID = -7427145547238486815L;

        protected UDPOutboundDefinition(Map<Object, Object> props) {
        }

        @Override
        public Map<Object, Object> getOutboundChannelProperties() {
            return null;
        }

        @Override
        public Class<?> getOutboundFactory() {
            return UDPChannelFactory.class;
        }

        @Override
        public Map<Object, Object> getOutboundFactoryProperties() {
            return null;
        }
    }
}

