/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tcpchannel.internal.ConnectChannelSelector;
import com.ibm.ws.tcpchannel.internal.WorkQueueManager;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import java.io.IOException;

public class AioWorkQueueManager
extends WorkQueueManager {
    private static final TraceComponent tc = Tr.register(AioWorkQueueManager.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");

    @Override
    protected void startSelectors(boolean inBound) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("startSelectors: " + inBound), (Object[])new Object[0]);
        }
        if (this.connect != null) {
            return;
        }
        try {
            if (!inBound) {
                this.connect = new ConnectChannelSelector[this.maxChannelSelectorsPerFlow];
                this.connectCount = new int[this.maxChannelSelectorsPerFlow];
                for (int i = 0; i < this.maxChannelSelectorsPerFlow; ++i) {
                    this.connectCount[i] = -1;
                }
                this.connect[0] = new ConnectChannelSelector(this, 0, 4);
                this.createNewThread(this.connect[0], 4, 1);
                this.connectCount[0] = 0;
            }
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)this.getClass().getName(), (String)"100", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Error creating selectors: " + ioe), (Object[])new Object[0]);
            }
            ChannelException ce = new ChannelException("Unable to start the TCP Channel Connect Selector", ioe);
            throw ce;
        }
    }
}

