/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.krb5.Krb5Common;
import com.ibm.ws.security.spnego.SpnegoConfig;
import com.ibm.ws.security.spnego.internal.Krb5Util;
import java.util.HashMap;
import java.util.List;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SpnGssCredential {
    private static final TraceComponent tc = Tr.register(SpnGssCredential.class, (String)"spnego", (String)"com.ibm.ws.security.spnego.internal.resources.SpnegoMessages");
    private HashMap<String, GSSCredential> spnGssCredentials = null;
    private SpnegoConfig spnegoConfig = null;
    Krb5Util krb5Util = new Krb5Util();
    static final long serialVersionUID = 464042328079164150L;

    public void init(List<String> servicePrincipalNames, SpnegoConfig spnegoConfig) {
        this.spnegoConfig = spnegoConfig;
        String oldPropValue = null;
        if (servicePrincipalNames != null && !servicePrincipalNames.isEmpty()) {
            this.spnGssCredentials = new HashMap();
            this.krb5Util.setKrb5ConfigAndKeytabProps(spnegoConfig);
            oldPropValue = Krb5Common.setPropertyAsNeeded((String)"javax.security.auth.useSubjectCredsOnly", (String)"false");
            for (String spn : servicePrincipalNames) {
                GSSCredential gssCred = this.createSpnGSSCredential(spn);
                if (gssCred == null) continue;
                String hostName = this.extractHostName(spn);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("host name: " + hostName + " spn: " + spn + " gssCred: " + gssCred), (Object[])new Object[0]);
                }
                if (this.spnGssCredentials.get(hostName) != null) {
                    Tr.warning((TraceComponent)tc, (String)"SPNEGO_MULTIPLE_SPNS_WITH_SAME_HOST_NAME", (Object[])new Object[]{hostName});
                    continue;
                }
                this.spnGssCredentials.put(hostName, gssCred);
            }
            Krb5Common.restorePropertyAsNeeded((String)"javax.security.auth.useSubjectCredsOnly", (String)oldPropValue, (String)"true");
        }
        if (this.spnGssCredentials == null || this.spnGssCredentials.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"SPNEGO_NO_SPN_GSS_CREDENTIAL", (Object[])new Object[0]);
        }
    }

    public boolean isEmpty() {
        return this.spnGssCredentials != null ? this.spnGssCredentials.isEmpty() : true;
    }

    public int howManySpns() {
        int size = 0;
        if (this.spnGssCredentials != null) {
            return this.spnGssCredentials.size();
        }
        return size;
    }

    protected String extractHostName(String spn) {
        String hostname = spn;
        if (spn.indexOf("@") != -1) {
            hostname = spn.substring(0, spn.indexOf("@"));
        }
        if (hostname.indexOf("/") != -1) {
            String[] hs = hostname.split("/");
            hostname = hs[1];
        }
        return hostname;
    }

    public GSSCredential getSpnGSSCredential(String hostName) {
        return this.spnGssCredentials != null ? this.spnGssCredentials.get(hostName) : null;
    }

    /*
     * WARNING - void declaration
     */
    protected GSSCredential createSpnGSSCredential(String servicePrincipalName) {
        GSSCredential spnGSSCred = null;
        GSSName gssName = null;
        try {
            GSSManager gssManager = GSSManager.getInstance();
            gssName = this.createGSSName(gssManager, servicePrincipalName);
            spnGSSCred = this.createGSSCredential(gssName, gssManager, servicePrincipalName);
        }
        catch (GSSException gssManager) {
            void e;
            FFDCFilter.processException((Throwable)gssManager, (String)"com.ibm.ws.security.spnego.internal.SpnGssCredential", (String)"111", (Object)this, (Object[])new Object[]{servicePrincipalName});
            Tr.error((TraceComponent)tc, (String)"SPNEGO_CAN_NOT_CREATE_GSSCRED_FOR_SPN", (Object[])new Object[]{gssName != null ? gssName.toString() : servicePrincipalName, e});
        }
        return spnGSSCred;
    }

    private GSSCredential createGSSCredential(GSSName gssName, GSSManager gssManager, String spn) throws GSSException {
        GSSCredential spnGSSCred;
        String previousSpn = null;
        if (Krb5Common.isIBMJdk18 || Krb5Common.isOtherSupportJDKs) {
            if (Krb5Common.isOtherSupportJDKs) {
                previousSpn = Krb5Common.getSystemProperty((String)Krb5Common.KRB5_PRINCIPAL);
                Krb5Common.setPropertyAsNeeded((String)Krb5Common.KRB5_PRINCIPAL, (String)spn);
                Krb5Common.setPropertyAsNeeded((String)"javax.security.auth.login.name", (String)spn);
            }
            spnGSSCred = gssManager.createCredential(gssName, 0, Krb5Common.KRB5_MECH_OID, 2);
            spnGSSCred.add(gssName, Integer.MAX_VALUE, Integer.MAX_VALUE, Krb5Common.SPNEGO_MECH_OID, 2);
            if (Krb5Common.isOtherSupportJDKs) {
                Krb5Common.restorePropertyAsNeeded((String)Krb5Common.KRB5_PRINCIPAL, (String)previousSpn, (String)spn);
                Krb5Common.restorePropertyAsNeeded((String)"javax.security.auth.login.name", (String)previousSpn, (String)spn);
            }
        } else {
            GSSCredential spnGSSCred2 = gssManager.createCredential(gssName, Integer.MAX_VALUE, Krb5Common.SPNEGO_MECH_OID, 2);
            return spnGSSCred2;
        }
        return spnGSSCred;
    }

    private GSSName createGSSName(GSSManager gssManager, String servicePrincipalName) throws GSSException {
        GSSName gssName = null;
        gssName = gssManager.createName(servicePrincipalName, GSSName.NT_USER_NAME, Krb5Common.SPNEGO_MECH_OID);
        if (this.spnegoConfig.isCanonicalHostName() && !servicePrincipalName.startsWith("localhost")) {
            gssName = gssName.canonicalize(Krb5Common.KRB5_MECH_OID);
        }
        return gssName;
    }
}

