/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.krb5.Krb5Common;
import com.ibm.ws.security.spnego.SpnegoConfig;
import com.ibm.ws.security.spnego.internal.SpnegoHelperProxy;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.servlet.http.HttpServletResponse;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Krb5Util {
    private static final TraceComponent tc = Tr.register(Krb5Util.class, (String)"spnego", (String)"com.ibm.ws.security.spnego.internal.resources.SpnegoMessages");
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char NEWLINE = '\n';
    private static final char TILDA = '~';
    private static final char DOT = '.';
    private static HashMap<String, Subject> delegateSubjectCache = null;
    static boolean ibmJDK = false;
    static final long serialVersionUID = -6766805925710873577L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationResult processSpnegoToken(HttpServletResponse resp, @Sensitive byte[] tokenByte, String reqHostName, SpnegoConfig spnegoConfig) throws AuthenticationException {
        AuthenticationResult result = null;
        GSSCredential spnGssCred = spnegoConfig.getSpnGSSCredential(reqHostName);
        String spnWithoutRealm = "HTTP/" + reqHostName;
        String currentSpn = null;
        if (spnGssCred == null) {
            Tr.error((TraceComponent)tc, (String)"SPNEGO_GSSCRED_NOT_FOUND_FOR_SPN", (Object[])new Object[]{spnWithoutRealm});
            return new AuthenticationResult(AuthResult.SEND_401, "There is no GSSCredential for SPN");
        }
        try {
            currentSpn = spnGssCred.getName().toString();
        }
        catch (GSSException gSSException) {
            Object[] objectArray = new Object[4];
            objectArray[0] = resp;
            objectArray[1] = "<sensitive byte[]>";
            objectArray[2] = reqHostName;
            objectArray[3] = spnegoConfig;
            FFDCFilter.processException((Throwable)gSSException, (String)"com.ibm.ws.security.spnego.internal.Krb5Util", (String)"79", (Object)this, (Object[])objectArray);
            Tr.error((TraceComponent)tc, (String)("spnWithouRealm: " + spnWithoutRealm + "currentSpn: " + currentSpn), (Object[])new Object[0]);
        }
        Subject clientSubject = new Subject();
        Subject delegateSubject = new Subject();
        GSSContext gssContext = null;
        String currentUseSubjectCredsOnly = "true";
        String preUseSubjectCredsOnly = null;
        String previousSpn = null;
        if (SpnegoHelperProxy.isS4U2proxyEnabled()) {
            currentUseSubjectCredsOnly = "false";
        }
        try {
            preUseSubjectCredsOnly = Krb5Common.setPropertyAsNeeded((String)"javax.security.auth.useSubjectCredsOnly", (String)currentUseSubjectCredsOnly);
            if (Krb5Common.isOtherSupportJDKs) {
                previousSpn = Krb5Common.setPropertyAsNeeded((String)Krb5Common.KRB5_PRINCIPAL, (String)currentSpn);
                Krb5Common.setPropertyAsNeeded((String)"javax.security.auth.login.name", (String)currentSpn);
            }
            if (SpnegoHelperProxy.isS4U2proxyEnabled()) {
                delegateSubject = Krb5Util.getdelegateServiceSubject(spnWithoutRealm, currentSpn, spnegoConfig);
            }
            if ((gssContext = this.validateSpnegoToken(resp, spnGssCred, tokenByte, delegateSubject, spnegoConfig)).isEstablished()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SPNEGO request token successfully processed. GSSContext is established", (Object[])new Object[0]);
                }
                result = this.createResult(clientSubject, gssContext, spnegoConfig);
            } else {
                result = new AuthenticationResult(AuthResult.FAILURE, "GSSContext is not established with a valid SPNEGO token");
            }
            this.disposeGssContext(gssContext);
        }
        finally {
            Krb5Common.restorePropertyAsNeeded((String)"javax.security.auth.useSubjectCredsOnly", (String)preUseSubjectCredsOnly, (String)currentUseSubjectCredsOnly);
            if (Krb5Common.isOtherSupportJDKs) {
                Krb5Common.restorePropertyAsNeeded((String)Krb5Common.KRB5_PRINCIPAL, (String)previousSpn, (String)currentSpn);
                Krb5Common.restorePropertyAsNeeded((String)"javax.security.auth.login.name", (String)previousSpn, (String)currentSpn);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public GSSContext validateSpnegoToken(HttpServletResponse resp, GSSCredential spnGssCredential, final @Sensitive byte[] inToken, Subject clientSubject, SpnegoConfig spnegoConfig) throws AuthenticationException {
        final GSSContext gssContext = this.createGssContext(spnGssCredential, spnegoConfig);
        byte[] responseToken = null;
        PrivilegedExceptionAction<byte[]> action = new PrivilegedExceptionAction<byte[]>(){
            static final long serialVersionUID = 3271709965058768907L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public byte[] run() throws Exception {
                return gssContext.acceptSecContext(inToken, 0, inToken.length);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.spnego.internal.Krb5Util$1", 1.class, (String)"spnego", (String)"com.ibm.ws.security.spnego.internal.resources.SpnegoMessages");
            }
        };
        try {
            responseToken = Subject.doAsPrivileged(clientSubject, action, AccessController.getContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            Object[] objectArray = new Object[5];
            objectArray[0] = resp;
            objectArray[1] = spnGssCredential;
            objectArray[2] = "<sensitive byte[]>";
            objectArray[3] = clientSubject;
            objectArray[4] = spnegoConfig;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.spnego.internal.Krb5Util", (String)"145", (Object)this, (Object[])objectArray);
            try {
                void e;
                throw e.getException();
            }
            catch (Exception exception) {
                void ee;
                Object[] objectArray2 = new Object[5];
                objectArray2[0] = resp;
                objectArray2[1] = spnGssCredential;
                objectArray2[2] = "<sensitive byte[]>";
                objectArray2[3] = clientSubject;
                objectArray2[4] = spnegoConfig;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.spnego.internal.Krb5Util", (String)"148", (Object)this, (Object[])objectArray2);
                throw new AuthenticationException(ee.getLocalizedMessage(), (Exception)ee);
            }
        }
        if (!gssContext.isEstablished()) {
            String responsebytes = Krb5Util.showHex(responseToken);
            Tr.error((TraceComponent)tc, (String)"SPNEGO_CAN_NOT_ESTABLISH_GSSCONTEXT_WITH_VALIDATE_TOKEN", (Object[])new Object[]{responsebytes});
        }
        if (responseToken != null) {
            this.setServerResponseToken(resp, responseToken);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"client subject: ", (Object[])new Object[]{clientSubject != null ? clientSubject : "is null"});
        }
        return gssContext;
    }

    /*
     * WARNING - void declaration
     */
    protected GSSContext createGssContext(GSSCredential spnGssCredential, SpnegoConfig spnegoConfig) throws AuthenticationException {
        GSSContext gssContext = null;
        GSSManager gssManager = GSSManager.getInstance();
        try {
            gssContext = gssManager.createContext(spnGssCredential);
        }
        catch (GSSException gSSException) {
            void e;
            FFDCFilter.processException((Throwable)gSSException, (String)"com.ibm.ws.security.spnego.internal.Krb5Util", (String)"180", (Object)this, (Object[])new Object[]{spnGssCredential, spnegoConfig});
            throw new AuthenticationException(e.getLocalizedMessage(), (Exception)e);
        }
        return gssContext;
    }

    @Trivial
    protected void setServerResponseToken(HttpServletResponse resp, byte[] respToken) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Server response token: " + Krb5Util.showHex(respToken)), (Object[])new Object[0]);
        }
        String responseEnc = new String(Base64Coder.base64Encode((byte[])respToken));
        resp.setHeader("WWW-Authenticate", "Negotiate " + responseEnc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Encoded response: " + responseEnc), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    AuthenticationResult createResult(Subject clientSubject, GSSContext gssContext, SpnegoConfig spnegoConfig) throws AuthenticationException {
        GSSCredential clientGSSCred;
        String userPrincipal = null;
        try {
            userPrincipal = gssContext.getSrcName().toString();
        }
        catch (GSSException gSSException) {
            void e;
            FFDCFilter.processException((Throwable)gSSException, (String)"com.ibm.ws.security.spnego.internal.Krb5Util", (String)"216", (Object)this, (Object[])new Object[]{clientSubject, gssContext, spnegoConfig});
            throw new AuthenticationException(e.getLocalizedMessage(), (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Kerberos client principal: " + userPrincipal), (Object[])new Object[0]);
        }
        KerberosPrincipal krb5Principal = new KerberosPrincipal(userPrincipal);
        clientSubject.getPrincipals().add(krb5Principal);
        String authName = userPrincipal;
        if (spnegoConfig.isTrimKerberosRealmNameFromPrincipal()) {
            authName = this.trimUsername(userPrincipal);
        }
        String customCacheKey = userPrincipal;
        if (spnegoConfig.isIncludeClientGSSCredentialInSubject() && (clientGSSCred = this.addGSSDelegCredToSubject(userPrincipal, gssContext, clientSubject, spnegoConfig)) != null) {
            customCacheKey = userPrincipal + clientGSSCred.hashCode();
        }
        this.addCustomProperties(clientSubject, customCacheKey, authName, spnegoConfig);
        return new AuthenticationResult(AuthResult.SUCCESS, clientSubject);
    }

    private void addCustomProperties(Subject subject, String customCacheKey, String authName, SpnegoConfig spnegoConfig) {
        Hashtable<String, Object> customProperties = new Hashtable<String, Object>();
        customProperties.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
        customProperties.put("com.ibm.wsspi.security.cred.userId", authName);
        if (spnegoConfig.isIncludeCustomCacheKeyInSubject()) {
            customProperties.put("com.ibm.wsspi.security.cred.cacheKey", customCacheKey);
        }
        if (spnegoConfig.isDisableLtpaCookie()) {
            customProperties.put("com.ibm.ws.authentication.internal.sso.disable.ltpa.cookie", Boolean.TRUE);
        }
        subject.getPrivateCredentials().add(customProperties);
    }

    /*
     * WARNING - void declaration
     */
    public void disposeGssContext(GSSContext gssContext) {
        block3: {
            if (gssContext != null) {
                try {
                    gssContext.dispose();
                }
                catch (GSSException gSSException) {
                    void e;
                    FFDCFilter.processException((Throwable)gSSException, (String)"com.ibm.ws.security.spnego.internal.Krb5Util", (String)"269", (Object)this, (Object[])new Object[]{gssContext});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("GSSException: " + e), (Object[])new Object[0]);
                }
            }
        }
    }

    @FFDCIgnore(value={GSSException.class})
    private GSSCredential addGSSDelegCredToSubject(String userPrincipal, GSSContext context, Subject subject, SpnegoConfig spnegoConfig) {
        GSSCredential clientCred;
        block9: {
            block8: {
                clientCred = null;
                try {
                    clientCred = context.getDelegCred();
                }
                catch (GSSException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)("gssClientCredential has not been saved in the subject, GSSException: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
            try {
                if (clientCred == null && SpnegoHelperProxy.isS4U2proxyEnabled()) {
                    String delegateServiceSpn = context.getTargName().toString();
                    clientCred = SpnegoHelperProxy.getDelegateGSSCredUsingS4U2proxy(userPrincipal, context, delegateServiceSpn);
                }
                if (clientCred != null) {
                    subject.getPrivateCredentials().add(clientCred);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Add gssClientCredential " + userPrincipal + " to subject"), (Object[])new Object[0]);
                    }
                } else {
                    Tr.warning((TraceComponent)tc, (String)"SPNEGO_NO_DELEGATED_CREDENTIALS_FOUND", (Object[])new Object[]{userPrincipal});
                }
            }
            catch (GSSException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)("gssClientCredential has not been saved in the subject, GSSException: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return clientCred;
    }

    public String trimUsername(String principal) {
        if (principal == null || principal.length() == 0) {
            return null;
        }
        String p = principal;
        int i = p.lastIndexOf("@");
        if (i != -1) {
            p = p.substring(0, i);
        }
        return p;
    }

    public void setKrb5ConfigAndKeytabProps(SpnegoConfig spnegoConfig) {
        String krb5Config;
        String krb5Keytab = spnegoConfig.getKrb5Keytab();
        if (krb5Keytab != null) {
            Krb5Common.setPropertyAsNeeded((String)"KRB5_KTNAME", (String)krb5Keytab);
        }
        if ((krb5Config = spnegoConfig.getKrb5Config()) != null) {
            Krb5Common.setPropertyAsNeeded((String)"java.security.krb5.conf", (String)krb5Config);
        }
    }

    @Trivial
    public static String showHex(byte[] buffer) {
        int i;
        if (buffer == null) {
            return null;
        }
        int nBytes = buffer.length;
        StringBuffer sb = new StringBuffer(nBytes);
        StringBuffer pb = new StringBuffer(nBytes << 1);
        StringBuffer hb = new StringBuffer(nBytes << 1);
        StringBuffer tb = new StringBuffer(nBytes << 1);
        int j = 0;
        int k = 0;
        float f = 0.0f;
        for (i = 0; i < nBytes; ++i) {
            int value = buffer[i] & 0xFF;
            if (value == 13 || value == 10 || value == 9 || value >= 32 && value <= 126) {
                sb.append((char)value);
            } else {
                sb.append('[' + Krb5Util.hexPad(Integer.toHexString(value), 2) + ']');
                f += 1.0f;
            }
            if (value >= 32 && value <= 126) {
                tb.append((char)value);
            } else {
                tb.append('.');
            }
            hb.append(Krb5Util.hexPad(Integer.toHexString(value), 2));
            if (j == 3 || j == 7 || j == 11) {
                hb.append(' ');
                tb.append(' ');
            }
            if (j == 15) {
                String pad = Krb5Util.hexPad(Integer.toHexString(k), 4);
                pb.append(pad).append(":  ").append(hb).append("    ").append(tb).append("\n");
                j = 0;
                k += 16;
                hb.setLength(0);
                tb.setLength(0);
                continue;
            }
            ++j;
        }
        for (i = hb.length(); i < 35; ++i) {
            hb.append(' ');
        }
        String pad = Krb5Util.hexPad(Integer.toHexString(k), 4);
        pb.append(pad).append(":  ").append(hb).append("    ").append(tb).append("\n");
        return pb.toString();
    }

    @Trivial
    private static String hexPad(String aString, int aPadLength) {
        int stringSize = aString.length();
        StringBuffer buffer = new StringBuffer(stringSize + aPadLength);
        for (int i = stringSize; i < aPadLength; ++i) {
            buffer.append('0');
        }
        buffer.append(aString);
        return buffer.toString();
    }

    private static Subject getdelegateServiceSubject(String spnWithoutRealm, String delegateServiceSpn, SpnegoConfig spnegoConfig) {
        Subject delegateServiceSubject = Krb5Util.getDelegateServiceSubjectFromCache(delegateServiceSpn);
        if (delegateServiceSubject != null) {
            return delegateServiceSubject;
        }
        try {
            delegateServiceSubject = SpnegoHelperProxy.doKerberosLogin(delegateServiceSpn, spnegoConfig.getKrb5Keytab());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.spnego.internal.Krb5Util", (String)"439", null, (Object[])new Object[]{spnWithoutRealm, delegateServiceSpn, spnegoConfig});
            Tr.error((TraceComponent)tc, (String)"SPNEGO_DELEGATE_SPN_LOGIN_TO_KDC_FAILURE", (Object[])new Object[]{spnWithoutRealm, spnegoConfig.getKrb5Config(), spnegoConfig.getKrb5Keytab()});
        }
        if (delegateServiceSubject != null) {
            delegateSubjectCache.put(delegateServiceSpn, delegateServiceSubject);
        }
        return delegateServiceSubject;
    }

    private static Subject getDelegateServiceSubjectFromCache(String delegateServiceSpn) {
        if (delegateSubjectCache == null) {
            delegateSubjectCache = new HashMap();
            return null;
        }
        Subject delegateServiceSubject = delegateSubjectCache.get(delegateServiceSpn);
        if (delegateServiceSubject != null) {
            boolean valid = SubjectHelper.isTGTInSubjectValid((Subject)delegateServiceSubject, (String)delegateServiceSpn);
            if (valid) {
                return delegateServiceSubject;
            }
            delegateSubjectCache.remove(delegateServiceSpn);
        }
        return delegateServiceSubject;
    }
}

