/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.InvalidAddOperation;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.Membership;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreConstants;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.cache.links.ItemLinkState;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.cache.links.Priorities;
import com.ibm.ws.sib.msgstore.cache.ref.Indirection;
import com.ibm.ws.sib.msgstore.cache.ref.IndirectionCache;
import com.ibm.ws.sib.msgstore.cache.statemodel.ListStatistics;
import com.ibm.ws.sib.msgstore.cache.statemodel.LockIdMismatch;
import com.ibm.ws.sib.msgstore.cache.statemodel.StateException;
import com.ibm.ws.sib.msgstore.deliverydelay.DeliveryDelayManager;
import com.ibm.ws.sib.msgstore.deliverydelay.DeliveryDelayable;
import com.ibm.ws.sib.msgstore.expiry.Expirable;
import com.ibm.ws.sib.msgstore.expiry.Expirer;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.list.Link;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.task.AbstractRemoveTask;
import com.ibm.ws.sib.msgstore.task.AddTask;
import com.ibm.ws.sib.msgstore.task.PersistLock;
import com.ibm.ws.sib.msgstore.task.PersistRedeliveredCount;
import com.ibm.ws.sib.msgstore.task.PersistUnlock;
import com.ibm.ws.sib.msgstore.task.RemoveLockedTask;
import com.ibm.ws.sib.msgstore.task.RemoveTask;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.task.UpdateTask;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.List;

public abstract class AbstractItemLink
extends Link
implements Membership,
Priorities,
XmlConstants,
Expirable,
Indirection,
DeliveryDelayable {
    static final long EXPIRY_LOCK_ID = 123456L;
    private static final int NOT_SET = -1;
    public static final int MEMORY_SIZE_MULTIPLIER = 4;
    private static final long NO_LOCK_ID = -2L;
    private static TraceComponent tc = SibTr.register(AbstractItemLink.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private int _backoutCount = 0;
    private static final NullStrongReferenceToItem NULL_STRONG_REF = new NullStrongReferenceToItem();
    private static final NullCacheReferenceToItem NULL_CACHE_REF = new NullCacheReferenceToItem();
    private AbstractItem _strongReferenceToItem = NULL_STRONG_REF;
    private volatile int _inMemoryItemSize = -1;
    private boolean _isStorageManaged = false;
    private IndirectionCache _itemCache;
    private Indirection _itemCacheLinkNext = null;
    private Indirection _itemCacheLinkPrevious = null;
    private AbstractItem _itemCacheManagedReference = NULL_CACHE_REF;
    private boolean _itemIsDiscardableIfPersistentRepresentationStable = false;
    private ItemLinkState _itemLinkState = ItemLinkState.STATE_NOT_STORED;
    private long _lockID = -2L;
    private AbstractItemLink _nextMappedLink;
    private final LinkOwner _owningStreamLink;
    private boolean _persistentRepresentationIsStable = false;
    private PersistentTranId _transactionId;
    private final Persistable _tuple;
    private boolean _persistentDataEncodingFailed = false;
    private int _unlockCount = 0;
    private SoftReference _softReferenceToItem;
    private int _persistedRedeliveredCount = 0;

    protected AbstractItemLink() {
        this._owningStreamLink = null;
        this._tuple = null;
        this._inMemoryItemSize = 0;
    }

    protected AbstractItemLink(AbstractItem item, LinkOwner owningStreamLink, Persistable persistable) throws OutOfCacheSpace {
        int strategy;
        this._itemLinkState = ItemLinkState.STATE_NOT_STORED;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{owningStreamLink, persistable});
        }
        this._tuple = persistable;
        if (null == item) {
            strategy = 4;
            this._tuple.setStorageStrategy(4);
            this._tuple.setItemClassName(MessageStoreImpl.class.getName());
            this._inMemoryItemSize = 0;
            this._isStorageManaged = false;
        } else {
            strategy = item.getStorageStrategy();
            this._tuple.setStorageStrategy(strategy);
            this._tuple.setItemClassName(item.getClass().getName());
            this.setInMemoryItemSize(item);
            this._tuple.setInMemoryByteSize(this._inMemoryItemSize);
            this._isStorageManaged = item.isItem() || item.isItemReference();
        }
        this._owningStreamLink = owningStreamLink;
        persistable.setAbstractItemLink(this);
        MessageStoreImpl msi = this.getMessageStoreImpl();
        if (this._isStorageManaged) {
            this._itemCache = msi.getManagedCache().register(strategy);
        }
        this._createSoftReference(item);
        this._strongReferenceToItem = item;
        if (1 == this._tuple.getStorageStrategy()) {
            this._persistentRepresentationIsStable = true;
        }
        this._persistedRedeliveredCount = this._tuple.getRedeliveredCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected AbstractItemLink(LinkOwner owningStreamLink, Persistable persistable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{owningStreamLink, persistable});
        }
        this._itemLinkState = ItemLinkState.STATE_NOT_STORED;
        this._tuple = persistable;
        this.setInMemoryItemSize(null);
        persistable.setAbstractItemLink(this);
        this._owningStreamLink = owningStreamLink;
        this._persistedRedeliveredCount = this._tuple.getRedeliveredCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    protected AbstractItemLink(Persistable persistable, boolean isRootLink) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)persistable);
        }
        this._itemLinkState = ItemLinkState.STATE_NOT_STORED;
        this._tuple = persistable;
        this.setInMemoryItemSize(null);
        persistable.setAbstractItemLink(this);
        this._owningStreamLink = null;
        this._persistedRedeliveredCount = this._tuple.getRedeliveredCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    final synchronized void _assertCanAddChild(PersistentTransaction transaction, ListStatistics stats) throws StreamIsFull, InvalidAddOperation {
        boolean allowed = false;
        if (this._itemLinkState == ItemLinkState.STATE_ADDING_LOCKED || this._itemLinkState == ItemLinkState.STATE_ADDING_UNLOCKED) {
            if (this.getTransactionId().equals((Object)transaction.getPersistentTranId())) {
                allowed = true;
            }
        } else {
            allowed = this._itemLinkState == ItemLinkState.STATE_UPDATING_DATA || this._itemLinkState == ItemLinkState.STATE_AVAILABLE || this._itemLinkState == ItemLinkState.STATE_LOCKED || this._itemLinkState == ItemLinkState.STATE_PERSISTENTLY_LOCKED || this._itemLinkState == ItemLinkState.STATE_PERSISTING_LOCK || this._itemLinkState == ItemLinkState.STATE_UNLOCKING_PERSISTENTLY_LOCKED;
        }
        if (!allowed) {
            throw new InvalidAddOperation("STREAM_WRONG_STATE_SIMS0006", new Object[]{this, this._itemLinkState});
        }
    }

    final synchronized void _assertCanAddChildUnder(PersistentTransaction transaction) throws InvalidAddOperation {
        boolean allowed = false;
        if (this._itemLinkState == ItemLinkState.STATE_ADDING_LOCKED || this._itemLinkState == ItemLinkState.STATE_ADDING_UNLOCKED) {
            if (this.getTransactionId().equals((Object)transaction.getPersistentTranId())) {
                allowed = true;
            }
        } else {
            allowed = this._itemLinkState == ItemLinkState.STATE_UPDATING_DATA || this._itemLinkState == ItemLinkState.STATE_AVAILABLE;
        }
        if (!allowed) {
            throw new InvalidAddOperation("STREAM_WRONG_STATE_SIMS0006", new Object[]{this, this._itemLinkState});
        }
    }

    final synchronized void _assertCanRemoveChildUnder(PersistentTransaction transaction) throws SevereMessageStoreException {
        boolean allowed = false;
        if (this._itemLinkState == ItemLinkState.STATE_UPDATING_DATA || this._itemLinkState == ItemLinkState.STATE_AVAILABLE) {
            allowed = true;
        } else if (this._itemLinkState == ItemLinkState.STATE_REMOVING_EXPIRING || this._itemLinkState == ItemLinkState.STATE_REMOVING_LOCKED || this._itemLinkState == ItemLinkState.STATE_REMOVING_PERSISTENTLY_LOCKED || this._itemLinkState == ItemLinkState.STATE_REMOVING_WITHOUT_LOCK) {
            PersistentTranId id = transaction.getPersistentTranId();
            if (id.equals((Object)this.getTransactionId())) {
                allowed = true;
            }
        } else {
            allowed = false;
        }
        if (!allowed) {
            throw new SevereMessageStoreException(this._itemLinkState + " - Wrong transaction(" + transaction.getPersistentTranId() + ") for action (old id=" + this.getTransactionId() + ")");
        }
    }

    private final void _assertCorrectTransaction(PersistentTransaction transaction) throws SevereMessageStoreException {
        PersistentTranId id = transaction.getPersistentTranId();
        if (!id.equals((Object)this._transactionId)) {
            throw new SevereMessageStoreException(this._itemLinkState + " - Wrong transaction(" + id + ") for action (old id=" + this._transactionId + ")");
        }
    }

    private final void _createSoftReference(AbstractItem item) throws OutOfCacheSpace {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"creating soft reference");
        }
        this._softReferenceToItem = new SoftReference<AbstractItem>(item);
    }

    private final synchronized boolean _declareDiscardable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_declareDiscardable");
        }
        boolean linkHasBecomeReleasable = false;
        if (this._isStorageManaged) {
            if (!this._itemIsDiscardableIfPersistentRepresentationStable) {
                linkHasBecomeReleasable = this._persistentRepresentationIsStable;
                if (linkHasBecomeReleasable) {
                    this._strongReferenceToItem = NULL_STRONG_REF;
                }
                this._itemIsDiscardableIfPersistentRepresentationStable = true;
            }
        } else {
            this._itemIsDiscardableIfPersistentRepresentationStable = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_declareDiscardable", (Object)linkHasBecomeReleasable);
        }
        return linkHasBecomeReleasable;
    }

    private final synchronized boolean _declareNotDiscardable(AbstractItem item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_declareNotDiscardable");
        }
        boolean notifyRequired = false;
        this._strongReferenceToItem = item;
        if (this._itemIsDiscardableIfPersistentRepresentationStable) {
            notifyRequired = this._persistentRepresentationIsStable;
            this._itemIsDiscardableIfPersistentRepresentationStable = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_declareNotDiscardable", (Object)notifyRequired);
        }
        return notifyRequired;
    }

    private final void _declareNotReleasable() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_declareNotReleasable");
        }
        if (this._isStorageManaged) {
            this._itemCache.unmanage(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_declareNotReleasable");
        }
    }

    private final void _declareReleasable(AbstractItem item) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_declareReleasable");
        }
        if (this._isStorageManaged) {
            this._itemCache.manage(this, item);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_declareReleasable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AbstractItem _getAndAssertItem() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_getAndAssertItem");
        }
        AbstractItem item = null;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            item = this._strongReferenceToItem;
        }
        if (item == NULL_STRONG_REF) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"_getAndAssertItem");
            }
            throw new SevereMessageStoreException("_getAndAssertItem");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_getAndAssertItem", (Object)item);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AbstractItem _getItemNoRestore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_getItemNoRestore");
        }
        AbstractItem item = null;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            item = this._strongReferenceToItem;
        }
        if (item == NULL_STRONG_REF) {
            item = null;
        }
        if (null == item && null != this._softReferenceToItem) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Retrieving Item from soft reference.");
            }
            item = (AbstractItem)this._softReferenceToItem.get();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_getItemNoRestore", (Object)item);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final AbstractItem _restoreItem() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_restoreItem");
        }
        AbstractItem item = null;
        boolean linkHasBecomeNonReleasable = false;
        boolean linkHasBecomeReleasable = false;
        try {
            block33: {
                boolean unlink;
                block35: {
                    MessageStoreImpl msi;
                    block36: {
                        block34: {
                            AbstractItemLink abstractItemLink = this;
                            // MONITORENTER : abstractItemLink
                            unlink = false;
                            item = this._getItemNoRestore();
                            if (null != item) break block33;
                            msi = this.getMessageStoreImpl();
                            if (this._tuple.getStorageStrategy() != 1) break block34;
                            if (ItemLinkState.STATE_NOT_STORED != this._itemLinkState) {
                                if (ItemLinkState.STATE_AVAILABLE != this._itemLinkState) {
                                    if (!TraceComponent.isAnyTracingEnabled()) throw new StateException(this._itemLinkState.toString());
                                    if (!tc.isEntryEnabled()) throw new StateException(this._itemLinkState.toString());
                                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreItem");
                                    throw new StateException(this._itemLinkState.toString());
                                }
                                unlink = true;
                            }
                            break block35;
                        }
                        if (!this._persistentDataEncodingFailed) break block36;
                        if (this._tuple.getStorageStrategy() == 2) {
                            if (ItemLinkState.STATE_NOT_STORED != this._itemLinkState) {
                                if (ItemLinkState.STATE_AVAILABLE != this._itemLinkState) {
                                    if (!TraceComponent.isAnyTracingEnabled()) throw new StateException(this._itemLinkState.toString());
                                    if (!tc.isEntryEnabled()) throw new StateException(this._itemLinkState.toString());
                                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreItem");
                                    throw new StateException(this._itemLinkState.toString());
                                }
                                unlink = true;
                            }
                            break block35;
                        } else {
                            SevereMessageStoreException msre = new SevereMessageStoreException();
                            FFDCFilter.processException((Throwable)msre, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink._restoreItem", (String)"1:764:1.241", (Object)this, (Object[])new Object[]{this._tuple});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Attempted to restore data not in store");
                            }
                            if (!TraceComponent.isAnyTracingEnabled()) throw msre;
                            if (!tc.isEntryEnabled()) throw msre;
                            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreItem");
                            throw msre;
                        }
                    }
                    if (this.isInStore()) {
                        long id = this._tuple.getUniqueId();
                        List<DataSlice> dataSlices = this.readDataFromPersistence();
                        if (null != dataSlices) {
                            block32: {
                                try {
                                    String itemClassName = this._tuple.getItemClassName();
                                    this.getMessageStoreImpl();
                                    item = MessageStoreImpl.getItemStreamInstance(itemClassName);
                                }
                                catch (Exception e) {
                                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink._restoreItem", (String)"1:784:1.241", (Object)this);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                        SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught while restoring item!", (Object)e);
                                    }
                                    if (!TraceComponent.isAnyTracingEnabled()) throw new SevereMessageStoreException("RESTORING_ITEM_SIMS0502" + id, (Throwable)e);
                                    if (!tc.isEntryEnabled()) throw new SevereMessageStoreException("RESTORING_ITEM_SIMS0502" + id, (Throwable)e);
                                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreItem");
                                    throw new SevereMessageStoreException("RESTORING_ITEM_SIMS0502" + id, (Throwable)e);
                                }
                                msi._setMembership(this, item);
                                try {
                                    item.restore(dataSlices);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"item restored");
                                    }
                                }
                                catch (PersistentDataEncodingException pdee) {
                                    FFDCFilter.processException((Throwable)pdee, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink._restoreItem", (String)"1:803:1.241", (Object)this);
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block32;
                                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught restoring Item!", (Object)((Object)pdee));
                                }
                            }
                            item.eventRestored();
                            this.itemHasBeenRestored(item);
                        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Indoubt item disappeared: ", (Object)this);
                        }
                        if (null != item) {
                            this._persistentRepresentationIsStable = true;
                            this._itemIsDiscardableIfPersistentRepresentationStable = false;
                            this._createSoftReference(item);
                            boolean bl = this._isStorageManaged = item.isItem() || item.isItemReference();
                            if (this._isStorageManaged) {
                                this._itemCache = msi.getManagedCache().register(this._tuple.getStorageStrategy());
                            } else {
                                this._strongReferenceToItem = item;
                            }
                            if (this.isAvailable() || this.isPersistentlyLocked()) {
                                linkHasBecomeReleasable = this._declareDiscardable();
                            } else {
                                linkHasBecomeNonReleasable = this._declareNotDiscardable(item);
                            }
                            int oldSize = this._inMemoryItemSize;
                            this.setInMemoryItemSize(item);
                            if (this._inMemoryItemSize != oldSize) {
                                ListStatistics stats = this.getParentStatistics();
                                stats.updateTotal(oldSize, this._inMemoryItemSize);
                            }
                        }
                    }
                }
                if (unlink) {
                    ListStatistics stats = this.getParentStatistics();
                    stats.decrementAvailable(this._inMemoryItemSize);
                    this._itemLinkState = ItemLinkState.STATE_NOT_STORED;
                    this.getMessageStoreImpl().unregister(this);
                    this.unlink();
                }
            }
            // MONITOREXIT : abstractItemLink
            if (linkHasBecomeReleasable) {
                this._declareReleasable(item);
            }
            if (linkHasBecomeNonReleasable) {
                this._declareNotReleasable();
            }
        }
        catch (OutOfCacheSpace e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink._restoreItem", (String)"1:897:1.241", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Exception caught while restoring item!", (Object)((Object)e));
            }
            if (!TraceComponent.isAnyTracingEnabled()) throw new SevereMessageStoreException((Throwable)e);
            if (!tc.isEntryEnabled()) throw new SevereMessageStoreException((Throwable)e);
            SibTr.exit((TraceComponent)tc, (String)"_restoreItem");
            throw new SevereMessageStoreException((Throwable)e);
        }
        if (!TraceComponent.isAnyTracingEnabled()) return item;
        if (!tc.isEntryEnabled()) return item;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreItem", (Object)item);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _restoreStateAdding(AbstractItemLink link, LinkOwner stream, PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_restoreStateAdding", (Object)new Object[]{link, stream, transaction});
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_NOT_STORED != this._itemLinkState) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("State has already been set: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateAdding");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            ListStatistics stats = this.getParentStatistics();
            stats.incrementAdding(this._inMemoryItemSize);
            this._transactionId = transaction.getPersistentTranId();
            this._itemLinkState = ItemLinkState.STATE_ADDING_UNLOCKED;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateAdding");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void _restoreStateAvailable(AbstractItemLink link, LinkOwner stream) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_restoreStateAvailable", (Object)new Object[]{link, stream});
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_NOT_STORED != this._itemLinkState) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("State has already been set: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateAvailable");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            ListStatistics stats = this.getParentStatistics();
            stats.incrementAvailable(this._inMemoryItemSize);
            this._itemLinkState = ItemLinkState.STATE_AVAILABLE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateAvailable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _restoreStatePersistentlyLocked(AbstractItemLink link, LinkOwner stream, long lockID) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_restoreStatePersistentlyLocked", (Object)new Object[]{link, stream, lockID});
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_NOT_STORED != this._itemLinkState) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("State has already been set: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStatePersistentlyLocked");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            ListStatistics stats = this.getParentStatistics();
            stats.incrementLocked(this._inMemoryItemSize);
            this._lockID = lockID;
            this._itemLinkState = ItemLinkState.STATE_PERSISTENTLY_LOCKED;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStatePersistentlyLocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _restoreStateLocked(AbstractItemLink link, LinkOwner stream, long lockID) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_restoreStateLocked", (Object)new Object[]{link, stream, lockID});
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_NOT_STORED != this._itemLinkState) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("State has already been set: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateLocked");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            ListStatistics stats = this.getParentStatistics();
            stats.incrementLocked(this._inMemoryItemSize);
            this._lockID = lockID;
            this._itemLinkState = ItemLinkState.STATE_LOCKED;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateLocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _restoreStateRemovingNoLock(AbstractItemLink link, LinkOwner stream, PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_restoreStateRemovingNoLock", (Object)new Object[]{link, stream, transaction});
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_NOT_STORED != this._itemLinkState) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("State has already been set: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateRemovingNoLock");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            ListStatistics stats = this.getParentStatistics();
            stats.incrementRemoving(this._inMemoryItemSize);
            this._transactionId = transaction.getPersistentTranId();
            this._itemLinkState = ItemLinkState.STATE_REMOVING_WITHOUT_LOCK;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateRemovingNoLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _restoreStateRemovingPersistentlyLocked(AbstractItemLink link, LinkOwner stream, long lockID, PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_restoreStateRemovingPersistentlyLocked", (Object)new Object[]{link, stream, lockID, transaction});
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_NOT_STORED != this._itemLinkState) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("State has already been set: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateRemovingPersistentlyLocked");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            ListStatistics stats = this.getParentStatistics();
            stats.incrementRemoving(this._inMemoryItemSize);
            this._lockID = lockID;
            this._transactionId = transaction.getPersistentTranId();
            this._itemLinkState = ItemLinkState.STATE_REMOVING_PERSISTENTLY_LOCKED;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_restoreStateRemovingPersistentlyLocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortAdd(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abortAdd", (Object)transaction);
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            MessageStoreImpl msi;
            if (this._itemLinkState == ItemLinkState.STATE_ADDING_LOCKED || this._itemLinkState == ItemLinkState.STATE_ADDING_UNLOCKED) {
                this._assertCorrectTransaction(transaction);
                msi = this.getMessageStoreImpl();
                Expirer expirer = msi._getExpirer();
                long expiryTime = this.getTuple().getExpiryTime();
                if (null != expirer && 0L != expiryTime) {
                    expirer.removeExpirable(this);
                }
                DeliveryDelayManager deliveryDelayManager = msi._getDeliveryDelayManager();
                long deliveryDelayTime = this.getTuple().getDeliveryDelayTime();
                if (null != deliveryDelayManager && 0L != deliveryDelayTime) {
                    deliveryDelayManager.removeDeliveryDelayable(this);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortAdd");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            ListStatistics stats = this.getParentStatistics();
            stats.decrementAdding(this._inMemoryItemSize);
            this._lockID = -2L;
            this._transactionId = null;
            this._itemLinkState = ItemLinkState.STATE_NOT_STORED;
            msi.unregister(this);
            this.unlink();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortAdd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abortPersistLock(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abortPersistLock", (Object)transaction);
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_PERSISTING_LOCK != this._itemLinkState) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortPersistLock");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            this._assertCorrectTransaction(transaction);
            this._itemLinkState = ItemLinkState.STATE_LOCKED;
            this._transactionId = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortPersistLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abortPersistUnlock(PersistentTransaction transaction) throws SevereMessageStoreException {
        AbstractItem item;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abortPersistUnlock", (Object)transaction);
        }
        boolean linkHasBecomeReleasable = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_UNLOCKING_PERSISTENTLY_LOCKED == this._itemLinkState) {
                this._assertCorrectTransaction(transaction);
                item = this._getAndAssertItem();
                int strategy = this._tuple.getStorageStrategy();
                if (1 != strategy && 2 != strategy) {
                    linkHasBecomeReleasable = this._declareDiscardable();
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortPersistUnlock");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            this._itemLinkState = ItemLinkState.STATE_PERSISTENTLY_LOCKED;
            this._transactionId = null;
        }
        if (linkHasBecomeReleasable) {
            this._declareReleasable(item);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortPersistUnlock");
        }
    }

    public final void persistRedeliveredCount(int redeliveredCount) throws SevereMessageStoreException {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistRedeliveredCount");
            }
            PersistentTransaction msTran = (PersistentTransaction)this.getMessageStore().getTransactionFactory().createAutoCommitTransaction();
            Persistable perTuple = this.getTuple();
            perTuple.setRedeliveredCount(redeliveredCount);
            PersistRedeliveredCount persistTask = new PersistRedeliveredCount(this);
            try {
                msTran.addWork(persistTask);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink.persistRedeliveredCount", (String)"1:1198:1.241", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught persisting redelivery count!", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persistRedeliveredCount");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortRemove(PersistentTransaction transaction) throws SevereMessageStoreException {
        AbstractItem item;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abortRemove", (Object)transaction);
        }
        boolean hasBecomeAvailable = false;
        boolean linkHasBecomeReleasable = false;
        ListStatistics stats = this.getParentStatistics();
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("ItemLinkState=" + this._itemLinkState));
            }
            this._assertCorrectTransaction(transaction);
            item = this._getAndAssertItem();
            ++this._backoutCount;
            if (this._itemLinkState == ItemLinkState.STATE_REMOVING_EXPIRING || this._itemLinkState == ItemLinkState.STATE_REMOVING_WITHOUT_LOCK) {
                ListStatistics listStatistics = stats;
                synchronized (listStatistics) {
                    stats.decrementRemoving();
                    stats.incrementAvailable();
                }
                linkHasBecomeReleasable = this._declareDiscardable();
                this._itemLinkState = ItemLinkState.STATE_AVAILABLE;
                hasBecomeAvailable = true;
            } else if (this._itemLinkState == ItemLinkState.STATE_REMOVING_LOCKED) {
                ListStatistics listStatistics = stats;
                synchronized (listStatistics) {
                    stats.decrementRemoving();
                    stats.incrementLocked();
                }
                this._itemLinkState = ItemLinkState.STATE_LOCKED;
            } else if (this._itemLinkState == ItemLinkState.STATE_REMOVING_PERSISTENTLY_LOCKED) {
                ListStatistics listStatistics = stats;
                synchronized (listStatistics) {
                    stats.decrementRemoving();
                    stats.incrementLocked();
                }
                int strategy = this._tuple.getStorageStrategy();
                if (1 != strategy && 2 != strategy) {
                    linkHasBecomeReleasable = this._declareDiscardable();
                }
                this._itemLinkState = ItemLinkState.STATE_PERSISTENTLY_LOCKED;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortRemove");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            this._transactionId = null;
        }
        if (hasBecomeAvailable && null != this._owningStreamLink) {
            this._owningStreamLink.linkAvailable(this);
        }
        if (linkHasBecomeReleasable) {
            this._declareReleasable(item);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortRemove");
        }
    }

    public final void abortPersistRedeliveredCount(PersistentTransaction transaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abortUpdate(PersistentTransaction transaction) throws SevereMessageStoreException {
        AbstractItem item;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abortUpdate", (Object)transaction);
        }
        boolean linkHasBecomeReleasable = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_UPDATING_DATA == this._itemLinkState) {
                ListStatistics stats;
                this._assertCorrectTransaction(transaction);
                item = this._getAndAssertItem();
                ListStatistics listStatistics = stats = this.getParentStatistics();
                synchronized (listStatistics) {
                    stats.decrementUpdating();
                    stats.incrementAvailable();
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortUpdate");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            linkHasBecomeReleasable = this._declareDiscardable();
            this._itemLinkState = ItemLinkState.STATE_AVAILABLE;
            this._transactionId = null;
        }
        if (linkHasBecomeReleasable) {
            this._declareReleasable(item);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortUpdate");
        }
    }

    public SevereMessageStoreException assertCanDelete(PersistentTransaction transaction) {
        return null;
    }

    public final void clearSoftReferenceToItem() {
        SoftReference ref = this._softReferenceToItem;
        if (ref != null) {
            ref.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cmdAdd(LinkOwner stream, long lockID, PersistentTransaction transaction) throws StreamIsFull, ProtocolException, TransactionException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdAdd", (Object)new Object[]{"Item Link:   " + this, "Stream Link: " + stream, this.formatLockId(lockID), "Transaction: " + transaction});
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_NOT_STORED == this._itemLinkState) {
                ListStatistics stats = this.getParentStatistics();
                stream._assertCanAddChild(transaction, stats);
                stats.incrementAdding(this._inMemoryItemSize);
                this._lockID = lockID;
                this._transactionId = transaction.getPersistentTranId();
                this._itemLinkState = -2L == lockID ? ItemLinkState.STATE_ADDING_UNLOCKED : ItemLinkState.STATE_ADDING_LOCKED;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdAdd");
                }
                throw new StateException(this._itemLinkState.toString());
            }
        }
        AddTask task = new AddTask(this);
        transaction.addWork(task);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdAdd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cmdLock(long lockID) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdLock", (Object)new Object[]{"Item Link:   " + this, "Stream Link: " + this._owningStreamLink, this.formatLockId(lockID)});
        }
        boolean hasBecomeNotReleasable = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_AVAILABLE == this._itemLinkState) {
                ListStatistics stats;
                ListStatistics listStatistics = stats = this.getParentStatistics();
                synchronized (listStatistics) {
                    stats.incrementLocked();
                    stats.decrementAvailable();
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdLock");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            hasBecomeNotReleasable = this._declareNotDiscardable(this._getItemNoRestore());
            this._lockID = lockID;
            this._itemLinkState = ItemLinkState.STATE_LOCKED;
        }
        if (hasBecomeNotReleasable) {
            this._declareNotReleasable();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cmdPersistLock(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdPersistLock", (Object)new Object[]{"Item Link:   " + this, "Stream Link: " + this._owningStreamLink, "Transaction: " + transaction});
        }
        if (null != transaction) {
            boolean hasBecomeNonReleasable = false;
            AbstractItemLink abstractItemLink = this;
            synchronized (abstractItemLink) {
                if (ItemLinkState.STATE_LOCKED != this._itemLinkState) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdPersistLock");
                    }
                    throw new StateException(this._itemLinkState.toString());
                }
                this._transactionId = transaction.getPersistentTranId();
                hasBecomeNonReleasable = this._declareNotDiscardable(this._getAndAssertItem());
                this._itemLinkState = ItemLinkState.STATE_PERSISTING_LOCK;
            }
            if (hasBecomeNonReleasable) {
                this._declareNotReleasable();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdPersistLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cmdRemove(long lockId, Transaction transaction) throws ProtocolException, TransactionException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdRemove", (Object)new Object[]{"Item Link:   " + this, "Stream Link: " + this._owningStreamLink, this.formatLockId(lockId), "Transaction: " + transaction});
        }
        boolean hasBecomeNotReleasable = false;
        boolean requireStateException = false;
        AbstractRemoveTask task = null;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("ItemLinkState=" + this._itemLinkState));
            }
            ListStatistics stats = this.getParentStatistics();
            if (this._itemLinkState == ItemLinkState.STATE_AVAILABLE) {
                if (-2L != lockId) {
                    throw new LockIdMismatch(-2L, lockId);
                }
                hasBecomeNotReleasable = this._declareNotDiscardable(this._getItemNoRestore());
                ListStatistics listStatistics = stats;
                synchronized (listStatistics) {
                    stats.decrementAvailable();
                    stats.incrementRemoving();
                }
                this._transactionId = transaction.getPersistentTranId();
                this._itemLinkState = ItemLinkState.STATE_REMOVING_WITHOUT_LOCK;
                task = new RemoveTask(this);
            } else if (this._itemLinkState == ItemLinkState.STATE_LOCKED) {
                if (this._lockID != lockId) {
                    if (this._lockID == -56789L) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Absorbing the LockIdMismatch exception since Item is locked using LockID=" + this._lockID));
                        }
                    } else {
                        throw new LockIdMismatch(this._lockID, lockId);
                    }
                }
                ListStatistics listStatistics = stats;
                synchronized (listStatistics) {
                    stats.decrementLocked();
                    stats.incrementRemoving();
                }
                this._transactionId = transaction.getPersistentTranId();
                this._itemLinkState = ItemLinkState.STATE_REMOVING_LOCKED;
                task = new RemoveLockedTask(this);
            } else if (this._itemLinkState == ItemLinkState.STATE_PERSISTENTLY_LOCKED) {
                if (this._lockID != lockId) {
                    throw new LockIdMismatch(this._lockID, lockId);
                }
                hasBecomeNotReleasable = this._declareNotDiscardable(this._getItemNoRestore());
                ListStatistics listStatistics = stats;
                synchronized (listStatistics) {
                    stats.decrementLocked();
                    stats.incrementRemoving();
                }
                this._transactionId = transaction.getPersistentTranId();
                this._itemLinkState = ItemLinkState.STATE_REMOVING_PERSISTENTLY_LOCKED;
                task = new RemoveLockedTask(this);
            } else if (this._itemLinkState == ItemLinkState.STATE_NOT_STORED) {
                if (1 == this._tuple.getStorageStrategy()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"STORE_NEVER item is not in store - no exception thrown during remove");
                    }
                } else {
                    requireStateException = true;
                }
            } else {
                requireStateException = true;
            }
            if (requireStateException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdRemove");
                }
                throw new StateException(this._itemLinkState.toString());
            }
        }
        if (hasBecomeNotReleasable) {
            this._declareNotReleasable();
        }
        if (null != task) {
            ((PersistentTransaction)transaction).addWork(task);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cmdRemoveExpiring(long lockId, PersistentTransaction transaction) throws ProtocolException, TransactionException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdRemoveExpiring", (Object)new Object[]{"Item Link:   " + this, "Stream Link: " + this._owningStreamLink, this.formatLockId(lockId), "Transaction: " + transaction});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("expiring item " + this._tuple.getUniqueId()));
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_LOCKED_FOR_EXPIRY == this._itemLinkState) {
                ListStatistics stats;
                if (this._lockID != lockId) {
                    throw new LockIdMismatch(this._lockID, lockId);
                }
                ListStatistics listStatistics = stats = this.getParentStatistics();
                synchronized (listStatistics) {
                    stats.decrementExpiring();
                    stats.incrementRemoving();
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdRemoveExpiring");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            this._transactionId = transaction.getPersistentTranId();
            this._itemLinkState = ItemLinkState.STATE_REMOVING_EXPIRING;
        }
        RemoveLockedTask task = new RemoveLockedTask(this);
        transaction.addWork(task);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdRemoveExpiring");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cmdRemoveExpiryLock() throws SevereMessageStoreException {
        AbstractItem item;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdRemoveExpiryLock");
        }
        boolean linkHasBecomeReleasable = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_LOCKED_FOR_EXPIRY == this._itemLinkState) {
                ListStatistics stats;
                item = this._getAndAssertItem();
                ListStatistics listStatistics = stats = this.getParentStatistics();
                synchronized (listStatistics) {
                    stats.decrementExpiring();
                    stats.incrementAvailable();
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdRemoveExpiryLock");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            this._lockID = -2L;
            this._transactionId = null;
            linkHasBecomeReleasable = this._declareDiscardable();
            this._itemLinkState = ItemLinkState.STATE_AVAILABLE;
        }
        if (linkHasBecomeReleasable) {
            this._declareReleasable(item);
        }
        if (null != this._owningStreamLink) {
            this._owningStreamLink.linkAvailable(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdRemoveExpiryLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final AbstractItem cmdRemoveIfMatches(Filter filter, PersistentTransaction transaction) throws SevereMessageStoreException {
        AbstractItem foundItem;
        block18: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdRemoveIfMatches", (Object)new Object[]{"Item Link:   " + this, "Stream Link: " + this._owningStreamLink, "Filter:      " + filter, "Transaction: " + transaction});
            }
            foundItem = null;
            this.isExpired();
            if (this.isAvailable() || this.getLockID() == -56789L && this.isStateLocked()) {
                AbstractItem item = this.getItem();
                if (null == item) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"item does not exist");
                    }
                } else {
                    try {
                        if (null != filter && !filter.filterMatches(item)) break block18;
                        boolean hasBecomeNotReleasable = false;
                        AbstractItemLink abstractItemLink = this;
                        synchronized (abstractItemLink) {
                            if (this.isAvailable() || this._lockID == -56789L && this.isStateLocked()) {
                                ListStatistics stats;
                                ListStatistics listStatistics = stats = this.getParentStatistics();
                                synchronized (listStatistics) {
                                    stats.decrementAvailable();
                                    stats.incrementRemoving();
                                }
                                foundItem = item;
                                hasBecomeNotReleasable = this._declareNotDiscardable(item);
                                this._transactionId = transaction.getPersistentTranId();
                                this._itemLinkState = this._lockID == -56789L ? ItemLinkState.STATE_REMOVING_LOCKED : ItemLinkState.STATE_REMOVING_WITHOUT_LOCK;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"matched");
                            }
                        }
                        if (null != foundItem) {
                            if (hasBecomeNotReleasable) {
                                this._declareNotReleasable();
                            }
                            RemoveTask task = new RemoveTask(this);
                            transaction.addWork(task);
                        }
                    }
                    catch (MessageStoreException messageStoreException) {
                        // empty catch block
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeIfMatches", foundItem);
        }
        return foundItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cmdRequestUpdate(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cmdRequestUpdate", (Object)new Object[]{"Item Link:   " + this, "Stream Link: " + this._owningStreamLink, "Transaction: " + transaction});
        }
        boolean hasBecomeNotReleasable = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_AVAILABLE == this._itemLinkState) {
                ListStatistics stats;
                ListStatistics listStatistics = stats = this.getParentStatistics();
                synchronized (listStatistics) {
                    stats.decrementAvailable();
                    stats.incrementUpdating();
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdRequestUpdate");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            this._transactionId = transaction.getPersistentTranId();
            hasBecomeNotReleasable = this._declareNotDiscardable(this._getItemNoRestore());
            this._itemLinkState = ItemLinkState.STATE_UPDATING_DATA;
        }
        if (hasBecomeNotReleasable) {
            this._declareNotReleasable();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cmdRequestUpdate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitAdd(PersistentTransaction transaction) throws SevereMessageStoreException {
        AbstractItem item;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitAdd", (Object)transaction);
        }
        ListStatistics stats = this.getParentStatistics();
        boolean hasBecomeAvailable = false;
        boolean linkHasBecomeReleasable = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("ItemLinkState=" + this._itemLinkState));
            }
            if (this._itemLinkState == ItemLinkState.STATE_ADDING_LOCKED) {
                this._assertCorrectTransaction(transaction);
                item = this._getAndAssertItem();
                ListStatistics listStatistics = stats;
                synchronized (listStatistics) {
                    stats.decrementAdding();
                    stats.incrementLocked();
                }
                this.registerWithExpirer();
                this.registerWithDeliveryDelayManager();
                if (this._owningStreamLink != null) {
                    this._owningStreamLink.checkSpillLimits();
                }
                if (this._lockID == -56789L) {
                    linkHasBecomeReleasable = this._declareDiscardable();
                }
                this._itemLinkState = ItemLinkState.STATE_LOCKED;
            } else if (this._itemLinkState == ItemLinkState.STATE_ADDING_UNLOCKED) {
                this._assertCorrectTransaction(transaction);
                item = this._getAndAssertItem();
                ListStatistics listStatistics = stats;
                synchronized (listStatistics) {
                    stats.decrementAdding();
                    stats.incrementAvailable();
                }
                this.registerWithExpirer();
                if (this._owningStreamLink != null) {
                    this._owningStreamLink.checkSpillLimits();
                }
                hasBecomeAvailable = true;
                linkHasBecomeReleasable = this._declareDiscardable();
                this._itemLinkState = ItemLinkState.STATE_AVAILABLE;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitAdd");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            this._transactionId = null;
        }
        if (hasBecomeAvailable && this._owningStreamLink != null) {
            this._owningStreamLink.linkAvailable(this);
        }
        if (linkHasBecomeReleasable) {
            this._declareReleasable(item);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitAdd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitPersistLock(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitPersistLock", (Object)transaction);
        }
        AbstractItem item = null;
        boolean hasBecomePersistentlyLocked = false;
        boolean linkHasBecomeReleasable = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_PERSISTING_LOCK == this._itemLinkState) {
                this._assertCorrectTransaction(transaction);
                item = this._getAndAssertItem();
                int strategy = this._tuple.getStorageStrategy();
                if (1 != strategy && 2 != strategy) {
                    linkHasBecomeReleasable = this._declareDiscardable();
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitPersistLock");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            this._itemLinkState = ItemLinkState.STATE_PERSISTENTLY_LOCKED;
            hasBecomePersistentlyLocked = true;
            this._transactionId = null;
        }
        if (hasBecomePersistentlyLocked && linkHasBecomeReleasable) {
            this._declareReleasable(item);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitPersistLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitPersistUnlock(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitPersistUnlock", (Object)transaction);
        }
        AbstractItem item = null;
        boolean hasBecomeAvailable = false;
        boolean linkHasBecomeReleasable = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_UNLOCKING_PERSISTENTLY_LOCKED == this._itemLinkState) {
                ListStatistics stats;
                this._assertCorrectTransaction(transaction);
                item = this.getItem();
                ListStatistics listStatistics = stats = this.getParentStatistics();
                synchronized (listStatistics) {
                    stats.decrementLocked();
                    stats.incrementAvailable();
                }
                this._lockID = -2L;
                ++this._unlockCount;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitPersistUnlock");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            linkHasBecomeReleasable = this._declareDiscardable();
            this._itemLinkState = ItemLinkState.STATE_AVAILABLE;
            hasBecomeAvailable = true;
            this._transactionId = null;
        }
        if (linkHasBecomeReleasable) {
            this._declareReleasable(item);
        }
        if (hasBecomeAvailable && this._owningStreamLink != null) {
            this._owningStreamLink.linkAvailable(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitPersistUnlock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitRemove(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitRemove", (Object)transaction);
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            MessageStoreImpl msi;
            if (this._itemLinkState == ItemLinkState.STATE_REMOVING_EXPIRING || this._itemLinkState == ItemLinkState.STATE_REMOVING_LOCKED || this._itemLinkState == ItemLinkState.STATE_REMOVING_PERSISTENTLY_LOCKED || this._itemLinkState == ItemLinkState.STATE_REMOVING_WITHOUT_LOCK) {
                this._assertCorrectTransaction(transaction);
                if (this._owningStreamLink != null) {
                    this._owningStreamLink.checkSpillLimits();
                }
                ListStatistics stats = this.getParentStatistics();
                stats.decrementRemoving(this._inMemoryItemSize);
                msi = this.getMessageStoreImpl();
                if (ItemLinkState.STATE_REMOVING_EXPIRING != this._itemLinkState) {
                    Expirer expirer = msi._getExpirer();
                    long expiryTime = this.getTuple().getExpiryTime();
                    if (null != expirer && 0L != expiryTime) {
                        expirer.removeExpirable(this);
                    }
                }
                DeliveryDelayManager deliveryDelayManager = msi._getDeliveryDelayManager();
                long deliveryDelayTime = this.getTuple().getDeliveryDelayTime();
                if (null != deliveryDelayManager && 0L != deliveryDelayTime) {
                    deliveryDelayManager.removeDeliveryDelayable(this);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitRemove");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            this._lockID = -2L;
            this._itemLinkState = ItemLinkState.STATE_NOT_STORED;
            msi.unregister(this);
            this.unlink();
            this._transactionId = null;
        }
        this.internalCommitRemove(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitUpdate(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitUpdate", (Object)transaction);
        }
        AbstractItem item = null;
        boolean linkHasBecomeReleasable = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (ItemLinkState.STATE_UPDATING_DATA == this._itemLinkState) {
                ListStatistics stats;
                this._assertCorrectTransaction(transaction);
                item = this._getAndAssertItem();
                ListStatistics listStatistics = stats = this.getParentStatistics();
                synchronized (listStatistics) {
                    stats.decrementUpdating();
                    stats.incrementAvailable();
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitUpdate");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            linkHasBecomeReleasable = this._declareDiscardable();
            this._itemLinkState = ItemLinkState.STATE_AVAILABLE;
            this._transactionId = null;
        }
        if (linkHasBecomeReleasable) {
            this._declareReleasable(item);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitUpdate");
        }
    }

    @Override
    public synchronized boolean expirableExpire(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"expirableExpire", (Object)("tran=" + transaction));
        }
        boolean removeFromExpiryList = false;
        boolean isExpired = this.isExpired();
        if (isExpired) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("item is expiring " + this.getID()));
            }
            try {
                AbstractItem item;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("expiring item " + this.getID()));
                }
                this.cmdRemoveExpiring(123456L, transaction);
                MessageStoreImpl msi = this.getMessageStoreImpl();
                DeliveryDelayManager deliveryDelayManager = msi._getDeliveryDelayManager();
                long deliveryDelayTime = this.getTuple().getDeliveryDelayTime();
                if (null != deliveryDelayManager && 0L != deliveryDelayTime) {
                    deliveryDelayManager.removeDeliveryDelayable(this);
                }
                removeFromExpiryList = true;
                boolean canExpireSilently = this.getTuple().getCanExpireSilently();
                if (!canExpireSilently && null != (item = this.getItem())) {
                    item.eventExpiryNotification((Transaction)transaction);
                }
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink.expirableExpire", (String)"1:2130:1.241", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("failed to expire item " + this.getID() + " because: " + (Object)((Object)e)));
                }
                this.cmdRemoveExpiryLock();
            }
        } else if (!this.isInStore()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"item already removed from store");
            }
            removeFromExpiryList = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"expirableExpire", (Object)removeFromExpiryList);
        }
        return removeFromExpiryList;
    }

    @Override
    public final long expirableGetExpiryTime() {
        long expiryTime = this.getTuple().getExpiryTime();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"expirableGetExpiryTime");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"expirableGetExpiryTime", (Object)expiryTime);
        }
        return expiryTime;
    }

    @Override
    public final long expirableGetID() {
        long l = this.getID();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"expirableGetID");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"expirableGetID", (Object)l);
        }
        return l;
    }

    @Override
    public final boolean expirableIsInStore() {
        return this.isInStore();
    }

    @Override
    public boolean deliveryDelayableUnlock(PersistentTransaction tran, long lockID) throws MessageStoreException {
        boolean removeFromDeliveryDelayIndex;
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"deliveryDelayableUnlock", (Object)("tran=" + tran + "lockID=" + lockID));
            }
            removeFromDeliveryDelayIndex = false;
            try {
                if (!this.isExpired() && this.isInStore() && this.isStateLocked()) {
                    this.unlock(lockID, tran, false);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Did not unlock item " + this.getID() + "whoes item link state is :" + this._itemLinkState + " because: eitherits expired or its not in store or the item link state is not ItemLinkState.STATE_LOCKED"));
                }
                removeFromDeliveryDelayIndex = true;
            }
            catch (MessageStoreException e) {
                removeFromDeliveryDelayIndex = false;
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink.deliveryDelayableUnlock", (String)"1:231:1.145", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("failed to unlock item " + this.getID() + " because: " + (Object)((Object)e)));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deliveryDelayableUnlock", (Object)removeFromDeliveryDelayIndex);
        }
        return removeFromDeliveryDelayIndex;
    }

    @Override
    public boolean handleInvalidDeliveryDelayable(MessageStoreConstants.MaximumAllowedDeliveryDelayAction action) throws MessageStoreException, SIException {
        String methodName = "handleInvalidDeliveryDelayable";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"handleInvalidDeliveryDelayable", (Object)("action=" + action));
        }
        boolean unlocked = false;
        if (this._tuple.getDeliveryDelayTimeIsSuspect()) {
            try {
                AbstractItem abstractItem = this.getItem();
                if (abstractItem != null) {
                    abstractItem.handleInvalidDeliveryDelayable(action);
                    switch (action) {
                        case unlock: 
                        case exception: {
                            ExternalLocalTransaction transaction = this.getMessageStore().getTransactionFactory().createLocalTransaction();
                            unlocked = this.deliveryDelayableUnlock((PersistentTransaction)transaction, -56789L);
                            transaction.commit();
                            break;
                        }
                    }
                }
            }
            catch (SIException | MessageStoreException exception) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"handleInvalidDeliveryDelayable", (Object)exception);
                throw exception;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"handleInvalidDeliveryDelayable", (Object)unlocked);
        }
        return unlocked;
    }

    private final synchronized boolean isStateLocked() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isStateLocked");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isStateLocked", (Object)this._itemLinkState);
        }
        return this._itemLinkState == ItemLinkState.STATE_LOCKED;
    }

    @Override
    public long deliveryDelayableGetDeliveryDelayTime() {
        long deliveryDelayTime = this.getTuple().getDeliveryDelayTime();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deliveryDelayableGetDeliveryDelayTime");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deliveryDelayableGetDeliveryDelayTime", (Object)deliveryDelayTime);
        }
        return deliveryDelayTime;
    }

    @Override
    public long deliveryDelayableGetID() {
        long l = this.getID();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deliveryDelayableGetID");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deliveryDelayableGetID", (Object)l);
        }
        return l;
    }

    @Override
    public boolean deliveryDelayableIsInStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deliveryDelayableIsInStore");
        }
        boolean isInStore = this.isInStore();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deliveryDelayableIsInStore", (Object)isInStore);
        }
        return isInStore;
    }

    public final String formatLockId(Long lockID) {
        String retval = lockID == -2L ? "Lock ID:     NO_LOCK_ID" : (lockID == 123456L ? "Lock ID:     EXPIRY_LOCK_ID" : "Lock ID:     " + lockID);
        return retval;
    }

    @Override
    public final long getID() {
        return this.getTuple().getUniqueId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AbstractItem getItem() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getItem");
        }
        AbstractItem item = this._getItemNoRestore();
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (this.isExpired()) {
                item = null;
            } else if (null == item) {
                try {
                    item = this._restoreItem();
                }
                catch (SevereMessageStoreException e) {
                    try {
                        StringWriter stringWriter = new StringWriter();
                        FormattedWriter writer = new FormattedWriter((Writer)stringWriter);
                        this.xmlWriteOn(writer);
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink.getItem", (String)"1:2252:1.241", (Object)this, (Object[])new Object[]{stringWriter});
                        writer.close();
                    }
                    catch (IOException ioe) {
                        FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink.getItem", (String)"1:2257:1.241", (Object)this);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"RuntimeException caught restoring Item!", (Object)((Object)e));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"getItem");
                    }
                    throw e;
                }
                catch (RuntimeException re) {
                    try {
                        StringWriter stringWriter = new StringWriter();
                        FormattedWriter writer = new FormattedWriter((Writer)stringWriter);
                        this.xmlWriteOn(writer);
                        FFDCFilter.processException((Throwable)re, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink.getItem", (String)"1:2274:1.241", (Object)this, (Object[])new Object[]{stringWriter});
                        writer.close();
                    }
                    catch (IOException ioe) {
                        FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink.getItem", (String)"1:2279:1.241", (Object)this);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"RuntimeException caught restoring Item!", (Object)re);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"getItem");
                    }
                    throw re;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getItem", (Object)item);
            }
        }
        return item;
    }

    public final synchronized long getLockID() {
        return this._lockID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<DataSlice> getMemberData() throws PersistentDataEncodingException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMemberData");
        }
        List dataSlices = null;
        try {
            AbstractItem item = this.getItem();
            if (null != item) {
                dataSlices = item.getPersistentData();
            }
        }
        catch (PersistentDataEncodingException pdee) {
            FFDCFilter.processException((Throwable)pdee, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink.getMemberData", (String)"1:2324:1.241", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught encoding member data!", (Object)((Object)pdee));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMemberData");
            }
            AbstractItemLink abstractItemLink = this;
            synchronized (abstractItemLink) {
                this._persistentDataEncodingFailed = true;
            }
            throw pdee;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMemberData", (Object)("return=" + dataSlices));
        }
        return dataSlices;
    }

    public final MessageStore getMessageStore() {
        return this.getMessageStoreImpl();
    }

    public MessageStoreImpl getMessageStoreImpl() {
        return this._owningStreamLink.getMessageStoreImpl();
    }

    public final AbstractItemLink getNextMappedLink() {
        return this._nextMappedLink;
    }

    public final LinkOwner getOwningStreamLink() {
        return this._owningStreamLink;
    }

    ListStatistics getParentStatistics() {
        return this._owningStreamLink.getListStatistics();
    }

    public final int getPriority() {
        int priority = this.getTuple().getPriority();
        return priority;
    }

    public final int getPersistedRedeliveredCount() {
        return this._persistedRedeliveredCount;
    }

    @Override
    public long getSequence() {
        long sequence = this.getTuple().getSequence();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSequence");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSequence", (Object)sequence);
        }
        return sequence;
    }

    @Override
    public final int getInMemoryItemSize() {
        if (this._inMemoryItemSize == -1) {
            this.setInMemoryItemSize(this._getItemNoRestore());
        }
        return this._inMemoryItemSize;
    }

    private final void setInMemoryItemSize(AbstractItem item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setInMemoryItemSize", (Object)item);
        }
        this._inMemoryItemSize = item != null ? item.getInMemoryDataSize() : this._tuple.getPersistentSize() * 4;
        this._tuple.setInMemoryByteSize(this._inMemoryItemSize);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setInMemoryItemSize", (Object)this._inMemoryItemSize);
        }
    }

    public final ItemLinkState getState() {
        return this._itemLinkState;
    }

    public final PersistentTranId getTransactionId() {
        return this._transactionId;
    }

    public final Persistable getTuple() {
        return this._tuple;
    }

    public final int guessBackoutCount() {
        return this._backoutCount;
    }

    public final int guessUnlockCount() {
        return this._unlockCount;
    }

    protected final void initializeSequenceNumber() {
        this.getTuple().setSequence(this._owningStreamLink.nextSequence());
    }

    boolean internalCanExpire() {
        return this.getMessageStoreImpl().itemsCanExpire();
    }

    public void internalCommitAdd() {
    }

    public void internalCommitRemove(PersistentTransaction transaction) throws SevereMessageStoreException {
    }

    public final synchronized boolean isAdding() {
        return ItemLinkState.STATE_ADDING_LOCKED == this._itemLinkState || ItemLinkState.STATE_ADDING_UNLOCKED == this._itemLinkState;
    }

    public final synchronized boolean isAvailable() {
        return ItemLinkState.STATE_AVAILABLE == this._itemLinkState;
    }

    public final synchronized boolean isCached() {
        return null != this._itemCache;
    }

    public final boolean isCacheManagedReferenceToItem() {
        return this._itemCacheManagedReference != NULL_CACHE_REF;
    }

    public final synchronized boolean isDiscardableIfPersistentRepresentationIsStable() {
        return this._itemIsDiscardableIfPersistentRepresentationStable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isExpired() throws SevereMessageStoreException {
        long expiryTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isExpired");
        }
        if (this.isAvailable() && this.internalCanExpire() && (expiryTime = this._tuple.getExpiryTime()) != 0L && expiryTime <= System.currentTimeMillis()) {
            boolean hasBecomeNonReleasable = false;
            AbstractItemLink abstractItemLink = this;
            synchronized (abstractItemLink) {
                if (ItemLinkState.STATE_AVAILABLE == this._itemLinkState) {
                    ListStatistics stats;
                    AbstractItem item = this._getItemNoRestore();
                    if (null == item) {
                        item = this._restoreItem();
                    }
                    ListStatistics listStatistics = stats = this.getParentStatistics();
                    synchronized (listStatistics) {
                        stats.incrementExpiring();
                        stats.decrementAvailable();
                    }
                    this._lockID = 123456L;
                    hasBecomeNonReleasable = this._declareNotDiscardable(item);
                    this._itemLinkState = ItemLinkState.STATE_LOCKED_FOR_EXPIRY;
                }
            }
            if (hasBecomeNonReleasable) {
                this._declareNotReleasable();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isExpired", (Object)this.isExpiring());
        }
        return this.isExpiring();
    }

    public final boolean isExpiring() {
        return this.isLockedForExpiry();
    }

    public final synchronized boolean isInStore() {
        return ItemLinkState.STATE_NOT_STORED != this._itemLinkState;
    }

    public boolean isItemStreamLink() {
        return false;
    }

    public final synchronized boolean isLocked() {
        return this._itemLinkState == ItemLinkState.STATE_LOCKED || this._itemLinkState == ItemLinkState.STATE_LOCKED_FOR_EXPIRY || this._itemLinkState == ItemLinkState.STATE_PERSISTENTLY_LOCKED || this._itemLinkState == ItemLinkState.STATE_PERSISTING_LOCK || this._itemLinkState == ItemLinkState.STATE_UNLOCKING_PERSISTENTLY_LOCKED;
    }

    final synchronized boolean isLockedForExpiry() {
        return ItemLinkState.STATE_LOCKED_FOR_EXPIRY == this._itemLinkState;
    }

    public final boolean isPersistentDataImmutable() throws SevereMessageStoreException {
        return this.getItem().isPersistentDataImmutable();
    }

    public final boolean isPersistentDataNeverUpdated() throws SevereMessageStoreException {
        return this.getItem().isPersistentDataNeverUpdated();
    }

    public final synchronized boolean isPersistentlyLocked() {
        return ItemLinkState.STATE_PERSISTENTLY_LOCKED == this._itemLinkState;
    }

    public final boolean isPersistentRepresentationStable() {
        return this._persistentRepresentationIsStable;
    }

    public boolean isReferenceStreamLink() {
        return false;
    }

    public final synchronized boolean isRemoving() {
        return this._itemLinkState == ItemLinkState.STATE_REMOVING_EXPIRING || this._itemLinkState == ItemLinkState.STATE_REMOVING_LOCKED || this._itemLinkState == ItemLinkState.STATE_REMOVING_PERSISTENTLY_LOCKED || this._itemLinkState == ItemLinkState.STATE_REMOVING_WITHOUT_LOCK;
    }

    final synchronized boolean isRemovingLocked() {
        return ItemLinkState.STATE_REMOVING_LOCKED == this._itemLinkState;
    }

    public final boolean isStorageManaged() {
        return this._isStorageManaged;
    }

    public final synchronized boolean isStrongReferenceToItem() {
        return this._strongReferenceToItem != NULL_STRONG_REF;
    }

    public boolean isStoreNever() {
        int storageStratey = this._tuple.getStorageStrategy();
        boolean isStoreNever = storageStratey == 1;
        return isStoreNever;
    }

    public final synchronized boolean isUpdating() {
        return ItemLinkState.STATE_UPDATING_DATA == this._itemLinkState;
    }

    @Override
    public final Indirection itemCacheGetNextLink() {
        return this._itemCacheLinkNext;
    }

    @Override
    public final Indirection itemCacheGetPrevioustLink() {
        return this._itemCacheLinkPrevious;
    }

    @Override
    public final void itemCacheSetNextLink(Indirection _linkNext) {
        this._itemCacheLinkNext = _linkNext;
    }

    @Override
    public final void itemCacheSetPreviousLink(Indirection _linkPrevious) {
        this._itemCacheLinkPrevious = _linkPrevious;
    }

    @Override
    public void itemCacheSetManagedReference(AbstractItem item) {
        this._itemCacheManagedReference = item != null ? item : NULL_CACHE_REF;
    }

    protected void itemHasBeenRestored(AbstractItem item) {
    }

    public final void lateInitialize() throws SevereMessageStoreException {
        int streamStorageStrategy;
        AbstractItem item;
        int priority;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"lateInitialize");
        }
        if ((priority = (item = this.getItem()).getPriority()) > 9 || priority < 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"lateInitialize");
            }
            throw new SevereMessageStoreException("invalid priority(" + priority + ") supplied");
        }
        this.getTuple().setPriority(priority);
        this.getTuple().setCanExpireSilently(item.canExpireSilently());
        long expiryTime = 0L;
        long expiryDelay = item.getMaximumTimeInStore();
        if (expiryDelay != -2L) {
            long expiryStartTime = item.getExpiryStartTime();
            if (expiryStartTime == 0L) {
                expiryStartTime = System.currentTimeMillis();
            }
            expiryTime = expiryStartTime + expiryDelay;
        }
        this.getTuple().setExpiryTime(expiryTime);
        long deliveryDelayTime = 0L;
        long deliveryDelay = item.getDeliveryDelay();
        if (deliveryDelay != 0L) {
            long deliveryDelayStartTime = item.getExpiryStartTime();
            if (deliveryDelayStartTime == 0L) {
                deliveryDelayStartTime = DeliveryDelayManager.timeNow();
            }
            deliveryDelayTime = deliveryDelayStartTime + deliveryDelay;
        }
        this.getTuple().setDeliveryDelayTime(deliveryDelayTime);
        int newStorageStrategy = item.getStorageStrategy();
        int oldStorageStrategy = this.getTuple().getStorageStrategy();
        if (oldStorageStrategy != newStorageStrategy) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("StorageStrategy changing from " + oldStorageStrategy + " to " + newStorageStrategy));
            }
            if (1 == oldStorageStrategy || 1 == newStorageStrategy) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"lateInitialize");
                }
                throw new SevereMessageStoreException("Invalid change of storage strategy from " + oldStorageStrategy + " to " + newStorageStrategy);
            }
            this.getTuple().setStorageStrategy(newStorageStrategy);
        }
        if (null != this._owningStreamLink && newStorageStrategy > (streamStorageStrategy = this._owningStreamLink.getTuple().getStorageStrategy())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"lateInitialize");
            }
            throw new InvalidAddOperation("STREAM_STORAGE_MISMATCH_SIMS0500", new Object[]{newStorageStrategy, streamStorageStrategy});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"lateInitialize");
        }
    }

    public final void lock(long lockID) throws SevereMessageStoreException {
        this.cmdLock(lockID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean lockIfMatches(Filter filter, long lockID) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"lockIfMatches", (Object)new Object[]{filter, lockID});
        }
        boolean locked = false;
        boolean matches = false;
        AbstractItem item = this.getItem();
        if (null == item) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"item does not exist");
            }
        } else {
            try {
                if (null == filter || filter.filterMatches(item)) {
                    matches = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean hasBecomeNonReleasable = false;
        if (matches) {
            AbstractItemLink abstractItemLink = this;
            synchronized (abstractItemLink) {
                if (this.isAvailable() && !this.isExpired()) {
                    if (ItemLinkState.STATE_AVAILABLE == this._itemLinkState) {
                        ListStatistics stats;
                        ListStatistics listStatistics = stats = this.getParentStatistics();
                        synchronized (listStatistics) {
                            stats.incrementLocked();
                            stats.decrementAvailable();
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((Object)this, (TraceComponent)tc, (String)"lockIfMatches");
                        }
                        throw new StateException(this._itemLinkState.toString());
                    }
                    this._lockID = lockID;
                    hasBecomeNonReleasable = this._declareNotDiscardable(item);
                    this._itemLinkState = ItemLinkState.STATE_LOCKED;
                    locked = true;
                }
            }
            if (hasBecomeNonReleasable) {
                this._declareNotReleasable();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"lockIfMatches", (Object)locked);
        }
        return locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean lockItemIfAvailable(long lockID) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"lockItemIfAvailable", (Object)lockID);
        }
        boolean locked = false;
        if (-2L == lockID) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"lockItemIfAvailable");
            }
            throw new SevereMessageStoreException("invalid lockID - clashes with internal constant NO_LOCK_ID");
        }
        boolean hasBecomeNonReleasable = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (!this.isExpired() && this.isAvailable()) {
                if (ItemLinkState.STATE_AVAILABLE == this._itemLinkState) {
                    ListStatistics stats;
                    ListStatistics listStatistics = stats = this.getParentStatistics();
                    synchronized (listStatistics) {
                        stats.incrementLocked();
                        stats.decrementAvailable();
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"lockItemIfAvailable");
                    }
                    throw new StateException(this._itemLinkState.toString());
                }
                locked = true;
                this._lockID = lockID;
                hasBecomeNonReleasable = this._declareNotDiscardable(this._getItemNoRestore());
                this._itemLinkState = ItemLinkState.STATE_LOCKED;
            }
        }
        if (hasBecomeNonReleasable) {
            this._declareNotReleasable();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"lockItemIfAvailable", (Object)locked);
        }
        return locked;
    }

    public final AbstractItem matches(Filter filter) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"matches", (Object)filter);
        }
        AbstractItem foundItem = null;
        if (this.getLockID() == -56789L && this.isStateLocked() || this.isAvailable() && !this.isExpired()) {
            AbstractItem item = this.getItem();
            if (null == item) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"item does not exist");
                }
            } else {
                try {
                    if (null == filter || filter.filterMatches(item)) {
                        foundItem = item;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"matches", foundItem);
        }
        return foundItem;
    }

    public final AbstractItem matches(Filter filter, boolean allowUnavailable) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"matches", (Object)new Object[]{filter, allowUnavailable});
        }
        AbstractItem foundItem = null;
        if ((allowUnavailable || this.isAvailable()) && !this.isExpired()) {
            AbstractItem item = this.getItem();
            if (null == item) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"item does not exist");
                }
            } else {
                try {
                    if (null == filter || filter.filterMatches(item)) {
                        foundItem = item;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"matches", foundItem);
        }
        return foundItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void persistentRepresentationIsStable() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistentRepresentationIsStable");
        }
        boolean notifyRequired = false;
        AbstractItem item = null;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (!this._persistentRepresentationIsStable) {
                notifyRequired = this._itemIsDiscardableIfPersistentRepresentationStable;
                if (notifyRequired) {
                    item = this._getItemNoRestore();
                    this._strongReferenceToItem = NULL_STRONG_REF;
                }
                this._persistentRepresentationIsStable = true;
            }
        }
        if (notifyRequired) {
            this._declareReleasable(item);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persistentRepresentationIsStable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void persistentRepresentationIsUnstable() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistentRepresentationIsUnstable");
        }
        boolean notifyRequired = false;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (this._strongReferenceToItem == NULL_STRONG_REF && null != this._softReferenceToItem) {
                this._strongReferenceToItem = (AbstractItem)this._softReferenceToItem.get();
                if (this._strongReferenceToItem == null) {
                    this._strongReferenceToItem = NULL_STRONG_REF;
                }
            }
            if (this._persistentRepresentationIsStable) {
                notifyRequired = this._itemIsDiscardableIfPersistentRepresentationStable;
                this._persistentRepresentationIsStable = false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("stable=false available=" + this._itemIsDiscardableIfPersistentRepresentationStable));
            }
        }
        if (notifyRequired) {
            this._declareNotReleasable();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persistentRepresentationIsUnstable");
        }
    }

    public final void persistLock(Transaction transaction) throws ProtocolException, TransactionException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persistLock", (Object)transaction);
        }
        if (null != transaction) {
            PersistentTransaction mstran = (PersistentTransaction)transaction;
            this.cmdPersistLock(mstran);
            this.getTuple().setLockID(this.getLockID());
            PersistLock task = new PersistLock(this);
            mstran.addWork(task);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persistLock");
        }
    }

    public final void postAbortAdd(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"postAbortAdd", (Object)transaction);
        }
        this.releaseItem();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"postAbortAdd");
        }
    }

    public final void postCommitRemove(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"postCommitRemove", (Object)transaction);
        }
        this.releaseItem();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"postCommitRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void preCommitAdd(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"preCommitAdd", (Object)transaction);
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (this._itemLinkState != ItemLinkState.STATE_ADDING_LOCKED && this._itemLinkState != ItemLinkState.STATE_ADDING_UNLOCKED) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"preCommitAdd");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            this.getItem().eventPrecommitAdd((Transaction)transaction);
            this._assertCorrectTransaction(transaction);
            this._owningStreamLink._assertCanAddChildUnder(transaction);
            this.lateInitialize();
            this.initializeSequenceNumber();
            this._owningStreamLink.append(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"preCommitAdd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void preCommitRemove(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"preCommitRemove", (Object)transaction);
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            SevereMessageStoreException ex = this.assertCanDelete(transaction);
            if (null != ex) {
                throw ex;
            }
            if (this._itemLinkState != ItemLinkState.STATE_REMOVING_EXPIRING && this._itemLinkState != ItemLinkState.STATE_REMOVING_LOCKED && this._itemLinkState != ItemLinkState.STATE_REMOVING_PERSISTENTLY_LOCKED && this._itemLinkState != ItemLinkState.STATE_REMOVING_WITHOUT_LOCK) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"preCommitRemove");
                }
                throw new StateException(this._itemLinkState.toString());
            }
            this._assertCorrectTransaction(transaction);
            this._owningStreamLink._assertCanRemoveChildUnder(transaction);
            this.getItem().eventPrecommitRemove((Transaction)transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"preCommitRemove");
        }
    }

    public final void preCommitUpdate(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"preCommitUpdate", (Object)transaction);
        }
        this.getItem().eventPrecommitUpdate((Transaction)transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"preCommitUpdate");
        }
    }

    public final List<DataSlice> readDataFromPersistence() throws SevereMessageStoreException {
        List<DataSlice> dataSlices;
        PersistentMessageStore pm = this.getMessageStoreImpl().getPersistentMessageStore();
        try {
            dataSlices = pm.readDataOnly(this.getTuple());
        }
        catch (PersistenceException pe) {
            FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink.readDataFromPersistence", (String)"1:3271:1.241", (Object)this);
            throw new SevereMessageStoreException((Throwable)pe);
        }
        return dataSlices;
    }

    public final void registerWithExpirer() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerWithExpirer");
        }
        MessageStoreImpl msi = this.getMessageStoreImpl();
        Expirer expirer = msi._getExpirer();
        long expiryTime = this.getTuple().getExpiryTime();
        if (null != expirer && 0L != expiryTime) {
            expirer.addExpirable(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerWithExpirer");
        }
    }

    public final void registerWithDeliveryDelayManager() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerWithDeliveryDelayManager");
        }
        MessageStoreImpl msi = this.getMessageStoreImpl();
        DeliveryDelayManager deliveryDelayManager = msi._getDeliveryDelayManager();
        long deliveryDelayTime = this.getTuple().getDeliveryDelayTime();
        if (null != deliveryDelayManager && 0L != deliveryDelayTime) {
            deliveryDelayManager.addDeliveryDelayable(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerWithDeliveryDelayManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseItem() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"releaseItem");
        }
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            this._strongReferenceToItem = NULL_STRONG_REF;
        }
        if (this._softReferenceToItem != null) {
            this._softReferenceToItem.clear();
        }
        if (this._isStorageManaged && this._itemCacheManagedReference != NULL_CACHE_REF) {
            this._itemCache.unmanage(this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("release item(" + this.getID() + ":" + this._inMemoryItemSize + ") new cacheSize = " + this._itemCache.getCurrentSize()));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"releaseItem");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void releaseIfDiscardable() throws SevereMessageStoreException {
        boolean unlink = false;
        if (this.isStoreNever()) {
            AbstractItemLink abstractItemLink = this;
            synchronized (abstractItemLink) {
                if (ItemLinkState.STATE_AVAILABLE == this._itemLinkState) {
                    ListStatistics stats;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"removing STORE_NEVER item as a result of discard");
                    }
                    ListStatistics listStatistics = stats = this.getParentStatistics();
                    synchronized (listStatistics) {
                        stats.decrementAvailable();
                        stats.decrementTotal(this._inMemoryItemSize);
                    }
                    this._itemLinkState = ItemLinkState.STATE_NOT_STORED;
                    unlink = true;
                }
            }
        }
        if (unlink) {
            this.getMessageStoreImpl().unregister(this);
            this.unlink();
        }
    }

    public final AbstractItem removeIfMatches(Filter filter, PersistentTransaction transaction) throws ProtocolException, TransactionException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeIfMatches", (Object)new Object[]{filter, transaction});
        }
        AbstractItem foundItem = this.cmdRemoveIfMatches(filter, transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeIfMatches", (Object)foundItem);
        }
        return foundItem;
    }

    public final void requestUpdate(Transaction transaction) throws ProtocolException, TransactionException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"requestUpdate", (Object)transaction);
        }
        PersistentTransaction mstran = (PersistentTransaction)transaction;
        this.cmdRequestUpdate(mstran);
        UpdateTask task = new UpdateTask(this);
        mstran.addWork(task);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"requestUpdate");
        }
    }

    public final void requestXmlWriteOn(FormattedWriter writer) throws IOException {
        this.xmlWriteOn(writer);
    }

    final void restoreState(Persistable tuple) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"restoreState", (Object)tuple);
        }
        PersistentTranId xid = tuple.getPersistentTranId();
        boolean logicallyDeleted = tuple.isLogicallyDeleted();
        PersistentTransaction transaction = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("xid = " + xid + "; logicallyDeleted = " + logicallyDeleted));
        }
        if (xid != null) {
            transaction = this.getMessageStoreImpl().getXidManager().getTransactionFromTranId(xid);
        }
        if (null == transaction) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"no transaction so tuple is not in doubt ");
            }
            if (logicallyDeleted) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"tuple is logically deleted - removing link");
                }
            } else {
                boolean canExpireSilently = false;
                boolean expired = false;
                if (expired && canExpireSilently) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"tuple is expired and can expire silently - removing link");
                    }
                } else {
                    long lockID = tuple.getLockID();
                    if (-2L != lockID) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("tuple is locked. LockID = " + lockID));
                        }
                        this._restoreStatePersistentlyLocked(this, this._owningStreamLink, lockID);
                        this._owningStreamLink.append(this);
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"tuple is not locked");
                        }
                        if (tuple.getDeliveryDelayTime() > System.currentTimeMillis()) {
                            this._restoreStateLocked(this, this._owningStreamLink, -56789L);
                            this.registerWithDeliveryDelayManager();
                        } else {
                            this._restoreStateAvailable(this, this._owningStreamLink);
                        }
                        this._owningStreamLink.append(this);
                    }
                    this.registerWithExpirer();
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Tuple is in doubt. transaction = " + transaction));
            }
            Task task = null;
            if (logicallyDeleted) {
                long lockID;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"tuple is logically deleted - tuple is deleting");
                }
                if (-2L != (lockID = tuple.getLockID())) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("tuple is 'removingLocked'. lockID = " + lockID));
                    }
                    this._restoreStateRemovingPersistentlyLocked(this, this._owningStreamLink, this.getLockID(), transaction);
                    this._owningStreamLink.append(this);
                    task = new RemoveLockedTask(this);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"tuple is not locked");
                    }
                    this._restoreStateRemovingNoLock(this, this._owningStreamLink, transaction);
                    this._owningStreamLink.append(this);
                    task = new RemoveTask(this);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"tuple is not logicallyDeleted, so is adding");
                }
                if (tuple.getDeliveryDelayTime() > System.currentTimeMillis()) {
                    this._restoreStateLocked(this, this._owningStreamLink, -56789L);
                } else {
                    this._restoreStateAdding(this, this._owningStreamLink, transaction);
                }
                this._owningStreamLink.append(this);
                task = new AddTask(this);
            }
            try {
                transaction.addWork(task);
                ((TaskList)transaction.getWorkList()).declareAlreadyPrecommitted();
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink.restoreState", (String)"1:3526:1.241", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Exception " + (Object)((Object)e) + " while adding task to tasklist"));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"restoreState");
                }
                throw new SevereMessageStoreException("SIMS_NNNN", (Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"restoreState");
        }
    }

    public final void setNextMappedLink(AbstractItemLink link) {
        this._nextMappedLink = link;
    }

    public final void setParentWasSpillingAtAddTime(boolean b) {
        this.getTuple().setWasSpillingAtAddition(b);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("AIL(");
        buf.append(this.getID());
        buf.append(", ");
        buf.append(this._itemLinkState);
        buf.append(")");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlock(long lockID, Transaction transaction, boolean incrementUnlockCountIfNonpersistent) throws ProtocolException, TransactionException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlock", (Object)new Object[]{lockID, transaction, incrementUnlockCountIfNonpersistent});
        }
        boolean invokeUnlockedCallback = false;
        boolean linkHasBecomeAvailable = false;
        boolean linkHasBecomeReleasable = false;
        boolean linkHasBecomeNotReleasable = false;
        boolean requiresPersistUnlockTask = false;
        AbstractItem item = null;
        AbstractItemLink abstractItemLink = this;
        synchronized (abstractItemLink) {
            if (this._itemLinkState == ItemLinkState.STATE_LOCKED) {
                if (this._lockID != lockID) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)("LockID mismatch! LockID(Item): " + this._lockID + ", LockID(New): " + lockID));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlock");
                    }
                    throw new LockIdMismatch(this._lockID, lockID);
                }
                if (null != transaction) {
                    this._transactionId = transaction.getPersistentTranId();
                }
                if (this._lockID == -56789L) {
                    ListStatistics stats;
                    item = this.getItem();
                    ListStatistics listStatistics = stats = this.getParentStatistics();
                    synchronized (listStatistics) {
                        stats.decrementLocked();
                        stats.incrementAvailable();
                    }
                    linkHasBecomeReleasable = this._declareDiscardable();
                    this._lockID = -2L;
                    this._tuple.setLockID(-2L);
                    if (incrementUnlockCountIfNonpersistent) {
                        ++this._unlockCount;
                    }
                    this._itemLinkState = ItemLinkState.STATE_AVAILABLE;
                    invokeUnlockedCallback = true;
                    linkHasBecomeAvailable = true;
                } else {
                    ListStatistics stats;
                    item = this._getAndAssertItem();
                    ListStatistics listStatistics = stats = this.getParentStatistics();
                    synchronized (listStatistics) {
                        stats.decrementLocked();
                        stats.incrementAvailable();
                    }
                    linkHasBecomeReleasable = this._declareDiscardable();
                    this._lockID = -2L;
                    this._tuple.setLockID(-2L);
                    if (incrementUnlockCountIfNonpersistent) {
                        ++this._unlockCount;
                    }
                    this._itemLinkState = ItemLinkState.STATE_AVAILABLE;
                    invokeUnlockedCallback = true;
                    linkHasBecomeAvailable = true;
                }
            } else if (this._itemLinkState == ItemLinkState.STATE_PERSISTENTLY_LOCKED) {
                if (this._lockID != lockID) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)("LockID mismatch! LockID(Item): " + this._lockID + ", LockID(New): " + lockID));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlock");
                    }
                    throw new LockIdMismatch(this._lockID, lockID);
                }
                if (null == transaction) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"No transaction supplied for persistent unlock!");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlock");
                    }
                    throw new StateException("Unlock of Persistently locked requires transaction");
                }
                this._transactionId = transaction.getPersistentTranId();
                linkHasBecomeNotReleasable = this._declareNotDiscardable(this._getItemNoRestore());
                this._tuple.setLockID(-2L);
                this._itemLinkState = ItemLinkState.STATE_UNLOCKING_PERSISTENTLY_LOCKED;
                requiresPersistUnlockTask = true;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)("Invalid Item state: " + this._itemLinkState));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlock");
                }
                throw new StateException(this._itemLinkState.toString());
            }
        }
        if (linkHasBecomeReleasable) {
            this._declareReleasable(this._getItemNoRestore());
        }
        if (linkHasBecomeNotReleasable) {
            this._declareNotReleasable();
        }
        if (requiresPersistUnlockTask) {
            PersistUnlock task = new PersistUnlock(this);
            ((PersistentTransaction)transaction).addWork(task);
        }
        if (linkHasBecomeAvailable && this.isAvailable() && null != this._owningStreamLink) {
            this._owningStreamLink.linkAvailable(this);
        }
        if (invokeUnlockedCallback && item != null) {
            item.eventUnlocked();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlock");
        }
    }

    @Override
    public void xmlShortWriteOn(FormattedWriter writer) throws IOException {
        String name = this.xmlTagName();
        writer.write(60);
        writer.write(writer.getNameSpace());
        writer.write(name);
        this.xmlWriteAttributesOn(writer);
        writer.write(" />");
    }

    protected abstract String xmlTagName();

    @Override
    protected synchronized void xmlWriteAttributesOn(FormattedWriter writer) throws IOException {
        writer.write(32);
        writer.write("id");
        writer.write("=\"");
        writer.write(Long.toString(this.getTuple().getUniqueId()));
        writer.write("\" ");
        writer.write("state");
        writer.write("=\"");
        writer.write(this._itemLinkState.toString());
        writer.write("\" ");
        writer.write("size");
        writer.write("=\"");
        writer.write(Integer.toString(this._inMemoryItemSize));
        writer.write("\" ");
        writer.write("backoutCount");
        writer.write("=\"");
        writer.write(Integer.toString(this._backoutCount));
        writer.write("\" ");
        writer.write("unlockCount");
        writer.write("=\"");
        writer.write(Integer.toString(this._unlockCount));
        writer.write(34);
        super.xmlWriteAttributesOn(writer);
    }

    protected void xmlWriteChildrenOn(FormattedWriter writer) throws IOException {
        AbstractItem item = this._getItemNoRestore();
        if (null != item) {
            item.xmlWriteOn(writer);
        }
    }

    @Override
    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        String name = this.xmlTagName();
        writer.write("<");
        writer.write(writer.getNameSpace());
        writer.write(name);
        this.xmlWriteAttributesOn(writer);
        writer.write(" >");
        writer.indent();
        if (null != this.getTuple()) {
            this.getTuple().xmlWrite(writer);
        }
        this.xmlWriteChildrenOn(writer);
        writer.outdent();
        writer.newLine();
        writer.endTag(name);
    }

    private static final class NullCacheReferenceToItem
    extends Item {
        private NullCacheReferenceToItem() {
        }
    }

    private static final class NullStrongReferenceToItem
    extends Item {
        private NullStrongReferenceToItem() {
        }
    }
}

