/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractSingleFileObjectStore;
import com.ibm.ws.objectManager.BTree;
import com.ibm.ws.objectManager.InvalidStoreSignatureException;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.TemporaryIOException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.UnexpectedExceptionException;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.TreeSet;

public final class SingleNonNioFileObjectStore
extends AbstractSingleFileObjectStore {
    private static final Class cclass = SingleNonNioFileObjectStore.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerStore");
    private static final long serialVersionUID = 4753669053373190961L;
    private transient ObjectManagerByteArrayOutputStream byteArrayOutputStream;

    public SingleNonNioFileObjectStore(String storeName, ObjectManager objectManager) throws ObjectManagerException {
        super(storeName, objectManager, 0);
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{storeName, objectManager});
            trace.exit(this, cclass, "<init>");
        }
    }

    public SingleNonNioFileObjectStore(String storeName, ObjectManager objectManager, int storeStrategy) throws ObjectManagerException {
        super(storeName, objectManager, storeStrategy);
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{storeName, objectManager, new Integer(storeStrategy)});
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    public synchronized void open(ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "open";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "open", objectManagerState);
        }
        super.open(objectManagerState);
        this.byteArrayOutputStream = new ObjectManagerByteArrayOutputStream(4096);
        try {
            int versionRead = this.storeFile.readInt();
            char[] signatureRead = new char["++ObjectManager.SingleFileObjectStore++".length()];
            for (int i = 0; i < "++ObjectManager.SingleFileObjectStore++".length(); ++i) {
                signatureRead[i] = this.storeFile.readChar();
            }
            if (!new String(signatureRead).equals("++ObjectManager.SingleFileObjectStore++")) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "open", new Object[]{signatureRead});
                }
                throw new InvalidStoreSignatureException(this, new String(signatureRead), "++ObjectManager.SingleFileObjectStore++");
            }
            long objectStoreIdentifierRead = this.storeFile.readLong();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "open", new Object[]{new Integer(versionRead), new String(signatureRead), new Long(objectStoreIdentifierRead)});
            }
            if (this.objectStoreIdentifier == -1) {
                this.objectStoreIdentifier = (int)objectStoreIdentifierRead;
            }
            long directoryRootByteAddress = this.storeFile.readLong();
            long directoryRootLength = this.storeFile.readLong();
            int directoryMinimumNodeSize = this.storeFile.readInt();
            long freeSpaceStoreAreaByteAddress = this.storeFile.readLong();
            long freeSpaceStoreAreaLength = this.storeFile.readLong();
            long freeSpaceCount = this.storeFile.readLong();
            this.sequenceNumber = this.storeFile.readLong();
            this.storeFileSizeUsed = this.storeFile.readLong();
            this.minimumStoreFileSize = this.storeFile.readLong();
            this.maximumStoreFileSize = this.storeFile.readLong();
            this.cachedManagedObjectsSize = this.storeFile.readInt();
            this.storeFileSizeAllocated = this.storeFile.length();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "open", new Object[]{new Long(directoryRootByteAddress), new Long(directoryRootLength), new Integer(directoryMinimumNodeSize), new Long(freeSpaceStoreAreaByteAddress), new Long(freeSpaceStoreAreaLength), new Long(freeSpaceCount), new Long(this.sequenceNumber), new Long(this.storeFileSizeUsed), new Long(this.minimumStoreFileSize), new Long(this.maximumStoreFileSize), new Integer(this.cachedManagedObjectsSize), new Long(this.storeFileSizeAllocated)});
            }
            if (this.storeStrategy == 0 || this.storeStrategy == 2) {
                this.cachedManagedObjects = new SoftReference[this.cachedManagedObjectsSize];
                this.directory = new Directory(directoryMinimumNodeSize, directoryRootByteAddress, directoryRootLength);
                if (freeSpaceStoreAreaByteAddress != 0L) {
                    this.freeSpaceStoreArea = this.directory.makeStoreArea(102L, freeSpaceStoreAreaByteAddress, freeSpaceStoreAreaLength);
                }
                this.readFreeSpaceMap(freeSpaceCount);
            } else if (this.storeStrategy == 1) {
                this.reservedSize = Runtime.getRuntime().totalMemory() < Integer.MAX_VALUE ? new AbstractSingleFileObjectStore.Atomic32BitLong(0L) : new AbstractSingleFileObjectStore.Atomic64BitLong(0L);
                this.clear();
            }
        }
        catch (EOFException exception) {
            if (Tracing.isAnyTracingEnabled() && trace.isEventEnabled()) {
                trace.event(this, cclass, "open", exception);
            }
            if (objectManagerState.getObjectManagerStateState() == 2) {
                ObjectManager.ffdc.processException(this, cclass, "open", exception, "1:241:1.35");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "open", new Object[]{"EndOfFile:244"});
                }
                throw new PermanentIOException((Object)this, (IOException)exception);
            }
            this.minimumStoreFileSize = 0L;
            this.maximumStoreFileSize = Long.MAX_VALUE;
            this.cachedManagedObjectsSize = 10000;
            this.cachedManagedObjects = new SoftReference[this.cachedManagedObjectsSize];
            this.directory = new Directory(10, 0L, 0L);
            this.freeSpaceByAddressHead = null;
            this.freeSpaceByLength = new TreeSet(new AbstractSingleFileObjectStore.LengthComparator());
            this.freeSpaceStoreArea = null;
            this.sequenceNumber = 200L;
            this.storeFileSizeAllocated = this.storeFileSizeUsed = 8192L;
            this.writeHeader();
            this.force();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "open", exception, "1:276:1.35");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "open");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        this.directoryReservedSize = this.directory.spaceRequired();
        this.reservedSize = Runtime.getRuntime().totalMemory() < Integer.MAX_VALUE ? new AbstractSingleFileObjectStore.Atomic32BitLong(0L) : new AbstractSingleFileObjectStore.Atomic64BitLong(0L);
        this.addSpaceOverhead = 77;
        this.setAllocationAllowed();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "open");
        }
    }

    private void readFreeSpaceMap(long freeSpaceCount) throws ObjectManagerException {
        String methodName = "readFreeSpaceMap";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readFreeSpaceMap", new Object[]{new Long(freeSpaceCount)});
        }
        this.freeSpaceByAddressHead = null;
        this.freeSpaceByLength = new TreeSet(new AbstractSingleFileObjectStore.LengthComparator());
        if (this.freeSpaceStoreArea != null) {
            try {
                this.storeFile.seek(this.freeSpaceStoreArea.byteAddress);
                AbstractSingleFileObjectStore.FreeSpace freeSpaceByAddressTail = null;
                int i = 0;
                while ((long)i < freeSpaceCount) {
                    AbstractSingleFileObjectStore.FreeSpace freeSpace = new AbstractSingleFileObjectStore.FreeSpace(this.storeFile.readLong(), this.storeFile.readLong());
                    if (freeSpaceByAddressTail != null && freeSpace.address < freeSpaceByAddressTail.address) {
                        AbstractSingleFileObjectStore.FreeSpace sortEntry = this.freeSpaceByAddressHead;
                        while (sortEntry != null) {
                            if (sortEntry.address > freeSpace.address) {
                                freeSpace.next = sortEntry;
                                freeSpace.prev = sortEntry.prev;
                                if (sortEntry.prev != null) {
                                    sortEntry.prev.next = freeSpace;
                                } else {
                                    this.freeSpaceByAddressHead = freeSpace;
                                }
                                sortEntry.prev = freeSpace;
                                break;
                            }
                            sortEntry = sortEntry.next;
                        }
                        if (sortEntry == null) {
                            RuntimeException exception = new RuntimeException();
                            ObjectManager.ffdc.processException(this, cclass, "readFreeSpaceMap", exception, "1:365:1.35");
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit(this, cclass, "readFreeSpaceMap");
                            }
                            throw new UnexpectedExceptionException((Object)this, exception);
                        }
                    } else {
                        if (freeSpaceByAddressTail == null) {
                            this.freeSpaceByAddressHead = freeSpace;
                        } else {
                            freeSpace.prev = freeSpaceByAddressTail;
                            freeSpaceByAddressTail.next = freeSpace;
                        }
                        freeSpaceByAddressTail = freeSpace;
                    }
                    this.freeSpaceByLength.add(freeSpace);
                    ++i;
                }
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, "readFreeSpaceMap", exception, "1:395:1.35");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, cclass, "readFreeSpaceMap");
                }
                this.objectManagerState.requestShutdown();
                throw new PermanentIOException((Object)this, exception);
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readFreeSpaceMap");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedObject get(Token token) throws ObjectManagerException {
        String methodName = "get";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "get", new Object[]{token});
        }
        ++this.numberOfGetRequests;
        ManagedObject objectFromStore = null;
        SingleNonNioFileObjectStore singleNonNioFileObjectStore = this;
        synchronized (singleNonNioFileObjectStore) {
            Directory.StoreArea storeArea = (Directory.StoreArea)this.directory.getEntry(new Long(token.storedObjectIdentifier));
            if (storeArea != null) {
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "get", new Object[]{storeArea});
                }
                byte[] managedObjectBytes = new byte[(int)storeArea.length];
                try {
                    this.storeFile.seek(storeArea.byteAddress);
                    this.storeFile.readFully(managedObjectBytes);
                }
                catch (IOException exception) {
                    ObjectManager.ffdc.processException(this, cclass, "get", exception, "1:455:1.35");
                    try {
                        if (this.storeFile.getFD().valid()) {
                            TemporaryIOException tioe = new TemporaryIOException((Object)this, exception);
                            if (trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "get", tioe);
                            }
                            throw tioe;
                        }
                        this.objectManagerState.requestShutdown();
                        PermanentIOException pioe = new PermanentIOException((Object)this, exception);
                        if (trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "get", pioe);
                        }
                        throw pioe;
                    }
                    catch (IOException e) {
                        this.objectManagerState.requestShutdown();
                        PermanentIOException pioe = new PermanentIOException((Object)this, exception);
                        if (trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "get", pioe);
                        }
                        throw pioe;
                    }
                }
                objectFromStore = ManagedObject.restoreFromSerializedBytes(managedObjectBytes, this.objectManagerState);
                this.cache(objectFromStore);
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "get", new Object[]{objectFromStore});
        }
        return objectFromStore;
    }

    @Override
    public synchronized void close() throws ObjectManagerException {
        String methodName = "close";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "close");
        }
        super.close();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "close");
        }
    }

    @Override
    final AbstractSingleFileObjectStore.Directory makeDirectory(int minimumNodeSize, long directoryRootByteAddress, long directoryRootLength) throws ObjectManagerException {
        return new Directory(minimumNodeSize, directoryRootByteAddress, directoryRootLength);
    }

    @Override
    final void write(ManagedObject managedObject) throws ObjectManagerException {
        String methodName = "write";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "write", new Object[]{managedObject});
        }
        ObjectManagerByteArrayOutputStream byteArrayOutputStream = null;
        byte[] serializedBytes = null;
        int serializedBytesLength = 0;
        if (this.usesSerializedForm) {
            if (managedObject.state != 7) {
                byteArrayOutputStream = managedObject.freeLatestSerializedBytes();
            }
        } else if (managedObject.state == 8) {
            byteArrayOutputStream = managedObject.getSerializedBytes();
        }
        if (byteArrayOutputStream != null) {
            Directory.StoreArea existingStoreArea;
            AbstractSingleFileObjectStore.FreeSpace freeSpace;
            Directory.StoreArea storeArea;
            serializedBytes = byteArrayOutputStream.getBuffer();
            serializedBytesLength = byteArrayOutputStream.getCount();
            boolean addToDirectory = false;
            if (this.objectManagerState.getObjectManagerStateState() == 2) {
                storeArea = (Directory.StoreArea)this.directory.getEntry(new Long(managedObject.owningToken.storedObjectIdentifier));
                if (storeArea == null || storeArea.length < (long)serializedBytesLength || storeArea.length + 17L > (long)serializedBytesLength) {
                    freeSpace = this.allocateSpace(serializedBytesLength);
                    storeArea = (Directory.StoreArea)this.directory.makeStoreArea(managedObject.owningToken.storedObjectIdentifier, freeSpace.address, freeSpace.length);
                    addToDirectory = true;
                }
            } else {
                freeSpace = this.allocateSpace(serializedBytesLength);
                storeArea = (Directory.StoreArea)this.directory.makeStoreArea(managedObject.owningToken.storedObjectIdentifier, freeSpace.address, freeSpace.length);
                addToDirectory = true;
            }
            ++this.numberOfManagedObjectsWritten;
            this.writeBuffer(serializedBytes, 0, serializedBytesLength, storeArea.byteAddress);
            if (addToDirectory && (existingStoreArea = (Directory.StoreArea)this.directory.putEntry(storeArea)) != null) {
                this.newFreeSpace.add(existingStoreArea);
            }
            this.checkpointReleaseSize += byteArrayOutputStream.getReleaseSize();
            this.objectManagerState.returnByteArrayOutputStreamToPool(byteArrayOutputStream);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "write");
        }
    }

    @Override
    final void writeFreeSpace() throws ObjectManagerException {
        String methodName = "writeFreeSpace";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "writeFreeSpace");
        }
        this.byteArrayOutputStream.reset();
        DataOutputStream dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
        long freeSpaceByteAddress = this.freeSpaceStoreArea.byteAddress;
        try {
            AbstractSingleFileObjectStore.FreeSpace freeSpace = this.freeSpaceByAddressHead;
            while (freeSpace != null) {
                dataOutputStream.writeLong(freeSpace.address);
                dataOutputStream.writeLong(freeSpace.length);
                freeSpace = freeSpace.next;
            }
            dataOutputStream.flush();
            this.byteArrayOutputStream.flush();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "flush", exception, "1:724:1.35");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "flush");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        this.writeBuffer(this.byteArrayOutputStream.getBuffer(), 0, this.byteArrayOutputStream.getCount(), freeSpaceByteAddress);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeFreeSpace");
        }
    }

    private int writeBuffer(byte[] byteBuffer, int offset, int length, long byteAddress) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeBuffer", new Object[]{new Integer(byteBuffer.hashCode()), new Integer(offset), new Integer(length), new Long(byteAddress)});
        }
        try {
            this.storeFile.seek(byteAddress);
            this.storeFile.write(byteBuffer, offset, length);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "writeBuffer", exception, "1:774:1.35");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "writeBuffer");
            }
            this.objectManagerState.requestShutdown();
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "writeBuffer", new Object[]{new Integer(length)});
        }
        return length;
    }

    @Override
    final void writeHeader() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "writeHeader");
        }
        this.byteArrayOutputStream.reset();
        DataOutputStream dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(1);
            dataOutputStream.writeChars("++ObjectManager.SingleFileObjectStore++");
            dataOutputStream.writeLong(this.objectStoreIdentifier);
            dataOutputStream.writeLong(((Directory.Node)this.directory.root).byteAddress);
            dataOutputStream.writeLong(((Directory.Node)this.directory.root).length);
            dataOutputStream.writeInt(this.directory.getMinimumNodeSize());
            if (this.freeSpaceStoreArea == null) {
                dataOutputStream.writeLong(0L);
                dataOutputStream.writeLong(0L);
            } else {
                dataOutputStream.writeLong(this.freeSpaceStoreArea.byteAddress);
                dataOutputStream.writeLong(this.freeSpaceStoreArea.length);
            }
            dataOutputStream.writeLong(this.freeSpaceByLength.size());
            dataOutputStream.writeLong(this.sequenceNumber);
            dataOutputStream.writeLong(this.storeFileSizeUsed);
            dataOutputStream.writeLong(this.minimumStoreFileSize);
            dataOutputStream.writeLong(this.maximumStoreFileSize);
            dataOutputStream.writeInt(this.cachedManagedObjectsSize);
            dataOutputStream.flush();
            this.byteArrayOutputStream.flush();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "writeHeader", exception, "1:836:1.35");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "flush");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        byte[] buffer = this.byteArrayOutputStream.getBuffer();
        int length = this.byteArrayOutputStream.getCount();
        this.writeBuffer(buffer, 0, length, 0L);
        this.writeBuffer(buffer, 0, length, 4096L);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeHeader");
        }
    }

    @Override
    void force() throws ObjectManagerException {
        String methodName = "force";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "force");
        }
        try {
            this.storeFile.getFD().sync();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "force", exception, "1:884:1.35");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "force");
            }
            this.objectManagerState.requestShutdown();
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "force");
        }
    }

    final class Directory
    extends AbstractSingleFileObjectStore.Directory {
        private final Class cclass;

        Directory(int minimumNodeSize, long directoryRootByteAddress, long directoryRootLength) throws ObjectManagerException {
            super(minimumNodeSize, directoryRootByteAddress, directoryRootLength);
            this.cclass = Directory.class;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, this.cclass, "<init>", new Object[]{new Integer(minimumNodeSize), new Long(directoryRootByteAddress), new Long(directoryRootLength)});
            }
            if (directoryRootLength > 0L) {
                this.root = new Node(directoryRootByteAddress, directoryRootLength);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, this.cclass, "<init>");
            }
        }

        @Override
        BTree.Node makeNode(BTree.Node parent) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, Directory.class, "makeNode", new Object[]{parent});
            }
            Node newNode = new Node((Node)parent);
            newNode.modified = true;
            newNode.dormantFlushCount = 2;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, Directory.class, "makeNode", new Object[]{newNode});
            }
            return newNode;
        }

        @Override
        BTree.Entry makeEntry(Object key, Object value) throws ObjectManagerException {
            StoreArea newEntry = new StoreArea(key, value);
            return newEntry;
        }

        @Override
        AbstractSingleFileObjectStore.Directory.StoreArea makeStoreArea(long identifier, long byteAddress, long length) throws ObjectManagerException {
            return new StoreArea(identifier, byteAddress, length);
        }

        class StoreArea
        extends AbstractSingleFileObjectStore.Directory.StoreArea {
            private final Class cclass;

            StoreArea(Object key, Object value) {
                super(key, value);
                this.cclass = StoreArea.class;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "<init>", new Object[]{key, value});
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, this.cclass, "<init>");
                }
            }

            StoreArea(long identifier, long byteAddress, long length) {
                super(identifier, byteAddress, length);
                this.cclass = StoreArea.class;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "<init>", new Object[]{new Long(identifier), new Long(byteAddress), new Long(length)});
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, this.cclass, "<init>");
                }
            }

            @Override
            BTree.Node getChild() throws ObjectManagerException {
                BTree.Node childRef;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "getChild", new Object[]{new Long(this.identifier), new Long(this.childByteAddress), new Long(this.childLength)});
                }
                if ((childRef = this.child) == null && this.childLength != 0L) {
                    SoftReference softReference = this.childSoftReference;
                    if (softReference != null) {
                        this.child = childRef = (BTree.Node)softReference.get();
                    }
                    if (childRef == null) {
                        this.child = childRef = new Node(this.childByteAddress, this.childLength);
                    }
                }
                if (childRef != null) {
                    ((Node)childRef).dormantFlushCount = 2;
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, this.cclass, "getChild", new Object[]{childRef});
                }
                return childRef;
            }
        }

        class Node
        extends AbstractSingleFileObjectStore.Directory.Node {
            private final Class cclass;

            Node(Node parent) {
                super(parent);
                this.cclass = Node.class;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "<init>", new Object[]{parent});
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, this.cclass, "<init>");
                }
            }

            Node(long byteAddress, long length) throws ObjectManagerException {
                super(null);
                this.cclass = Node.class;
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "<init>", new Object[]{new Long(byteAddress), new Long(length)});
                }
                this.byteAddress = byteAddress;
                this.length = length;
                ++SingleNonNioFileObjectStore.this.numberOfDirectoryNodesRead;
                try {
                    SingleNonNioFileObjectStore.this.storeFile.seek(byteAddress);
                    this.numberOfKeys = SingleNonNioFileObjectStore.this.storeFile.readInt();
                    byte flag = SingleNonNioFileObjectStore.this.storeFile.readByte();
                    if (flag == 1) {
                        this.isLeaf = false;
                    }
                    StoreArea previous = null;
                    for (int i = 0; i < this.numberOfKeys; ++i) {
                        StoreArea storeArea = (StoreArea)Directory.this.makeStoreArea(SingleNonNioFileObjectStore.this.storeFile.readLong(), SingleNonNioFileObjectStore.this.storeFile.readLong(), SingleNonNioFileObjectStore.this.storeFile.readLong());
                        if (previous == null) {
                            this.first = storeArea;
                        } else {
                            previous.next = storeArea;
                        }
                        previous = storeArea;
                        if (this.isLeaf) continue;
                        storeArea.childByteAddress = SingleNonNioFileObjectStore.this.storeFile.readLong();
                        storeArea.childLength = SingleNonNioFileObjectStore.this.storeFile.readLong();
                    }
                    if (!this.isLeaf) {
                        StoreArea storeArea = new StoreArea(null, null);
                        storeArea.childByteAddress = SingleNonNioFileObjectStore.this.storeFile.readLong();
                        storeArea.childLength = SingleNonNioFileObjectStore.this.storeFile.readLong();
                        previous.next = storeArea;
                    }
                }
                catch (IOException exception) {
                    ObjectManager.ffdc.processException(this, this.cclass, "<init>", exception, "1:1125:1.35");
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit(this, this.cclass, "<init>");
                    }
                    SingleNonNioFileObjectStore.this.objectManagerState.requestShutdown();
                    throw new PermanentIOException((Object)this, exception);
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, this.cclass, "<init>");
                }
            }

            @Override
            void write() throws ObjectManagerException {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.entry((Object)this, this.cclass, "write", new Object[]{new Long(this.byteAddress), new Long(this.length)});
                }
                if (this.modified) {
                    if (!this.isLeaf) {
                        StoreArea storeArea = (StoreArea)this.first;
                        while (storeArea != null) {
                            if (storeArea.child != null) {
                                ((Node)storeArea.child).write();
                                storeArea.childByteAddress = ((Node)storeArea.child).byteAddress;
                                storeArea.childLength = ((Node)storeArea.child).length;
                            }
                            storeArea = (StoreArea)storeArea.next;
                        }
                    }
                    SingleNonNioFileObjectStore.this.byteArrayOutputStream.reset();
                    DataOutputStream dataOutputStream = new DataOutputStream(SingleNonNioFileObjectStore.this.byteArrayOutputStream);
                    long directoryByteAddress = this.byteAddress;
                    try {
                        dataOutputStream.writeInt(this.numberOfKeys);
                        if (this.isLeaf) {
                            dataOutputStream.writeByte(0);
                        } else {
                            dataOutputStream.writeByte(1);
                        }
                        StoreArea storeArea = (StoreArea)this.first;
                        while (storeArea != null) {
                            if (storeArea.getKey() != null) {
                                dataOutputStream.writeLong(storeArea.identifier);
                                dataOutputStream.writeLong(storeArea.byteAddress);
                                dataOutputStream.writeLong(storeArea.length);
                            }
                            if (!this.isLeaf) {
                                dataOutputStream.writeLong(storeArea.getChildByteAddress());
                                dataOutputStream.writeLong(storeArea.getChildLength());
                            }
                            storeArea = (StoreArea)storeArea.next;
                        }
                        dataOutputStream.flush();
                        SingleNonNioFileObjectStore.this.byteArrayOutputStream.flush();
                    }
                    catch (IOException exception) {
                        ObjectManager.ffdc.processException(this, this.cclass, "write", exception, "1:1222:1.35");
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit(this, this.cclass, "write");
                        }
                        throw new PermanentIOException((Object)this, exception);
                    }
                    SingleNonNioFileObjectStore.this.writeBuffer(SingleNonNioFileObjectStore.this.byteArrayOutputStream.getBuffer(), 0, SingleNonNioFileObjectStore.this.byteArrayOutputStream.getCount(), directoryByteAddress);
                    this.modified = false;
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(this, this.cclass, "write");
                }
            }
        }
    }
}

