/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractObjectStore;
import com.ibm.ws.objectManager.CheckpointEndLogRecord;
import com.ibm.ws.objectManager.CheckpointEndNotFoundException;
import com.ibm.ws.objectManager.CheckpointStartLogRecord;
import com.ibm.ws.objectManager.ClassNotFoundException;
import com.ibm.ws.objectManager.ConcurrentHashMap;
import com.ibm.ws.objectManager.DummyFileObjectStore;
import com.ibm.ws.objectManager.DummyInternalTransaction;
import com.ibm.ws.objectManager.DummyLogOutput;
import com.ibm.ws.objectManager.DuplicateObjectStoreIdentifierException;
import com.ibm.ws.objectManager.DuplicateObjectStoreNameException;
import com.ibm.ws.objectManager.DuplicateTransactionException;
import com.ibm.ws.objectManager.FileLogInput;
import com.ibm.ws.objectManager.FileLogOutput;
import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.InvalidLogFileTypeException;
import com.ibm.ws.objectManager.InvalidStateException;
import com.ibm.ws.objectManager.LogFileExhaustedException;
import com.ibm.ws.objectManager.LogFileInUseException;
import com.ibm.ws.objectManager.LogInput;
import com.ibm.ws.objectManager.LogOutput;
import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.LogicalUnitOfWork;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.NonExistentLogFileException;
import com.ibm.ws.objectManager.NonExistentObjectStoreException;
import com.ibm.ws.objectManager.NonExistentTransactionException;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerEventCallback;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.SimplifiedSerialization;
import com.ibm.ws.objectManager.StateErrorException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.TooManyTransactionsException;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.TransactionCapacityExceededException;
import com.ibm.ws.objectManager.TreeMap;
import com.ibm.ws.objectManager.UnexpectedExceptionException;
import com.ibm.ws.objectManager.UnknownObjectStoreException;
import com.ibm.ws.objectManager.utils.FileLock;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjectManagerState
extends ManagedObject
implements SimplifiedSerialization {
    private static final Class cclass;
    private static Trace trace;
    private static final long serialVersionUID = 1238245075497061436L;
    public static final boolean gatherStatistics = true;
    private static final boolean migrateObjectStores = false;
    static int numberOfProcessors;
    protected Map objectStores = new HashMap();
    protected long maximumObjectStoreIdentifier = 100L;
    protected long persistentTransactionsPerCheckpoint = 5000L;
    protected long nonPersistentTransactionsPerCheckpoint = 5000L;
    protected float logFullTriggerCheckpointThreshold = 0.4f;
    protected float logFullPostCheckpointThreshold = 0.5f;
    protected long maximumActiveTransactions = 1000L;
    protected int checkpointDelay = 100;
    protected String coldStartLogFileName;
    protected long coldStartTime = 0L;
    static final int stateError = 0;
    static final int stateOpeningLog = 1;
    static final int stateReplayingLog = 2;
    static final int stateWarmStarted = 3;
    static final int stateColdStarted = 4;
    static final int stateShutdownStarted = 5;
    static final int stateStopped = 6;
    static final String[] stateNames;
    static final int[] nextStateForLogFailedToOpen;
    static final int[] nextStateForLogOpened;
    static final int[] nextStateForLogReplayed;
    static final int[] nextStateForStartShutdown;
    static final int[] nextStateForShutdown;
    protected transient int state = 1;
    private transient int previousState = -1;
    transient String logFileName;
    protected transient RandomAccessFile logFile;
    private transient FileLock logLock;
    protected transient LogOutput logOutput;
    private transient String logFileMode;
    protected transient int logFileType;
    protected transient ObjectStore defaultObjectStore;
    protected static final int defaultObjectStoreIdentifier = 0;
    private boolean mainObjectManagerState;
    protected transient Token namedObjects;
    protected transient boolean nioAvailable = true;
    protected transient ObjectManager objectManager;
    private transient long maximumLogicalUnitOfWorkIdentifier = 0L;
    private transient Map registeredInternalTransactions = new ConcurrentHashMap(numberOfProcessors * 4);
    private transient ConcurrentHashMap freeTransactions = new ConcurrentHashMap(numberOfProcessors * 4);
    protected transient long currentMaximumActiveTransactions = this.maximumActiveTransactions;
    private transient long totalTransactions = 0L;
    protected transient ReferenceQueue orphanTransactionsQueue = new ReferenceQueue();
    protected transient DummyInternalTransaction dummyInternalTransaction;
    private transient long dummyLogSequenceNumber = 0L;
    private transient Object dummyLogSequenceNumberLock = new Object();
    protected transient boolean checkpointEndSeen;
    private transient int persistentTransactionsSinceLastCheckpoint = 0;
    private transient int nonPersistentTransactionsSinceLastCheckpoint = 0;
    protected static final int CHECKPOINT_STARTING_NO = 0;
    protected static final int CHECKPOINT_STARTING_NONPERSISTENT = 1;
    protected static final int CHECKPOINT_STARTING_PERSISTENT = 2;
    protected transient int checkpointStarting = 0;
    protected transient CheckpointHelper checkpointHelper = null;
    private transient long checkpointStartLogRecordSize;
    private transient long serializedSize;
    private transient long transactionUnlockSequence = 0L;
    protected transient Object transactionUnlockSequenceLock = new Object();
    protected transient Map objectStoreLocations;
    static int byteArrayOutputStreamPoolsSize;
    static int byteArrayOutputStreamPoolSize;
    static int maximumByteArrayOutputStreamSize;
    private transient List[] byteArrayOutputStreamPools = new List[byteArrayOutputStreamPoolsSize];
    private transient long totalCheckpointsTaken = 0L;
    private transient long waitingBetweenCheckpointsMilliseconds = 0L;
    private transient long flushingCheckpointStartMilliseconds = 0L;
    private transient long pausedDuringCheckpointMilliseconds = 0L;
    private transient long flushingObjectStoresForCheckpointMilliseconds = 0L;
    private transient long flushingEndCheckpointMilliseconds = 0L;
    private transient long lastCheckpointMilliseconds;
    private transient long reusedTransactions = 0L;
    private transient long totalTransactionsRequiringCheckpoint = 0L;
    private transient long maximumTransactionsInAnyCheckpoint = 0L;
    private transient long transactionsDelayedForLogFull = 0L;
    private transient ArrayList callbacks = new ArrayList();
    private static final byte simpleSerialVersion = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectManagerState(String logFileName, ObjectManager objectManager, int logFileType, Map objectStoreLocations, ObjectManagerEventCallback[] callbacks) throws ObjectManagerException {
        int i;
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{logFileName, objectManager, Integer.toString(logFileType), objectStoreLocations, callbacks});
        }
        this.logFileName = logFileName;
        this.objectManager = objectManager;
        this.logFileType = logFileType;
        this.objectStoreLocations = objectStoreLocations;
        if (callbacks != null) {
            for (i = 0; i < callbacks.length; ++i) {
                this.callbacks.add(callbacks[i]);
            }
        }
        for (i = 0; i < this.byteArrayOutputStreamPools.length; ++i) {
            this.byteArrayOutputStreamPools[i] = new ArrayList(byteArrayOutputStreamPoolSize);
        }
        this.defaultObjectStore = new DummyFileObjectStore(this);
        this.defaultObjectStore.setIdentifier(0);
        this.defaultObjectStore.open(this);
        ((ManagedObject)this).state = 8;
        this.mainObjectManagerState = true;
        Token objectManagerStateToken = new Token(this, this.defaultObjectStore, ObjectStore.objectManagerStateIdentifier);
        objectManagerStateToken = objectManagerStateToken.current();
        try {
            Class.forName("java.nio.channels.FileChannel");
        }
        catch (java.lang.ClassNotFoundException exception) {
            if (Tracing.isAnyTracingEnabled() && trace.isEventEnabled()) {
                trace.event(this, cclass, "<init>", exception);
            }
            this.nioAvailable = false;
        }
        try {
            this.logFileMode = "rwd";
            if (!this.nioAvailable) {
                this.logFileMode = "rw";
            }
            this.logFile = new RandomAccessFile(logFileName, this.logFileMode);
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "<init>", new Object[]{"Opened log file:384", logFileName, this.logFileMode, this.logFile});
            }
        }
        catch (FileNotFoundException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:395:1.62");
            this.shutdown();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", new Object[]{exception, logFileName});
            }
            throw new NonExistentLogFileException(this, exception, logFileName);
        }
        try {
            this.logLock = FileLock.getFileLock(this.logFile, logFileName);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:421:1.62");
            this.shutdown();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (!this.logLock.tryLock()) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", "via LogFileInUseException, logFileName=" + logFileName + "(String)");
            }
            throw new LogFileInUseException((Object)this, logFileName);
        }
        try {
            if (this.logFile.length() == 0L) {
                this.setState(nextStateForLogFailedToOpen);
            } else {
                this.setState(nextStateForLogOpened);
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:458:1.62");
            this.shutdown();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        this.dummyInternalTransaction = new DummyInternalTransaction(this, new LogicalUnitOfWork(this.maximumLogicalUnitOfWorkIdentifier++));
        this.registeredInternalTransactions.remove(new Long(this.dummyInternalTransaction.getLogicalUnitOfWork().identifier));
        if (this.state == 2) {
            this.performWarmStart();
        } else {
            this.performColdStart();
        }
        this.currentMaximumActiveTransactions = this.maximumActiveTransactions;
        this.totalTransactions = this.registeredInternalTransactions.size() + this.freeTransactions.size();
        this.checkpointStartLogRecordSize = (new CheckpointStartLogRecord(this).getBytesLeft() / 4096 + 1) * 4096;
        this.logOutput.reserve((long)((new CheckpointEndLogRecord().getBytesLeft() / 4096 + 2) * 4096) + this.checkpointStartLogRecordSize);
        this.checkpointHelper = new CheckpointHelper();
        this.lastCheckpointMilliseconds = System.currentTimeMillis();
        this.checkpointHelper.waitForCheckpoint(true);
        ObjectManagerState objectManagerState = this;
        synchronized (objectManagerState) {
            this.notifyAll();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected void performColdStart() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "performColdStart");
        }
        this.coldStartLogFileName = this.logFileName;
        this.coldStartTime = System.currentTimeMillis();
        switch (this.logFileType) {
            case 0: 
            case 2: {
                this.logOutput = new FileLogOutput(this.logFile, this);
                break;
            }
            case 1: {
                this.logOutput = new DummyLogOutput();
                break;
            }
            default: {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "performColdStart", new Integer(this.logFileType));
                }
                throw new InvalidLogFileTypeException((Object)this, this.logFileType);
            }
        }
        trace.debug(cclass, "performColdStart", (Object)("ObjectManager using logFile " + this.logFileName + " was cold started"));
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "performColdStart", new Object[]{this.coldStartLogFileName, new Date(this.coldStartTime)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performWarmStart() throws ObjectManagerException {
        String methodName = "performWarmStart";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "performWarmStart");
        }
        FileLogInput logInput = new FileLogInput(this.logFile, this);
        this.logOutput = new DummyLogOutput();
        this.logOutput.setLogFileSize(logInput.getLogFileSize());
        this.currentMaximumActiveTransactions = Integer.MAX_VALUE;
        this.performRecovery(logInput);
        this.logOutput.close();
        this.logOutput = new FileLogOutput(this.logFile, this.logOutput.getLogSequenceNumber(), logInput.getCurrentPage(), this);
        Map map = this.registeredInternalTransactions;
        synchronized (map) {
            Transaction transaction;
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "performWarmStart", "Inform registered transactions that recovery is completed:620");
            }
            for (InternalTransaction registeredTransaction : this.registeredInternalTransactions.values()) {
                transaction = new Transaction(registeredTransaction);
                this.logOutput.reserve(registeredTransaction.getLogSpaceReserved());
                transaction.recoveryCompleted();
            }
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "performWarmStart", "Complete transactions:634");
            }
            for (InternalTransaction registeredTransaction : this.registeredInternalTransactions.values()) {
                switch (registeredTransaction.state) {
                    case 6: {
                        transaction = new Transaction(registeredTransaction);
                        transaction.prepare();
                        if (this.logFileType != 2) break;
                        transaction.backout(false);
                        break;
                    }
                    case 12: {
                        transaction = new Transaction(registeredTransaction);
                        transaction.commit(false);
                        break;
                    }
                    case 3: 
                    case 15: {
                        transaction = new Transaction(registeredTransaction);
                        transaction.backout(false);
                    }
                }
            }
        }
        Transaction transaction = this.getTransaction();
        if (this.logFileType == 2) {
            this.namedObjects = null;
            for (ObjectStore objectStore : this.objectStores.values()) {
                objectStore.clear();
            }
        }
        for (ObjectStore objectStore : this.objectStores.values()) {
            if (!objectStore.getContainsRestartData()) continue;
            TreeMap namedObjectsTree = this.getNamedObjects(objectStore, transaction);
            if (this.namedObjects != null) continue;
            this.namedObjects = namedObjectsTree.getToken();
        }
        transaction.commit(false);
        trace.debug(cclass, "performWarmStart", (Object)("ObjectManager using logFile " + this.logFileName + " was warm started logFileType=" + ObjectManager.logFileTypeNames[this.logFileType]));
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "performWarmStart", new Object[]{this.coldStartLogFileName, new Date(this.coldStartTime)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performRecovery(LogInput logInput) throws ObjectManagerException {
        String methodName = "performRecovery";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "performRecovery", new Object[]{logInput});
        }
        this.checkpointEndSeen = false;
        try {
            while (true) {
                LogRecord logRecordRead = logInput.readNext();
                logRecordRead.performRecovery(this);
            }
        }
        catch (LogFileExhaustedException exception) {
            if (Tracing.isAnyTracingEnabled() && trace.isEventEnabled()) {
                trace.event(this, cclass, "performRecovery", exception);
            }
        }
        catch (ObjectManagerException exception) {
            ObjectManager.ffdc.processException(this, cclass, "performRecovery", exception, "1:751:1.62");
            this.shutdown();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "performRecovery", "ObjectManagerException:758");
            }
            throw exception;
        }
        if (!this.checkpointEndSeen) {
            this.shutdown();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "performRecovery", new Object[]{"CheckpointEndNotFoundException:774", this.logFileName});
            }
            throw new CheckpointEndNotFoundException((Object)this, this.logFileName);
        }
        ObjectManagerState objectManagerState = this;
        synchronized (objectManagerState) {
            this.setState(nextStateForLogReplayed);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "performRecovery");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCheckpoint(boolean persistentTransactions) throws ObjectManagerException {
        ObjectStore[] stores;
        Object registeredTransaction3;
        Iterator lock;
        String methodName = "performCheckpoint";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "performCheckpoint", new Boolean(persistentTransactions));
        }
        long now = System.currentTimeMillis();
        this.waitingBetweenCheckpointsMilliseconds += now - this.lastCheckpointMilliseconds;
        this.lastCheckpointMilliseconds = now;
        this.completeOrphanTransactions();
        long logSequenceNumber = 0L;
        if (persistentTransactions) {
            CheckpointStartLogRecord checkpointStartLogRecord = new CheckpointStartLogRecord(this);
            logSequenceNumber = this.logOutput.markAndWriteNext(checkpointStartLogRecord, 0L, false, true);
            long now2 = System.currentTimeMillis();
            this.flushingCheckpointStartMilliseconds += now2 - this.lastCheckpointMilliseconds;
            this.lastCheckpointMilliseconds = now2;
            this.checkpointStarting = 2;
            for (InternalTransaction registeredTransaction2 : this.registeredInternalTransactions.values()) {
                if (registeredTransaction2 == null) continue;
                registeredTransaction2.setRequiresCheckpoint();
            }
        } else {
            this.checkpointStarting = 1;
        }
        this.checkpointStarting = 0;
        Iterator registeredTransactionIterator = lock = new Iterator();
        synchronized (registeredTransactionIterator) {
            try {
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "performCheckpoint", new Object[]{"wait:867", new Integer(this.checkpointDelay)});
                }
                lock.wait(this.checkpointDelay);
            }
            catch (InterruptedException exception) {
                ObjectManager.ffdc.processException(this, cclass, "performCheckpoint", exception, "1:877:1.62");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "performCheckpoint", exception);
                }
                throw new UnexpectedExceptionException((Object)this, exception);
            }
        }
        long now3 = System.currentTimeMillis();
        this.pausedDuringCheckpointMilliseconds += now3 - this.lastCheckpointMilliseconds;
        this.lastCheckpointMilliseconds = now3;
        long transactionsRequiringCheckpoint = 0L;
        for (Object registeredTransaction3 : this.registeredInternalTransactions.values()) {
            if (registeredTransaction3 == null || !((InternalTransaction)registeredTransaction3).requiresPersistentCheckpoint) continue;
            ((InternalTransaction)registeredTransaction3).checkpoint(logSequenceNumber);
            ++transactionsRequiringCheckpoint;
        }
        this.totalTransactionsRequiringCheckpoint += transactionsRequiringCheckpoint;
        this.maximumTransactionsInAnyCheckpoint = Math.max(transactionsRequiringCheckpoint, this.maximumTransactionsInAnyCheckpoint);
        registeredTransaction3 = this.objectStores;
        synchronized (registeredTransaction3) {
            stores = this.objectStores.values().toArray(new ObjectStore[this.objectStores.size()]);
        }
        for (int i = 0; i < stores.length; ++i) {
            if (persistentTransactions) {
                stores[i].flush();
                continue;
            }
            if (stores[i].getPersistence()) continue;
            stores[i].flush();
        }
        long now4 = System.currentTimeMillis();
        this.flushingObjectStoresForCheckpointMilliseconds += now4 - this.lastCheckpointMilliseconds;
        this.lastCheckpointMilliseconds = now4;
        ++this.totalCheckpointsTaken;
        if (persistentTransactions) {
            CheckpointEndLogRecord checkpointEndLogRecord = new CheckpointEndLogRecord();
            this.logOutput.writeNext(checkpointEndLogRecord, 0L, false, false);
            this.logOutput.truncate();
            long now5 = System.currentTimeMillis();
            this.flushingEndCheckpointMilliseconds += now5 - this.lastCheckpointMilliseconds;
            this.lastCheckpointMilliseconds = now5;
            Map map = this.registeredInternalTransactions;
            synchronized (map) {
                if (this.logOutput.isOcupancyHigh()) {
                    this.currentMaximumActiveTransactions = Math.max(this.registeredInternalTransactions.size() / 2, 2);
                    InternalTransaction biggestTransaction = null;
                    long biggestTransactionSize = 0L;
                    for (InternalTransaction internalTransaction : this.registeredInternalTransactions.values()) {
                        long transactionSize = internalTransaction.getLogSpaceReserved();
                        if (transactionSize <= biggestTransactionSize || internalTransaction.state != 3) continue;
                        biggestTransaction = internalTransaction;
                        biggestTransactionSize = transactionSize;
                    }
                    if (biggestTransaction != null) {
                        block32: {
                            Transaction transaction = biggestTransaction.getExternalTransaction();
                            try {
                                if (biggestTransaction.state == 3) {
                                    if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                                        trace.debug((Object)this, cclass, "performCheckpoint", new Object[]{"Log too full, backing out biggestTransaction:995", biggestTransaction});
                                    }
                                    trace.warning((Object)this, cclass, "performCheckpoint", "ObjectManagerState_LogTooFull", biggestTransaction);
                                    transaction.setTerminationReason(3);
                                    transaction.backout(false);
                                }
                            }
                            catch (InvalidStateException exception) {
                                if (!Tracing.isAnyTracingEnabled() || !trace.isEventEnabled()) break block32;
                                trace.event(this, cclass, "performCheckpoint", exception);
                            }
                        }
                        this.requestCheckpoint(true);
                    }
                } else {
                    this.currentMaximumActiveTransactions = this.maximumActiveTransactions;
                }
                if (this.totalTransactions > this.currentMaximumActiveTransactions) {
                    this.totalTransactions -= this.freeTransactions.clear(this.totalTransactions - this.currentMaximumActiveTransactions);
                }
            }
        }
        if (persistentTransactions) {
            this.persistentTransactionsSinceLastCheckpoint = 0;
        }
        this.nonPersistentTransactionsSinceLastCheckpoint = 0;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "performCheckpoint");
        }
    }

    protected String getLogFileName() {
        return this.logFileName;
    }

    protected String getLogFileMode() {
        return this.logFileMode;
    }

    protected void saveClonedState(Transaction transaction) throws ObjectManagerException {
        String methodName = "saveClonedState";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "saveClonedState", transaction);
        }
        for (ObjectStore objectStore : this.objectStores.values()) {
            if (!objectStore.getContainsRestartData()) continue;
            Token objectManagerStateCloneToken = new Token(objectStore, ObjectStore.objectManagerStateIdentifier);
            ObjectManagerState objectManagerStateClone = (ObjectManagerState)(objectManagerStateCloneToken = objectStore.like(objectManagerStateCloneToken)).getManagedObject();
            if (objectManagerStateClone == null) {
                objectManagerStateClone = new ObjectManagerState();
                objectManagerStateClone.objectStores = this.objectStores;
                objectManagerStateClone.becomeCloneOf(this);
                objectManagerStateCloneToken.setManagedObject(objectManagerStateClone);
                transaction.add(objectManagerStateClone);
                continue;
            }
            transaction.lock(objectManagerStateClone);
            objectManagerStateClone.objectStores = this.objectStores;
            objectManagerStateClone.becomeCloneOf(this);
            transaction.replace(objectManagerStateClone);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "saveClonedState");
        }
    }

    protected final void waitForCheckpoint(boolean persistent) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "waitForCheckpoint");
        }
        this.checkpointHelper.waitForCheckpoint(persistent);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "waitForCheckpoint", "persistent=" + persistent + "(boolean)");
        }
    }

    protected final void requestCheckpoint(boolean persistent) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "requestCheckpoint", new Object[]{new Boolean(persistent)});
        }
        if (this.checkpointHelper != null) {
            this.checkpointHelper.requestCheckpoint(persistent);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "requestCheckpoint");
        }
    }

    protected final void suggestCheckpoint(boolean persistent) throws ObjectManagerException {
        if (trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "suggestCheckpoint", new Object[]{new Boolean(persistent)});
        }
        if (this.checkpointHelper != null) {
            this.checkpointHelper.suggestCheckpoint(persistent);
        }
        if (trace.isEntryEnabled()) {
            trace.exit(this, cclass, "suggestCheckpoint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void shutdown() throws ObjectManagerException {
        String methodName = "shutdown";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "shutdown");
        }
        Exception exceptionCaughtDuringShutdown = null;
        Object[] objectArray = this;
        synchronized (this) {
            this.setState(nextStateForStartShutdown);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.currentMaximumActiveTransactions = 0L;
            objectArray = this;
            synchronized (this) {
                Object[] objects;
                if (this.callbacks != null) {
                    for (ObjectManagerEventCallback callback : this.callbacks) {
                        callback.notification(0, null);
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "shutdown", "Backout remaining unprepared transactions:1231");
                }
                int[] transactionsPerState = new int[InternalTransaction.stateNames.length];
                try {
                    Iterator registeredTransactionIterator = this.registeredInternalTransactions.values().iterator();
                    while (registeredTransactionIterator.hasNext()) {
                        InternalTransaction registeredTransaction;
                        InternalTransaction internalTransaction = registeredTransaction = (InternalTransaction)registeredTransactionIterator.next();
                        synchronized (internalTransaction) {
                            if ((registeredTransaction.state == 1 || registeredTransaction.state == 2 || registeredTransaction.state == 3) && this.registeredInternalTransactions.get(new Long(registeredTransaction.getLogicalUnitOfWork().identifier)) == registeredTransaction) {
                                Transaction transaction = registeredTransaction.getExternalTransaction();
                                transaction.setTerminationReason(2);
                                transaction.backout(false);
                            }
                            int n = registeredTransaction.state;
                            transactionsPerState[n] = transactionsPerState[n] + 1;
                        }
                    }
                }
                catch (Exception exception) {
                    ObjectManager.ffdc.processException(this, cclass, "shutdown", exception, "1:1263:1.62");
                    exceptionCaughtDuringShutdown = exception;
                }
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    objects = new Object[transactionsPerState.length];
                    for (int i = 0; i < transactionsPerState.length; ++i) {
                        objects[i] = InternalTransaction.stateNames[i] + "=" + Integer.toString(transactionsPerState[i]);
                    }
                    trace.debug((Object)this, cclass, "shutdown", "Transactions in each state:1271");
                    trace.debug((Object)this, cclass, "shutdown", objects);
                }
                objects = this;
                synchronized (this) {
                    this.setState(nextStateForShutdown);
                    // ** MonitorExit[objects] (shouldn't be in output)
                    try {
                        if (this.checkpointHelper != null) {
                            this.checkpointHelper.waitForCheckpoint(true);
                            this.checkpointHelper.shutdown();
                            this.checkpointHelper = null;
                        }
                    }
                    catch (Exception exception) {
                        ObjectManager.ffdc.processException(this, cclass, "shutdown", exception, "1:1294:1.62");
                        exceptionCaughtDuringShutdown = exception;
                    }
                    try {
                        for (InternalTransaction internalTransaction : this.registeredInternalTransactions.values()) {
                            internalTransaction.shutdown();
                        }
                    }
                    catch (Exception exception) {
                        ObjectManager.ffdc.processException(this, cclass, "shutdown", exception, "1:1315:1.62");
                        exceptionCaughtDuringShutdown = exception;
                    }
                    Map exception = this.objectStores;
                    synchronized (exception) {
                        Iterator objectStoreIterator = this.objectStores.values().iterator();
                        while (objectStoreIterator.hasNext()) {
                            try {
                                ObjectStore objectStore = (ObjectStore)objectStoreIterator.next();
                                objectStore.close();
                            }
                            catch (Exception exception2) {
                                ObjectManager.ffdc.processException(this, cclass, "shutdown", exception2, "1:1334:1.62");
                                exceptionCaughtDuringShutdown = exception2;
                            }
                        }
                    }
                    try {
                        if (this.logOutput != null) {
                            this.logOutput.close();
                            this.logOutput = null;
                        }
                    }
                    catch (Exception exception2) {
                        ObjectManager.ffdc.processException(this, cclass, "shutdown", exception2, "1:1352:1.62");
                        exceptionCaughtDuringShutdown = exception2;
                    }
                    try {
                        if (this.logLock != null) {
                            this.logLock.release();
                        }
                        if (this.logFile != null) {
                            this.logFile.close();
                        }
                    }
                    catch (IOException exception3) {
                        ObjectManager.ffdc.processException(this, cclass, "shutdown", exception3, "1:1368:1.62");
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "shutdown", "via PermanentIOException");
                        }
                        throw new PermanentIOException((Object)this, exception3);
                    }
                    Object[] objectArray2 = ObjectManager.objectManagerStates;
                    synchronized (ObjectManager.objectManagerStates) {
                        ObjectManager.objectManagerStates.remove(this.logFileName);
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        this.registeredInternalTransactions.clear();
                        this.registeredInternalTransactions = null;
                        objectArray2 = this;
                        synchronized (this) {
                            this.notifyAll();
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            trace.debug(cclass, "shutdown", (Object)("ObjectManager using logFile " + this.logFileName + " has shut down."));
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "shutdown", new Object[]{exceptionCaughtDuringShutdown});
                            }
                            if (exceptionCaughtDuringShutdown != null) {
                                throw new UnexpectedExceptionException((Object)this, exceptionCaughtDuringShutdown);
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    protected void requestShutdown() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "shutdown");
        }
        new ShutdownHelper();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "requestShutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void shutdownFast() throws ObjectManagerException {
        String methodName = "shutdownFast";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "shutdownFast");
        }
        Exception exceptionCaughtDuringShutdown = null;
        if (!this.inShutdown()) {
            Cloneable cloneable = this;
            synchronized (cloneable) {
                this.setState(nextStateForStartShutdown);
            }
            this.notifyCallbacks(0, null);
            try {
                if (this.checkpointHelper != null) {
                    this.checkpointHelper.shutdown();
                    this.checkpointHelper = null;
                }
            }
            catch (Exception exception) {
                ObjectManager.ffdc.processException(this, cclass, "shutdownFast", exception, "1:1470:1.62");
                exceptionCaughtDuringShutdown = exception;
            }
            Object exception = this;
            synchronized (exception) {
                this.setState(nextStateForShutdown);
            }
            exception = this.objectStores;
            synchronized (exception) {
                Iterator objectStoreIterator = this.objectStores.values().iterator();
                while (objectStoreIterator.hasNext()) {
                    try {
                        ObjectStore objectStore = (ObjectStore)objectStoreIterator.next();
                        objectStore.close();
                    }
                    catch (Exception exception2) {
                        ObjectManager.ffdc.processException(this, cclass, "shutdownFast", exception2, "1:1491:1.62");
                        exceptionCaughtDuringShutdown = exception2;
                    }
                }
            }
            try {
                if (this.logOutput != null) {
                    this.logOutput.close();
                    this.logOutput = null;
                }
            }
            catch (Exception exception2) {
                ObjectManager.ffdc.processException(this, cclass, "shutdownFast", exception2, "1:1509:1.62");
                exceptionCaughtDuringShutdown = exception2;
            }
            try {
                if (this.logLock != null) {
                    this.logLock.release();
                }
                if (this.logFile != null) {
                    this.logFile.close();
                }
            }
            catch (IOException exception3) {
                ObjectManager.ffdc.processException(this, cclass, "shutdownFast", exception3, "1:1524:1.62");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "shutdownFast", "PermanentIOException:1530");
                }
                throw new PermanentIOException((Object)this, exception3);
            }
            cloneable = ObjectManager.objectManagerStates;
            synchronized (cloneable) {
                ObjectManager.objectManagerStates.remove(this.logFileName);
            }
            cloneable = this;
            synchronized (cloneable) {
                this.notifyAll();
            }
        }
        trace.debug(cclass, "shutdownFast", (Object)("ObjectManager using logFile " + this.logFileName + " has shut down without performing a final checkpoint"));
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "shutdownFast", new Object[]{exceptionCaughtDuringShutdown});
        }
        if (exceptionCaughtDuringShutdown != null) {
            throw new UnexpectedExceptionException((Object)this, exceptionCaughtDuringShutdown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerObjectStore(ObjectStore objectStore) throws ObjectManagerException {
        String methodName = "registerObjectStore";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "registerObjectStore", new Object[]{objectStore});
        }
        Map map = this.objectStores;
        synchronized (map) {
            ObjectStore existingObjectStore = this.getObjectStoreByName(objectStore.getName());
            if (existingObjectStore != null) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "registerObjectStore", new Object[]{"DuplicateObjectStoreNameException:1594", objectStore.getName()});
                }
                throw new DuplicateObjectStoreNameException((Object)this, objectStore.getName(), existingObjectStore);
            }
            objectStore.open(this);
            if (objectStore.getIdentifier() == -1) {
                ++this.maximumObjectStoreIdentifier;
                objectStore.setIdentifier((int)this.maximumObjectStoreIdentifier);
            } else {
                existingObjectStore = (ObjectStore)this.objectStores.get(new Integer(objectStore.getIdentifier()));
                if (existingObjectStore != null) {
                    objectStore.close();
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "registerObjectStore", new Object[]{"DuplicateObjectStoreNameException:1621", objectStore.getName()});
                    }
                    throw new DuplicateObjectStoreIdentifierException((Object)this, objectStore.getName(), objectStore.getIdentifier(), existingObjectStore);
                }
                this.maximumObjectStoreIdentifier = Math.max(this.maximumObjectStoreIdentifier, (long)objectStore.getIdentifier());
            }
            Transaction transaction = this.getTransaction();
            transaction.lock(this);
            try {
                this.objectStores.put(new Integer(objectStore.getIdentifier()), objectStore);
                transaction.replace(this);
                Token namedObjectsToken = null;
                if (objectStore.getContainsRestartData()) {
                    TreeMap namedObjectsTree = this.getNamedObjects(objectStore, transaction);
                    namedObjectsToken = namedObjectsTree.getToken();
                    if (this.namedObjects != null) {
                        namedObjectsTree.clear(transaction);
                        namedObjectsTree.putAll((TreeMap)this.namedObjects.getManagedObject(), transaction);
                    }
                }
                this.saveClonedState(transaction);
                long newCheckpointStartLogRecordSize = (new CheckpointStartLogRecord(this).getBytesLeft() / 4096 + 1) * 4096;
                this.logOutput.reserve(newCheckpointStartLogRecordSize - this.checkpointStartLogRecordSize);
                this.checkpointStartLogRecordSize = newCheckpointStartLogRecordSize;
                transaction.commit(false);
                if (this.namedObjects == null) {
                    this.namedObjects = namedObjectsToken;
                }
            }
            catch (ObjectManagerException exception) {
                ObjectManager.ffdc.processException(this, cclass, "registerObjectStore", exception, "1:1683:1.62");
                this.objectStores.remove(new Integer(objectStore.getIdentifier()));
                transaction.backout(false);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "registerObjectStore", new Object[]{exception});
                }
                throw exception;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "registerObjectStore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renameObjectStore(ObjectStore objectStore, String newName) throws ObjectManagerException {
        String methodName = "renameObjectStore";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "renameObjectStore", new Object[]{objectStore, newName});
        }
        Map map = this.objectStores;
        synchronized (map) {
            ObjectStore existingObjectStore = this.getObjectStoreByName(objectStore.getName());
            if (existingObjectStore == null) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "renameObjectStore", new Object[]{"Store not registered:1724"});
                }
                return;
            }
            existingObjectStore = this.getObjectStoreByName(newName);
            if (existingObjectStore != null) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "renameObjectStore", new Object[]{"DuplicateObjectStoreNameException:1735", newName, objectStore.getName()});
                }
                throw new DuplicateObjectStoreNameException((Object)this, newName, existingObjectStore);
            }
            Transaction transaction = this.getTransaction();
            transaction.lock(this);
            String oldName = objectStore.getName();
            try {
                objectStore.setLogicalName(newName);
                transaction.replace(this);
                this.saveClonedState(transaction);
                long newCheckpointStartLogRecordSize = (new CheckpointStartLogRecord(this).getBytesLeft() / 4096 + 1) * 4096;
                this.logOutput.reserve(newCheckpointStartLogRecordSize - this.checkpointStartLogRecordSize);
                this.checkpointStartLogRecordSize = newCheckpointStartLogRecordSize;
                transaction.commit(false);
            }
            catch (ObjectManagerException exception) {
                ObjectManager.ffdc.processException(this, cclass, "renameObjectStore", exception, "1:1773:1.62");
                if (objectStore instanceof AbstractObjectStore) {
                    ((AbstractObjectStore)objectStore).storeName = oldName;
                }
                transaction.backout(false);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "renameObjectStore", new Object[]{exception});
                }
                throw exception;
            }
        }
        this.waitForCheckpoint(true);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "renameObjectStore");
        }
    }

    private final TreeMap getNamedObjects(ObjectStore objectStore, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getNamedObjects", new Object[]{objectStore, transaction});
        }
        Token namedObjectsToken = new Token(objectStore, ObjectStore.namedObjectTreeIdentifier);
        TreeMap namedObjectsTree = (TreeMap)(namedObjectsToken = objectStore.like(namedObjectsToken)).getManagedObject();
        if (namedObjectsTree == null) {
            namedObjectsTree = new TreeMap();
            namedObjectsToken.setManagedObject(namedObjectsTree);
            namedObjectsTree.reserveAndAdd(transaction, objectStore);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getNamedObjects", new Object[]{namedObjectsTree});
        }
        return namedObjectsTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deRegisterObjectStore(ObjectStore objectStore) throws ObjectManagerException {
        String methodName = "deRegisterObjectStore";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "deRegisterObjectStore", new Object[]{objectStore});
        }
        this.waitForCheckpoint(objectStore.getPersistence());
        Map map = this.objectStores;
        synchronized (map) {
            Transaction transaction = this.getTransaction();
            transaction.lock(this);
            if (this.namedObjects != null && this.namedObjects.getObjectStore() == objectStore) {
                this.namedObjects = null;
            }
            objectStore.close();
            this.objectStores.remove(new Integer(objectStore.getIdentifier()));
            transaction.replace(this);
            this.saveClonedState(transaction);
            long newCheckpointStartLogRecordSize = (new CheckpointStartLogRecord(this).getBytesLeft() / 4096 + 1) * 4096;
            this.logOutput.reserve(newCheckpointStartLogRecordSize - this.checkpointStartLogRecordSize);
            this.checkpointStartLogRecordSize = newCheckpointStartLogRecordSize;
            transaction.commit(false);
            this.setDefinitiveNamedObjects();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "deRegisterObjectStore");
        }
    }

    private void setDefinitiveNamedObjects() {
        Iterator objectStoreIterator = this.objectStores.values().iterator();
        while (objectStoreIterator.hasNext() && this.namedObjects == null) {
            ObjectStore objectStore = (ObjectStore)objectStoreIterator.next();
            if (!objectStore.getContainsRestartData()) continue;
            Token namedObjectsToken = new Token(objectStore, ObjectStore.namedObjectTreeIdentifier);
            this.namedObjects = objectStore.like(namedObjectsToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectStore getObjectStore(int objectStoreIdentifier) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getObjectStore", new Integer(objectStoreIdentifier));
        }
        ObjectStore objectStore = null;
        if (objectStoreIdentifier == 0) {
            objectStore = this.defaultObjectStore;
        } else {
            Map map = this.objectStores;
            synchronized (map) {
                objectStore = (ObjectStore)this.objectStores.get(new Integer(objectStoreIdentifier));
                if (objectStore == null) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "getOjectStore", "via NonEexistantObjectStoreException objectStoreIdentifier=" + objectStoreIdentifier + "(int)");
                    }
                    throw new NonExistentObjectStoreException(this, objectStoreIdentifier);
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getObjectStore", objectStore);
        }
        return objectStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ObjectStore getObjectStore(String objectStoreName) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getObjectStore", "objectStoreName=" + objectStoreName + "(String)");
        }
        ObjectStore objectStore = null;
        Map map = this.objectStores;
        synchronized (map) {
            objectStore = this.getObjectStoreByName(objectStoreName);
        }
        if (objectStore == null) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "getObjectStore", "via UnknownObjectStoreException objectStoreName=" + objectStoreName + "(String)");
            }
            throw new UnknownObjectStoreException((Object)this, objectStoreName);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getObjectStore", "returns objectStore=" + objectStore + "(ObjectStore)");
        }
        return objectStore;
    }

    private final ObjectStore getObjectStoreByName(String objectStoreName) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getObjectStoreByName", new String(objectStoreName));
        }
        ObjectStore objectStore = null;
        Iterator objectStoreIterator = this.objectStores.values().iterator();
        while (objectStoreIterator.hasNext() && objectStore == null) {
            ObjectStore existingObjectStore = (ObjectStore)objectStoreIterator.next();
            if (!existingObjectStore.getName().equals(objectStoreName)) continue;
            objectStore = existingObjectStore;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getObjectStoreByName", "returns objectStore=" + objectStore + "(ObjectStore)");
        }
        return objectStore;
    }

    final Iterator getObjectStoreIterator() throws ObjectManagerException {
        String methodName = "getObjectStoreIterator";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getObjectStoreIterator");
        }
        ArrayList storesList = new ArrayList(this.objectStores.values());
        Iterator objectStoreIterator = storesList.iterator();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getObjectStoreIterator", objectStoreIterator);
        }
        return objectStoreIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Transaction getTransaction() throws ObjectManagerException {
        InternalTransaction internalTransaction;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getTransaction");
        }
        if ((internalTransaction = (InternalTransaction)this.freeTransactions.removeOne()) != null) {
            this.registerTransaction(internalTransaction);
            ++this.reusedTransactions;
        } else {
            Map map = this.registeredInternalTransactions;
            synchronized (map) {
                if (this.totalTransactions >= this.maximumActiveTransactions) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "getTransaction", new Object[]{new Long(this.totalTransactions), new Long(this.maximumActiveTransactions)});
                    }
                    throw new TooManyTransactionsException(this, this.maximumActiveTransactions);
                }
                if (this.totalTransactions >= this.currentMaximumActiveTransactions) {
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "getTransaction", new Object[]{new Long(this.totalTransactions), new Long(this.currentMaximumActiveTransactions)});
                    }
                    throw new TransactionCapacityExceededException(this, this.totalTransactions, this.currentMaximumActiveTransactions);
                }
                internalTransaction = new InternalTransaction(this, new LogicalUnitOfWork(++this.maximumLogicalUnitOfWorkIdentifier));
                ++this.totalTransactions;
            }
        }
        Transaction transaction = internalTransaction.getExternalTransaction();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getTransaction", transaction);
        }
        return transaction;
    }

    protected final void registerTransaction(InternalTransaction internalTransaction) throws ObjectManagerException {
        String methodName = "registerTransaction";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "registerTransaction", internalTransaction);
        }
        LogicalUnitOfWork logicalUnitOfWork = internalTransaction.getLogicalUnitOfWork();
        internalTransaction.registeredTick = System.currentTimeMillis();
        internalTransaction.registeredTid = Thread.currentThread().getId();
        internalTransaction.registeredName = Thread.currentThread().getName();
        InternalTransaction registeredTransaction = this.registeredInternalTransactions.put(new Long(logicalUnitOfWork.identifier), internalTransaction);
        if (registeredTransaction != null) {
            registeredTransaction.terminate(5);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "registerTransaction", new Object[]{internalTransaction, registeredTransaction});
            }
            throw new DuplicateTransactionException(this, internalTransaction, registeredTransaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "registerTransaction");
        }
    }

    protected final void deRegisterTransaction(InternalTransaction internalTransaction) throws ObjectManagerException {
        String methodName = "deRegisterTransaction";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "deRegisterTransaction", new Object[]{internalTransaction});
        }
        LogicalUnitOfWork logicalUnitOfWork = internalTransaction.getLogicalUnitOfWork();
        InternalTransaction registeredTransaction = (InternalTransaction)this.registeredInternalTransactions.remove(new Long(logicalUnitOfWork.identifier));
        if (registeredTransaction == null) {
            internalTransaction.terminate(5);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "deRegisterTransaction", new Object[]{"via NonExistantTransactionException", logicalUnitOfWork});
            }
            throw new NonExistentTransactionException((Object)this, internalTransaction);
        }
        internalTransaction.freeTick = System.currentTimeMillis();
        internalTransaction.freeTid = Thread.currentThread().getId();
        internalTransaction.freeName = Thread.currentThread().getName();
        InternalTransaction freeTransaction = (InternalTransaction)this.freeTransactions.put(new Long(logicalUnitOfWork.identifier), internalTransaction);
        if (freeTransaction != null) {
            internalTransaction.terminate(5);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "deRegisterTransaction", new Object[]{internalTransaction, freeTransaction});
            }
            throw new DuplicateTransactionException(this, internalTransaction, freeTransaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "deRegisterTransaction");
        }
    }

    protected final void transactionCompleted(InternalTransaction internalTransaction, boolean persistentWorkDone) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "transactionCompleted", new Object[]{internalTransaction, new Boolean(persistentWorkDone)});
        }
        if (persistentWorkDone) {
            ++this.persistentTransactionsSinceLastCheckpoint;
            if ((long)this.persistentTransactionsSinceLastCheckpoint > this.persistentTransactionsPerCheckpoint) {
                this.suggestCheckpoint(true);
            }
        } else {
            ++this.nonPersistentTransactionsSinceLastCheckpoint;
            if ((long)this.nonPersistentTransactionsSinceLastCheckpoint > this.nonPersistentTransactionsPerCheckpoint) {
                this.suggestCheckpoint(false);
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "transactionCompleted");
        }
    }

    protected final void transactionPacing() throws ObjectManagerException {
        LogOutput localLogOutput;
        String methodName = "transactionPacing";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "transactionPacing");
        }
        if ((localLogOutput = this.logOutput) == null) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "transactionPacing", new Object[]{new Integer(this.state), stateNames[this.state]});
            }
            throw new InvalidStateException((Object)this, this.state, stateNames[this.state]);
        }
        if (localLogOutput.isOcupancyHigh()) {
            ++this.transactionsDelayedForLogFull;
            this.waitForCheckpoint(true);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "transactionPacing");
        }
    }

    protected final Transaction getTransaction(LogicalUnitOfWork logicalUnitOfWork) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getTransaction", new Object[]{logicalUnitOfWork});
        }
        InternalTransaction internalTransaction = null;
        internalTransaction = (InternalTransaction)this.registeredInternalTransactions.get(new Long(logicalUnitOfWork.identifier));
        if (internalTransaction == null && (internalTransaction = (InternalTransaction)this.freeTransactions.remove(new Long(logicalUnitOfWork.identifier))) != null) {
            this.registerTransaction(internalTransaction);
        }
        if (internalTransaction == null) {
            this.maximumLogicalUnitOfWorkIdentifier = Math.max(logicalUnitOfWork.identifier, this.maximumLogicalUnitOfWorkIdentifier);
            internalTransaction = new InternalTransaction(this, logicalUnitOfWork);
        } else if (logicalUnitOfWork.XID != null && internalTransaction.getXID() == null) {
            internalTransaction.setXID(logicalUnitOfWork.XID);
        }
        Transaction transaction = new Transaction(internalTransaction);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getTransaction", transaction);
        }
        return transaction;
    }

    protected final Transaction getTransactionByXID(byte[] XID) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getTransactionByXID");
            trace.bytes(this, cclass, XID);
        }
        Transaction externalTransaction = null;
        for (InternalTransaction internalTransaction : this.registeredInternalTransactions.values()) {
            byte[] transactionXID = internalTransaction.getXID();
            if (!Arrays.equals(transactionXID, XID)) continue;
            externalTransaction = internalTransaction.getExternalTransaction();
            break;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getTransactionByXID", "returns externalTransaction=" + externalTransaction + "(Transaction)");
        }
        return externalTransaction;
    }

    protected final Iterator getTransactionIterator() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getTransactionIterator");
        }
        TransactionIterator transactionIterator = new TransactionIterator();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getTransactionIterator", transactionIterator);
        }
        return transactionIterator;
    }

    private void completeOrphanTransactions() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "completeOrphanTransactions");
        }
        InternalTransaction.TransactionReference transactionReference = (InternalTransaction.TransactionReference)this.orphanTransactionsQueue.poll();
        while (transactionReference != null) {
            boolean skipComplete = false;
            Long ID = new Long(transactionReference.getLogicalUnitOfWork().identifier);
            if (!this.registeredInternalTransactions.containsKey(ID)) {
                trace.warning((Object)this, cclass, "completeOrphanTransactions", "InternalTransaction_OrphanDiagnostics", new Object[]{transactionReference.getTransactionString(), "" + System.currentTimeMillis(), this.freeTransactions.containsKey(ID) ? "free" : "unknown"});
                skipComplete = transactionReference.isUnused();
            }
            if (!skipComplete) {
                transactionReference.complete();
            }
            transactionReference = (InternalTransaction.TransactionReference)this.orphanTransactionsQueue.poll();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "completeOrphanTransactions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getDummyLogSequenceNumber() throws ObjectManagerException {
        long usableLogSequenceNumber;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getDummyLogSequenceNumber");
        }
        Object object = this.dummyLogSequenceNumberLock;
        synchronized (object) {
            ++this.dummyLogSequenceNumber;
            usableLogSequenceNumber = this.dummyLogSequenceNumber;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getDummyLogSequenceNumber", new Long(usableLogSequenceNumber));
        }
        return usableLogSequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long getGlobalTransactionUnlockSequence() {
        Object object = this.transactionUnlockSequenceLock;
        synchronized (object) {
            return this.transactionUnlockSequence;
        }
    }

    protected final long getNewGlobalTransactionUnlockSequence() {
        return ++this.transactionUnlockSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ObjectManagerByteArrayOutputStream getbyteArrayOutputStreamFromPool(int idealSize) {
        int index = Thread.currentThread().hashCode();
        index = (index >>> 5) % this.byteArrayOutputStreamPools.length;
        List byteArrayOutputStreamPool = this.byteArrayOutputStreamPools[index];
        ObjectManagerByteArrayOutputStream byteArrayOutputStream = null;
        List list = byteArrayOutputStreamPool;
        synchronized (list) {
            byteArrayOutputStream = byteArrayOutputStreamPool.isEmpty() || idealSize > maximumByteArrayOutputStreamSize ? new ObjectManagerByteArrayOutputStream(idealSize) : (ObjectManagerByteArrayOutputStream)byteArrayOutputStreamPool.remove(byteArrayOutputStreamPool.size() - 1);
        }
        return byteArrayOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void returnByteArrayOutputStreamToPool(ObjectManagerByteArrayOutputStream byteArrayOutputStream) {
        int index = Thread.currentThread().hashCode();
        index = (index >>> 5) % this.byteArrayOutputStreamPools.length;
        List byteArrayOutputStreamPool = this.byteArrayOutputStreamPools[index];
        if (byteArrayOutputStream.size() <= maximumByteArrayOutputStreamSize) {
            List list = byteArrayOutputStreamPool;
            synchronized (list) {
                if (byteArrayOutputStreamPool.size() < byteArrayOutputStreamPoolSize) {
                    byteArrayOutputStream.reset();
                    byteArrayOutputStreamPool.add(byteArrayOutputStream);
                }
            }
        }
    }

    protected Map captureStatistics() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "captureStatistics");
        }
        HashMap<String, String> statistics = new HashMap<String, String>();
        statistics.put("totalCheckpointsTaken", Long.toString(this.totalCheckpointsTaken));
        statistics.put("waitingBetweenCheckpointsMilliseconds", Long.toString(this.waitingBetweenCheckpointsMilliseconds));
        statistics.put("flushingCheckpointStartMilliseconds", Long.toString(this.flushingCheckpointStartMilliseconds));
        statistics.put("pausedDuringCheckpointMilliseconds", Long.toString(this.pausedDuringCheckpointMilliseconds));
        statistics.put("flushingObjectStoresForCheckpointMilliseconds", Long.toString(this.flushingObjectStoresForCheckpointMilliseconds));
        statistics.put("flushingEndCheckpointMilliseconds", Long.toString(this.flushingEndCheckpointMilliseconds));
        statistics.put("threadsWaitingForCheckpoint", Integer.toString(this.checkpointHelper.threadsWaitingForCheckpoint));
        statistics.put("currentMaximumActiveTransactions", Long.toString(this.currentMaximumActiveTransactions));
        statistics.put("registeredInternalTransactions.size()", Integer.toString(this.registeredInternalTransactions.size()));
        statistics.put("freeTransactions.size()", Integer.toString(this.freeTransactions.size()));
        statistics.put("totalTransactions", Long.toString(this.totalTransactions));
        statistics.put("reusedTransactions", Long.toString(this.reusedTransactions));
        statistics.put("totalTransactionsRequiringCheckpoint", Long.toString(this.totalTransactionsRequiringCheckpoint));
        statistics.put("maximumTransactionsInAnyCheckpoint", Long.toString(this.maximumTransactionsInAnyCheckpoint));
        statistics.put("transactionsDelaydForLogFull", Long.toString(this.transactionsDelayedForLogFull));
        int byteArrayOutputStreamPoolsSize = 0;
        for (int i = 0; i < this.byteArrayOutputStreamPools.length; ++i) {
            byteArrayOutputStreamPoolsSize += this.byteArrayOutputStreamPools[i].size();
        }
        statistics.put("byteArrayOutputStreamPoolsSize", Integer.toString(byteArrayOutputStreamPoolsSize));
        this.totalCheckpointsTaken = 0L;
        this.waitingBetweenCheckpointsMilliseconds = 0L;
        this.flushingCheckpointStartMilliseconds = 0L;
        this.pausedDuringCheckpointMilliseconds = 0L;
        this.flushingObjectStoresForCheckpointMilliseconds = 0L;
        this.flushingEndCheckpointMilliseconds = 0L;
        this.reusedTransactions = 0L;
        this.totalTransactionsRequiringCheckpoint = 0L;
        this.maximumTransactionsInAnyCheckpoint = 0L;
        this.transactionsDelayedForLogFull = 0L;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "captureStatistics", statistics);
        }
        return statistics;
    }

    protected int getObjectManagerStateState() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getState");
        }
        int stateToReturn = this.state;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getState", stateToReturn + " " + stateNames[stateToReturn]);
        }
        return stateToReturn;
    }

    void setState(int[] nextState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setState", new Object[]{nextState, new Integer(this.state), stateNames[this.state]});
        }
        this.previousState = this.state;
        this.state = nextState[this.state];
        if (this.state == 0) {
            StateErrorException stateErrorException = new StateErrorException((Object)this, this.previousState, stateNames[this.previousState]);
            ObjectManager.ffdc.processException(this, cclass, "setState", stateErrorException, "1:2674:1.62");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "setState", new Object[]{stateErrorException, new Integer(this.state), stateNames[this.state]});
            }
            throw stateErrorException;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "setState", new Object[]{new Integer(this.state), stateNames[this.state]});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void becomeCloneOf(ManagedObject other) throws ObjectManagerException {
        String methodName = "becomeCloneOf";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "becomeCloneOf", other);
        }
        ObjectManagerState otherObjectManagerState = (ObjectManagerState)other;
        this.maximumObjectStoreIdentifier = otherObjectManagerState.maximumObjectStoreIdentifier;
        this.persistentTransactionsPerCheckpoint = otherObjectManagerState.persistentTransactionsPerCheckpoint;
        this.nonPersistentTransactionsPerCheckpoint = otherObjectManagerState.nonPersistentTransactionsPerCheckpoint;
        this.logFullTriggerCheckpointThreshold = otherObjectManagerState.logFullTriggerCheckpointThreshold;
        this.logFullPostCheckpointThreshold = otherObjectManagerState.logFullPostCheckpointThreshold;
        this.maximumActiveTransactions = otherObjectManagerState.maximumActiveTransactions;
        this.checkpointDelay = otherObjectManagerState.checkpointDelay;
        this.coldStartLogFileName = otherObjectManagerState.coldStartLogFileName;
        this.coldStartTime = otherObjectManagerState.coldStartTime;
        if (this.mainObjectManagerState) {
            Map map = this.objectStores;
            synchronized (map) {
                this.mergeObjectStores(otherObjectManagerState);
                this.setDefinitiveNamedObjects();
            }
        } else {
            this.objectStores = otherObjectManagerState.objectStores;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "becomeCloneOf");
        }
    }

    private void mergeObjectStores(ObjectManagerState otherObjectManagerState) throws ObjectManagerException {
        for (ObjectStore objectStore : otherObjectManagerState.objectStores.values()) {
            Object existingStore = this.objectStores.get(new Integer(objectStore.getIdentifier()));
            if (existingStore != null) continue;
            objectStore.open(this);
            this.objectStores.put(new Integer(objectStore.getIdentifier()), objectStore);
            if (!objectStore.getContainsRestartData() || this.namedObjects != null) continue;
            Token namedObjectsToken = new Token(objectStore, ObjectStore.namedObjectTreeIdentifier);
            namedObjectsToken = objectStore.like(namedObjectsToken);
        }
        for (ObjectStore objectStore : this.objectStores.values()) {
            Object newObjectStore = otherObjectManagerState.objectStores.get(new Integer(objectStore.getIdentifier()));
            if (newObjectStore != null) continue;
            objectStore.close();
            this.objectStores.remove(new Integer(objectStore.getIdentifier()));
            if (this.namedObjects == null || this.namedObjects.getObjectStore() != objectStore) continue;
            this.namedObjects = null;
        }
    }

    ObjectManagerState() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "<init>");
        }
        this.mainObjectManagerState = false;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    protected int getSignature() {
        return 4;
    }

    @Override
    public long estimatedLength() {
        return this.serializedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(DataOutputStream dataOutputStream) throws ObjectManagerException {
        String methodName = "writeObject";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeObject", dataOutputStream);
        }
        try {
            dataOutputStream.writeByte(0);
            super.writeObject(dataOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(dataOutputStream);
            Map map = this.objectStores;
            synchronized (map) {
                objectOutputStream.writeObject(this.objectStores);
            }
            objectOutputStream.close();
            dataOutputStream.writeLong(this.maximumObjectStoreIdentifier);
            dataOutputStream.writeLong(this.persistentTransactionsPerCheckpoint);
            dataOutputStream.writeLong(this.nonPersistentTransactionsPerCheckpoint);
            dataOutputStream.writeFloat(this.logFullTriggerCheckpointThreshold);
            dataOutputStream.writeFloat(this.logFullPostCheckpointThreshold);
            dataOutputStream.writeLong(this.maximumActiveTransactions);
            dataOutputStream.writeInt(this.checkpointDelay);
            dataOutputStream.writeUTF(this.coldStartLogFileName);
            dataOutputStream.writeLong(this.coldStartTime);
            this.serializedSize = dataOutputStream.size();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "writeObject", exception, "1:2887:1.62");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "writeObject", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeObject");
        }
    }

    @Override
    public void readObject(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "readObject";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readObject", new Object[]{dataInputStream, objectManagerState});
        }
        try {
            byte version = dataInputStream.readByte();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "readObject", new Byte(version));
            }
            super.readObject(dataInputStream, objectManagerState);
            ObjectInputStream objectInputStream = new ObjectInputStream(dataInputStream);
            this.objectStores = (Map)objectInputStream.readObject();
            objectInputStream.close();
            this.maximumObjectStoreIdentifier = dataInputStream.readLong();
            this.persistentTransactionsPerCheckpoint = dataInputStream.readLong();
            this.nonPersistentTransactionsPerCheckpoint = dataInputStream.readLong();
            this.logFullTriggerCheckpointThreshold = dataInputStream.readFloat();
            this.logFullPostCheckpointThreshold = dataInputStream.readFloat();
            this.maximumActiveTransactions = dataInputStream.readLong();
            this.checkpointDelay = dataInputStream.readInt();
            this.coldStartLogFileName = dataInputStream.readUTF();
            dataInputStream.readLong();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:2999:1.62");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "readObject", new Object[]{"PermanentIOException:%C", exception});
            }
            throw new PermanentIOException((Object)this, exception);
        }
        catch (java.lang.ClassNotFoundException exception) {
            ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:3015:1.62");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "readObject", new Object[]{"ClassNotFoundException:3021", exception});
            }
            throw new ClassNotFoundException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readObject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerEventCallback(ObjectManagerEventCallback callback) {
        String methodName = "registerEventCallback";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "registerEventCallback", callback);
        }
        ArrayList arrayList = this.callbacks;
        synchronized (arrayList) {
            this.callbacks.add(callback);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "registerEventCallback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCallbacks(int event, Object[] args) {
        String methodName = "notifyCallbacks";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "notifyCallbacks", new Object[]{new Integer(event), args});
        }
        ArrayList arrayList = this.callbacks;
        synchronized (arrayList) {
            for (ObjectManagerEventCallback callback : this.callbacks) {
                callback.notification(event, args);
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "notifyCallbacks");
        }
    }

    protected boolean inShutdown() throws ObjectManagerException {
        return this.getObjectManagerStateState() == 5 || this.getObjectManagerStateState() == 6;
    }

    @Override
    public String toString() {
        return new String("ObjectManagerState(" + this.logFileName + ")/" + stateNames[this.state] + " " + super.toString());
    }

    static {
        block2: {
            cclass = ObjectManagerState.class;
            trace = ObjectManager.traceFactory.getTrace(ObjectManagerState.class, "ObjectManager");
            numberOfProcessors = 1;
            try {
                Method availableProcessorsMethod = Runtime.class.getMethod("availableProcessors", new Class[0]);
                Integer integer = (Integer)availableProcessorsMethod.invoke((Object)Runtime.getRuntime(), new Object[0]);
                numberOfProcessors = integer;
            }
            catch (Exception exception) {
                if (!Tracing.isAnyTracingEnabled() || !trace.isEventEnabled()) break block2;
                trace.event(cclass, "<init>", exception);
            }
        }
        stateNames = new String[]{"Error", "OpeningLog", "ReplayingLog", "WarmStarted", "ColdStarted", "ShutdownStarted", "Stopped"};
        nextStateForLogFailedToOpen = new int[]{0, 4, 0, 0, 0, 0, 0};
        nextStateForLogOpened = new int[]{0, 2, 0, 0, 0, 0, 0};
        nextStateForLogReplayed = new int[]{0, 0, 3, 0, 0, 0, 0};
        nextStateForStartShutdown = new int[]{0, 5, 5, 5, 5, 0, 0};
        nextStateForShutdown = new int[]{0, 0, 0, 0, 0, 6, 0};
        byteArrayOutputStreamPoolsSize = 8;
        byteArrayOutputStreamPoolSize = 200;
        maximumByteArrayOutputStreamSize = 4096;
    }

    private class ShutdownHelper
    implements Runnable {
        ShutdownHelper() {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "<init>");
            }
            Thread shutdownThread = new Thread(this);
            shutdownThread.setName("ShutdownHelper");
            shutdownThread.start();
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        @Override
        public void run() {
            String methodName = "run";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "run");
            }
            try {
                ObjectManagerState.this.shutdownFast();
            }
            catch (Exception exception) {
                ObjectManager.ffdc.processException(this, cclass, "run", exception, "1:3516:1.62");
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "run");
            }
        }
    }

    protected class CheckpointHelper
    implements Runnable {
        private boolean running = true;
        private boolean waiting = false;
        private boolean checkpointRequested = false;
        private boolean persistentTransactions = false;
        private Exception abnormalTerminationException = null;
        private long checkpointCycle = 0L;
        protected Thread checkpointThread = null;
        private int threadsWaitingForCheckpoint = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CheckpointHelper() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "<init>");
            }
            this.checkpointThread = new Thread(this);
            this.checkpointThread.setName("CheckpointHelper");
            this.checkpointThread.setPriority(6);
            CheckpointHelper checkpointHelper = this;
            synchronized (checkpointHelper) {
                this.checkpointThread.start();
                try {
                    this.wait();
                }
                catch (InterruptedException exception) {
                    ObjectManager.ffdc.processException(this, cclass, "waitForCheckpoint", exception, "1:3180:1.62");
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "waitForCheckpoint", exception);
                    }
                    throw new UnexpectedExceptionException((Object)this, exception);
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "run");
            }
            try {
                while (true) {
                    boolean nextCheckpointPersistentence;
                    CheckpointHelper checkpointHelper = this;
                    synchronized (checkpointHelper) {
                        ++this.checkpointCycle;
                        this.notifyAll();
                        this.threadsWaitingForCheckpoint = 0;
                        if (!this.running) {
                            break;
                        }
                        if (!this.checkpointRequested) {
                            this.waiting = true;
                            this.wait();
                            this.waiting = false;
                        }
                        this.checkpointRequested = false;
                        nextCheckpointPersistentence = this.persistentTransactions;
                        this.persistentTransactions = false;
                    }
                    if (!this.running) continue;
                    ObjectManagerState.this.performCheckpoint(nextCheckpointPersistentence);
                }
            }
            catch (Exception exception) {
                ObjectManager.ffdc.processException(this, cclass, "run", exception, "1:3247:1.62");
                this.running = false;
                this.abnormalTerminationException = exception;
                ObjectManagerState.this.requestShutdown();
                CheckpointHelper checkpointHelper = this;
                synchronized (checkpointHelper) {
                    this.notifyAll();
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "run");
            }
        }

        synchronized void requestCheckpoint(boolean persistent) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "requestCheckpoint", new Object[]{new Boolean(persistent)});
            }
            if (this.abnormalTerminationException != null) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "requestCheckpoint", this.abnormalTerminationException);
                }
                throw new UnexpectedExceptionException((Object)this, this.abnormalTerminationException);
            }
            this.checkpointRequested = true;
            boolean bl = this.persistentTransactions = this.persistentTransactions || persistent;
            if (this.waiting) {
                this.notify();
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "requestCheckpoint");
            }
        }

        synchronized void suggestCheckpoint(boolean persistent) throws ObjectManagerException {
            if (trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "suggestCheckpoint", new Object[]{new Boolean(persistent)});
            }
            if (this.abnormalTerminationException != null) {
                if (trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "requestCheckpoint", this.abnormalTerminationException);
                }
                throw new UnexpectedExceptionException((Object)this, this.abnormalTerminationException);
            }
            boolean bl = this.persistentTransactions = this.persistentTransactions || persistent;
            if (this.waiting) {
                this.checkpointRequested = true;
                this.notify();
            }
            if (trace.isEntryEnabled()) {
                trace.exit(this, cclass, "suggestCheckpoint");
            }
        }

        private synchronized void waitForCheckpoint(boolean persistent) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "waitForCheckpoint", new Boolean(persistent));
            }
            long endCycle = this.waiting ? this.checkpointCycle : this.checkpointCycle + 1L;
            while (endCycle >= this.checkpointCycle && this.abnormalTerminationException == null) {
                this.requestCheckpoint(persistent);
                ++this.threadsWaitingForCheckpoint;
                try {
                    this.wait();
                }
                catch (InterruptedException exception) {
                    ObjectManager.ffdc.processException(this, cclass, "waitForCheckpoint", exception, "1:3393:1.62");
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "waitForCheckpoint", exception);
                    }
                    throw new UnexpectedExceptionException((Object)this, exception);
                }
            }
            if (this.abnormalTerminationException != null) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "waitForCheckpoint", this.abnormalTerminationException);
                }
                throw new UnexpectedExceptionException((Object)this, this.abnormalTerminationException);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "waitForCheckpoint");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "shutdown");
            }
            CheckpointHelper checkpointHelper = this;
            synchronized (checkpointHelper) {
                this.running = false;
                if (this.waiting) {
                    this.notify();
                }
            }
            try {
                this.checkpointThread.join();
            }
            catch (InterruptedException exception) {
                ObjectManager.ffdc.processException(this, cclass, "shutdown", exception, "1:3450:1.62");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "shutdown", exception);
                }
                throw new UnexpectedExceptionException((Object)this, exception);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "shutdown");
            }
        }
    }

    private class TransactionIterator
    implements Iterator {
        Iterator internalTransactionIterator;

        TransactionIterator() {
            this.internalTransactionIterator = ObjectManagerState.this.registeredInternalTransactions.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.internalTransactionIterator.hasNext();
        }

        public Object next() {
            InternalTransaction internalTransaction = (InternalTransaction)this.internalTransactionIterator.next();
            Transaction transaction = internalTransaction.getExternalTransaction();
            return transaction;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

