/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.utils.Printable;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public abstract class LogOutput
implements Printable {
    private static final Class cclass = LogOutput.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerLog");
    public static final boolean gatherStatistics = true;
    protected long logSequenceNumber = 0L;
    protected long reserved = 0L;

    protected LogOutput() throws ObjectManagerException {
    }

    protected abstract void close() throws ObjectManagerException;

    protected abstract void setLogFileSize(long var1) throws ObjectManagerException;

    protected abstract long getLogFileSize();

    protected abstract long getLogFileSizeRequested();

    protected abstract long getLogFileSpaceLeft();

    protected boolean isOcupancyHigh() {
        return false;
    }

    protected abstract void truncate() throws ObjectManagerException;

    @Override
    public void print(PrintWriter printWriter) {
        printWriter.println("LogOutput logSequenceNumber=" + this.logSequenceNumber + "(long) reserved=" + this.reserved + "(long)");
    }

    protected abstract void reserve(long var1) throws ObjectManagerException;

    protected abstract long writeNext(LogRecord var1, long var2, boolean var4, boolean var5) throws ObjectManagerException;

    protected abstract long markAndWriteNext(LogRecord var1, long var2, boolean var4, boolean var5) throws ObjectManagerException;

    protected long getLogSequenceNumber() {
        return this.logSequenceNumber;
    }

    protected Map captureStatistics() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "captureStatistics");
        }
        HashMap statistics = new HashMap();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "captureStatistics", statistics);
        }
        return statistics;
    }
}

