/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.CheckpointEndLogRecord;
import com.ibm.ws.objectManager.CheckpointStartLogRecord;
import com.ibm.ws.objectManager.FileLogHeader;
import com.ibm.ws.objectManager.InvalidLogRecordPartTypeException;
import com.ibm.ws.objectManager.InvalidLogRecordTypeException;
import com.ibm.ws.objectManager.LogFileExhaustedException;
import com.ibm.ws.objectManager.LogInput;
import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PaddingLogRecord;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.PrematureEndOfLogFileException;
import com.ibm.ws.objectManager.TransactionAddLogRecord;
import com.ibm.ws.objectManager.TransactionBackoutLogRecord;
import com.ibm.ws.objectManager.TransactionCheckpointLogRecord;
import com.ibm.ws.objectManager.TransactionCommitLogRecord;
import com.ibm.ws.objectManager.TransactionDeleteLogRecord;
import com.ibm.ws.objectManager.TransactionOptimisticReplaceLogRecord;
import com.ibm.ws.objectManager.TransactionPrepareLogRecord;
import com.ibm.ws.objectManager.TransactionReplaceLogRecord;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class FileLogInput
extends LogInput {
    private static final Class cclass = FileLogInput.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerLog");
    static final byte[] mask = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    private RandomAccessFile logFile;
    private SectorValidatedInputStream sectorValidatedInputStream;
    private DataInputStream dataInputStream;
    private List[] multiPartLogRecords = new List[256];
    private boolean checkpointStartSeen = false;

    protected FileLogInput(RandomAccessFile logFile, ObjectManagerState objectManagerState) throws ObjectManagerException {
        super(objectManagerState);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{logFile, objectManagerState});
        }
        this.logFile = logFile;
        this.sectorValidatedInputStream = new SectorValidatedInputStream(logFile);
        this.dataInputStream = new DataInputStream(this.sectorValidatedInputStream);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    public void close() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "Close");
        }
        try {
            this.dataInputStream.close();
            this.sectorValidatedInputStream.close();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(cclass, "close", exception, "1:98:1.13");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "close", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "close");
        }
    }

    @Override
    protected long getLogFileSize() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getLogFileSIze");
        }
        long logFileSize = ((SectorValidatedInputStream)this.sectorValidatedInputStream).header.fileSize;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getLogFileSize", "returns logFileSize=" + logFileSize + "(long)");
        }
        return logFileSize;
    }

    @Override
    public LogRecord readNext() throws ObjectManagerException {
        int type;
        DataInputStream logRecordDataInputStream;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "readNext");
        }
        do {
            logRecordDataInputStream = this.readNextLogRecord();
            try {
                type = logRecordDataInputStream.readInt();
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(cclass, "readNext", exception, "1:160:1.13");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "readNext", exception);
                }
                throw new PermanentIOException((Object)this, exception);
            }
            if (type != 8) continue;
            this.checkpointStartSeen = true;
        } while (!this.checkpointStartSeen);
        LogRecord logRecordRead = null;
        switch (type) {
            case 0: {
                logRecordRead = LogRecord.getUserLogRecord(logRecordDataInputStream, this.objectManagerState);
                break;
            }
            case 1: {
                logRecordRead = new TransactionAddLogRecord(logRecordDataInputStream, this.objectManagerState);
                break;
            }
            case 2: {
                logRecordRead = new TransactionReplaceLogRecord(logRecordDataInputStream, this.objectManagerState);
                break;
            }
            case 3: {
                logRecordRead = new TransactionOptimisticReplaceLogRecord(logRecordDataInputStream, this.objectManagerState);
                break;
            }
            case 4: {
                logRecordRead = new TransactionDeleteLogRecord(logRecordDataInputStream, this.objectManagerState);
                break;
            }
            case 5: {
                logRecordRead = new TransactionPrepareLogRecord(logRecordDataInputStream);
                break;
            }
            case 6: {
                logRecordRead = new TransactionCommitLogRecord(logRecordDataInputStream);
                break;
            }
            case 7: {
                logRecordRead = new TransactionBackoutLogRecord(logRecordDataInputStream);
                break;
            }
            case 8: {
                logRecordRead = new CheckpointStartLogRecord(logRecordDataInputStream, this.objectManagerState);
                break;
            }
            case 9: {
                logRecordRead = new CheckpointEndLogRecord(logRecordDataInputStream);
                break;
            }
            case 10: {
                logRecordRead = new TransactionCheckpointLogRecord(logRecordDataInputStream, this.objectManagerState);
                break;
            }
            case 11: {
                logRecordRead = new PaddingLogRecord(logRecordDataInputStream);
                break;
            }
            default: {
                InvalidLogRecordTypeException invalidLogRecordTypeException = new InvalidLogRecordTypeException((Object)this, type);
                ObjectManager.ffdc.processException(cclass, "readNext", invalidLogRecordTypeException, "1:229:1.13");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "readNext", new Object[]{invalidLogRecordTypeException, logRecordDataInputStream, new Integer(type)});
                }
                throw invalidLogRecordTypeException;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "readNext", new Object[]{logRecordRead});
        }
        return logRecordRead;
    }

    private DataInputStream readNextLogRecord() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readNextLogRecord", new Object[]{new Long(this.sectorValidatedInputStream.currentPage), new Integer(this.sectorValidatedInputStream.currentByte)});
        }
        byte[] logRecordBytes = null;
        short partLength = 0;
        byte partType = 0;
        byte multiPartID = 0;
        DataInputStream logRecordDataInputStream = null;
        block7: while (logRecordDataInputStream == null) {
            try {
                partType = this.dataInputStream.readByte();
                switch (partType) {
                    case 3: {
                        continue block7;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        multiPartID = this.dataInputStream.readByte();
                        partLength = this.dataInputStream.readShort();
                        logRecordBytes = new byte[partLength];
                        int bytesRead = this.dataInputStream.read(logRecordBytes);
                        if (bytesRead != partLength) {
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "readNextLogRecord", new Object[]{"LogFileExhausted_1", new Integer(bytesRead), new Short(partLength)});
                            }
                            throw new LogFileExhaustedException((Object)this, new EOFException());
                        }
                        if (multiPartID == 0) {
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(logRecordBytes);
                            logRecordDataInputStream = new DataInputStream(byteArrayInputStream);
                            continue block7;
                        }
                        if (partType == 2) {
                            if (this.multiPartLogRecords[multiPartID] == null) continue block7;
                            this.multiPartLogRecords[multiPartID].add(logRecordBytes);
                            MultiByteArrayInputStream inputStream = new MultiByteArrayInputStream(this.multiPartLogRecords[multiPartID]);
                            logRecordDataInputStream = new DataInputStream(inputStream);
                            this.multiPartLogRecords[multiPartID] = null;
                            continue block7;
                        }
                        if (partType == 0) {
                            this.multiPartLogRecords[multiPartID] = new ArrayList();
                            this.multiPartLogRecords[multiPartID].add(logRecordBytes);
                            continue block7;
                        }
                        if (this.multiPartLogRecords[multiPartID] == null) continue block7;
                        this.multiPartLogRecords[multiPartID].add(logRecordBytes);
                        continue block7;
                    }
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "readNextLogRecord", "via InvalidLogPartTypeException partType=" + partType + "(byte)");
                }
                throw new InvalidLogRecordPartTypeException(this, partType);
            }
            catch (EOFException exception) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "readNextLogRecord", new Object[]{"LogFileExhausted_2", new Short(partLength)});
                }
                throw new LogFileExhaustedException((Object)this, exception);
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(cclass, "readNext", exception, "1:348:1.13");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "readNextLogRecord", new Object[]{new Short(partLength), exception});
                }
                throw new PermanentIOException((Object)this, exception);
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "readNextLogRecord", new Object[]{logRecordDataInputStream});
        }
        return logRecordDataInputStream;
    }

    protected long getCurrentPage() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getCurrentPage");
        }
        long currentPage = this.sectorValidatedInputStream.currentPage;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getCurrentPage", "returns =" + currentPage + "(long)");
        }
        return currentPage;
    }

    protected static boolean restoreSectorBits(byte[] page, byte sectorByte) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "restoreSectorBits", new Object[]{new Byte(page[0]), new Byte(sectorByte)});
        }
        for (int i = 1; i < 9; ++i) {
            if ((page[512 * i - 1] & 1) != sectorByte) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit(cclass, "restoreSectorBits", (Object)("returns false i=" + i + "(int) page[FileLogOutput.sectorSize*i -1]=" + page[512 * i - 1] + "(byte)"));
                }
                return false;
            }
            if ((page[0] & mask[i - 1]) == 0) {
                int n = 512 * i - 1;
                page[n] = (byte)(page[n] & 0xFE);
                continue;
            }
            int n = 512 * i - 1;
            page[n] = (byte)(page[n] | 1);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "restoreSectorBits", (Object)"returns true");
        }
        return true;
    }

    private class MultiByteArrayInputStream
    extends InputStream {
        private List byteArrays;
        private int byteArrayIndex = 0;
        private byte[] currentBuffer;
        private int currentByte = 0;

        MultiByteArrayInputStream(List byteArrays) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "<init>", "byteArrays=" + byteArrays + "(java.util.List)");
            }
            this.byteArrays = byteArrays;
            this.currentBuffer = (byte[])byteArrays.get(this.byteArrayIndex);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        @Override
        public int read() {
            int byteToReturn = -1;
            if (this.currentByte < this.currentBuffer.length) {
                byteToReturn = this.currentBuffer[this.currentByte] & 0xFF;
                ++this.currentByte;
            } else {
                ++this.byteArrayIndex;
                if (this.byteArrayIndex < this.byteArrays.size()) {
                    this.currentBuffer = (byte[])this.byteArrays.get(this.byteArrayIndex);
                    byteToReturn = this.currentBuffer[0] & 0xFF;
                    this.currentByte = 1;
                }
            }
            return byteToReturn;
        }

        @Override
        public synchronized int read(byte[] buffer, int offset, int length) {
            int bytesRead = 0;
            while (length > 0) {
                if (this.currentByte == this.currentBuffer.length) {
                    ++this.byteArrayIndex;
                    if (this.byteArrayIndex < this.byteArrays.size()) {
                        this.currentBuffer = (byte[])this.byteArrays.get(this.byteArrayIndex);
                        this.currentByte = 0;
                    } else {
                        if (bytesRead != 0) break;
                        bytesRead = -1;
                        break;
                    }
                }
                int lengthToCopy = Math.min(length, this.currentBuffer.length - this.currentByte);
                System.arraycopy(this.currentBuffer, this.currentByte, buffer, offset, lengthToCopy);
                length -= lengthToCopy;
                offset += lengthToCopy;
                this.currentByte += lengthToCopy;
                bytesRead += lengthToCopy;
            }
            return bytesRead;
        }
    }

    private class SectorValidatedInputStream
    extends InputStream {
        private RandomAccessFile file;
        private FileLogHeader header;
        private byte[] page = new byte[4096];
        private int currentByte = this.page.length;
        private long currentPage = -1L;

        SectorValidatedInputStream(RandomAccessFile randomAccessFile) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "<init>", "randomAccessFile=" + randomAccessFile + "(java.io.RandomAccessFile)");
            }
            this.file = randomAccessFile;
            this.header = new FileLogHeader(FileLogInput.this.logFile);
            this.seek(this.header.startByteAddress);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }

        private void seek(long position) throws ObjectManagerException {
            int bytesRead;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "seek", "position=" + position + "(long)");
            }
            this.currentByte = (int)(position % 4096L);
            try {
                this.file.seek(position - (long)this.currentByte);
                bytesRead = this.file.read(this.page);
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(cclass, "seek", exception, "1:510:1.13");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "seek", exception);
                }
                throw new PermanentIOException((Object)this, exception);
            }
            if (bytesRead != this.page.length) {
                PrematureEndOfLogFileException prematureEndOfLogFileException = new PrematureEndOfLogFileException((Object)this, FileLogInput.this.objectManagerState.getLogFileName(), this.header.fileSize, position);
                ObjectManager.ffdc.processException(cclass, "seek", prematureEndOfLogFileException, "1:531:1.13", new Object[]{new Long(this.header.fileSize), new Long(position), new Integer(bytesRead)});
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "seek", prematureEndOfLogFileException);
                }
                throw prematureEndOfLogFileException;
            }
            if (!FileLogInput.restoreSectorBits(this.page, this.header.sectorByte)) {
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "seek", "Failed to restore sector bits");
                    trace.bytes(this, cclass, this.page);
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "seek", "via LogFileExhaustedException");
                }
                throw new LogFileExhaustedException((Object)this, new Exception("SectorBit"));
            }
            if (this.currentByte == 0) {
                ++this.currentByte;
            }
            this.currentPage = position / 4096L;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "seek", new Object[]{new Long(this.currentPage), new Integer(this.currentByte)});
            }
        }

        @Override
        public int read() throws IOException {
            if (this.currentByte == this.page.length) {
                int bytesRead;
                ++this.currentPage;
                if (this.currentPage * 4096L == this.header.fileSize) {
                    this.file.seek(8192L);
                    this.currentPage = 2L;
                    this.header.sectorByte = this.header.sectorByte == 0 ? (byte)1 : 0;
                }
                if ((bytesRead = this.file.read(this.page)) != this.page.length) {
                    return -1;
                }
                if (!FileLogInput.restoreSectorBits(this.page, this.header.sectorByte)) {
                    return -1;
                }
                this.currentByte = 1;
            }
            int byteToReturn = this.page[this.currentByte] & 0xFF;
            ++this.currentByte;
            return byteToReturn;
        }

        @Override
        public int read(byte[] bytes, int offset, int length) throws IOException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "read", new Object[]{bytes, new Integer(offset), new Integer(length)});
            }
            int lengthRead = 0;
            while (length > 0) {
                if (this.currentByte == this.page.length) {
                    int bytesRead;
                    ++this.currentPage;
                    if (this.currentPage * 4096L == this.header.fileSize) {
                        this.file.seek(8192L);
                        this.currentPage = 2L;
                        this.header.sectorByte = this.header.sectorByte == 0 ? (byte)1 : 0;
                    }
                    if ((bytesRead = this.file.read(this.page)) != this.page.length) {
                        if (lengthRead == 0) {
                            lengthRead = -1;
                        }
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "read", "returns lengthRead=" + lengthRead + "(int) bytesRead=" + bytesRead + "(int)");
                        }
                        return lengthRead;
                    }
                    if (!FileLogInput.restoreSectorBits(this.page, this.header.sectorByte)) {
                        if (lengthRead == 0) {
                            lengthRead = -1;
                        }
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "read", "returns lengthRead=" + lengthRead + "(int)");
                        }
                        return lengthRead;
                    }
                    this.currentByte = 1;
                }
                int lengthToCopy = Math.min(length, this.page.length - this.currentByte);
                System.arraycopy(this.page, this.currentByte, bytes, offset, lengthToCopy);
                length -= lengthToCopy;
                offset += lengthToCopy;
                this.currentByte += lengthToCopy;
                lengthRead += lengthToCopy;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "read", "returns lengthRead=" + lengthRead + "(int)");
            }
            return lengthRead;
        }
    }
}

