/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jtaextensions;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.tx.jta.impl.LocalTIDTable;
import com.ibm.tx.jta.impl.TranManagerSet;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.websphere.jtaextensions.CallbackNotRegisteredException;
import com.ibm.websphere.jtaextensions.ExtendedJTATransaction;
import com.ibm.websphere.jtaextensions.NotSupportedException;
import com.ibm.websphere.jtaextensions.SynchronizationCallback;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jtaextensions.SynchronizationCallbackWrapper;
import java.util.ArrayList;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;

public final class ExtendedJTATransactionImpl
implements ExtendedJTATransaction {
    private static final ArrayList<ArrayList<SynchronizationCallback>> _syncLevels = new ArrayList();
    private static int _syncLevel = -1;
    private static final TraceComponent tc = Tr.register(ExtendedJTATransactionImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");

    @Override
    public byte[] getGlobalId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGlobalId");
        }
        byte[] globalId = null;
        TransactionImpl tran = ((TranManagerSet)TransactionManagerFactory.getTransactionManager()).getTransactionImpl();
        if (tran != null) {
            globalId = tran.getTID();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGlobalId", (Object)globalId);
        }
        return globalId;
    }

    @Override
    public int getLocalId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLocalId");
        }
        int localId = 0;
        TransactionImpl tran = ((TranManagerSet)TransactionManagerFactory.getTransactionManager()).getTransactionImpl();
        if (tran != null) {
            localId = (int)tran.getLocalTID();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLocalId", (Object)localId);
        }
        return localId;
    }

    @Override
    public synchronized void registerSynchronizationCallback(SynchronizationCallback sync) throws NotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerSynchronizationCallback", (Object)sync);
        }
        if (sync == null) {
            NullPointerException npe = new NullPointerException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerSynchronizationCallback", (Object)npe);
            }
            throw npe;
        }
        if (_syncLevel < 0) {
            ArrayList<SynchronizationCallback> newSyncList = new ArrayList<SynchronizationCallback>();
            newSyncList.add(sync);
            ExtendedJTATransactionImpl.setLevel(newSyncList);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerSynchronizationCallback", (Object)_syncLevel);
            }
            return;
        }
        ArrayList<SynchronizationCallback> currentSyncList = _syncLevels.get(_syncLevel);
        if (currentSyncList == null) {
            ArrayList<SynchronizationCallback> newSyncList = new ArrayList<SynchronizationCallback>();
            newSyncList.add(sync);
            ExtendedJTATransactionImpl.setLevel(newSyncList);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerSynchronizationCallback", (Object)_syncLevel);
            }
            return;
        }
        ArrayList<SynchronizationCallback> newSyncList = new ArrayList<SynchronizationCallback>(currentSyncList);
        newSyncList.add(sync);
        ExtendedJTATransactionImpl.setLevel(newSyncList);
        ExtendedJTATransactionImpl.garbageCollectUnusedLevels();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerSynchronizationCallback", (Object)_syncLevel);
        }
    }

    @Override
    public synchronized void registerSynchronizationCallbackForCurrentTran(SynchronizationCallback sync) throws NotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerSynchronizationCallbackForCurrentTran", (Object)sync);
        }
        if (sync == null) {
            String msg = "SynchronizationCallback is null";
            NullPointerException npe = new NullPointerException("SynchronizationCallback is null");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerSynchronizationCallbackForCurrentTran", (Object)npe);
            }
            throw npe;
        }
        TransactionImpl tran = ((TranManagerSet)TransactionManagerFactory.getTransactionManager()).getTransactionImpl();
        if (tran == null) {
            NotSupportedException nse = new NotSupportedException();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"No current transaction");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerSynchronizationCallbackForCurrentTran", (Object)nse);
            }
            throw nse;
        }
        SynchronizationCallbackWrapper syncCallbackWrapper = new SynchronizationCallbackWrapper(sync, (int)tran.getLocalTID(), tran.getTID());
        try {
            tran.registerSynchronization((Synchronization)syncCallbackWrapper, 0);
        }
        catch (RollbackException re) {
            FFDCFilter.processException((Throwable)re, (String)"com.ibm.ws.jtaextensions.ExtendedJTATransactionImpl.registerSynchronizationCallbackForCurrentTran", (String)"325", (Object)this);
            NotSupportedException nse = new NotSupportedException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerSynchronizationCallbackForCurrentTran", (Object)nse);
            }
            throw nse;
        }
        catch (IllegalStateException ise) {
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.ws.jtaextensions.ExtendedJTATransactionImpl.registerSynchronizationCallbackForCurrentTran", (String)"333", (Object)this);
            NotSupportedException nse = new NotSupportedException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerSynchronizationCallbackForCurrentTran", (Object)nse);
            }
            throw nse;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerSynchronizationCallbackForCurrentTran");
        }
    }

    @Override
    public synchronized void unRegisterSynchronizationCallback(SynchronizationCallback sync) throws CallbackNotRegisteredException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unRegisterSynchronizationCallback", (Object)sync);
        }
        if (sync == null || _syncLevel < 0) {
            CallbackNotRegisteredException cnre = new CallbackNotRegisteredException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"unRegisterSynchronizationCallback", (Object)cnre);
            }
            throw cnre;
        }
        ArrayList<SynchronizationCallback> currentSyncList = _syncLevels.get(_syncLevel);
        if (currentSyncList == null || !currentSyncList.contains(sync)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"unRegisterSynchronizationCallback", (Object)"Sync not registered");
            }
            throw new CallbackNotRegisteredException();
        }
        ArrayList<SynchronizationCallback> newSyncList = new ArrayList<SynchronizationCallback>(currentSyncList);
        int pos = newSyncList.lastIndexOf(sync);
        newSyncList.remove(pos);
        ExtendedJTATransactionImpl.setLevel(newSyncList);
        ExtendedJTATransactionImpl.garbageCollectUnusedLevels();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unRegisterSynchronizationCallback");
        }
    }

    public static void beforeCompletion(TransactionImpl tran, int syncLevel) {
        ArrayList<SynchronizationCallback> syncs;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"beforeCompletion", (Object)new Object[]{tran, syncLevel});
        }
        if (syncLevel >= 0 && (syncs = _syncLevels.get(syncLevel)) != null) {
            int localID = (int)tran.getLocalTID();
            byte[] globalID = tran.getTID();
            int numSyncs = syncs.size();
            for (int s = 0; s < numSyncs; ++s) {
                syncs.get(s).beforeCompletion(localID, globalID);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"beforeCompletion");
        }
    }

    public static void afterCompletion(TransactionImpl tran, int status, int syncLevel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)new Object[]{tran, status, syncLevel});
        }
        if (syncLevel >= 0) {
            ArrayList<SynchronizationCallback> syncs = _syncLevels.get(syncLevel);
            if (syncs != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("syncs.length=" + syncs.size()));
                }
                int localID = (int)tran.getLocalTID();
                byte[] globalID = tran.getTID();
                boolean committed = status != 4;
                int numSyncs = syncs.size();
                for (int s = 0; s < numSyncs; ++s) {
                    try {
                        syncs.get(s).afterCompletion(localID, globalID, committed);
                        continue;
                    }
                    catch (Throwable t) {
                        Tr.error((TraceComponent)tc, (String)"WTRN0074_SYNCHRONIZATION_EXCEPTION", (Object)new Object[]{"afterCompletion", syncs.get(s), t});
                    }
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"syncs is null");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"afterCompletion");
        }
    }

    public static boolean callbacksRegistered() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"callbacksRegistered");
        }
        if (_syncLevel < 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"callbacksRegistered", (Object)Boolean.FALSE);
            }
            return false;
        }
        int maxLevels = _syncLevels.size();
        for (int level = 0; level < maxLevels; ++level) {
            ArrayList<SynchronizationCallback> syncs = _syncLevels.get(_syncLevel);
            if (syncs == null || syncs.isEmpty()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"callbacksRegistered", (Object)Boolean.TRUE);
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"callbacksRegistered", (Object)Boolean.FALSE);
        }
        return false;
    }

    private static int nextLevel() {
        int numLevels = _syncLevels.size();
        for (int i = 0; i < numLevels; ++i) {
            if (_syncLevels.get(i) != null) continue;
            return i;
        }
        return numLevels;
    }

    public static int getSyncLevel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sync level: " + _syncLevel));
        }
        return _syncLevel;
    }

    private static void garbageCollectUnusedLevels() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"garbageCollectUnusedLevels");
        }
        int numLevels = _syncLevels.size();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Levels: " + numLevels));
        }
        if (numLevels < 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"garbageCollectUnusedLevels", (Object)"Doing nothing");
            }
            return;
        }
        int[] counts = new int[numLevels];
        TransactionImpl[] txns = LocalTIDTable.getAllTransactions();
        int i = txns.length;
        while (--i >= 0) {
            int level = 0;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Not generating any counts for garbageCollectUnusedLevels()");
            }
            if (level < 0 || level >= numLevels) continue;
            int n = level;
            counts[n] = counts[n] + 1;
        }
        i = counts.length;
        while (--i >= 0) {
            if (i == _syncLevel || counts[i] != 0) continue;
            _syncLevels.set(i, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"garbageCollectUnusedLevels", (Object)_syncLevels.size());
        }
    }

    private static void setLevel(ArrayList level) {
        _syncLevel = ExtendedJTATransactionImpl.nextLevel();
        if (_syncLevel == _syncLevels.size()) {
            _syncLevels.add(level);
        } else {
            _syncLevels.set(_syncLevel, level);
        }
    }
}

