/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.jose4j.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jose4j.jwt.JwtClaims;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OidcTokenImplBase {
    private static final TraceComponent tc = Tr.register(OidcTokenImplBase.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    protected static final String CLIENT_ID = "azp2";
    private static final String BEARER = "Bearer";
    JwtClaims jwtClaims = null;
    String access_token = null;
    String refresh_token = null;
    String client_id = null;
    String tokenTypeNoSpace = null;
    static final long serialVersionUID = 1391264172872808257L;

    public OidcTokenImplBase(JwtClaims jwtClaims, String access_token, String refresh_token, String client_id, String tokenTypeNoSpace) {
        this.jwtClaims = jwtClaims;
        this.access_token = access_token;
        this.refresh_token = refresh_token;
        this.client_id = client_id;
        if (tokenTypeNoSpace == null) {
            tokenTypeNoSpace = "IDToken";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Provided token type is null; defaulting to " + tokenTypeNoSpace), (Object[])new Object[0]);
            }
        }
        this.tokenTypeNoSpace = tokenTypeNoSpace;
    }

    public String getTokenTypeNoSpace() {
        return this.tokenTypeNoSpace;
    }

    public JwtClaims getJwtClaims() {
        return this.jwtClaims;
    }

    public String getJwtId() {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getJwtId();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"64", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public String getType() {
        return BEARER;
    }

    public String getIssuer() {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getIssuer();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"79", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public String getSubject() {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getSubject();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"90", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public List<String> getAudience() {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getAudience();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"101", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public String getClientId() {
        return this.client_id;
    }

    public long getExpirationTimeSeconds() {
        if (this.jwtClaims == null) {
            return 0L;
        }
        try {
            return this.jwtClaims.getExpirationTime().getValue();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"116", (Object)this, (Object[])new Object[0]);
            return 0L;
        }
    }

    public long getNotBeforeTimeSeconds() {
        if (this.jwtClaims == null) {
            return 0L;
        }
        try {
            return this.jwtClaims.getNotBefore().getValue();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"127", (Object)this, (Object[])new Object[0]);
            return 0L;
        }
    }

    public long getIssuedAtTimeSeconds() {
        if (this.jwtClaims == null) {
            return 0L;
        }
        try {
            return this.jwtClaims.getIssuedAt().getValue();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"138", (Object)this, (Object[])new Object[0]);
            return 0L;
        }
    }

    public long getAuthorizationTimeSeconds() {
        return 0L;
    }

    public String getNonce() {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getStringClaimValue("nonce");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"153", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public String getAccessTokenHash() {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getStringClaimValue("at_hash");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"164", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public String getClassReference() {
        return null;
    }

    public List<String> getMethodsReferences() {
        return null;
    }

    public String getAuthorizedParty() {
        return null;
    }

    public Object getClaim(String key) {
        if (this.jwtClaims == null) {
            return null;
        }
        try {
            return this.jwtClaims.getClaimValue(key);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"187", (Object)this, (Object[])new Object[]{key});
            return null;
        }
    }

    public Map<String, Object> getAllClaims() {
        if (this.jwtClaims == null) {
            return null;
        }
        return new HashMap<String, Object>(this.jwtClaims.getClaimsMap());
    }

    public String getAccessToken() {
        return this.access_token;
    }

    public String getRefreshToken() {
        return this.refresh_token;
    }

    public String getAllClaimsAsJson() {
        try {
            if (this.jwtClaims == null) {
                return null;
            }
            return this.jwtClaims.toJson();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.jose4j.util.OidcTokenImplBase", (String)"213", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.tokenTypeNoSpace);
        String claimsString = this.getAllClaimsAsJson();
        if (claimsString == null) {
            return sb.toString();
        }
        sb.append(":").append(claimsString);
        return sb.toString();
    }
}

