/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import org.jboss.jdeparser.JClass;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JGenerable;
import org.jboss.jdeparser.JPrimitiveType;

public abstract class JType
implements JGenerable,
Comparable<JType> {
    public static JPrimitiveType parse(JDeparser deparser, String typeName) {
        if (typeName.equals("void")) {
            return deparser.VOID;
        }
        if (typeName.equals("boolean")) {
            return deparser.BOOLEAN;
        }
        if (typeName.equals("byte")) {
            return deparser.BYTE;
        }
        if (typeName.equals("short")) {
            return deparser.SHORT;
        }
        if (typeName.equals("char")) {
            return deparser.CHAR;
        }
        if (typeName.equals("int")) {
            return deparser.INT;
        }
        if (typeName.equals("float")) {
            return deparser.FLOAT;
        }
        if (typeName.equals("long")) {
            return deparser.LONG;
        }
        if (typeName.equals("double")) {
            return deparser.DOUBLE;
        }
        throw new IllegalArgumentException("Not a primitive type: " + typeName);
    }

    public abstract JDeparser owner();

    public abstract String fullName();

    public String binaryName() {
        return this.fullName();
    }

    public abstract String name();

    public abstract JClass array();

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public abstract JClass boxify();

    public abstract JType unboxify();

    public JType erasure() {
        return this;
    }

    public final boolean isReference() {
        return !this.isPrimitive();
    }

    public JType elementType() {
        throw new IllegalArgumentException("Not an array type");
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.fullName() + ')';
    }

    @Override
    public int compareTo(JType o) {
        String rhs = o.fullName();
        boolean p = this.fullName().startsWith("java");
        boolean q = rhs.startsWith("java");
        if (p && !q) {
            return -1;
        }
        if (!p && q) {
            return 1;
        }
        return this.fullName().compareTo(rhs);
    }
}

