/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import org.jboss.jdeparser.JArrayClass;
import org.jboss.jdeparser.JClass;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExpression;
import org.jboss.jdeparser.JFormatter;
import org.jboss.jdeparser.JType;

public final class JPrimitiveType
extends JType {
    private final String typeName;
    private final JDeparser owner;
    private final JClass wrapperClass;
    private JClass arrayClass;

    JPrimitiveType(JDeparser owner, String typeName, Class<?> wrapper) {
        this.owner = owner;
        this.typeName = typeName;
        this.wrapperClass = owner.ref(wrapper);
    }

    @Override
    public JDeparser owner() {
        return this.owner;
    }

    @Override
    public String fullName() {
        return this.typeName;
    }

    @Override
    public String name() {
        return this.fullName();
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public JClass array() {
        if (this.arrayClass == null) {
            this.arrayClass = new JArrayClass(this.owner, this);
        }
        return this.arrayClass;
    }

    @Override
    public JClass boxify() {
        return this.wrapperClass;
    }

    @Override
    public JType unboxify() {
        return this;
    }

    public JClass getWrapperClass() {
        return this.boxify();
    }

    public JExpression wrap(JExpression exp) {
        return JExpr._new(this.boxify()).arg(exp);
    }

    public JExpression unwrap(JExpression exp) {
        return exp.invoke(this.typeName + "Value");
    }

    @Override
    public void generate(JFormatter f) {
        f.p(this.typeName);
    }
}

