/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtc.adapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jtc.adapter.IPlatformAdapter;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class DefaultPlatformAdapter
implements IPlatformAdapter {
    private static final String CLASSNAME = DefaultPlatformAdapter.class.getName();
    private static final TraceComponent tc = Tr.register((String)CLASSNAME, (String)"Runtime", (String)"com.ibm.ws.runtime.runtime");
    private static Field svAddrField;
    private static Field svThreadLocalsField;

    @Override
    public long getByteBufferAddress(ByteBuffer byteBuffer) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("The specified byte buffer is not direct");
        }
        try {
            return svAddrField.getLong(byteBuffer);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    @Override
    public long getSocketChannelHandle(SocketChannel socketChannel) {
        StartPrivilegedThread privThread = new StartPrivilegedThread(socketChannel);
        return AccessController.doPrivileged(privThread);
    }

    @Override
    public void cleanThreadLocals(Thread thread) {
        block2: {
            try {
                svThreadLocalsField.set(thread, null);
            }
            catch (IllegalAccessException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Unable to clear java.lang.ThreadLocals: ", (Object)e);
            }
        }
    }

    static {
        StartPrivilegedThread2 privThread = new StartPrivilegedThread2();
        AccessController.doPrivileged(privThread);
        try {
            svThreadLocalsField = Thread.class.getDeclaredField("threadLocals");
            svThreadLocalsField.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class StartPrivilegedThread
    implements PrivilegedAction<Long> {
        SocketChannel ioSocket;

        StartPrivilegedThread(SocketChannel _ioSocket) {
            this.ioSocket = _ioSocket;
        }

        @Override
        public Long run() {
            Long ret;
            try {
                Field fdValField = this.ioSocket.getClass().getDeclaredField("fdVal");
                fdValField.setAccessible(true);
                ret = fdValField.getInt(this.ioSocket);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return ret;
        }
    }

    static class StartPrivilegedThread2
    implements PrivilegedAction {
        public Object run() {
            try {
                Class<?> bufClass = Class.forName("java.nio.Buffer");
                svAddrField = bufClass.getDeclaredField("address");
                svAddrField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }
}

