/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.core.util;

import com.fasterxml.jackson.databind.type.TypeFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.model.media.SchemaImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.models.media.Schema;

public enum PrimitiveType {
    STRING((Class)String.class, "string"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.STRING);
        }
    }
    ,
    BOOLEAN((Class)Boolean.class, "boolean"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.BOOLEAN);
        }
    }
    ,
    BYTE((Class)Byte.class, "byte"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.STRING).format("base64");
        }
    }
    ,
    BINARY((Class)Byte.class, "binary"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.STRING).format("binary");
        }
    }
    ,
    URI((Class)URI.class, "uri"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.STRING).format("uri");
        }
    }
    ,
    URL((Class)URL.class, "url"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.STRING).format("url");
        }
    }
    ,
    EMAIL((Class)String.class, "email"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.STRING).format("email");
        }
    }
    ,
    UUID((Class)UUID.class, "uuid"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.STRING).format("uuid");
        }
    }
    ,
    INT((Class)Integer.class, "integer"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.INTEGER);
        }
    }
    ,
    LONG((Class)Long.class, "long"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.INTEGER).format("int64");
        }
    }
    ,
    FLOAT((Class)Float.class, "float"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.NUMBER).format("float");
        }
    }
    ,
    DOUBLE((Class)Double.class, "double"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.NUMBER).format("double");
        }
    }
    ,
    INTEGER((Class)BigInteger.class){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.INTEGER);
        }
    }
    ,
    DECIMAL((Class)BigDecimal.class, "number"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.NUMBER);
        }
    }
    ,
    DATE((Class)DateStub.class, "date"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.STRING).format("date");
        }
    }
    ,
    DATE_TIME((Class)Date.class, "date-time"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.STRING).format("date-time");
        }
    }
    ,
    FILE((Class)File.class, "file"){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.STRING).format("base64");
        }
    }
    ,
    OBJECT((Class)Object.class){

        @Override
        public Schema createProperty() {
            return new SchemaImpl().type(Schema.SchemaType.OBJECT);
        }
    };

    private static final Map<Class<?>, PrimitiveType> KEY_CLASSES;
    private static final Map<Class<?>, PrimitiveType> BASE_CLASSES;
    private static final Map<String, PrimitiveType> EXTERNAL_CLASSES;
    private static final Map<String, PrimitiveType> NAMES;
    private final Class<?> keyClass;
    private final String commonName;
    public static final Map<String, String> datatypeMappings;

    private PrimitiveType(Class<?> keyClass) {
        this(keyClass, null);
    }

    private PrimitiveType(Class<?> keyClass, String commonName) {
        this.keyClass = keyClass;
        this.commonName = commonName;
    }

    public static PrimitiveType fromType(Type type) {
        Class raw = TypeFactory.defaultInstance().constructType(type).getRawClass();
        PrimitiveType key = KEY_CLASSES.get(raw);
        if (key != null) {
            return key;
        }
        PrimitiveType external = EXTERNAL_CLASSES.get(raw.getName());
        if (external != null) {
            return external;
        }
        for (Map.Entry<Class<?>, PrimitiveType> entry : BASE_CLASSES.entrySet()) {
            if (!entry.getKey().isAssignableFrom(raw)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static PrimitiveType fromName(String name) {
        if (name == null) {
            return null;
        }
        PrimitiveType fromName = NAMES.get(name);
        if (fromName == null) {
            fromName = EXTERNAL_CLASSES.get(name);
        }
        return fromName;
    }

    public static PrimitiveType fromTypeAndFormat(String type, String format) {
        if (StringUtils.isNotBlank((CharSequence)type) && type.equals("object")) {
            return null;
        }
        return PrimitiveType.fromName(datatypeMappings.get(String.format("%s_%s", StringUtils.isBlank((CharSequence)type) ? "" : type, StringUtils.isBlank((CharSequence)format) ? "" : format)));
    }

    public static Schema createProperty(Type type) {
        PrimitiveType item = PrimitiveType.fromType(type);
        return item == null ? null : item.createProperty();
    }

    public static Schema createProperty(String name) {
        PrimitiveType item = PrimitiveType.fromName(name);
        return item == null ? null : item.createProperty();
    }

    public static String getCommonName(Type type) {
        PrimitiveType item = PrimitiveType.fromType(type);
        return item == null ? null : item.getCommonName();
    }

    public Class<?> getKeyClass() {
        return this.keyClass;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public abstract Schema createProperty();

    private static <K> void addKeys(Map<K, PrimitiveType> map, PrimitiveType type, K ... keys) {
        for (K key : keys) {
            map.put(key, type);
        }
    }

    static {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("integer_int32", "integer");
        mappings.put("integer_", "integer");
        mappings.put("integer_int64", "long");
        mappings.put("number", "number");
        mappings.put("number_float", "float");
        mappings.put("number_double", "double");
        datatypeMappings = Collections.unmodifiableMap(mappings);
        HashMap keyClasses = new HashMap();
        PrimitiveType.addKeys(keyClasses, BOOLEAN, Boolean.class, Boolean.TYPE);
        PrimitiveType.addKeys(keyClasses, STRING, String.class, Character.class, Character.TYPE);
        PrimitiveType.addKeys(keyClasses, BYTE, Byte.class, Byte.TYPE);
        PrimitiveType.addKeys(keyClasses, URL, URL.class);
        PrimitiveType.addKeys(keyClasses, URI, URI.class);
        PrimitiveType.addKeys(keyClasses, UUID, UUID.class);
        PrimitiveType.addKeys(keyClasses, INT, Integer.class, Integer.TYPE, Short.class, Short.TYPE);
        PrimitiveType.addKeys(keyClasses, LONG, Long.class, Long.TYPE);
        PrimitiveType.addKeys(keyClasses, FLOAT, Float.class, Float.TYPE);
        PrimitiveType.addKeys(keyClasses, DOUBLE, Double.class, Double.TYPE);
        PrimitiveType.addKeys(keyClasses, INTEGER, BigInteger.class);
        PrimitiveType.addKeys(keyClasses, DECIMAL, BigDecimal.class);
        PrimitiveType.addKeys(keyClasses, DATE, DateStub.class);
        PrimitiveType.addKeys(keyClasses, DATE_TIME, Date.class);
        PrimitiveType.addKeys(keyClasses, FILE, File.class);
        PrimitiveType.addKeys(keyClasses, OBJECT, Object.class);
        KEY_CLASSES = Collections.unmodifiableMap(keyClasses);
        HashMap baseClasses = new HashMap();
        PrimitiveType.addKeys(baseClasses, DATE_TIME, Date.class, Calendar.class);
        BASE_CLASSES = Collections.unmodifiableMap(baseClasses);
        HashMap externalClasses = new HashMap();
        PrimitiveType.addKeys(externalClasses, DATE, "org.joda.time.LocalDate", "java.time.LocalDate");
        PrimitiveType.addKeys(externalClasses, DATE_TIME, "org.joda.time.DateTime", "org.joda.time.ReadableDateTime", "javax.xml.datatype.XMLGregorianCalendar", "java.time.LocalDateTime", "java.time.ZonedDateTime", "java.time.OffsetDateTime");
        PrimitiveType.addKeys(externalClasses, LONG, "java.time.Instant");
        EXTERNAL_CLASSES = Collections.unmodifiableMap(externalClasses);
        TreeMap names = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (PrimitiveType item : PrimitiveType.values()) {
            String name = item.getCommonName();
            if (name == null) continue;
            PrimitiveType.addKeys(names, item, name);
        }
        PrimitiveType.addKeys(names, INT, "int");
        PrimitiveType.addKeys(names, OBJECT, "object");
        NAMES = Collections.unmodifiableMap(names);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class DateStub {
        static final long serialVersionUID = 8851999160708854677L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DateStub() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.core.util.PrimitiveType$DateStub", DateStub.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        }
    }
}

