/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class UtilImpl_WriteBuffer {
    private final String path;
    private final OutputStream outputStream;
    private final int bufferSize;
    private final byte[] buffer;
    private int bufferFill;
    private int bufferAvail;
    private int totalWritten;
    private final String encoding;
    private final Charset charset;
    public static final String UTF_8 = "UTF-8";
    private final byte[] smallIntBytes = new byte[2];
    private final byte[] largeIntBytes = new byte[4];
    public static final int MAX_STRING = 512;
    public static final int MAX_WIDTH = 60;
    private final byte[] nullBytes = new byte[60];
    static final long serialVersionUID = -3263025242526017300L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    public String getPath() {
        return this.path;
    }

    @Trivial
    public String getEncoding() {
        return this.encoding;
    }

    public UtilImpl_WriteBuffer(String path, OutputStream outputStream, int bufferSize) throws IOException {
        this(path, outputStream, bufferSize, UTF_8);
    }

    public UtilImpl_WriteBuffer(String path, OutputStream outputStream, int bufferSize, String encoding) throws IOException {
        this.path = path;
        this.outputStream = outputStream;
        this.bufferSize = bufferSize;
        this.buffer = new byte[bufferSize];
        this.bufferFill = 0;
        this.bufferAvail = bufferSize;
        this.totalWritten = 0;
        this.encoding = encoding;
        this.charset = Charset.forName(encoding);
    }

    public int getTotalWritten() throws IOException {
        return this.totalWritten;
    }

    public void flush() throws IOException {
        if (this.bufferFill > 0) {
            this.outputStream.write(this.buffer, 0, this.bufferFill);
            this.bufferFill = 0;
            this.bufferAvail = this.bufferSize;
            this.outputStream.flush();
        }
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.outputStream.close();
        }
    }

    @Trivial
    public static byte[] asBytes(int value) {
        byte[] result = new byte[4];
        for (int i = 4; i >= 0; --i) {
            result[i] = (byte)(value & 0xFF);
            value >>= 8;
        }
        return result;
    }

    @Trivial
    public void writeSmallInt(int smallInt) throws IOException {
        this.smallIntBytes[0] = (byte)((smallInt & 0xFF00) >> 8);
        this.smallIntBytes[1] = (byte)((smallInt & 0xFF) >> 0);
        this.write(this.smallIntBytes, 0, 2);
    }

    @Trivial
    public static void convertLargeInt(int value, byte[] bytes) {
        bytes[0] = (byte)((value & 0xFF000000) >> 24);
        bytes[1] = (byte)((value & 0xFF0000) >> 16);
        bytes[2] = (byte)((value & 0xFF00) >> 8);
        bytes[3] = (byte)((value & 0xFF) >> 0);
    }

    @Trivial
    public void writeLargeInt(int largeInt) throws IOException {
        UtilImpl_WriteBuffer.convertLargeInt(largeInt, this.largeIntBytes);
        this.write(this.largeIntBytes, 0, 4);
    }

    @Trivial
    public void writeLargeInt(byte fieldByte, int value) throws IOException {
        this.write(fieldByte);
        this.writeLargeInt(value);
    }

    @Trivial
    public void write(byte b) throws IOException {
        this.buffer[this.bufferFill] = b;
        ++this.bufferFill;
        --this.bufferAvail;
        ++this.totalWritten;
        if (this.bufferAvail == 0) {
            this.outputStream.write(this.buffer, 0, this.bufferSize);
            this.bufferFill = 0;
            this.bufferAvail = this.bufferSize;
        }
    }

    @Trivial
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Trivial
    public void write(byte[] bytes, int offset, int len) throws IOException {
        if (offset < 0) {
            throw new IllegalArgumentException("Write offset [ " + offset + " ] is less than zero for [ " + this.path + " ]");
        }
        if (len < 0) {
            throw new IllegalArgumentException("Write length [ " + len + " ] is less than zero for [ " + this.path + " ]");
        }
        if (len < this.bufferAvail) {
            System.arraycopy(bytes, offset, this.buffer, this.bufferFill, len);
            this.bufferFill += len;
            this.bufferAvail -= len;
            this.totalWritten += len;
        } else {
            if (this.bufferFill > 0) {
                System.arraycopy(bytes, offset, this.buffer, this.bufferFill, this.bufferAvail);
                offset += this.bufferAvail;
                len -= this.bufferAvail;
                this.totalWritten += this.bufferAvail;
                this.outputStream.write(this.buffer, 0, this.bufferSize);
                this.bufferFill = 0;
                this.bufferAvail = this.bufferSize;
            }
            if (len >= this.bufferSize) {
                int spanLen = len / this.bufferSize * this.bufferSize;
                this.outputStream.write(bytes, offset, spanLen);
                this.totalWritten += spanLen;
                offset += spanLen;
                len -= spanLen;
            }
            if (len > 0) {
                System.arraycopy(bytes, offset, this.buffer, 0, len);
                this.bufferFill += len;
                this.bufferAvail -= len;
                this.totalWritten += len;
            }
        }
    }

    @Trivial
    public byte[] asBytes(String text) {
        byte[] textBytes = text.getBytes(this.charset);
        if (textBytes.length > 512) {
            throw new IllegalArgumentException("String width [ " + textBytes.length + " ] too long for width [ " + 512 + " ]");
        }
        return textBytes;
    }

    @Trivial
    public int write(String value) throws IOException {
        byte[] valueBytes = this.asBytes(value);
        int numValueBytes = valueBytes.length;
        this.writeSmallInt(numValueBytes);
        this.write(valueBytes, 0, numValueBytes);
        return 2 + numValueBytes;
    }

    @Trivial
    public int write(byte fieldByte, String value) throws IOException {
        byte[] valueBytes = this.asBytes(value);
        int numValueBytes = valueBytes.length;
        this.write(fieldByte);
        this.writeSmallInt(numValueBytes);
        this.write(valueBytes, 0, numValueBytes);
        return 3 + numValueBytes;
    }

    @Trivial
    public void write(byte fieldByte, String value, int width) throws IOException {
        byte[] valueBytes = this.asBytes(value);
        int numValueBytes = valueBytes.length;
        int missingBytes = width - 3 - numValueBytes;
        if (missingBytes < 0) {
            throw new IllegalArgumentException("Value [ " + value + " ] too long for width [ " + width + " ]");
        }
        if (missingBytes > this.nullBytes.length) {
            throw new IllegalArgumentException("Value [ " + value + " ] too short for width [ " + width + " ]; maximum shortfall [ " + this.nullBytes.length + " ]");
        }
        this.write(fieldByte);
        this.writeSmallInt(numValueBytes);
        this.write(valueBytes, 0, numValueBytes);
        if (missingBytes > 0) {
            this.write(this.nullBytes, 0, missingBytes);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_WriteBuffer", UtilImpl_WriteBuffer.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    }
}

