/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.internal;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.TargetsTableDetails;
import com.ibm.ws.annocache.targets.cache.TargetCache_ParseError;
import com.ibm.ws.annocache.targets.cache.TargetCache_Readable;
import com.ibm.ws.annocache.targets.cache.TargetCache_Reader;
import com.ibm.ws.annocache.targets.internal.TargetsTableImpl;
import com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TargetsTableDetailsImpl
implements TargetsTableDetails,
TargetCache_Readable {
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    public static final String CLASS_NAME = TargetsTableDetailsImpl.class.getSimpleName();
    protected final String hashText;
    protected final TargetsTableImpl parentData;
    protected final Map<String, Map<String, String>> i_packageDetails;
    protected final Map<String, Map<String, String>> i_classDetails;
    protected final Map<String, Map<String, Map<String, String>>> i_methodDetails;
    protected final Map<String, Map<String, Map<String, String>>> i_fieldDetails;
    protected static final Set<String> ADD_ALL = null;
    static final long serialVersionUID = 4436998455470104749L;

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "getHashText", new Object[0]);
        }
        String string = this.hashText;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "getHashText", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TargetsTableDetailsImpl(TargetsTableImpl parentData) {
        String methodName = "<init>";
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        this.parentData = parentData;
        this.i_packageDetails = new IdentityHashMap<String, Map<String, String>>();
        this.i_classDetails = new IdentityHashMap<String, Map<String, String>>();
        this.i_methodDetails = new IdentityHashMap<String, Map<String, Map<String, String>>>();
        this.i_fieldDetails = new IdentityHashMap<String, Map<String, Map<String, String>>>();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] of [ {1} ]", new Object[]{this.hashText, this.parentData.getHashText()});
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsTableImpl getParentData() {
        return this.parentData;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Map<String, String>> i_getPackageDetails() {
        return this.i_packageDetails;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, String> i_getPackageAnnotationDetails(String packageName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getPackageAnnotationDetails", new Object[]{packageName});
        }
        Map<String, String> map = this.i_packageDetails.get(packageName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            map = map;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getPackageAnnotationDetails", map);
        }
        return map;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String i_getPackageAnnotationDetail(String packageName, String annotationClassName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getPackageAnnotationDetail", new Object[]{packageName, annotationClassName});
        }
        Map<String, String> packageAnnotations = this.i_packageDetails.get(packageName);
        String string = packageAnnotations == null ? null : packageAnnotations.get(annotationClassName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getPackageAnnotationDetail", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Map<String, String>> i_getClassDetails() {
        return this.i_classDetails;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, String> i_getClassAnnotationDetails(String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getClassAnnotationDetails", new Object[]{i_className});
        }
        Map<String, String> map = this.i_classDetails.get(i_className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            map = map;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getClassAnnotationDetails", map);
        }
        return map;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String i_getClassAnnotationDetail(String i_className, String i_annotationClassName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getClassAnnotationDetail", new Object[]{i_className, i_annotationClassName});
        }
        Map<String, String> classAnnotations = this.i_classDetails.get(i_className);
        String string = classAnnotations == null ? null : classAnnotations.get(i_annotationClassName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getClassAnnotationDetail", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Map<String, Map<String, String>>> i_getMethodDetails() {
        return this.i_methodDetails;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Map<String, String>> i_getMethodAnnotationDetails(String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getMethodAnnotationDetails", new Object[]{i_className});
        }
        Map<String, Map<String, String>> map = this.i_methodDetails.get(i_className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            map = map;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getMethodAnnotationDetails", map);
        }
        return map;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, String> i_getMethodAnnotationDetails(String i_className, String i_methodSignature) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getMethodAnnotationDetails", new Object[]{i_className, i_methodSignature});
        }
        Map<String, Map<String, String>> methodDataForClass = this.i_methodDetails.get(i_className);
        Map<String, String> map = methodDataForClass == null ? null : methodDataForClass.get(i_methodSignature);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            map = map;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getMethodAnnotationDetails", map);
        }
        return map;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String i_getMethodAnnotationDetails(String i_className, String i_methodSignature, String i_annotationClassName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getMethodAnnotationDetails", new Object[]{i_className, i_methodSignature, i_annotationClassName});
        }
        Map<String, Map<String, String>> methodDataForClass = this.i_methodDetails.get(i_className);
        if (methodDataForClass == null) {
            String string = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getMethodAnnotationDetails", string);
            }
            return string;
        }
        Map<String, String> annotationDataForMethod = methodDataForClass.get(i_methodSignature);
        String string = annotationDataForMethod == null ? null : annotationDataForMethod.get(i_methodSignature);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getMethodAnnotationDetails", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Map<String, Map<String, String>>> i_getFieldDetails() {
        return this.i_fieldDetails;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, Map<String, String>> i_getFieldAnnotationDetails(String i_className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getFieldAnnotationDetails", new Object[]{i_className});
        }
        Map<String, Map<String, String>> map = this.i_fieldDetails.get(i_className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            map = map;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getFieldAnnotationDetails", map);
        }
        return map;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, String> i_getFieldAnnotationDetails(String i_className, String i_fieldName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getFieldAnnotationDetails", new Object[]{i_className, i_fieldName});
        }
        Map<String, Map<String, String>> fieldDataForClass = this.i_fieldDetails.get(i_className);
        Map<String, String> map = fieldDataForClass == null ? null : fieldDataForClass.get(i_fieldName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            map = map;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getFieldAnnotationDetails", map);
        }
        return map;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String i_getFieldAnnotationDetails(String i_className, String i_fieldName, String i_annotationClassName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getFieldAnnotationDetails", new Object[]{i_className, i_fieldName, i_annotationClassName});
        }
        Map<String, Map<String, String>> fieldDataForClass = this.i_fieldDetails.get(i_className);
        if (fieldDataForClass == null) {
            String string = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getFieldAnnotationDetails", string);
            }
            return string;
        }
        Map<String, String> annotationDataForMethod = fieldDataForClass.get(i_fieldName);
        String string = annotationDataForMethod == null ? null : annotationDataForMethod.get(i_fieldName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_getFieldAnnotationDetails", string);
        }
        return string;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(Logger useLogger) {
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class Source Annotations Details:");
        this.logPackageDetails(useLogger);
        this.logClassDetails(useLogger);
        this.logFieldDetails(useLogger);
        this.logMethodDetails(useLogger);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Annotations Details: Complete");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void logPackageDetails(Logger useLogger) {
        String methodName = "logPackageDetails";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Package Annotation Details:");
        this.logAnnotations(useLogger, "Package", "", this.i_packageDetails);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Package Details: Complete");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void logClassDetails(Logger useLogger) {
        String methodName = "logClassDetails";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class Annotation Details:");
        this.logAnnotations(useLogger, "Class", "", this.i_classDetails);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class Details: Complete");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void logFieldDetails(Logger useLogger) {
        String methodName = "logFieldDetails";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Field Annotation Details:");
        for (Map.Entry<String, Map<String, Map<String, String>>> i_classFieldsEntry : this.i_fieldDetails.entrySet()) {
            String i_className = i_classFieldsEntry.getKey();
            Map<String, Map<String, String>> i_fieldEntries = i_classFieldsEntry.getValue();
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class [ " + i_className + " ]");
            this.logAnnotations(useLogger, "Field", "  ", i_fieldEntries);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Field Annotation Details: Complete");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void logMethodDetails(Logger useLogger) {
        String methodName = "logMethodDetails";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Method Annotation Details:");
        for (Map.Entry<String, Map<String, Map<String, String>>> i_classMethodsEntry : this.i_methodDetails.entrySet()) {
            String i_className = i_classMethodsEntry.getKey();
            Map<String, Map<String, String>> i_methodEntries = i_classMethodsEntry.getValue();
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class [ " + i_className + " ]");
            this.logAnnotations(useLogger, "Method", "  ", i_methodEntries);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Method Annotation Details: Complete");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void logAnnotations(Logger useLogger, String entryTypeName, String prefix, Map<String, Map<String, String>> i_entries) {
        String methodName = "logAnnotations";
        for (Map.Entry<String, Map<String, String>> i_entry : i_entries.entrySet()) {
            String i_entryName = i_entry.getKey();
            Map<String, String> i_entryAnnotations = i_entry.getValue();
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, prefix + entryTypeName + " [ " + i_entryName + " ]");
            for (Map.Entry<String, String> i_annotationEntry : i_entryAnnotations.entrySet()) {
                String i_annotationClassName = i_annotationEntry.getKey();
                String annotationDetailText = i_annotationEntry.getValue();
                useLogger.logp(Level.FINER, CLASS_NAME, methodName, prefix + "  [ " + i_annotationClassName + " ] [ " + annotationDetailText + " ]");
            }
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logConsolidated(Logger useLogger) {
        String methodName = "logConsolidated";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Annotations Details:");
        this.logConsolidatedPackageDetails(useLogger);
        this.logConsolidatedClassDetails(useLogger);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Annotation Details: Complete");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void logConsolidatedPackageDetails(Logger useLogger) {
        String methodName = "logConsolidatedPackageDetails";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Package Annotation Details:");
        this.logConsolidatedAnnotations(useLogger, "Package", "", this.i_packageDetails);
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Package Details: Complete");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void logConsolidatedClassDetails(Logger useLogger) {
        String methodName = "logConsolidatedClassDetails";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class Details:");
        HashSet<String> i_classNames = new HashSet<String>();
        i_classNames.addAll(this.i_classDetails.keySet());
        i_classNames.addAll(this.i_fieldDetails.keySet());
        i_classNames.addAll(this.i_methodDetails.keySet());
        Object[] i_sortedClassNames = i_classNames.toArray(new String[i_classNames.size()]);
        Arrays.sort(i_sortedClassNames);
        for (Object i_className : i_sortedClassNames) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class [ " + (String)i_className + " ]");
            Map<String, String> i_classAnnotations = this.i_classDetails.get(i_className);
            if (i_classAnnotations == null) {
                useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  No class annotations");
            } else {
                useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Class annotations:");
                this.logConsolidatedAnnotations(useLogger, "  ", i_classAnnotations);
            }
            Map<String, Map<String, String>> i_fieldAnnotations = this.i_fieldDetails.get(i_className);
            if (i_fieldAnnotations == null) {
                useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  No field annotations");
            } else {
                useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Field annotations:");
                this.logConsolidatedAnnotations(useLogger, "Field", "  ", i_fieldAnnotations);
            }
            Map<String, Map<String, String>> i_methodAnnotations = this.i_methodDetails.get(i_className);
            if (i_methodAnnotations == null) {
                useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  No method annotations");
                continue;
            }
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Method annotations:");
            this.logConsolidatedAnnotations(useLogger, "Method", "  ", i_methodAnnotations);
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class Details: Complete");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void logConsolidatedAnnotations(Logger useLogger, String entryTypeName, String prefix, Map<String, Map<String, String>> i_entries) {
        String methodName = "logConsolidatedAnnotations";
        Object[] i_sortedEntryNames = i_entries.keySet().toArray(new String[i_entries.size()]);
        Arrays.sort(i_sortedEntryNames);
        for (Object i_entryName : i_sortedEntryNames) {
            Map<String, String> i_entryAnnotations = i_entries.get(i_entryName);
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, prefix + entryTypeName + " [ " + (String)i_entryName + " ]");
            this.logConsolidatedAnnotations(useLogger, prefix, i_entryAnnotations);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void logConsolidatedAnnotations(Logger useLogger, String prefix, Map<String, String> i_annotations) {
        String methodName = "logConsolidatedAnnotations";
        Object[] i_sortedAnnotationClassNames = i_annotations.keySet().toArray(new String[i_annotations.size()]);
        Arrays.sort(i_sortedAnnotationClassNames);
        for (Object i_annotationClassName : i_sortedAnnotationClassNames) {
            String annotationDetailText = i_annotations.get(i_annotationClassName);
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, prefix + "  [ " + (String)i_annotationClassName + " ] [ " + annotationDetailText + " ]");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void record(TargetsVisitorClassImpl.ClassData classData) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "record", new Object[]{classData});
        }
        if (!classData.isClass) {
            Map<String, String> i_packageAnnotations = classData.i_classAnnotationsDetail;
            if (i_packageAnnotations != null) {
                this.i_putPackageAnnotations(classData.i_className, i_packageAnnotations);
            }
        } else {
            Map<String, Map<String, String>> i_classMethodAnnotations;
            Map<String, Map<String, String>> i_classFieldAnnotations;
            String i_className = classData.i_className;
            Map<String, String> i_classAnnotations = classData.i_classAnnotationsDetail;
            if (i_classAnnotations != null) {
                this.i_putClassAnnotations(i_className, i_classAnnotations);
            }
            if ((i_classFieldAnnotations = classData.i_classFieldAnnotationsDetail) != null) {
                this.i_putFieldAnnotations(i_className, i_classFieldAnnotations);
            }
            if ((i_classMethodAnnotations = classData.i_classMethodAnnotationsDetail) != null) {
                this.i_putMethodAnnotations(i_className, i_classMethodAnnotations);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "record");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_putPackageAnnotations(String i_packageName, Map<String, String> i_annotations) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putPackageAnnotations", new Object[]{i_packageName, i_annotations});
        }
        this.i_packageDetails.put(i_packageName, i_annotations);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putPackageAnnotations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_putClassAnnotations(String i_className, Map<String, String> i_annotations) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putClassAnnotations", new Object[]{i_className, i_annotations});
        }
        this.i_classDetails.put(i_className, i_annotations);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putClassAnnotations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_putFieldAnnotations(String i_className, Map<String, Map<String, String>> i_classFieldAnnotations) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putFieldAnnotations", new Object[]{i_className, i_classFieldAnnotations});
        }
        this.i_fieldDetails.put(i_className, i_classFieldAnnotations);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putFieldAnnotations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_putMethodAnnotations(String i_className, Map<String, Map<String, String>> i_classMethodAnnotations) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putMethodAnnotations", new Object[]{i_className, i_classMethodAnnotations});
        }
        this.i_methodDetails.put(i_className, i_classMethodAnnotations);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putMethodAnnotations");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void i_putPackageAnnotation(String i_packageName, String i_annotationClassName, String annotationDetail) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putPackageAnnotation", new Object[]{i_packageName, i_annotationClassName, annotationDetail});
        }
        Map<String, String> i_packageAnnotations = this.i_packageDetails.get(i_packageName);
        if (i_packageAnnotations == null) {
            i_packageAnnotations = new IdentityHashMap<String, String>();
            this.i_packageDetails.put(i_packageName, i_packageAnnotations);
        }
        i_packageAnnotations.put(i_annotationClassName, annotationDetail);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putPackageAnnotation");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void i_putClassAnnotation(String i_className, String i_annotationClassName, String annotationDetail) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putClassAnnotation", new Object[]{i_className, i_annotationClassName, annotationDetail});
        }
        Map<String, String> i_classAnnotations = this.i_classDetails.get(i_className);
        if (i_classAnnotations == null) {
            i_classAnnotations = new IdentityHashMap<String, String>();
            this.i_classDetails.put(i_className, i_classAnnotations);
        }
        i_classAnnotations.put(i_annotationClassName, annotationDetail);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putClassAnnotation");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void i_putFieldAnnotation(String i_className, String i_fieldName, String i_annotationClassName, String annotationDetail) {
        Map<String, String> i_fieldAnnotations;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putFieldAnnotation", new Object[]{i_className, i_fieldName, i_annotationClassName, annotationDetail});
        }
        Map<String, Map<String, String>> i_fieldAnnotationSuite = this.i_fieldDetails.get(i_className);
        if (i_fieldAnnotationSuite == null) {
            i_fieldAnnotationSuite = new IdentityHashMap<String, Map<String, String>>();
            this.i_fieldDetails.put(i_className, i_fieldAnnotationSuite);
        }
        if ((i_fieldAnnotations = i_fieldAnnotationSuite.get(i_fieldName)) == null) {
            i_fieldAnnotations = new IdentityHashMap<String, String>();
            i_fieldAnnotationSuite.put(i_fieldName, i_fieldAnnotations);
        }
        i_fieldAnnotations.put(i_annotationClassName, annotationDetail);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putFieldAnnotation");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void i_putMethodAnnotation(String i_className, String i_methodSignature, String i_annotationClassName, String annotationDetail) {
        Map<String, String> i_methodAnnotations;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putMethodAnnotation", new Object[]{i_className, i_methodSignature, i_annotationClassName, annotationDetail});
        }
        Map<String, Map<String, String>> i_methodAnnotationSuite = this.i_methodDetails.get(i_className);
        if (i_methodAnnotationSuite == null) {
            i_methodAnnotationSuite = new IdentityHashMap<String, Map<String, String>>();
            this.i_methodDetails.put(i_className, i_methodAnnotationSuite);
        }
        if ((i_methodAnnotations = i_methodAnnotationSuite.get(i_methodSignature)) == null) {
            i_methodAnnotations = new IdentityHashMap<String, String>();
            i_methodAnnotationSuite.put(i_methodSignature, i_methodAnnotations);
        }
        i_methodAnnotations.put(i_annotationClassName, annotationDetail);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_putMethodAnnotation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void restrictedAdd(TargetsTableDetailsImpl otherTable, Set<String> i_addedPackageNames, Set<String> i_addedClassNames) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "restrictedAdd", new Object[]{otherTable, i_addedPackageNames, i_addedClassNames});
        }
        this.i_addDetails(this.i_getPackageDetails(), otherTable.i_getPackageDetails(), i_addedPackageNames);
        this.i_addDetails(this.i_getClassDetails(), otherTable.i_getClassDetails(), i_addedClassNames);
        this.i_addDetailsSuite(this.i_getFieldDetails(), otherTable.i_getFieldDetails(), i_addedClassNames);
        this.i_addDetailsSuite(this.i_getMethodDetails(), otherTable.i_getMethodDetails(), i_addedClassNames);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "restrictedAdd");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_addDetails(Map<String, Map<String, String>> i_otherDetails, Map<String, Map<String, String>> i_theseDetails, Set<String> i_addedNames) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_addDetails", new Object[]{i_otherDetails, i_theseDetails, i_addedNames});
        }
        for (Map.Entry<String, Map<String, String>> i_otherDetailEntry : i_otherDetails.entrySet()) {
            String i_name = i_otherDetailEntry.getKey();
            if (i_addedNames != null && !i_addedNames.contains(i_name)) continue;
            Map<String, String> i_otherAnnotations = i_otherDetailEntry.getValue();
            Map<String, String> i_theseAnnotations = i_theseDetails.get(i_name);
            if (i_theseAnnotations == null) {
                i_theseAnnotations = new IdentityHashMap<String, String>();
                i_theseDetails.put(i_name, i_theseAnnotations);
            }
            i_theseAnnotations.putAll(i_otherAnnotations);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_addDetails");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void i_addDetailsSuite(Map<String, Map<String, Map<String, String>>> i_otherDetailSuite, Map<String, Map<String, Map<String, String>>> i_thisDetailSuite, Set<String> i_addedClassNames) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_addDetailsSuite", new Object[]{i_otherDetailSuite, i_thisDetailSuite, i_addedClassNames});
        }
        for (Map.Entry<String, Map<String, Map<String, String>>> i_otherSuiteEntry : i_otherDetailSuite.entrySet()) {
            String i_className = i_otherSuiteEntry.getKey();
            if (!i_addedClassNames.contains(i_className)) continue;
            Map<String, Map<String, String>> i_otherDetails = i_otherSuiteEntry.getValue();
            Map<String, Map<String, String>> i_theseDetails = i_thisDetailSuite.get(i_className);
            if (i_theseDetails == null) {
                i_theseDetails = new IdentityHashMap<String, Map<String, String>>();
                i_thisDetailSuite.put(i_className, i_theseDetails);
            }
            this.i_addDetails(i_otherDetails, i_theseDetails, ADD_ALL);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "i_addDetailsSuite");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean sameAs(TargetsTableDetailsImpl otherTable) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "sameAs", new Object[]{otherTable});
        }
        if (otherTable == this) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "sameAs", bl);
            }
            return bl;
        }
        if (!this.equalsSuite(this.i_getPackageDetails(), otherTable == null ? null : otherTable.i_getPackageDetails())) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "sameAs", bl);
            }
            return bl;
        }
        if (!this.equalsSuite(this.i_getClassDetails(), otherTable == null ? null : otherTable.i_getClassDetails())) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "sameAs", bl);
            }
            return bl;
        }
        if (!this.equalsClassSuite(this.i_getFieldDetails(), otherTable == null ? null : otherTable.i_getFieldDetails())) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "sameAs", bl);
            }
            return bl;
        }
        if (!this.equalsClassSuite(this.i_getMethodDetails(), otherTable == null ? null : otherTable.i_getMethodDetails())) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "sameAs", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "sameAs", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean equalsClassSuite(Map<String, Map<String, Map<String, String>>> finalClassSuite, Map<String, Map<String, Map<String, String>>> initialClassSuite) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsClassSuite", new Object[]{finalClassSuite, initialClassSuite});
        }
        if (finalClassSuite == null) {
            boolean bl = this.isEmptyClassSuite(initialClassSuite);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsClassSuite", bl);
            }
            return bl;
        }
        if (initialClassSuite == null) {
            boolean bl = this.isEmptyClassSuite(finalClassSuite);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsClassSuite", bl);
            }
            return bl;
        }
        for (Map.Entry<String, Map<String, Map<String, String>>> classSuiteEntry : finalClassSuite.entrySet()) {
            Map<String, Map<String, String>> initialDetailsSuite;
            String finalClassName = classSuiteEntry.getKey();
            Map<String, Map<String, String>> finalDetailsSuite = classSuiteEntry.getValue();
            if (this.equalsSuite(finalDetailsSuite, initialDetailsSuite = initialClassSuite.get(finalClassName))) continue;
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsClassSuite", bl);
            }
            return bl;
        }
        for (Map.Entry<String, Map<String, Map<String, String>>> initialSuiteEntry : initialClassSuite.entrySet()) {
            String initialClassName = initialSuiteEntry.getKey();
            if (finalClassSuite.containsKey(initialClassName) || this.isEmptySuite(initialSuiteEntry.getValue())) continue;
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsClassSuite", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsClassSuite", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isEmptyClassSuite(Map<String, Map<String, Map<String, String>>> classSuite) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "isEmptyClassSuite", new Object[]{classSuite});
        }
        if (classSuite == null) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "isEmptyClassSuite", bl);
            }
            return bl;
        }
        if (classSuite.isEmpty()) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "isEmptyClassSuite", bl);
            }
            return bl;
        }
        for (Map<String, Map<String, String>> suite : classSuite.values()) {
            if (this.isEmptySuite(suite)) continue;
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "isEmptyClassSuite", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "isEmptyClassSuite", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean equalsSuite(Map<String, Map<String, String>> finalSuite, Map<String, Map<String, String>> initialSuite) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsSuite", new Object[]{finalSuite, initialSuite});
        }
        if (finalSuite == null) {
            boolean bl = this.isEmptySuite(initialSuite);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsSuite", bl);
            }
            return bl;
        }
        if (initialSuite == null) {
            boolean bl = this.isEmptySuite(finalSuite);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsSuite", bl);
            }
            return bl;
        }
        for (Map.Entry<String, Map<String, String>> finalDetailsEntry : finalSuite.entrySet()) {
            Map<String, String> initialValue;
            String finalKey = finalDetailsEntry.getKey();
            Map<String, String> finalValue = finalDetailsEntry.getValue();
            if (this.equalsMap(finalValue, initialValue = initialSuite.get(finalKey))) continue;
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsSuite", bl);
            }
            return bl;
        }
        for (Map.Entry<String, Map<String, String>> initialDetailsEntry : initialSuite.entrySet()) {
            String initialKey = initialDetailsEntry.getKey();
            if (finalSuite.containsKey(initialKey) || initialDetailsEntry.getValue().isEmpty()) continue;
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsSuite", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsSuite", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isEmptySuite(Map<String, Map<String, String>> suite) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "isEmptySuite", new Object[]{suite});
        }
        if (suite == null) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "isEmptySuite", bl);
            }
            return bl;
        }
        if (suite.isEmpty()) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "isEmptySuite", bl);
            }
            return bl;
        }
        for (Map<String, String> detailValue : suite.values()) {
            if (detailValue.isEmpty()) continue;
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "isEmptySuite", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "isEmptySuite", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean equalsMap(Map<String, String> finalMap, Map<String, String> initialMap) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsMap", new Object[]{finalMap, initialMap});
        }
        if (finalMap == null) {
            boolean bl = initialMap == null || initialMap.isEmpty();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsMap", bl);
            }
            return bl;
        }
        if (initialMap == null) {
            boolean bl = finalMap.isEmpty();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsMap", bl);
            }
            return bl;
        }
        if (finalMap.size() != initialMap.size()) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsMap", bl);
            }
            return bl;
        }
        for (Map.Entry<String, String> finalEntry : finalMap.entrySet()) {
            String finalKey = finalEntry.getKey();
            String finalValue = finalEntry.getValue();
            String initialValue = initialMap.get(finalKey);
            if (initialValue == null) {
                boolean bl = false;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsMap", bl);
                }
                return bl;
            }
            if (finalValue.equals(initialValue)) continue;
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsMap", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "equalsMap", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<TargetCache_ParseError> readUsing(TargetCache_Reader reader) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "readUsing", new Object[]{reader});
        }
        List<TargetCache_ParseError> list = reader.read(this);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableDetailsImpl", "readUsing", list);
        }
        return list;
    }
}

