/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.jandex.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.nio.charset.Charset;
import java.util.ArrayList;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class SparseDotName
implements Comparable<SparseDotName> {
    public static final boolean SIMPLE = true;
    public static final boolean INNER_CLASS = true;
    public static final SparseDotName PLACEHOLDER;
    public static final SparseDotName[] PLACEHOLDER_ARRAY;
    public static final SparseDotName[] EMPTY_ARRAY;
    private static Charset UTF8;
    private final boolean innerClass;
    private final boolean simple;
    private final SparseDotName head;
    private final String tail;
    private int hash;
    static final long serialVersionUID = 810031012557973460L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public boolean isPlaceholder() {
        return this.simple && this.tail.isEmpty();
    }

    public static SparseDotName createSimple(byte[] bytes) {
        return SparseDotName.createSimple(new String(bytes, UTF8));
    }

    public static SparseDotName createSimple(String name) {
        return new SparseDotName(null, name, true, false);
    }

    public SparseDotName(SparseDotName head, String tail, boolean simple, boolean innerClass) {
        if (tail == null) {
            throw new IllegalArgumentException("Tail cannot be null");
        }
        if (simple && tail.indexOf(46) != -1) {
            throw new IllegalArgumentException("Simple name [ " + tail + " ] must not have any dots ('.')");
        }
        if (simple && head != null) {
            throw new IllegalArgumentException("Simple name [ " + tail + " ] must have a null prefix");
        }
        if (head != null && head.simple) {
            throw new IllegalArgumentException("Prefix [ " + head + " ] of [ " + tail + " ] must not be simple");
        }
        if (innerClass && simple) {
            throw new IllegalArgumentException("Simple name [ " + tail + " ] cannot be an inner class name");
        }
        if (innerClass && head == null) {
            throw new IllegalArgumentException("Inner class name [ " + tail + " ] must have a prefix");
        }
        this.simple = simple;
        this.head = head;
        this.tail = tail;
        this.innerClass = innerClass;
        this.hash = 0;
    }

    public String toString() {
        if (this.head == null) {
            return this.tail;
        }
        int size = 0;
        SparseDotName sizeCursor = this;
        while (sizeCursor != null) {
            SparseDotName prevCursor = sizeCursor.head;
            size += sizeCursor.tail.length();
            if (prevCursor != null) {
                ++size;
            }
            sizeCursor = prevCursor;
        }
        StringBuilder builder = new StringBuilder(size);
        SparseDotName fillCursor = this;
        while (fillCursor != null) {
            SparseDotName prevCursor = fillCursor.head;
            builder.insert(0, fillCursor.tail);
            if (prevCursor != null) {
                builder.insert(0, fillCursor.innerClass ? (char)'$' : '.');
            }
            fillCursor = prevCursor;
        }
        return builder.toString();
    }

    public boolean isInner() {
        return this.innerClass;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public SparseDotName prefix() {
        return this.head;
    }

    public String local() {
        return this.tail;
    }

    public int hashCode() {
        int useHash = this.hash;
        if (useHash != 0) {
            return useHash;
        }
        if (this.head != null) {
            useHash = this.head.hashCode();
            useHash = 31 * useHash + (this.innerClass ? 36 : 46);
            useHash = 31 * useHash + this.tail.hashCode();
        } else {
            useHash = this.tail.hashCode();
        }
        this.hash = useHash;
        return this.hash;
    }

    @Override
    public int compareTo(SparseDotName otherDotName) {
        if (!this.simple || !otherDotName.simple) {
            return this.toString().compareTo(otherDotName.toString());
        }
        ArrayList<SparseDotName> thisStack = new ArrayList<SparseDotName>(10);
        SparseDotName thisHead = this;
        while (thisHead != null) {
            thisStack.add(0, thisHead);
            thisHead = thisHead.head;
        }
        ArrayList<SparseDotName> otherStack = new ArrayList<SparseDotName>(10);
        SparseDotName otherHead = otherDotName;
        while (otherHead != null) {
            otherStack.add(0, otherHead);
            otherHead = otherHead.head;
        }
        int thisSize = thisStack.size();
        int otherSize = otherStack.size();
        int minSize = Math.min(thisSize, otherSize);
        for (int headNo = 0; headNo < minSize; ++headNo) {
            SparseDotName thisHead2 = (SparseDotName)thisStack.get(headNo);
            SparseDotName otherHead2 = (SparseDotName)otherStack.get(headNo);
            int nextComparison = thisHead2.tail.compareTo(otherHead2.tail);
            if (nextComparison == 0) continue;
            return nextComparison;
        }
        return thisSize - otherSize;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SparseDotName)) {
            return false;
        }
        SparseDotName otherDotName = (SparseDotName)other;
        if (this.simple != otherDotName.simple) {
            return false;
        }
        if (this.innerClass != otherDotName.innerClass) {
            return false;
        }
        if (!this.simple && this.head == null != (otherDotName.head == null)) {
            return false;
        }
        if (!this.tail.equals(otherDotName.tail)) {
            return false;
        }
        return this.simple || this.head == null || this.head.equals(otherDotName.head);
    }

    public boolean matches(String simpleName) {
        if (!this.simple) {
            return false;
        }
        return this.tail.equals(simpleName);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.jandex.internal.SparseDotName", SparseDotName.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        PLACEHOLDER = SparseDotName.createSimple("");
        PLACEHOLDER_ARRAY = new SparseDotName[0];
        EMPTY_ARRAY = PLACEHOLDER_ARRAY;
        UTF8 = Charset.forName("UTF-8");
    }
}

