/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.gogo.command.Util;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Basic {
    private final BundleContext m_bc;

    public Basic(BundleContext bc) {
        this.m_bc = bc;
    }

    @Descriptor(value="query bundle start level")
    public void bundlelevel(@Descriptor(value="bundle to query") Bundle bundle) {
        ArrayList refs = new ArrayList();
        StartLevel sl = Util.getService(this.m_bc, StartLevel.class, refs);
        if (sl == null) {
            System.out.println("Start Level service is unavailable.");
        } else if (bundle != null) {
            System.out.println(bundle + " is level " + sl.getBundleStartLevel(bundle));
        }
        Util.ungetServices(this.m_bc, refs);
    }

    @Descriptor(value="set bundle start level or initial bundle start level")
    public void bundlelevel(@Descriptor(value="set the bundle's start level") @Parameter(names={"-s", "--setlevel"}, presentValue="true", absentValue="false") boolean set, @Descriptor(value="set the initial bundle start level") @Parameter(names={"-i", "--setinitial"}, presentValue="true", absentValue="false") boolean initial, @Descriptor(value="target level") int level, @Descriptor(value="target identifiers") Bundle[] bundles) {
        ArrayList refs = new ArrayList();
        StartLevel sl = Util.getService(this.m_bc, StartLevel.class, refs);
        if (sl == null) {
            System.out.println("Start Level service is unavailable.");
        } else if (set && initial) {
            System.out.println("Cannot specify '-s' and '-i' at the same time.");
        } else if (!set && !initial) {
            System.out.println("Must specify either '-s' or '-i'.");
        } else if (level <= 0) {
            System.out.println("Specified start level must be greater than zero.");
        } else if (initial) {
            if (bundles != null && bundles.length == 0) {
                sl.setInitialBundleStartLevel(level);
            } else {
                System.out.println("Cannot specify bundles when setting initial start level.");
            }
        } else if (set) {
            if (bundles != null && bundles.length != 0) {
                for (Bundle bundle : bundles) {
                    sl.setBundleStartLevel(bundle, level);
                }
            } else {
                System.out.println("Must specify target bundles.");
            }
        }
        Util.ungetServices(this.m_bc, refs);
    }

    @Descriptor(value="query framework active start level")
    public void frameworklevel() {
        ArrayList refs = new ArrayList();
        StartLevel sl = Util.getService(this.m_bc, StartLevel.class, refs);
        if (sl == null) {
            System.out.println("Start Level service is unavailable.");
        }
        System.out.println("Level is " + sl.getStartLevel());
        Util.ungetServices(this.m_bc, refs);
    }

    @Descriptor(value="set framework active start level")
    public void frameworklevel(@Descriptor(value="target start level") int level) {
        ArrayList refs = new ArrayList();
        StartLevel sl = Util.getService(this.m_bc, StartLevel.class, refs);
        if (sl == null) {
            System.out.println("Start Level service is unavailable.");
        }
        sl.setStartLevel(level);
        Util.ungetServices(this.m_bc, refs);
    }

    @Descriptor(value="display bundle headers")
    public void headers(@Descriptor(value="target bundles") Bundle[] bundles) {
        for (Bundle bundle : bundles = bundles == null || bundles.length == 0 ? this.m_bc.getBundles() : bundles) {
            String title = Util.getBundleName(bundle);
            System.out.println("\n" + title);
            System.out.println(Util.getUnderlineString(title.length()));
            Dictionary dict = bundle.getHeaders();
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                String k = (String)keys.nextElement();
                String v = (String)dict.get(k);
                System.out.println(k + " = " + v);
            }
        }
    }

    @Descriptor(value="displays available commands")
    public void help() {
        Map<String, List<Method>> commands = this.getCommands();
        for (String name : commands.keySet()) {
            System.out.println(name);
        }
    }

    @Descriptor(value="displays information about a specific command")
    public void help(@Descriptor(value="target command") String name) {
        Map<String, List<Method>> commands = this.getCommands();
        List<Method> methods = null;
        int scopeIdx = name.indexOf(58);
        if (scopeIdx < 0) {
            for (Map.Entry<String, List<Method>> entry : commands.entrySet()) {
                String k = entry.getKey().substring(entry.getKey().indexOf(58) + 1);
                if (!name.equals(k)) continue;
                name = entry.getKey();
                methods = entry.getValue();
                break;
            }
        } else {
            methods = commands.get(name);
        }
        if (methods != null && methods.size() > 0) {
            for (Method m : methods) {
                int aliasIdx;
                String[] names;
                Descriptor d = m.getAnnotation(Descriptor.class);
                if (d == null) {
                    System.out.println("\n" + m.getName());
                } else {
                    System.out.println("\n" + m.getName() + " - " + d.value());
                }
                System.out.println("   scope: " + name.substring(0, name.indexOf(58)));
                Class<?>[] paramTypes = m.getParameterTypes();
                TreeMap<String, Parameter> flags = new TreeMap<String, Parameter>();
                TreeMap<String, String> flagDescs = new TreeMap<String, String>();
                TreeMap<String, Parameter> options = new TreeMap<String, Parameter>();
                TreeMap<String, String> optionDescs = new TreeMap<String, String>();
                ArrayList<String> params = new ArrayList<String>();
                Annotation[][] anns = m.getParameterAnnotations();
                for (int paramIdx = 0; paramIdx < anns.length; ++paramIdx) {
                    Class<?> paramType = m.getParameterTypes()[paramIdx];
                    if (paramType == CommandSession.class) continue;
                    Parameter p = Basic.findAnnotation(anns[paramIdx], Parameter.class);
                    d = Basic.findAnnotation(anns[paramIdx], Descriptor.class);
                    if (p != null) {
                        if (p.presentValue().equals("org.apache.felix.service.command.unspecified.parameter")) {
                            options.put(p.names()[0], p);
                            if (d == null) continue;
                            optionDescs.put(p.names()[0], d.value());
                            continue;
                        }
                        flags.put(p.names()[0], p);
                        if (d == null) continue;
                        flagDescs.put(p.names()[0], d.value());
                        continue;
                    }
                    if (d != null) {
                        params.add(paramTypes[paramIdx].getSimpleName());
                        params.add(d.value());
                        continue;
                    }
                    params.add(paramTypes[paramIdx].getSimpleName());
                    params.add("");
                }
                if (flags.size() > 0) {
                    System.out.println("   flags:");
                    for (Map.Entry entry : flags.entrySet()) {
                        names = ((Parameter)entry.getValue()).names();
                        System.out.print("      " + names[0]);
                        for (aliasIdx = 1; aliasIdx < names.length; ++aliasIdx) {
                            System.out.print(", " + names[aliasIdx]);
                        }
                        System.out.println("   " + (String)flagDescs.get(entry.getKey()));
                    }
                }
                if (options.size() > 0) {
                    System.out.println("   options:");
                    for (Map.Entry entry : options.entrySet()) {
                        names = ((Parameter)entry.getValue()).names();
                        System.out.print("      " + names[0]);
                        for (aliasIdx = 1; aliasIdx < names.length; ++aliasIdx) {
                            System.out.print(", " + names[aliasIdx]);
                        }
                        System.out.println("   " + (String)optionDescs.get(entry.getKey()) + (((Parameter)entry.getValue()).absentValue() == null ? "" : " [optional]"));
                    }
                }
                if (params.size() <= 0) continue;
                System.out.println("   parameters:");
                Iterator it = params.iterator();
                while (it.hasNext()) {
                    System.out.println("      " + (String)it.next() + "   " + (String)it.next());
                }
            }
        }
    }

    private static <T extends Annotation> T findAnnotation(Annotation[] anns, Class<T> clazz) {
        for (int i = 0; anns != null && i < anns.length; ++i) {
            if (!clazz.isInstance(anns[i])) continue;
            return (T)((Annotation)clazz.cast(anns[i]));
        }
        return null;
    }

    private Map<String, List<Method>> getCommands() {
        ServiceReference[] refs = null;
        try {
            refs = this.m_bc.getAllServiceReferences(null, "(osgi.command.scope=*)");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        TreeMap<String, List<Method>> commands = new TreeMap<String, List<Method>>();
        for (ServiceReference ref : refs) {
            String[] funcs;
            String[] stringArray;
            Object svc = this.m_bc.getService(ref);
            if (svc == null) continue;
            String scope = (String)ref.getProperty("osgi.command.scope");
            Object ofunc = ref.getProperty("osgi.command.function");
            if (ofunc instanceof String[]) {
                stringArray = (String[])ofunc;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = String.valueOf(ofunc);
            }
            for (String func : funcs = stringArray) {
                commands.put(scope + ":" + func, new ArrayList());
            }
            if (!commands.isEmpty()) {
                Method[] methods;
                for (Method method : methods = svc.getClass().getMethods()) {
                    List commandMethods = (List)commands.get(scope + ":" + method.getName());
                    if (commandMethods == null) continue;
                    commandMethods.add(method);
                }
            }
            Iterator it = commands.entrySet().iterator();
            while (it.hasNext()) {
                if (((List)it.next().getValue()).size() != 0) continue;
                it.remove();
            }
        }
        return commands;
    }

    @Descriptor(value="install bundle using URLs")
    public void install(@Descriptor(value="command session") CommandSession session, @Descriptor(value="target URLs") String[] urls) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (String url : urls) {
            String location = Util.resolveUri(session, url.trim());
            Bundle bundle = null;
            try {
                bundle = this.m_bc.installBundle(location, null);
            }
            catch (IllegalStateException ex) {
                System.err.println(ex.toString());
            }
            catch (BundleException ex) {
                if (ex.getNestedException() != null) {
                    System.err.println(ex.getNestedException().toString());
                } else {
                    System.err.println(ex.toString());
                }
            }
            catch (Exception ex) {
                System.err.println(ex.toString());
            }
            if (bundle == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(bundle.getBundleId());
        }
        if (sb.toString().indexOf(44) > 0) {
            System.out.println("Bundle IDs: " + sb.toString());
        } else if (sb.length() > 0) {
            System.out.println("Bundle ID: " + sb.toString());
        }
    }

    @Descriptor(value="list all installed bundles")
    public void lb(@Descriptor(value="show location") @Parameter(names={"-l", "--location"}, presentValue="true", absentValue="false") boolean showLoc, @Descriptor(value="show symbolic name") @Parameter(names={"-s", "--symbolicname"}, presentValue="true", absentValue="false") boolean showSymbolic, @Descriptor(value="show update location") @Parameter(names={"-u", "--updatelocation"}, presentValue="true", absentValue="false") boolean showUpdate) {
        this.lb(showLoc, showSymbolic, showUpdate, null);
    }

    @Descriptor(value="list installed bundles matching a substring")
    public void lb(@Descriptor(value="show location") @Parameter(names={"-l", "--location"}, presentValue="true", absentValue="false") boolean showLoc, @Descriptor(value="show symbolic name") @Parameter(names={"-s", "--symbolicname"}, presentValue="true", absentValue="false") boolean showSymbolic, @Descriptor(value="show update location") @Parameter(names={"-u", "--updatelocation"}, presentValue="true", absentValue="false") boolean showUpdate, @Descriptor(value="subtring matched against name or symbolic name") String pattern) {
        ArrayList refs = new ArrayList();
        StartLevel sl = Util.getService(this.m_bc, StartLevel.class, refs);
        if (sl == null) {
            System.out.println("Start Level service is unavailable.");
        }
        ArrayList<Bundle> found = new ArrayList<Bundle>();
        if (pattern == null) {
            found.addAll(Arrays.asList(this.m_bc.getBundles()));
        } else {
            Bundle[] bundles = this.m_bc.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                Bundle bundle = bundles[i];
                String name = (String)bundle.getHeaders().get("Bundle-Name");
                if (!this.matchBundleName(bundle.getSymbolicName(), pattern) && !this.matchBundleName(name, pattern)) continue;
                found.add(bundle);
            }
        }
        if (found.size() > 0) {
            Basic.printBundleList(found.toArray(new Bundle[found.size()]), sl, showLoc, showSymbolic, showUpdate);
        } else {
            System.out.println("No matching bundles found");
        }
        Util.ungetServices(this.m_bc, refs);
    }

    private boolean matchBundleName(String name, String pattern) {
        return name != null && name.toLowerCase().contains(pattern.toLowerCase());
    }

    @Descriptor(value="display all matching log entries")
    public void log(@Descriptor(value="minimum log level [ debug | info | warn | error ]") String logLevel) {
        this.log(-1, logLevel);
    }

    @Descriptor(value="display some matching log entries")
    public void log(@Descriptor(value="maximum number of entries") int maxEntries, @Descriptor(value="minimum log level [ debug | info | warn | error ]") String logLevel) {
        ArrayList refs = new ArrayList();
        LogReaderService lrs = Util.getService(this.m_bc, LogReaderService.class, refs);
        if (lrs == null) {
            System.out.println("Log reader service is unavailable.");
        } else {
            Enumeration entries = lrs.getLog();
            int minLevel = Basic.logLevelAsInt(logLevel);
            int index = 0;
            while (entries.hasMoreElements() && (maxEntries < 0 || index < maxEntries)) {
                LogEntry entry = (LogEntry)entries.nextElement();
                if (entry.getLevel() > minLevel) continue;
                this.display(entry);
                ++index;
            }
            Util.ungetServices(this.m_bc, refs);
        }
    }

    private void display(LogEntry entry) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        StringBuffer buffer = new StringBuffer();
        buffer.append(sdf.format(new Date(entry.getTime()))).append(" ");
        buffer.append(Basic.logLevelAsString(entry.getLevel())).append(" - ");
        buffer.append("Bundle: ").append(entry.getBundle().getSymbolicName());
        if (entry.getServiceReference() != null) {
            buffer.append(" - ");
            buffer.append(entry.getServiceReference().toString());
        }
        buffer.append(" - ").append(entry.getMessage());
        if (entry.getException() != null) {
            buffer.append(" - ");
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            entry.getException().printStackTrace(pw);
            buffer.append(writer.toString());
        }
        System.out.println(buffer.toString());
    }

    private static int logLevelAsInt(String logLevel) {
        if ("error".equalsIgnoreCase(logLevel)) {
            return 1;
        }
        if ("warn".equalsIgnoreCase(logLevel)) {
            return 2;
        }
        if ("info".equalsIgnoreCase(logLevel)) {
            return 3;
        }
        return 4;
    }

    private static String logLevelAsString(int level) {
        switch (level) {
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "WARNING";
            }
            case 3: {
                return "INFO";
            }
        }
        return "DEBUG";
    }

    @Descriptor(value="refresh bundles")
    public void refresh(@Descriptor(value="target bundles (can be null or empty)") Bundle[] bundles) {
        ArrayList refs;
        PackageAdmin pa;
        if (bundles != null && bundles.length == 0) {
            bundles = null;
        }
        if ((pa = Util.getService(this.m_bc, PackageAdmin.class, refs = new ArrayList())) == null) {
            System.out.println("Package Admin service is unavailable.");
        }
        pa.refreshPackages(bundles == null ? null : bundles);
        Util.ungetServices(this.m_bc, refs);
    }

    @Descriptor(value="resolve bundles")
    public void resolve(@Descriptor(value="target bundles (can be null or empty)") Bundle[] bundles) {
        ArrayList refs;
        PackageAdmin pa;
        if (bundles != null && bundles.length == 0) {
            bundles = null;
        }
        if ((pa = Util.getService(this.m_bc, PackageAdmin.class, refs = new ArrayList())) == null) {
            System.out.println("Package Admin service is unavailable.");
        }
        if (!pa.resolveBundles(bundles)) {
            System.out.println("Not all bundles could be resolved.");
        }
        Util.ungetServices(this.m_bc, refs);
    }

    @Descriptor(value="start bundles")
    public void start(@Descriptor(value="start bundle transiently") @Parameter(names={"-t", "--transient"}, presentValue="true", absentValue="false") boolean trans, @Descriptor(value="use declared activation policy") @Parameter(names={"-p", "--policy"}, presentValue="true", absentValue="false") boolean policy, @Descriptor(value="target bundle identifiers or URLs") String[] ss) {
        int options = 0;
        if (trans) {
            options |= 1;
        }
        if (policy) {
            options |= 2;
        }
        if (ss != null && ss.length >= 1) {
            for (String s : ss) {
                String id = s.trim();
                try {
                    Bundle bundle = null;
                    if (Character.isDigit(id.charAt(0))) {
                        long l = Long.parseLong(id);
                        bundle = this.m_bc.getBundle(l);
                    } else {
                        bundle = this.m_bc.installBundle(id);
                    }
                    if (bundle != null) {
                        bundle.start(options);
                        continue;
                    }
                    System.err.println("Bundle ID " + id + " is invalid.");
                }
                catch (NumberFormatException ex) {
                    System.err.println("Unable to parse id '" + id + "'.");
                }
                catch (BundleException ex) {
                    if (ex.getNestedException() != null) {
                        ex.printStackTrace();
                        System.err.println(ex.getNestedException().toString());
                        continue;
                    }
                    System.err.println(ex.toString());
                }
                catch (Exception ex) {
                    System.err.println(ex.toString());
                }
            }
        } else {
            System.err.println("Incorrect number of arguments");
        }
    }

    @Descriptor(value="stop bundles")
    public void stop(@Descriptor(value="stop bundle transiently") @Parameter(names={"-t", "--transient"}, presentValue="true", absentValue="false") boolean trans, @Descriptor(value="target bundles") Bundle[] bundles) {
        if (bundles == null || bundles.length == 0) {
            System.out.println("Please specify the bundles to stop.");
        }
        int options = 0;
        if (trans) {
            options |= 1;
        }
        for (Bundle bundle : bundles) {
            try {
                bundle.stop(options);
            }
            catch (BundleException ex) {
                if (ex.getNestedException() != null) {
                    System.err.println(ex.getNestedException().toString());
                    continue;
                }
                System.err.println(ex.toString());
            }
            catch (Exception ex) {
                System.err.println(ex.toString());
            }
        }
    }

    @Descriptor(value="uninstall bundles")
    public void uninstall(@Descriptor(value="target bundles") Bundle[] bundles) {
        if (bundles == null || bundles.length == 0) {
            System.out.println("Please specify the bundles to uninstall.");
        } else {
            try {
                for (Bundle bundle : bundles) {
                    bundle.uninstall();
                }
            }
            catch (BundleException ex) {
                if (ex.getNestedException() != null) {
                    ex.printStackTrace();
                    System.err.println(ex.getNestedException().toString());
                } else {
                    System.err.println(ex.toString());
                }
            }
            catch (Exception ex) {
                System.err.println(ex.toString());
            }
        }
    }

    @Descriptor(value="update bundle")
    public void update(@Descriptor(value="target bundle") Bundle bundle) {
        try {
            if (bundle != null) {
                bundle.update();
            }
        }
        catch (BundleException ex) {
            if (ex.getNestedException() != null) {
                System.err.println(ex.getNestedException().toString());
            } else {
                System.err.println(ex.toString());
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }

    @Descriptor(value="update bundle from URL")
    public void update(@Descriptor(value="command session") CommandSession session, @Descriptor(value="target bundle") Bundle bundle, @Descriptor(value="URL from where to retrieve bundle") String location) throws IOException {
        block9: {
            if (location != null) {
                location = Util.resolveUri(session, location.trim());
                try {
                    if (bundle != null) {
                        InputStream is = new URL(location).openStream();
                        bundle.update(is);
                        break block9;
                    }
                    System.err.println("Please specify a bundle to update");
                }
                catch (MalformedURLException ex) {
                    System.err.println("Unable to parse URL");
                }
                catch (IOException ex) {
                    System.err.println("Unable to open input stream: " + ex);
                }
                catch (BundleException ex) {
                    if (ex.getNestedException() != null) {
                        System.err.println(ex.getNestedException().toString());
                        break block9;
                    }
                    System.err.println(ex.toString());
                }
                catch (Exception ex) {
                    System.err.println(ex.toString());
                }
            } else {
                System.err.println("Must specify a location.");
            }
        }
    }

    @Descriptor(value="determines from where a bundle loads a class")
    public void which(@Descriptor(value="target bundle") Bundle bundle, @Descriptor(value="target class name") String className) {
        if (bundle == null) {
            System.err.println("Please specify a bundle");
        } else {
            Class clazz = null;
            try {
                clazz = bundle.loadClass(className);
                if (clazz.getClassLoader() == null) {
                    System.out.println("Loaded from: boot class loader");
                } else if (clazz.getClassLoader() instanceof BundleReference) {
                    Bundle p = ((BundleReference)clazz.getClassLoader()).getBundle();
                    System.out.println("Loaded from: " + p);
                } else {
                    System.out.println("Loaded from: " + clazz.getClassLoader());
                }
            }
            catch (ClassNotFoundException ex) {
                System.out.println("Class not found");
            }
        }
    }

    private static void printBundleList(Bundle[] bundles, StartLevel startLevel, boolean showLoc, boolean showSymbolic, boolean showUpdate) {
        if (startLevel != null) {
            System.out.println("START LEVEL " + startLevel.getStartLevel());
        }
        String lastColumn = "Name";
        if (showLoc) {
            lastColumn = "Location";
        } else if (showSymbolic) {
            lastColumn = "Symbolic name";
        } else if (showUpdate) {
            lastColumn = "Update location";
        }
        if (startLevel != null) {
            System.out.println(String.format("%5s|%-11s|%5s|%s", "ID", "State", "Level", lastColumn));
        } else {
            System.out.println(String.format("%5s|%-11s|%s", "ID", "State", lastColumn));
        }
        for (Bundle bundle : bundles) {
            int level;
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            name = name == null ? bundle.getSymbolicName() : name;
            String string = name = name == null ? bundle.getLocation() : name;
            if (showLoc) {
                name = bundle.getLocation();
            } else if (showSymbolic) {
                name = bundle.getSymbolicName();
                name = name == null ? "<no symbolic name>" : name;
            } else if (showUpdate) {
                name = (String)bundle.getHeaders().get("Bundle-UpdateLocation");
                name = name == null ? bundle.getLocation() : name;
            }
            name = !showLoc && !showUpdate ? name + " (" + bundle.getVersion() + ")" : name;
            int n = level = startLevel == null ? -1 : startLevel.getBundleStartLevel(bundle);
            if (level < 0) {
                System.out.println(String.format("%5d|%-11s|%s|%s", bundle.getBundleId(), Basic.getStateString(bundle), name, bundle.getVersion()));
                continue;
            }
            System.out.println(String.format("%5d|%-11s|%5d|%s|%s", bundle.getBundleId(), Basic.getStateString(bundle), level, name, bundle.getVersion()));
        }
    }

    private static String getStateString(Bundle bundle) {
        int state = bundle.getState();
        if (state == 32) {
            return "Active     ";
        }
        if (state == 2) {
            return "Installed  ";
        }
        if (state == 4) {
            return "Resolved   ";
        }
        if (state == 8) {
            return "Starting   ";
        }
        if (state == 16) {
            return "Stopping   ";
        }
        return "Unknown    ";
    }
}

