/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.adaptable.module.NotifierExtension;
import com.ibm.ws.app.manager.AppMessageHelper;
import com.ibm.ws.app.manager.NotificationHelper;
import com.ibm.ws.app.manager.internal.ApplicationInstallInfo;
import com.ibm.ws.app.manager.internal.monitor.ApplicationMonitorConfig;
import com.ibm.ws.app.manager.internal.monitor.UpdateTrigger;
import com.ibm.ws.classloading.ClassLoadingButler;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.DefaultNotification;
import com.ibm.wsspi.adaptable.module.Notifier;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationMonitor.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ApplicationMonitor {
    private static final TraceComponent tc = Tr.register(ApplicationMonitor.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.monitor.ApplicationMonitor");
    private final AtomicReference<ApplicationMonitorConfig> _config = new AtomicReference();
    private final AtomicReference<ExecutorService> _executorService = new AtomicReference();
    private final ConcurrentHashMap<String, ApplicationListeners> _appListeners = new ConcurrentHashMap();
    static final long serialVersionUID = -6677716415972806660L;

    @Activate
    protected void activate(ComponentContext ctx, Map<String, Object> config) {
        ctx.getBundleContext();
    }

    @Modified
    protected void modified(Map<String, Object> config) {
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx, int reason) {
        for (ApplicationListeners listeners : this._appListeners.values()) {
            listeners.stopListeners(true);
        }
    }

    @Reference(name="executorService")
    protected void setExecutorService(ScheduledExecutorService executorService) {
        this._executorService.set(executorService);
    }

    protected void unsetExecutorService(ScheduledExecutorService executorService) {
        this._executorService.set(null);
    }

    public ApplicationMonitorConfig getConfig() {
        return this._config.get();
    }

    public void refresh(ApplicationMonitorConfig config) {
        this._config.set(config);
        UpdateTrigger trigger = config.getUpdateTrigger();
        if (trigger != UpdateTrigger.DISABLED) {
            for (ApplicationListeners listeners : this._appListeners.values()) {
                listeners.startListeners(config.getPollingRate(), config.getUpdateTrigger() == UpdateTrigger.MBEAN);
            }
        } else {
            for (ApplicationListeners listeners : this._appListeners.values()) {
                listeners.stopListeners(false);
            }
        }
    }

    @FFDCIgnore(value={UnableToAdaptException.class})
    public void addApplication(ApplicationInstallInfo installInfo) {
        boolean listenForRootStructuralChanges;
        Collection<Notifier.Notification> notificationsToMonitor;
        ApplicationMonitoringInformation ami = installInfo.getApplicationMonitoringInformation();
        if (ami != null) {
            notificationsToMonitor = ami.getNotificationsToMonitor();
            listenForRootStructuralChanges = ami.isListeningForRootStructuralChanges();
        } else {
            notificationsToMonitor = null;
            listenForRootStructuralChanges = true;
        }
        try {
            ApplicationMonitorConfig config;
            ApplicationListeners listeners = new ApplicationListeners(installInfo.getUpdateHandler(), this._executorService);
            if (notificationsToMonitor != null) {
                for (Notifier.Notification notificationToMonitor : notificationsToMonitor) {
                    ApplicationListener listener = new ApplicationListener(notificationToMonitor, listeners, installInfo);
                    listeners.addListener(listener);
                }
                listeners.addListener(new RootApplicationListener(installInfo.getContainer(), listenForRootStructuralChanges, listeners));
            } else {
                listeners.addListener(new CompleteApplicationListener(installInfo.getContainer(), listeners));
            }
            ApplicationListeners old = this._appListeners.put(installInfo.getPid(), listeners);
            if (old != null) {
                old.stopListeners(true);
            }
            if ((config = this._config.get()).getUpdateTrigger() != UpdateTrigger.DISABLED) {
                listeners.startListeners(config.getPollingRate(), config.getUpdateTrigger() == UpdateTrigger.MBEAN);
            }
        }
        catch (UnableToAdaptException e) {
            AppMessageHelper.get(installInfo.getHandler()).warning("APPLICATION_MONITORING_FAIL", installInfo.getName());
        }
    }

    public void removeApplication(String pid) {
        ApplicationListeners listeners = this._appListeners.remove(pid);
        if (listeners != null) {
            listeners.stopListeners(true);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class CompleteApplicationListener
    extends BaseApplicationListener {
        static final long serialVersionUID = 354332027257632561L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CompleteApplicationListener(Container container, ApplicationListeners listeners) throws UnableToAdaptException {
            super((Notifier.Notification)new DefaultNotification(container, "/"), listeners);
        }

        public void notifyEntryChange(Notifier.Notification added, Notifier.Notification removed, Notifier.Notification modified) {
            if (removed.getPaths().contains("/")) {
                this.listeners.queueEvent(EventType.REMOVE);
            } else if (!(added.getPaths().isEmpty() && removed.getPaths().isEmpty() && modified.getPaths().isEmpty())) {
                this.listeners.queueEvent(EventType.UPDATE);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CompleteApplicationListener.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.monitor.ApplicationMonitor$CompleteApplicationListener");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class ApplicationListener
    extends BaseApplicationListener {
        private static final String[] MINOR_UPDATE_FILE_EXTENSIONS;
        private final ApplicationInstallInfo appInfo;
        private final ClassLoadingButler butler;
        static final long serialVersionUID = 415518968789495942L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ApplicationListener(Notifier.Notification monitoringInformation, ApplicationListeners listeners, ApplicationInstallInfo appInfo) throws UnableToAdaptException {
            super(monitoringInformation, listeners);
            this.appInfo = appInfo;
            this.butler = (ClassLoadingButler)appInfo.getContainer().adapt(ClassLoadingButler.class);
        }

        private boolean isMinorUpdate(Notifier.Notification modified) {
            if (modified.getPaths().isEmpty()) {
                return true;
            }
            for (String path : modified.getPaths()) {
                boolean hasMinorExtension = false;
                for (String pattern : MINOR_UPDATE_FILE_EXTENSIONS) {
                    if (!path.toLowerCase().endsWith(pattern)) continue;
                    hasMinorExtension = true;
                    break;
                }
                if (hasMinorExtension) continue;
                return false;
            }
            boolean isMinor = this.butler.redefineClasses(modified);
            if (isMinor) {
                String msg = AppMessageHelper.get(this.appInfo.getHandler()).formatMessage("APPLICATION_UPDATED", this.appInfo.getName());
                NotificationHelper.broadcastChange(this.appInfo.getMBeanNotifier(), this.appInfo.getMBeanName(), "application.update", Boolean.TRUE, msg);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                }
            }
            return isMinor;
        }

        public void notifyEntryChange(Notifier.Notification added, Notifier.Notification removed, Notifier.Notification modified) {
            if (!(added.getPaths().isEmpty() && removed.getPaths().isEmpty() && this.isMinorUpdate(modified))) {
                this.listeners.queueEvent(EventType.UPDATE);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ApplicationListener.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.monitor.ApplicationMonitor$ApplicationListener");
            String builtInPatterns = ".class,.jsp,.jspx,.jsw,.jsv,.jspf,.tld,.tag";
            String userPatterns = System.getProperty("com.ibm.ws.app.manager.minorUpdateFileExtensions");
            String minorUpdatePatterns = builtInPatterns + (userPatterns == null ? "" : "," + userPatterns);
            MINOR_UPDATE_FILE_EXTENSIONS = minorUpdatePatterns.split(",");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"minor file patterns: ", (Object[])new Object[]{MINOR_UPDATE_FILE_EXTENSIONS});
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class RootApplicationListener
    extends BaseApplicationListener {
        private final boolean listenForRootStructuralChanges;
        static final long serialVersionUID = -3538415793725844332L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public RootApplicationListener(Container container, boolean listenForRootStructuralChanges, ApplicationListeners listeners) throws UnableToAdaptException {
            super((Notifier.Notification)new DefaultNotification(container, "!/"), listeners);
            this.listenForRootStructuralChanges = listenForRootStructuralChanges;
        }

        public void notifyEntryChange(Notifier.Notification added, Notifier.Notification removed, Notifier.Notification modified) {
            if (removed.getPaths().contains("/")) {
                this.listeners.queueEvent(EventType.REMOVE);
            } else if (!(!this.listenForRootStructuralChanges || added.getPaths().isEmpty() && removed.getPaths().isEmpty())) {
                this.listeners.queueEvent(EventType.UPDATE);
            } else if (modified.getPaths().contains("/")) {
                this.listeners.queueEvent(EventType.UPDATE);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(RootApplicationListener.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.monitor.ApplicationMonitor$RootApplicationListener");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static abstract class BaseApplicationListener
    implements NotifierExtension.NotificationListener {
        protected final Notifier applicationNotifier;
        protected final AtomicBoolean isListening = new AtomicBoolean(false);
        protected final Notifier.Notification monitoringInformation;
        protected final ApplicationListeners listeners;
        private final String id = "com.ibm.ws.app.listener";
        static final long serialVersionUID = -886646069652346174L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BaseApplicationListener(Notifier.Notification monitoringInformation, ApplicationListeners listeners) throws UnableToAdaptException {
            this.monitoringInformation = monitoringInformation;
            this.applicationNotifier = (Notifier)monitoringInformation.getContainer().adapt(Notifier.class);
            this.listeners = listeners;
        }

        private synchronized void start(long interval, boolean useMBean) {
            this.applicationNotifier.setNotificationOptions(interval, useMBean);
            if (this.isListening.compareAndSet(false, true)) {
                this.applicationNotifier.registerForNotifications(this.monitoringInformation, (Notifier.NotificationListener)this);
            }
        }

        private synchronized void stop() {
            if (this.isListening.compareAndSet(true, false)) {
                this.applicationNotifier.removeListener((Notifier.NotificationListener)this);
            }
        }

        public String getId() {
            return "com.ibm.ws.app.listener";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BaseApplicationListener.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.monitor.ApplicationMonitor$BaseApplicationListener");
        }
    }

    private static enum EventType {
        UPDATE,
        REMOVE;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class ApplicationListeners {
        private final UpdateHandler updateHandler;
        private final AtomicReference<ExecutorService> executorService;
        private final Collection<BaseApplicationListener> listeners = new HashSet<BaseApplicationListener>();
        private FutureTask<Object> future = null;
        private EventType eventType;
        private boolean start = true;
        static final long serialVersionUID = -7925656492005417059L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ApplicationListeners(UpdateHandler updateHandler, AtomicReference<ExecutorService> executorService) {
            this.updateHandler = updateHandler;
            this.executorService = executorService;
        }

        private void addListener(BaseApplicationListener listener) {
            this.listeners.add(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopListeners(boolean terminal) {
            ApplicationListeners applicationListeners = this;
            synchronized (applicationListeners) {
                this.start = !terminal;
            }
            for (BaseApplicationListener listener : this.listeners) {
                listener.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startListeners(long interval, boolean useMBean) {
            boolean doStart;
            ApplicationListeners applicationListeners = this;
            synchronized (applicationListeners) {
                doStart = this.start;
            }
            if (doStart) {
                for (BaseApplicationListener listener : this.listeners) {
                    listener.start(interval, useMBean);
                }
            }
        }

        public synchronized void queueEvent(EventType eventToPerform) {
            ExecutorService executor;
            if (this.future != null && !this.future.isDone()) {
                this.future.cancel(true);
            }
            if (this.eventType == null || this.eventType != EventType.REMOVE) {
                this.eventType = eventToPerform;
            }
            if ((executor = this.executorService.get()) != null) {
                this.future = new FutureTask<Object>(new Callable<Object>(){
                    static final long serialVersionUID = 3317205856618937509L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    @FFDCIgnore(value={InterruptedException.class})
                    public Object call() {
                        try {
                            Thread.sleep(200L);
                            this.executeEvent();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.monitor.ApplicationMonitor$ApplicationListeners$1");
                    }
                });
                executor.execute(this.future);
            }
        }

        private synchronized void executeEvent() {
            if (this.eventType != null && this.start) {
                this.updateHandler.handleMonitorUpdate(this.eventType == EventType.REMOVE);
                this.future = null;
                this.eventType = null;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ApplicationListeners.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.monitor.ApplicationMonitor$ApplicationListeners");
        }
    }

    public static interface UpdateHandler {
        public void handleMonitorUpdate(boolean var1);
    }
}

