/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.cdi30.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.cdi.binding.MetricsBinding;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.astefanutti.metrics.cdi30.MetricResolver;
import io.astefanutti.metrics.cdi30.MetricsExtension;
import io.openliberty.microprofile.metrics.internal.cdi30.helper.Utils;
import io.openliberty.microprofile.metrics.internal.cdi30.producer.MetricRegistryFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;
import org.eclipse.microprofile.metrics.annotation.Timed;

@Interceptor
@MetricsBinding
@Priority(value=1000)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricsInterceptor {
    private static final TraceComponent tc = Tr.register(MetricsInterceptor.class, (String)"METRICS", (String)"io.openliberty.microprofile.metrics.internal.cdi.resources.MetricsCDI");
    private final MetricRegistry registry;
    private final MetricResolver resolver;
    private final MetricsExtension extension;
    static final long serialVersionUID = 1217352514750102401L;

    @Inject
    private MetricsInterceptor(MetricRegistry registry, MetricResolver resolver, MetricsExtension extension) {
        this.registry = registry;
        this.resolver = resolver;
        this.extension = extension;
    }

    @AroundConstruct
    private Object metrics(InvocationContext context) throws Exception {
        Class bean = context.getConstructor().getDeclaringClass();
        if (!this.extension.getBeansVisited().contains(bean)) {
            this.extension.getBeansVisited().add(bean);
            this.registerMetrics(bean, context.getConstructor());
            Class type = bean;
            do {
                for (Method method : MetricsInterceptor.getDeclaredMethods(type)) {
                    if (method.isSynthetic() || Modifier.isPrivate(method.getModifiers())) continue;
                    this.registerMetrics(bean, method);
                }
            } while (!Object.class.equals(type = type.getSuperclass()));
        }
        Object target = context.proceed();
        Class type = bean;
        do {
            for (Method method : MetricsInterceptor.getDeclaredMethods(type)) {
                MetricResolver.Of<org.eclipse.microprofile.metrics.annotation.Gauge> gauge = this.resolver.gauge(bean, method);
                if (!gauge.isPresent()) continue;
                this.registry.register(gauge.metadata(), (Metric)new ForwardingGauge(method, context.getTarget()), Utils.tagsToTags(gauge.tags()));
                MetricID mid = new MetricID(gauge.metadata().getName(), Utils.tagsToTags(gauge.tags()));
                this.extension.addMetricID(mid);
            }
        } while (!Object.class.equals(type = type.getSuperclass()));
        return target;
    }

    private <E extends Member & AnnotatedElement> void registerMetrics(Class<?> bean, E element) {
        MetricResolver.Of<SimplyTimed> simplyTimed;
        MetricResolver.Of<Timed> timed;
        MetricResolver.Of<Metered> metered;
        MetricResolver.Of<ConcurrentGauge> concurrentGauge;
        MetricResolver.Of<Counted> counted = this.resolver.counted(bean, element);
        if (counted.isPresent()) {
            this.registry.counter(counted.metadata(), Utils.tagsToTags(counted.tags()));
            MetricID mid = new MetricID(counted.metadata().getName(), Utils.tagsToTags(counted.tags()));
            this.extension.addMetricID(element, (Annotation)counted.metricAnnotation(), mid);
        }
        if ((concurrentGauge = this.resolver.concurentGauged(bean, element)).isPresent()) {
            this.registry.concurrentGauge(concurrentGauge.metadata(), Utils.tagsToTags(concurrentGauge.tags()));
            MetricID mid = new MetricID(concurrentGauge.metadata().getName(), Utils.tagsToTags(concurrentGauge.tags()));
            this.extension.addMetricID(element, (Annotation)concurrentGauge.metricAnnotation(), mid);
        }
        if ((metered = this.resolver.metered(bean, element)).isPresent()) {
            this.registry.meter(metered.metadata(), Utils.tagsToTags(metered.tags()));
            MetricID mid = new MetricID(metered.metadata().getName(), Utils.tagsToTags(metered.tags()));
            this.extension.addMetricID(element, (Annotation)metered.metricAnnotation(), mid);
        }
        if ((timed = this.resolver.timed(bean, element)).isPresent()) {
            this.registry.timer(timed.metadata(), Utils.tagsToTags(timed.tags()));
            MetricID mid = new MetricID(timed.metadata().getName(), Utils.tagsToTags(timed.tags()));
            this.extension.addMetricID(element, (Annotation)timed.metricAnnotation(), mid);
        }
        if ((simplyTimed = this.resolver.simplyTimed(bean, element)).isPresent()) {
            this.registry.simpleTimer(simplyTimed.metadata(), Utils.tagsToTags(simplyTimed.tags()));
            MetricID mid = new MetricID(simplyTimed.metadata().getName(), Utils.tagsToTags(simplyTimed.tags()));
            this.extension.addMetricID(element, (Annotation)simplyTimed.metricAnnotation(), mid);
        }
    }

    @FFDCIgnore(value={InvocationTargetException.class})
    private static Object invokeMethod(Method method, Object object) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException cause) {
            throw new IllegalStateException("Error while calling method [" + method + "]", cause);
        }
    }

    private static Method[] getDeclaredMethods(Class<?> type) {
        if (System.getSecurityManager() == null) {
            return type.getDeclaredMethods();
        }
        return AccessController.doPrivileged(() -> type.getDeclaredMethods());
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class ForwardingGauge
    implements Gauge<Object> {
        private final Method method;
        private final Object object;
        static final long serialVersionUID = -3269969911553911168L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ForwardingGauge(Method method, Object object) {
            this.method = method;
            this.object = object;
            AccessController.doPrivileged(() -> {
                method.setAccessible(true);
                return null;
            });
        }

        @FFDCIgnore(value={IllegalStateException.class})
        public Object getValue() {
            try {
                return MetricsInterceptor.invokeMethod(this.method, this.object);
            }
            catch (IllegalStateException exception) {
                MetricRegistryFactory.getApplicationRegistry().removeMatching(new MetricFilter(){
                    static final long serialVersionUID = 1558854444901900168L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public boolean matches(MetricID metricID, Metric metric) {
                        if (metric.equals(this)) {
                            Tr.warning((TraceComponent)tc, (String)"cannot.resolve.metric.warning.CWMMC3000W", (Object[])new Object[]{metricID.getName()});
                            return true;
                        }
                        return false;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics.internal.cdi30.interceptors.MetricsInterceptor$ForwardingGauge$1", 1.class, (String)"METRICS", (String)"io.openliberty.microprofile.metrics.internal.cdi.resources.MetricsCDI");
                    }
                });
                throw exception;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics.internal.cdi30.interceptors.MetricsInterceptor$ForwardingGauge", ForwardingGauge.class, (String)"METRICS", (String)"io.openliberty.microprofile.metrics.internal.cdi.resources.MetricsCDI");
        }
    }
}

