/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.JmsDestination;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsQueueImpl;
import com.ibm.ws.sib.api.jms.impl.JmsTopicImpl;
import com.ibm.ws.sib.api.jms.impl.MsgDestEncodingUtilsImpl;
import com.ibm.ws.sib.utils.TopicWildcardTranslation;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;

public class URIDestinationCreator
implements JmsInternalConstants {
    private static TraceComponent tc = SibTr.register(URIDestinationCreator.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    public static final int QM_ERROR = 0;
    public static final int QM_DISCARD = 1;
    public static final int QM_TRANSFORM = 2;
    public static final int QM_PEV = 3;
    private static final String TOPIC_NAME = "topicName";
    private static final String REVERSE_RP = "reverseRP";
    private static final String FORWARD_RP = "forwardRP";
    private static final String STRING_AMPERSAND = "&";
    private static final String STRING_BACKSLASH = "\\";
    private static final String STRING_EQUALS_SIGN = "=";
    private static final char CHAR_BACKSLASH = '\\';
    private static final String MA88_EXPIRY = "expiry";
    private static final String MA88_PERSISTENCE = "persistence";
    private static final String MA88_BROKER_VERSION = "brokerVersion";
    private TopicWildcardTranslation twt;

    public URIDestinationCreator() {
        block2: {
            this.twt = null;
            try {
                this.twt = TopicWildcardTranslation.getInstance();
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Exception caught calling TopicWildcardTranslation.getInstance()");
            }
        }
    }

    public String extractPropertyFromURI(String propName, String uri) {
        String nvps;
        String[] parts;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"extractPropertyFromURI", (Object)new Object[]{propName, uri});
        }
        String result = null;
        if (uri != null && !(uri = uri.trim()).equals("") && (parts = this.splitOnNonEscapedChar(uri, '?', 2)).length >= 2 && !(nvps = parts[1].trim()).equals("")) {
            String[] nvpArray = this.splitOnNonEscapedChar(nvps, '&', -1);
            String propNameE = propName + STRING_EQUALS_SIGN;
            for (int i = 0; i < nvpArray.length; ++i) {
                String nvp = nvpArray[i];
                if (!nvp.startsWith(propNameE)) continue;
                result = nvp.substring(propNameE.length());
                break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"extractPropertyFromURI", result);
        }
        return result;
    }

    public Destination createDestinationFromString(String uri, DestType destType) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDestinationFromString", (Object)new Object[]{uri, destType});
        }
        JmsDestination result = null;
        if (uri.startsWith("dest://")) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "RESERVED_DEST_PREFIX_CWSIA0383", new Object[]{"dest://", uri}, tc);
        }
        if (uri.startsWith("queue://") || uri.startsWith("topic://")) {
            result = this.processURI(uri, 0, null);
        } else if (destType == DestType.QUEUE) {
            JmsQueueImpl q = new JmsQueueImpl();
            q.setQueueName(uri);
            result = q;
        } else {
            result = this.processShortTopicForm(uri);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDestinationFromString", (Object)result);
        }
        return result;
    }

    private JmsTopicImpl processShortTopicForm(String topic) throws JMSException {
        String topicSpace;
        String topicName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processShortTopicForm", (Object)topic);
        }
        String[] parts = this.splitOnNonEscapedChar(topic, ':', 2);
        parts[0] = this.unescape(parts[0], ':');
        if (parts.length > 1) {
            parts[1] = this.unescape(parts[1], ':');
        }
        parts[0] = this.unescapeBackslash(parts[0]);
        if (parts.length == 1) {
            topicName = parts[0];
            topicSpace = null;
        } else {
            topicSpace = parts[0];
            topicName = parts[1];
        }
        JmsTopicImpl result = new JmsTopicImpl();
        result.setTopicName(topicName);
        if (topicSpace != null) {
            result.setTopicSpace(topicSpace);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processShortTopicForm", (Object)result);
        }
        return result;
    }

    JmsDestination processURI(String uri, int qmProcessing, Map<String, String> nvpReturn) throws JMSException {
        boolean isQueue;
        JmsDestinationImpl result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processURI", (Object)new Object[]{uri, qmProcessing});
        }
        if (uri.startsWith("topic://")) {
            result = new JmsTopicImpl();
            isQueue = false;
        } else if (uri.startsWith("queue://")) {
            result = new JmsQueueImpl();
            isQueue = true;
        } else {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0386", null, tc);
        }
        String destURI = uri.substring(8, uri.length());
        String[] parts = this.splitOnNonEscapedChar(destURI, '?', 2);
        String destName = parts[0];
        String nvps = null;
        if (parts.length > 1) {
            nvps = parts[1].trim();
        }
        if (isQueue) {
            parts = this.splitOnNonEscapedChar(destName, '/', 2);
            String qmName = null;
            String queueName = null;
            if (parts.length > 1) {
                qmName = parts[0];
                queueName = parts[1];
                if (qmName.trim().equals("")) {
                    qmName = null;
                }
            } else {
                queueName = parts[0];
            }
            destName = queueName;
            switch (qmProcessing) {
                case 2: {
                    if (qmName == null) break;
                    destName = destName + "@" + qmName;
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    result.setBusName(qmName);
                    break;
                }
                case 0: {
                    if (qmName == null) break;
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_URI_ELEMENT_CWSIA0385", new Object[]{uri}, tc);
                }
                default: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Unknown value for qmProcessing: " + qmProcessing));
                    }
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0386", null, tc);
                }
            }
            destName = this.unescape(destName, '/');
        }
        destName = this.unescape(destName, '?');
        destName = this.unescapeBackslash(destName);
        if (isQueue) {
            ((JmsQueueImpl)result).setQueueName(destName);
        } else {
            ((JmsTopicImpl)result).setTopicName(destName);
        }
        this.processNVPs(nvps, result, nvpReturn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processURI", (Object)result);
        }
        return result;
    }

    private String[] splitOnNonEscapedChar(String inputStr, char splitChar, int expectedPartCount) {
        String nextPart;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"splitOnNonEscapedChar", (Object)new Object[]{inputStr, Character.valueOf(splitChar), expectedPartCount});
        }
        String[] parts = null;
        ArrayList<String> partsList = null;
        int startPoint = 0;
        int tokenStart = 0;
        int splitCharIndex = 0;
        int partCount = 0;
        while (splitCharIndex != -1 && partCount != expectedPartCount - 1) {
            splitCharIndex = inputStr.indexOf(splitChar, startPoint);
            if (splitCharIndex != -1 && !URIDestinationCreator.charIsEscaped(inputStr, splitCharIndex)) {
                nextPart = inputStr.substring(tokenStart, splitCharIndex);
                if (expectedPartCount >= 2) {
                    if (parts == null) {
                        parts = new String[expectedPartCount];
                    }
                    parts[partCount] = nextPart;
                } else {
                    if (partsList == null) {
                        partsList = new ArrayList<String>(5);
                    }
                    partsList.add(nextPart);
                }
                ++partCount;
                tokenStart = startPoint = splitCharIndex + 1;
                continue;
            }
            startPoint = splitCharIndex + 1;
        }
        nextPart = inputStr.substring(tokenStart, inputStr.length());
        if (expectedPartCount >= 2) {
            if (parts == null) {
                parts = new String[1];
            }
            parts[partCount] = nextPart;
        } else if (partsList == null) {
            parts = new String[]{nextPart};
        } else {
            partsList.add(nextPart);
            parts = partsList.toArray(new String[0]);
        }
        if (parts[parts.length - 1] == null) {
            int lastValidEntry = 0;
            while (parts[lastValidEntry] != null && !"".equals(parts[lastValidEntry])) {
                ++lastValidEntry;
            }
            String[] tempParts = new String[lastValidEntry];
            System.arraycopy(parts, 0, tempParts, 0, lastValidEntry);
            parts = tempParts;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"splitOnNonEscapedChar", (Object)parts);
        }
        return parts;
    }

    private void processNVPs(String nvps, JmsDestination dest, Map<String, String> nvpReturn) throws JMSException {
        String topicName;
        Map<Object, Object> propertyMap;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processNVPs", (Object)new Object[]{nvps, dest});
        }
        if (nvpReturn == null) {
            propertyMap = new HashMap();
        } else {
            nvpReturn.clear();
            propertyMap = nvpReturn;
        }
        if (nvps != null && !nvps.equals("")) {
            String[] nvpArray = this.splitOnNonEscapedChar(nvps, '&', -1);
            for (int i = 0; i < nvpArray.length; ++i) {
                String nvp = nvpArray[i];
                int equalsIndex = nvp.indexOf(STRING_EQUALS_SIGN);
                if (equalsIndex == -1) {
                    JmsErrorUtils.newThrowable(JMSException.class, "MALFORMED_URI_ELEMENT_CWSIA0382", new Object[]{nvp, nvps}, null, "URIDestinationCreator.processNVPs#1", this, tc);
                    continue;
                }
                if (equalsIndex == nvp.length() - 1) {
                    JmsErrorUtils.newThrowable(JMSException.class, "MALFORMED_URI_ELEMENT_CWSIA0382", new Object[]{nvp, nvps}, null, "URIDestinationCreator.processNVPs#2", this, tc);
                    continue;
                }
                String namePart = nvp.substring(0, equalsIndex);
                String valuePart = nvp.substring(equalsIndex + 1);
                String[] validatedNVP = this.validateNVP(namePart, valuePart, nvps, dest);
                namePart = validatedNVP[0];
                valuePart = validatedNVP[1];
                if (namePart.equals(FORWARD_RP)) {
                    String[] frp = valuePart.split("<#>");
                    ((JmsDestinationImpl)dest).setForwardRoutingPath(frp);
                    continue;
                }
                if (namePart.equals(REVERSE_RP)) {
                    String[] rrp = valuePart.split("<#>");
                    ((JmsDestinationImpl)dest).setReverseRoutingPath(rrp);
                    continue;
                }
                propertyMap.put(namePart, valuePart);
            }
        }
        if (dest instanceof JmsTopic && propertyMap.containsKey(MA88_BROKER_VERSION) && (topicName = ((JmsTopicImpl)dest).getTopicName()) != null) {
            String bVer = (String)propertyMap.remove(MA88_BROKER_VERSION);
            if ("1".equals(bVer)) {
                try {
                    topicName = this.twt.convertEventBrokerToSIB(topicName);
                }
                catch (ParseException pe) {
                    JmsErrorUtils.newThrowable(JMSException.class, "MALFORMED_URI_ELEMENT_CWSIA0382", new Object[]{topicName, nvps}, pe, "URIDestinationCreator.processNVPs#3", this, tc);
                }
            } else {
                try {
                    topicName = this.twt.convertMA0CToSIB(topicName);
                }
                catch (ParseException pe) {
                    JmsErrorUtils.newThrowable(JMSException.class, "MALFORMED_URI_ELEMENT_CWSIA0382", new Object[]{topicName, nvps}, pe, "URIDestinationCreator.processNVPs#4", this, tc);
                }
            }
            ((JmsTopicImpl)dest).setTopicName(topicName);
        }
        this.configureDestinationFromMap(dest, propertyMap, nvps);
    }

    private String unescape(String input, char c) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unescape", (Object)new Object[]{input, Character.valueOf(c)});
        }
        String result = input;
        if (input.indexOf(c) != -1) {
            int startValue = 0;
            StringBuffer temp = new StringBuffer(input);
            String cStr = new String(new char[]{c});
            while ((startValue = temp.indexOf(cStr, startValue)) != -1) {
                if (startValue > 0 && temp.charAt(startValue - 1) == '\\') {
                    temp.deleteCharAt(startValue - 1);
                    continue;
                }
                ++startValue;
            }
            result = temp.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unescape", (Object)result);
        }
        return result;
    }

    private String unescapeBackslash(String input) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unescapeBackslash", (Object)input);
        }
        String result = input;
        if (input.indexOf(STRING_BACKSLASH) != -1) {
            int startValue = 0;
            StringBuffer tmp = new StringBuffer(input);
            while ((startValue = tmp.indexOf(STRING_BACKSLASH, startValue)) != -1) {
                if (startValue + 1 < tmp.length() && tmp.charAt(startValue + 1) == '\\') {
                    tmp.deleteCharAt(startValue);
                    ++startValue;
                    continue;
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "BAD_ESCAPE_CHAR_CWSIA0387", new Object[]{input}, tc);
            }
            result = tmp.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unescapeBackslash", (Object)result);
        }
        return result;
    }

    private String[] validateNVP(String namePart, String valuePart, String uri, JmsDestination dest) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"validateNVP", (Object)new Object[]{namePart, valuePart, uri, dest});
        }
        if (valuePart.indexOf(38) != -1) {
            valuePart = valuePart.replaceAll("\\\\&", STRING_AMPERSAND);
        }
        valuePart = this.unescapeBackslash(valuePart);
        if (namePart.equalsIgnoreCase(MA88_EXPIRY)) {
            namePart = "timeToLive";
        }
        if (namePart.equalsIgnoreCase(MA88_PERSISTENCE)) {
            namePart = "deliveryMode";
            valuePart = valuePart.equals("1") ? "NonPersistent" : (valuePart.equals("2") ? "Persistent" : "Application");
        }
        String[] result = new String[]{namePart, valuePart};
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"validateNVP", (Object)result);
        }
        return result;
    }

    private void configureDestinationFromMap(JmsDestination dest, Map<String, String> props, String uri) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"configureDestinationFromMap", (Object)new Object[]{dest, props, uri});
        }
        for (Map.Entry<String, String> nextProp : props.entrySet()) {
            String namePart = nextProp.getKey();
            String valuePart = nextProp.getValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("name " + namePart + ", value " + valuePart));
            }
            boolean propertyIsSettable = true;
            Class cl = MsgDestEncodingUtilsImpl.getPropertyType(namePart);
            if (cl == null) {
                propertyIsSettable = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Ignoring invalid property " + namePart));
                }
            }
            if (!propertyIsSettable) continue;
            try {
                Object valueObject = MsgDestEncodingUtilsImpl.convertPropertyToType(namePart, valuePart);
                if (namePart.equals(TOPIC_NAME)) {
                    if (dest instanceof JmsTopicImpl) {
                        ((JmsTopicImpl)dest).setTopicName((String)valueObject);
                        continue;
                    }
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INTERNAL_ERROR_CWSIA0386", null, tc);
                }
                MsgDestEncodingUtilsImpl.setDestinationProperty(dest, namePart, valueObject);
            }
            catch (NumberFormatException nfe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)nfe);
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_URI_ELEMENT_CWSIA0384", new Object[]{namePart, valuePart, uri}, nfe, null, null, tc);
            }
            catch (JMSException jmse) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)jmse));
                }
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_URI_ELEMENT_CWSIA0384", new Object[]{namePart, valuePart, uri}, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"configureDestinationFromMap");
        }
    }

    public static String escapeValueString(String propValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"escapeValueString", (Object)propValue);
        }
        if (propValue != null) {
            int indexOfAmpInValue;
            int nextIndex = 0;
            while ((nextIndex = propValue.indexOf(92, nextIndex)) != -1) {
                int nextChar = 65535;
                if (nextIndex + 1 < propValue.length()) {
                    nextChar = propValue.charAt(nextIndex + 1);
                }
                if (nextChar != 92) {
                    propValue = propValue.substring(0, nextIndex) + STRING_BACKSLASH + propValue.substring(nextIndex);
                }
                nextIndex += 2;
            }
            int startValueAmp = 0;
            while ((indexOfAmpInValue = propValue.indexOf(STRING_AMPERSAND, startValueAmp)) != -1) {
                int newStartFrom = indexOfAmpInValue;
                int previousAtChar = 65535;
                if (indexOfAmpInValue > 0) {
                    previousAtChar = propValue.charAt(indexOfAmpInValue - 1);
                }
                if (previousAtChar != 92) {
                    propValue = propValue.substring(0, newStartFrom) + STRING_BACKSLASH + propValue.substring(newStartFrom);
                }
                startValueAmp = newStartFrom + 1;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"escapeValueString", (Object)propValue);
        }
        return propValue;
    }

    public static String escapeDestName(String destName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"escapeDestName", (Object)destName);
        }
        if (destName != null) {
            int nextIndex = 0;
            while ((nextIndex = destName.indexOf(92, nextIndex)) != -1) {
                int nextChar = 65535;
                if (nextIndex + 1 < destName.length()) {
                    nextChar = destName.charAt(nextIndex + 1);
                }
                if (nextChar != 92) {
                    destName = destName.substring(0, nextIndex) + STRING_BACKSLASH + destName.substring(nextIndex);
                }
                nextIndex += 2;
            }
            nextIndex = 0;
            while ((nextIndex = destName.indexOf(63, nextIndex)) != -1) {
                if (!URIDestinationCreator.charIsEscaped(destName, nextIndex)) {
                    destName = destName.substring(0, nextIndex) + STRING_BACKSLASH + destName.substring(nextIndex);
                }
                ++nextIndex;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"escapeDestName", (Object)destName);
        }
        return destName;
    }

    public Destination createDestinationFromURI(String uri, int qmProcessing) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDestinationFromURI", (Object)new Object[]{uri, qmProcessing});
        }
        JmsDestination result = null;
        if (uri != null) {
            result = this.processURI(uri, qmProcessing, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDestinationFromURI", (Object)result);
        }
        return result;
    }

    private static boolean charIsEscaped(String str, int index) {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"charIsEscaped", (Object)new Object[]{str, index});
        }
        if (str == null || index < 0 || index >= str.length()) {
            return false;
        }
        int nEscape = 0;
        for (int i = index - 1; i >= 0 && str.charAt(i) == '\\'; --i) {
            ++nEscape;
        }
        boolean bl = result = nEscape % 2 == 1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"charIsEscaped", (Object)result);
        }
        return result;
    }

    public static enum DestType {
        QUEUE,
        TOPIC;

    }
}

