/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;

public class JmsMapMessageImpl
extends JmsMessageImpl
implements MapMessage {
    private static final long serialVersionUID = -5270211659893353729L;
    private JsJmsMapMessage mapMsg;
    private transient String cachedMapToString = null;
    private static TraceComponent tc = SibTr.register(JmsMapMessageImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    public JmsMapMessageImpl() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsMapMessageImpl");
        }
        this.messageClass = "jms_map";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsMapMessageImpl");
        }
    }

    JmsMapMessageImpl(JsJmsMapMessage newMsg, JmsSessionImpl newSess) {
        super((JsJmsMessage)newMsg, newSess);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsMapMessageImpl", (Object)new Object[]{newMsg, newSess});
        }
        this.mapMsg = newMsg;
        this.messageClass = "jms_map";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsMapMessageImpl");
        }
    }

    JmsMapMessageImpl(MapMessage mapMessage) throws JMSException {
        super((Message)mapMessage);
        Enumeration mapNames;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsMapMessageImpl", (Object)mapMessage);
        }
        if ((mapNames = mapMessage.getMapNames()) != null) {
            while (mapNames.hasMoreElements()) {
                String name = (String)mapNames.nextElement();
                Object value = mapMessage.getObject(name);
                this.setObject(name, value);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsMapMessageImpl");
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBoolean", (Object)name);
        }
        Object obj = null;
        try {
            obj = this.mapMsg.getObject(name);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.getBoolean"}, e, "JmsMapMessageImpl#1", this, tc);
        }
        boolean value = false;
        try {
            value = JmsMessageImpl.parseBoolean(obj, name);
        }
        catch (JMSException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error parsing object", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBoolean", (Object)value);
        }
        return value;
    }

    public byte getByte(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getByte", (Object)name);
        }
        Object obj = null;
        try {
            obj = this.mapMsg.getObject(name);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.getByte"}, e, "JmsMapMessageImpl#2", this, tc);
        }
        byte value = 0;
        try {
            value = JmsMessageImpl.parseByte(obj, name);
        }
        catch (JMSException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error parsing object", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getByte", (Object)value);
        }
        return value;
    }

    public short getShort(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getShort", (Object)name);
        }
        Object obj = null;
        try {
            obj = this.mapMsg.getObject(name);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.getShort"}, e, "JmsMapMessageImpl#3", this, tc);
        }
        short value = 0;
        try {
            value = JmsMessageImpl.parseShort(obj, name);
        }
        catch (JMSException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error parsing object", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getShort", (Object)value);
        }
        return value;
    }

    public char getChar(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getChar", (Object)name);
        }
        Object obj = null;
        try {
            obj = this.mapMsg.getObject(name);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.getChar"}, e, "JmsMapMessageImpl#4", this, tc);
        }
        char value = '\u0000';
        if (!(obj instanceof Character)) {
            if (obj == null) {
                RuntimeException e = (RuntimeException)JmsErrorUtils.newThrowable(NullPointerException.class, "FIELD_NOT_SET_CWSIA0105", new Object[]{name}, tc);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Field has not been set", (Object)e);
                }
                throw e;
            }
            MessageFormatException e = JmsMapMessageImpl.newBadConvertException(obj, name, "Character", tc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Invalid convert", (Object)((Object)e));
            }
            throw e;
        }
        value = ((Character)obj).charValue();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getChar", (Object)Character.valueOf(value));
        }
        return value;
    }

    public int getInt(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getInt", (Object)name);
        }
        Object obj = null;
        try {
            obj = this.mapMsg.getObject(name);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.getInt"}, e, "JmsMapMessageImpl#5", this, tc);
        }
        int value = 0;
        try {
            value = JmsMessageImpl.parseInt(obj, name);
        }
        catch (JMSException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error parsing object", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getInt", (Object)value);
        }
        return value;
    }

    public long getLong(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLong", (Object)name);
        }
        Object obj = null;
        try {
            obj = this.mapMsg.getObject(name);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.getLong"}, e, "JmsMapMessageImpl#6", this, tc);
        }
        long value = 0L;
        try {
            value = JmsMessageImpl.parseLong(obj, name);
        }
        catch (JMSException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error parsing object", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLong", (Object)value);
        }
        return value;
    }

    public float getFloat(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getFloat", (Object)name);
        }
        Object obj = null;
        try {
            obj = this.mapMsg.getObject(name);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.getFloat"}, e, "JmsMapMessageImpl#7", this, tc);
        }
        float value = 0.0f;
        try {
            value = JmsMessageImpl.parseFloat(obj, name);
        }
        catch (JMSException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error parsing object", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getFloat", (Object)Float.valueOf(value));
        }
        return value;
    }

    public double getDouble(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDouble", (Object)name);
        }
        Object obj = null;
        try {
            obj = this.mapMsg.getObject(name);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.getDouble"}, e, "JmsMapMessageImpl#8", this, tc);
        }
        double value = 0.0;
        try {
            value = JmsMessageImpl.parseDouble(obj, name);
        }
        catch (JMSException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Error parsing object", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDouble", (Object)value);
        }
        return value;
    }

    public String getString(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getString", (Object)name);
        }
        Object obj = null;
        try {
            obj = this.mapMsg.getObject(name);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.getString"}, e, "JmsMapMessageImpl#9", this, tc);
        }
        String value = null;
        if (obj instanceof String || obj == null) {
            value = (String)obj;
        } else {
            if (obj instanceof byte[]) {
                MessageFormatException e = JmsMapMessageImpl.newBadConvertException(obj, name, "String", tc);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"invalid convert", (Object)((Object)e));
                }
                throw e;
            }
            value = obj.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getString", (Object)value);
        }
        return value;
    }

    public byte[] getBytes(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBytes", (Object)name);
        }
        Object obj = null;
        try {
            obj = this.mapMsg.getObject(name);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.getBytes"}, e, "JmsMapMessageImpl#10", this, tc);
        }
        byte[] value = null;
        if (obj instanceof byte[]) {
            byte[] objB = (byte[])obj;
            value = new byte[objB.length];
            System.arraycopy(objB, 0, value, 0, objB.length);
        } else if (obj == null) {
            value = null;
        } else {
            MessageFormatException e = JmsMapMessageImpl.newBadConvertException(obj, name, "Byte[]", tc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Invalid convert", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBytes", (Object)Arrays.toString(value));
        }
        return value;
    }

    public Object getObject(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getObject", (Object)name);
        }
        Object result = null;
        Object obj = null;
        try {
            obj = this.mapMsg.getObject(name);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.getObject"}, e, "JmsMapMessageImpl#11", this, tc);
        }
        if (obj instanceof byte[]) {
            byte[] objB = (byte[])obj;
            byte[] value = new byte[objB.length];
            System.arraycopy(objB, 0, value, 0, objB.length);
            result = value;
        } else {
            result = obj;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getObject", (Object)result);
        }
        return result;
    }

    public Enumeration getMapNames() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMapNames");
        }
        Enumeration map = null;
        try {
            map = this.mapMsg.getMapNames();
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.getMapNames"}, e, "JmsMapMessageImpl#12", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMapNames", (Object)map);
        }
        return map;
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBoolean", (Object)new Object[]{name, value});
        }
        this.checkBodyWriteable("setBoolean");
        JmsMapMessageImpl.checkPropName(name, "setBoolean");
        try {
            this.mapMsg.setBoolean(name, value);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.setBoolean"}, e, "JmsMapMessageImpl#13", this, tc);
        }
        this.cachedMapToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBoolean");
        }
    }

    public void setByte(String name, byte value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setByte", (Object)new Object[]{name, value});
        }
        this.checkBodyWriteable("setByte");
        JmsMapMessageImpl.checkPropName(name, "setByte");
        try {
            this.mapMsg.setByte(name, value);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.setByte"}, e, "JmsMapMessageImpl#14", this, tc);
        }
        this.cachedMapToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setByte");
        }
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBytes", (Object)new Object[]{name, value});
        }
        int length = 0;
        if (value != null) {
            length = value.length;
        }
        this.setBytes(name, value, 0, length);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBytes");
        }
    }

    public void setBytes(String name, byte[] value, int start, int length) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBytes", (Object)new Object[]{name, value, start, length});
        }
        this.checkBodyWriteable("setBytes");
        JmsMapMessageImpl.checkPropName(name, "setBytes");
        byte[] deepCopy = null;
        if (value != null) {
            deepCopy = new byte[length];
            System.arraycopy(value, start, deepCopy, 0, length);
        }
        try {
            this.mapMsg.setBytes(name, deepCopy);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.setBytes"}, e, "JmsMapMessageImpl#15", this, tc);
        }
        this.cachedMapToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBytes");
        }
    }

    public void setChar(String name, char value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setChar", (Object)new Object[]{name, Character.valueOf(value)});
        }
        this.checkBodyWriteable("setChar");
        JmsMapMessageImpl.checkPropName(name, "setChar");
        try {
            this.mapMsg.setChar(name, value);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.setChar"}, e, "JmsMapMessageImpl#16", this, tc);
        }
        this.cachedMapToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setChar");
        }
    }

    public void setDouble(String name, double value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDouble", (Object)new Object[]{name, value});
        }
        this.checkBodyWriteable("setDouble");
        JmsMapMessageImpl.checkPropName(name, "setDouble");
        try {
            this.mapMsg.setDouble(name, value);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.setDouble"}, e, "JmsMapMessageImpl#17", this, tc);
        }
        this.cachedMapToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDouble");
        }
    }

    public void setFloat(String name, float value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setFloat", (Object)new Object[]{name, Float.valueOf(value)});
        }
        this.checkBodyWriteable("setFloat");
        JmsMapMessageImpl.checkPropName(name, "setFloat");
        try {
            this.mapMsg.setFloat(name, value);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.setFloat"}, e, "JmsMapMessageImpl#18", this, tc);
        }
        this.cachedMapToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setFloat");
        }
    }

    public void setInt(String name, int value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setInt", (Object)new Object[]{name, value});
        }
        this.checkBodyWriteable("setInt");
        JmsMapMessageImpl.checkPropName(name, "setInt");
        try {
            this.mapMsg.setInt(name, value);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.setInt"}, e, "JmsMapMessageImpl#19", this, tc);
        }
        this.cachedMapToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setInt");
        }
    }

    public void setLong(String name, long value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLong", (Object)new Object[]{name, value});
        }
        this.checkBodyWriteable("setLong");
        JmsMapMessageImpl.checkPropName(name, "setLong");
        try {
            this.mapMsg.setLong(name, value);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.setLong"}, e, "JmsMapMessageImpl#20", this, tc);
        }
        this.cachedMapToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLong");
        }
    }

    public void setObject(String name, Object value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setObject", (Object)new Object[]{name, value});
        }
        this.checkBodyWriteable("setObject");
        JmsMapMessageImpl.checkPropName(name, "setObject");
        if (!(value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character || value instanceof byte[])) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("value is bad type: " + value.getClass().getName()));
            }
            throw (JMSException)JmsErrorUtils.newThrowable(MessageFormatException.class, "BAD_OBJECT_CWSIA0188", new Object[]{value.getClass().getName()}, tc);
        }
        if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            byte[] tmp = new byte[v.length];
            System.arraycopy(v, 0, tmp, 0, v.length);
            value = tmp;
        }
        try {
            this.mapMsg.setObject(name, value);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.setObject"}, e, "JmsMapMessageImpl#21", this, tc);
        }
        this.cachedMapToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setObject");
        }
    }

    public void setShort(String name, short value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setShort", (Object)new Object[]{name, value});
        }
        this.checkBodyWriteable("setShort");
        JmsMapMessageImpl.checkPropName(name, "setShort");
        try {
            this.mapMsg.setShort(name, value);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.setShort"}, e, "JmsMapMessageImpl#22", this, tc);
        }
        this.cachedMapToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setShort");
        }
    }

    public void setString(String name, String value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setString", (Object)new Object[]{name, value});
        }
        this.checkBodyWriteable("setString");
        JmsMapMessageImpl.checkPropName(name, "setString");
        try {
            this.mapMsg.setString(name, value);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.setString"}, e, "JmsMapMessageImpl#23", this, tc);
        }
        this.cachedMapToString = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setString");
        }
    }

    public boolean itemExists(String name) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"itemExists", (Object)name);
        }
        boolean exists = false;
        try {
            exists = this.mapMsg.itemExists(name);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsMapMessageImpl.itemExists"}, e, "JmsMapMessageImpl#24", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"itemExists", (Object)exists);
        }
        return exists;
    }

    @Override
    public String toString() {
        if (this.cachedMapToString == null) {
            StringBuffer sb = new StringBuffer();
            try {
                Enumeration props = this.getMapNames();
                while (props.hasMoreElements()) {
                    String nextKey = (String)props.nextElement();
                    Object propVal = this.getObject(nextKey);
                    if (propVal == null) {
                        propVal = "<null>";
                    }
                    sb.append("\n" + nextKey + " = " + propVal);
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.cachedMapToString = sb.toString();
        }
        return super.toString() + this.cachedMapToString;
    }

    @Override
    protected JsJmsMessage instantiateMessage() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"instantiateMessage");
        }
        JsJmsMapMessage newMsg = null;
        newMsg = jmfact.createJmsMapMessage();
        this.mapMsg = newMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"instantiateMessage", (Object)newMsg);
        }
        return newMsg;
    }
}

