/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms;

import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.sib.api.jms.service.JmsServiceFacade;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.jms.JMSException;

public class StringArrayWrapper
implements Serializable {
    private static final long serialVersionUID = 3870265914027831694L;
    private List fullMsgPath = null;
    public static final String BUS_SEPARATOR = ":";

    public StringArrayWrapper(List siDests) throws JMSException {
        this.fullMsgPath = siDests;
    }

    public static StringArrayWrapper create(String[] data, String bigDestName) throws JMSException {
        int size = 0;
        if (data != null) {
            size = data.length;
        }
        ArrayList<SIDestinationAddress> fakedFullMsgPath = new ArrayList<SIDestinationAddress>(size + 1);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                String destName = data[i];
                String busName = null;
                if (destName.indexOf(BUS_SEPARATOR) != -1) {
                    busName = destName.substring(destName.indexOf(BUS_SEPARATOR) + 1);
                    destName = destName.substring(0, destName.indexOf(BUS_SEPARATOR));
                }
                try {
                    SIDestinationAddress sida = JmsServiceFacade.getSIDestinationAddressFactory().createSIDestinationAddress(destName, busName);
                    fakedFullMsgPath.add(sida);
                    continue;
                }
                catch (Exception e) {
                    JMSException jmse = new JMSException(e.getMessage());
                    jmse.setLinkedException(e);
                    jmse.initCause((Throwable)e);
                }
            }
            if (bigDestName != null) {
                try {
                    SIDestinationAddress sida = JmsServiceFacade.getSIDestinationAddressFactory().createSIDestinationAddress(bigDestName, null);
                    fakedFullMsgPath.add(sida);
                }
                catch (Exception e) {
                    JMSException jmse = new JMSException(e.getMessage());
                    jmse.setLinkedException(e);
                    jmse.initCause((Throwable)e);
                }
            }
        }
        StringArrayWrapper newSAW = new StringArrayWrapper(fakedFullMsgPath);
        return newSAW;
    }

    public List getMsgForwardRoutingPath() {
        return this.fullMsgPath.subList(1, this.fullMsgPath.size());
    }

    public String[] getArray() {
        String[] newArray = null;
        newArray = new String[this.fullMsgPath.size() - 1];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = ((SIDestinationAddress)this.fullMsgPath.get(i)).getDestinationName();
        }
        return newArray;
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (that instanceof StringArrayWrapper) {
            StringArrayWrapper thatSaw = (StringArrayWrapper)that;
            if (thatSaw.fullMsgPath == this.fullMsgPath) {
                return true;
            }
            if (thatSaw.fullMsgPath.size() != this.fullMsgPath.size()) {
                return false;
            }
            for (int i = 0; i < this.fullMsgPath.size(); ++i) {
                if (thatSaw.fullMsgPath.get(i).equals(this.fullMsgPath.get(i))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public List getCorePath() {
        return this.fullMsgPath.subList(0, this.fullMsgPath.size() - 1);
    }

    public SIDestinationAddress getProducerSIDestAddress() {
        return (SIDestinationAddress)this.fullMsgPath.get(0);
    }

    public String toString() {
        List arrayStrings = this.getCorePath();
        ListIterator iter = arrayStrings.listIterator();
        String result = "";
        while (iter.hasNext()) {
            SIDestinationAddress thisSida = (SIDestinationAddress)iter.next();
            result = result + thisSida.getDestinationName();
            if (thisSida.getBusName() != null && !"".equals(thisSida.getBusName())) {
                result = result + BUS_SEPARATOR + thisSida.getBusName();
            }
            if (!iter.hasNext()) continue;
            result = result + "<#>";
        }
        return result;
    }
}

