/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.rs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ByteArrayDecoder {
    private static final TraceComponent tc = Tr.register(ByteArrayDecoder.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    ParserPool parserPool = Configuration.getParserPool();
    static final long serialVersionUID = -7254589607929301193L;

    protected void doDecode(MessageContext messageContext, ByteArrayInputStream byteArrayInputStream) throws MessageDecodingException {
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        ByteArrayInputStream base64DecodedMessage = byteArrayInputStream;
        SAMLObject inboundMessage = (SAMLObject)this.unmarshallMessage(base64DecodedMessage);
        samlMsgCtx.setInboundMessage((XMLObject)inboundMessage);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Decoded SAML message", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected XMLObject unmarshallMessage(InputStream messageStream) throws MessageDecodingException {
        try {
            Unmarshaller unmarshaller;
            Document messageDoc = this.parserPool.parse(messageStream);
            Element messageElem = messageDoc.getDocumentElement();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Resultant DOM message was:\n{}", (Object[])new Object[]{messageElem == null ? "null" : XMLHelper.nodeToString((Node)messageElem)});
                Tr.debug((TraceComponent)tc, (String)"Unmarshalling message DOM", (Object[])new Object[0]);
            }
            if ((unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(messageElem)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unable to unmarshall message, no unmarshaller registered for message element " + XMLHelper.getNodeQName((Node)messageElem)), (Object[])new Object[0]);
                }
                throw new MessageDecodingException("Unable to unmarshall message, no unmarshaller registered for message element " + XMLHelper.getNodeQName((Node)messageElem));
            }
            XMLObject message = unmarshaller.unmarshall(messageElem);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Message succesfully unmarshalled", (Object[])new Object[0]);
            }
            return message;
        }
        catch (XMLParserException messageDoc) {
            void e;
            FFDCFilter.processException((Throwable)messageDoc, (String)"com.ibm.ws.security.saml.sso20.rs.ByteArrayDecoder", (String)"101", (Object)this, (Object[])new Object[]{messageStream});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("XMLParserException e:" + e), (Object[])new Object[0]);
            }
            throw new MessageDecodingException("Encountered error parsing message into its DOM representation", (Exception)e);
        }
        catch (UnmarshallingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.rs.ByteArrayDecoder", (String)"106", (Object)this, (Object[])new Object[]{messageStream});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("UnmarshallingException e:" + (Object)((Object)e)), (Object[])new Object[0]);
            }
            throw new MessageDecodingException("Encountered error unmarshalling message from its DOM representation", (Exception)((Object)e));
        }
    }
}

