/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoHandler;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.metadata.SpMetadataBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MetadataHandler
implements SsoHandler {
    private static TraceComponent tc = Tr.register(MetadataHandler.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static final long serialVersionUID = 7418478075062856265L;

    @Override
    public Constants.SamlSsoVersion getSamlVersion() {
        return Constants.SamlSsoVersion.SAMLSSO20;
    }

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response, SsoRequest samlRequest, Map<String, Object> parameters) throws SamlException {
        SsoSamlService samlService = (SsoSamlService)parameters.get(Constants.KEY_SAML_SERVICE);
        SsoConfig samlConfig = samlService.getConfig();
        String filename = "spMetadata.xml";
        SecurityService securityService = (SecurityService)parameters.get(Constants.KEY_SECURITY_SERVICE);
        if (tc.isDebugEnabled()) {
            String authFilterId = samlConfig.getAuthFilterId();
            Tr.debug((TraceComponent)tc, (String)("handleRequest(Metadata): providerId:" + samlService.getProviderId() + " request:" + request + " response:" + response + " samlRequest:" + samlRequest + " samlService:" + samlService + " securityService:" + securityService + " authFilterId:" + authFilterId), (Object[])new Object[0]);
        }
        try {
            response.setContentType("text/xml");
            response.setHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), response.getCharacterEncoding()));
            SpMetadataBuilder spMetadataBuilder = new SpMetadataBuilder(samlService);
            String metadataData = spMetadataBuilder.buildSpMetadata(request);
            bw.write(metadataData);
            bw.flush();
            bw.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.saml.sso20.metadata.MetadataHandler", (String)"80", (Object)this, (Object[])new Object[]{request, response, samlRequest, parameters});
        }
    }
}

