/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.UserData;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SsoRequest {
    protected Constants.EndpointType type;
    protected String providerName;
    protected HttpServletRequest request;
    protected Constants.SamlSsoVersion samlVersion;
    protected SsoSamlService ssoSamlService;
    protected SsoConfig ssoConfig;
    protected UserData userData = null;
    protected AtomicServiceReference<WsLocationAdmin> locationAdminRef;
    @Sensitive
    protected String spCookieValue = null;
    boolean inboundPropagation = false;
    static final long serialVersionUID = 3281878309381957203L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SsoRequest(String providerName, Constants.EndpointType type, HttpServletRequest request, Constants.SamlSsoVersion samlVersion) {
        this.providerName = providerName;
        this.type = type;
        this.request = request;
        this.samlVersion = samlVersion;
    }

    public SsoRequest(String providerName, Constants.EndpointType type, HttpServletRequest request, Constants.SamlSsoVersion samlVersion, SsoSamlService ssoSamlService) {
        this(providerName, type, request, samlVersion);
        this.setSsoSamlService(ssoSamlService);
    }

    public boolean isInboundPropagation() {
        return this.inboundPropagation;
    }

    public void setInboundPropagation(boolean inboundPropagation) {
        this.inboundPropagation = inboundPropagation;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    public Constants.EndpointType getType() {
        return this.type;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public Constants.SamlSsoVersion getSamlVersion() {
        return this.samlVersion;
    }

    public SsoSamlService getSsoSamlService() {
        return this.ssoSamlService;
    }

    public SsoConfig getSsoConfig() {
        return this.ssoConfig;
    }

    public void setSsoSamlService(SsoSamlService ssoSamlService) {
        this.ssoSamlService = ssoSamlService;
        this.ssoConfig = ssoSamlService.getConfig();
        this.inboundPropagation = ssoSamlService.isInboundPropagation();
    }

    public void createSpCookieIfDisableLtpa(HttpServletRequest req, HttpServletResponse resp) {
        if (this.isDisableLtpaCookie()) {
            String spCookieName = this.getSpCookieName();
            String spCookieValue = this.getSpCookieValue();
            if (spCookieName != null && spCookieValue != null) {
                RequestUtil.createCookie(req, resp, spCookieName, spCookieValue);
            }
        }
    }

    public void setType(Constants.EndpointType type) {
        this.type = type;
    }

    @Sensitive
    public String getSpCookieValue() {
        return this.spCookieValue;
    }

    public void setSpCookieValue(@Sensitive String spCookieValue) {
        this.spCookieValue = spCookieValue;
    }

    public void setLocationAdminRef(AtomicServiceReference<WsLocationAdmin> locationAdminRef) {
        this.locationAdminRef = locationAdminRef;
    }

    public String getSpCookieName() {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        return this.ssoConfig.getSpCookieName(locationAdmin);
    }

    public boolean isDisableLtpaCookie() {
        return this.ssoConfig.isDisableLtpaCookie();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SamlRequest [provider:").append(this.providerName).append(" type:").append((Object)this.type).append(" request:").append(this.request).append("]").append(" userData=" + (this.userData != null));
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.saml.SsoRequest", SsoRequest.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    }
}

