/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.security.NewInstanceAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static <T> T newInstance(Class<T> javaClass) throws InstantiationException, IllegalAccessException {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(NewInstanceAction.of(javaClass));
            }
            catch (PrivilegedActionException e) {
                throw new WeldException(e.getCause());
            }
        }
        return javaClass.newInstance();
    }

    static void addShutdownHook(final Thread hook) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Runtime.getRuntime().addShutdownHook(hook);
                    return null;
                }
            });
        } else {
            Runtime.getRuntime().addShutdownHook(hook);
        }
    }
}

