/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.am;

import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.utils.am.GroupAlarmListener;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleLinkedListEntry;
import com.ibm.ws.sib.utils.ras.SibTr;

public class MPAlarmImpl
extends SimpleLinkedListEntry
implements Alarm {
    private long latest;
    private Object context;
    private long time;
    private volatile boolean active;
    private boolean groupListener = false;
    private long index;
    private static TraceComponent tc = SibTr.register(MPAlarmImpl.class, (String)"SIBUtils", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public MPAlarmImpl(long time, long latest, AlarmListener listener, Object context, long index) {
        super(listener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MPAlarmImpl", (Object)new Object[]{time, latest, listener, context, index});
        }
        this.reset(time, latest, listener, context, index);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MPAlarmImpl", (Object)this);
        }
    }

    public void cancel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cancel", (Object)this.toString());
        }
        this.active = false;
        if (this.groupListener && this.data != null) {
            ((GroupAlarmListener)this.data).cancel();
        }
        this.data = null;
        this.groupListener = false;
        this.context = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancel");
        }
    }

    protected void cancelSingleEntry() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cancelSingleEntry", (Object)this.toString());
        }
        this.active = false;
        this.data = null;
        this.groupListener = false;
        this.context = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancelSingleEntry");
        }
    }

    void reset(long time, long latest, AlarmListener listener, Object context, long index) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reset", (Object)new Object[]{new Long(time), new Long(latest), listener, context, new Long(index)});
        }
        this.data = listener;
        this.time = time;
        this.latest = latest;
        this.context = context;
        this.index = index;
        this.groupListener = listener instanceof GroupAlarmListener;
        this.active = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    long time() {
        return this.time;
    }

    long index() {
        return this.index;
    }

    long latest() {
        return this.latest;
    }

    AlarmListener listener() {
        return (AlarmListener)this.data;
    }

    Object context() {
        return this.context;
    }

    boolean hasGroupListener() {
        return this.groupListener;
    }

    boolean active() {
        return this.active;
    }

    MPAlarmImpl next() {
        return (MPAlarmImpl)this.getNext();
    }

    MPAlarmImpl previous() {
        return (MPAlarmImpl)this.getPrevious();
    }

    @Override
    public synchronized String toString(String indent) {
        StringBuffer buffer = new StringBuffer();
        long now = System.currentTimeMillis();
        buffer.append(indent);
        buffer.append("Alarm(" + this.index + "," + this.time + "," + this.latest + "," + this.active + "," + (this.time - now));
        if (this.data != null) {
            buffer.append(",@" + Integer.toHexString(this.data.hashCode()));
        } else {
            buffer.append(",-");
        }
        if (this.context != null) {
            buffer.append(",@" + Integer.toHexString(this.context.hashCode()));
        } else {
            buffer.append(",-");
        }
        if (this.groupListener) {
            buffer.append(",Y");
        } else {
            buffer.append(",N");
        }
        buffer.append(")");
        if (this.parentList == null) {
            buffer.append(" Not in list");
        }
        return buffer.toString();
    }
}

