/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PtoPInputHandler;
import com.ibm.ws.sib.processor.runtime.SIMPForeignBusControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLinkRemoteMessagePointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPVirtualLinkControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractRegisteredControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashSet;

public class VirtualLinkControl
extends AbstractRegisteredControlAdapter
implements SIMPVirtualLinkControllable {
    private static TraceComponent tc = SibTr.register(VirtualLinkControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private LinkHandler _link;
    private MessageProcessor _messageProcessor;
    private HashSet<SIMPLinkRemoteMessagePointControllable> _remotePoints;

    public VirtualLinkControl(MessageProcessor messageProcessor, LinkHandler link) {
        super(messageProcessor, ControllableType.SIB_LINK);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"VirtualLinkControl", (Object)new Object[]{messageProcessor, link});
        }
        this._link = link;
        this._messageProcessor = messageProcessor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"VirtualLinkControl", (Object)this);
        }
    }

    public VirtualLinkControl(MessageProcessor messageProcessor) {
        super(messageProcessor, ControllableType.SIB_LINK);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"VirtualLinkControl", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"VirtualLinkControl", (Object)this);
        }
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String id = "" + this._link.getUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)id);
        }
        return id;
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        String name = this._link.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)name);
        }
        return name;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._link == null || !this._link.isInStore()) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"VirtualLinkControl.assertValidControllable", "1:131:1.33", this._link}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._link = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public SIMPForeignBusControllable getForeignBusControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignBusControlAdapter");
            SibTr.exit((TraceComponent)tc, (String)"getForeignBusControlAdapter");
        }
        return (SIMPForeignBusControllable)this._messageProcessor.getDestinationManager().getForeignBusIndex().findByName(this._link.getBusName(), null).getControlAdapter();
    }

    public SIMPIterator getLinkReceiverControllableIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkReceiverControllableIterator");
        }
        SIMPIterator itr = ((PtoPInputHandler)this._link.getInputHandler()).getTargetStreamManager().getTargetStreamSetControlIterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkReceiverControllableIterator", (Object)itr);
        }
        return itr;
    }

    public SIMPIterator getLinkRemoteQueuePointControllableIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkRemoteQueuePointControllableIterator");
        }
        BasicSIMPIterator returnItr = new BasicSIMPIterator(this._remotePoints.iterator());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkRemoteQueuePointControllableIterator", (Object)returnItr);
        }
        return returnItr;
    }

    public String getState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        String state = this._messageProcessor.getDestinationManager().getLinkIndex().getState(this._link).toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)state);
        }
        return state;
    }

    public String getTargetBus() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetBus");
        }
        String bus = this._link.getBusName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTargetBus", (Object)bus);
        }
        return bus;
    }

    public void addRemoteMessagePointControl(SIMPLinkRemoteMessagePointControllable adapter) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addRemoteMessagePointControl", (Object)adapter);
        }
        if (this._remotePoints == null) {
            this._remotePoints = new HashSet();
        }
        this._remotePoints.add(adapter);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addRemoteMessagePointControl");
        }
    }

    public void removeRemoteMessagePointControl(ControlAdapter adapter) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeRemoteMessagePointControl", (Object)adapter);
        }
        if (this._remotePoints != null) {
            this._remotePoints.remove((SIMPLinkRemoteMessagePointControllable)adapter);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeRemoteMessagePointControl");
        }
    }

    public String getType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getType");
        }
        String type = this._link.getType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getType", (Object)type);
        }
        return type;
    }

    public void merge(VirtualLinkControl control) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"merge", (Object)control);
        }
        SIMPIterator it = control.getLinkRemoteQueuePointControllableIterator();
        while (it.hasNext()) {
            this._remotePoints.add((SIMPLinkRemoteMessagePointControllable)it.next());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"merge");
        }
    }
}

