/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.gd.TargetStream;
import com.ibm.ws.sib.processor.gd.TargetStreamManager;
import com.ibm.ws.sib.processor.impl.interfaces.HealthStateListener;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryStreamReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPReceivedMessageControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.HealthStateTree;
import com.ibm.ws.sib.processor.runtime.impl.LinkReceivedMessageControl;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Iterator;
import java.util.LinkedList;

public class TargetStreamControl
extends AbstractControlAdapter
implements SIMPDeliveryStreamReceiverControllable {
    private static final TraceComponent tc = SibTr.register(TargetStreamControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private TargetStream _targetStream;
    private SIBUuid12 _streamSetID;
    private Reliability _targetStreamReliability;
    private int _priority;
    private SIBUuid8 _remoteEngineUUID;
    private TargetStreamManager _tsm;
    private HealthStateListener _healthState;

    public TargetStreamControl(SIBUuid8 remoteEngineUUID, TargetStream targetStream, SIBUuid12 streamSetID, Reliability targetStreamReliability, int priority) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TargetStreamControl", (Object)new Object[]{targetStream, streamSetID, targetStreamReliability, priority});
        }
        this._remoteEngineUUID = remoteEngineUUID;
        this._targetStream = targetStream;
        this._streamSetID = streamSetID;
        this._targetStreamReliability = targetStreamReliability;
        this._priority = priority;
        this._healthState = new HealthStateTree();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"TargetStreamControl", (Object)this);
        }
    }

    public SIMPDeliveryReceiverControllable.StreamState getStreamState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        TargetStream.TargetStreamState returnValue = this._targetStream.getStreamState();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)returnValue);
        }
        return returnValue;
    }

    public SIBUuid12 getStreamID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamID");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamID", (Object)this._streamSetID);
        }
        return this._streamSetID;
    }

    public Reliability getReliability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReliability");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)this._targetStreamReliability);
        }
        return this._targetStreamReliability;
    }

    public int getPriority() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPriority");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPriority", (Object)new Integer(this._priority));
        }
        return this._priority;
    }

    public int getNumberOfActiveMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfActiveMessages");
        }
        int returnValue = (int)this._targetStream.countAllMessagesOnStream();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfActiveMessages", (Object)new Integer(returnValue));
        }
        return returnValue;
    }

    @Override
    public String getRemoteEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)this._remoteEngineUUID);
        }
        return this._remoteEngineUUID.toString();
    }

    public String getName() {
        return null;
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._targetStream = null;
        this._streamSetID = null;
        this._priority = -1;
        this._targetStreamReliability = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._targetStream == null || this._streamSetID == null || this._targetStreamReliability == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"TargetStreamControl.assertValidControllable", "1:228:1.32", this._streamSetID}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public String getId() {
        String returnValue = this._targetStream.getID();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)returnValue);
        }
        return returnValue;
    }

    public SIMPIterator getReceivedMessageIterator(int maxMsgs) {
        LinkedList<LinkReceivedMessageControl> receivedMessages = new LinkedList<LinkReceivedMessageControl>();
        Iterator<MessageItem> streamMessages = this._targetStream.getAllMessagesOnStream().iterator();
        boolean allMsgs = maxMsgs == -1;
        for (int index = 0; (allMsgs || index < maxMsgs) && streamMessages.hasNext(); ++index) {
            MessageItem msgItem = streamMessages.next();
            LinkReceivedMessageControl receivedMessage = new LinkReceivedMessageControl(msgItem, this._tsm.getDestinationHandler().getMessageProcessor(), this._tsm.getDestinationHandler());
            receivedMessages.add(receivedMessage);
        }
        return new BasicSIMPIterator(receivedMessages.iterator());
    }

    public SIMPReceivedMessageControllable getReceivedMessageByID(String id) {
        SIMPReceivedMessageControllable returnMessage = null;
        SIMPIterator iterator = this.getReceivedMessageIterator(-1);
        while (iterator.hasNext()) {
            SIMPReceivedMessageControllable receivedMessage = (SIMPReceivedMessageControllable)iterator.next();
            String msgID = receivedMessage.getId();
            if (!msgID.equals(id)) continue;
            returnMessage = receivedMessage;
            break;
        }
        return returnMessage;
    }

    public long getLastDeliveredMessageSequenceId() {
        return this._targetStream.getLastKnownTick();
    }

    public long getNumberOfMessagesReceived() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfMessagesReceived");
        }
        long returnValue = this._targetStream.getNumberOfMessagesReceived();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfMessagesReceived", (Object)new Long(returnValue));
        }
        return returnValue;
    }

    public long getLastMsgReceivedTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHealthState");
        }
        long time = this._targetStream.getLastMsgReceivedTimestamp();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getHealthState", (Object)time);
        }
        return time;
    }

    public HealthStateListener getHealthState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHealthState");
            SibTr.exit((TraceComponent)tc, (String)"getHealthState", (Object)this._healthState);
        }
        return this._healthState;
    }

    public void setTSM(TargetStreamManager tsm) {
        this._tsm = tsm;
    }
}

