/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.items.MessageItemReference;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPQueuedMessageControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;

public class QueuedMessage
extends AbstractControlAdapter
implements SIMPQueuedMessageControllable {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(QueuedMessage.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private long _messageID;
    private ItemStream _itemStream = null;
    private ReferenceStream _refStream = null;
    private DestinationHandler _destinationHandler;
    private SIMPTransactionManager _txManager;
    private MessageProcessor _messageProcessor;

    public QueuedMessage(SIMPMessage message, DestinationHandler destination, ItemStream is) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"QueuedMessage", (Object)new Object[]{message, destination, is});
        }
        try {
            this._messageID = message.getID();
            this._itemStream = is;
            this._destinationHandler = destination;
            this._messageProcessor = this._destinationHandler.getMessageProcessor();
            this._txManager = this._messageProcessor.getTXManager();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.QueuedMessage.QueuedMessage", (String)"1:129:1.66", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"QueuedMessage", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"QueuedMessage", (Object)this);
        }
    }

    public QueuedMessage(SIMPMessage message, DestinationHandler destination, ReferenceStream rs) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"QueuedMessage", (Object)new Object[]{message, destination, rs});
        }
        try {
            this._messageID = message.getID();
            this._refStream = rs;
            this._destinationHandler = destination;
            this._messageProcessor = this._destinationHandler.getMessageProcessor();
            this._txManager = this._messageProcessor.getTXManager();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.QueuedMessage.QueuedMessage", (String)"1:168:1.66", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"QueuedMessage", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"QueuedMessage", (Object)this);
        }
    }

    public JsMessage getJsMessage() throws SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJsMessage");
        }
        this.assertValidControllable();
        SIMPMessage message = null;
        try {
            message = this.getSIMPMessage();
        }
        catch (SIResourceException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getJsMessage", (Object)((Object)e));
            }
            throw new SIMPRuntimeOperationFailedException((Throwable)e);
        }
        if (message == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"QueuedMessage.getJsMessage", "1:211:1.66", Long.toString(this._messageID)}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getJsMessage", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJsMessage");
        }
        return message.getMessage();
    }

    private SIMPMessage getSIMPMessage() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIMPMessage");
        }
        SIMPMessage message = null;
        try {
            if (this._itemStream != null) {
                message = (SIMPMessage)this._itemStream.findById(this._messageID);
            } else if (this._refStream != null) {
                message = (SIMPMessage)this._refStream.findById(this._messageID);
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.QueuedMessage.getSIMPMessage", (String)"1:245:1.66", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSIMPMessage", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIMPMessage", (Object)message);
        }
        return message;
    }

    public String getState() throws SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        String state = "UNLOCKED";
        this.assertValidControllable();
        SIMPMessage msg = null;
        try {
            msg = this.getSIMPMessage();
        }
        catch (SIResourceException e) {
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"QueuedMessage.getState", "1:288:1.66", e, Long.toString(this._messageID)}, null), (Throwable)e, "INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{Long.toString(this._messageID)});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getState", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (msg != null) {
            AbstractItem msgItem = (AbstractItem)msg;
            if (!msgItem.isAvailable()) {
                state = msg.isHidden() ? "PENDING_RETRY" : (msgItem.isAdding() ? "COMMITTING" : (msgItem.isRemoving() ? "REMOVING" : (msgItem.isPersistentlyLocked() ? "REMOTE_LOCKED" : "LOCKED")));
            } else if (this.isStreamBlocked()) {
                state = "BLOCKED";
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)state);
        }
        return state;
    }

    private boolean isStreamBlocked() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStreamBlocked");
        }
        boolean blocked = false;
        if (this._itemStream != null) {
            if (this._itemStream instanceof PtoPMessageItemStream) {
                blocked = ((PtoPMessageItemStream)this._itemStream).isBlocked();
            }
        } else if (this._refStream != null && this._refStream instanceof SubscriptionItemStream) {
            blocked = ((SubscriptionItemStream)this._refStream).isBlocked();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isStreamBlocked", (Object)blocked);
        }
        return blocked;
    }

    public String getTransactionId() throws SIMPException {
        PersistentTranId pTranId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionId");
        }
        this.assertValidControllable();
        String id = null;
        SIMPMessage msg = null;
        try {
            msg = this.getSIMPMessage();
        }
        catch (SIResourceException e) {
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"QueuedMessage.getTransactionId", "1:389:1.66", e, Long.toString(this._messageID)}, null), (Throwable)e, "INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{Long.toString(this._messageID)});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getTransactionId", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (msg != null && (pTranId = msg.getTransactionId()) != null) {
            id = pTranId.toTMString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransactionId", (Object)id);
        }
        return id;
    }

    public void copyMessageToExceptionDestination(LocalTransaction tran) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"copyMessageToExceptionDestination", (Object)tran);
        }
        SIMPMessage msg = this.getSIMPMessage();
        ExceptionDestinationHandlerImpl edh = null;
        if (this._destinationHandler.isLink()) {
            edh = new ExceptionDestinationHandlerImpl(this._destinationHandler);
        } else {
            edh = new ExceptionDestinationHandlerImpl(null, this._messageProcessor);
            edh.setDestination(this._destinationHandler);
        }
        edh.sendToExceptionDestination((SIBusMessage)msg.getMessage(), null, (TransactionCommon)tran, 36, null, new String[]{"" + this._messageID, this._destinationHandler.getName(), this._messageProcessor.getMessagingEngineName()});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"copyMessageToExceptionDestination");
        }
    }

    public void moveMessage(boolean discard) throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveMessage", (Object)new Object[]{discard});
        }
        this.assertValidControllable();
        LocalTransaction tran = this._txManager.createLocalTransaction(false);
        SIMPMessage msg = null;
        try {
            msg = this.getSIMPMessage();
        }
        catch (SIResourceException e) {
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"QueuedMessage.moveMessage", "1:473:1.66", e, Long.toString(this._messageID)}, null), (Throwable)e, "INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{Long.toString(this._messageID)});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"moveMessage", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (!discard) {
            try {
                this.copyMessageToExceptionDestination(tran);
            }
            catch (Exception e) {
                SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException((Throwable)e);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"moveMessage", (Object)((Object)finalE));
                }
                throw finalE;
            }
            discard = true;
        }
        if (discard) {
            try {
                if (msg.isInStore()) {
                    if (msg.getLockID() == -2L) {
                        long lockID = this._messageProcessor.getMessageStore().getUniqueLockID(1);
                        msg.lockItemIfAvailable(lockID);
                    }
                    Transaction msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction((TransactionCommon)tran);
                    msg.remove(msTran, msg.getLockID());
                }
            }
            catch (Exception e) {
                SIMPRuntimeOperationFailedException finalE = null;
                boolean adding = false;
                boolean removing = false;
                if (msg instanceof MessageItem) {
                    adding = ((MessageItem)msg).isAdding();
                    removing = ((MessageItem)msg).isRemoving();
                } else {
                    adding = ((MessageItemReference)msg).isAdding();
                    removing = ((MessageItemReference)msg).isRemoving();
                }
                if (adding) {
                    finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("MESSAGE_INDOUBT_WARNING_CWSIP0361", new Object[]{Long.toString(this._messageID), this._destinationHandler.getName()}, null), (Throwable)e, "MESSAGE_INDOUBT_WARNING_CWSIP0361", new Object[]{Long.toString(this._messageID), this._destinationHandler.getName()});
                } else if (removing) {
                    finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("MESSAGE_INDOUBT_WARNING_CWSIP0362", new Object[]{Long.toString(this._messageID), this._destinationHandler.getName()}, null), (Throwable)e, "MESSAGE_INDOUBT_WARNING_CWSIP0362", new Object[]{Long.toString(this._messageID), this._destinationHandler.getName()});
                } else {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.QueuedMessage.moveMessage", (String)"1:579:1.66", (Object)this);
                    finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"QueuedMessage.removeMessage", "1:587:1.66", e, Long.toString(this._messageID)}, null), (Throwable)e, "INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{Long.toString(this._messageID)});
                }
                try {
                    tran.rollback();
                }
                catch (SIException ee) {
                    FFDCFilter.processException((Throwable)ee, (String)"com.ibm.ws.sib.processor.runtime.QueuedMessage.moveMessage", (String)"1:603:1.66", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)ee));
                }
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"moveMessage", (Object)((Object)finalE));
                }
                throw finalE;
            }
        }
        try {
            tran.commit();
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.QueuedMessage.moveMessage", (String)"1:625:1.66", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"QueuedMessage.removeMessage", "1:633:1.66", e, Long.toString(this._messageID)}, null), (Throwable)e, "INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{Long.toString(this._messageID)});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"moveMessage", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveMessage");
        }
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)Long.toString(this._messageID));
        }
        return "" + this._messageID;
    }

    public String getName() {
        return null;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._messageID == -1L) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"QueuedMessage.assertValidControllable", "1:683:1.66", Long.toString(this._messageID)}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._messageID = -1L;
        this._itemStream = null;
        this._refStream = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
    }

    public long getSequenceID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSequenceID");
        }
        long sequenceID = 0L;
        try {
            SIMPMessage msg = this.getSIMPMessage();
            if (msg != null) {
                sequenceID = msg.getMessage().getGuaranteedValueValueTick();
            }
        }
        catch (SIResourceException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSequenceID", (Object)sequenceID);
        }
        return sequenceID;
    }

    public long getPreviousSequenceId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPreviousSequenceId");
        }
        long previousSequenceID = 0L;
        try {
            SIMPMessage msg = this.getSIMPMessage();
            if (msg != null) {
                previousSequenceID = msg.getMessage().getGuaranteedValueStartTick() - 1L;
            }
        }
        catch (SIResourceException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPreviousSequenceId", (Object)previousSequenceID);
        }
        return previousSequenceID;
    }

    public long getApproximateLength() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getApproximateLength");
        }
        long length = 0L;
        try {
            SIMPMessage msg = this.getSIMPMessage();
            if (msg != null) {
                length = msg.getMessage().getApproximateLength();
            }
        }
        catch (SIResourceException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getApproximateLength", (Object)length);
        }
        return length;
    }
}

